/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#include "RebuildAndReloadExtension.h"

#include <Application.h>

#include <QMessageBox>
#include <QFileInfo>

using namespace camitk;

#include <HotPlugExtensionManager.h>
#include <CamiTKExtensionModel.h>

// -------------------- process --------------------
Action::ApplyStatus RebuildAndReloadExtension::process() {
    QString camitkExtensionFile = getParameterValueAsString("CamiTK File");
    if (camitkExtensionFile.isEmpty() || !QFileInfo(camitkExtensionFile).exists()) {
        return ABORTED;
    }

    if (HotPlugExtensionManager::unload(camitkExtensionFile)) {
        if (HotPlugExtensionManager::load(camitkExtensionFile, true)) {
            // check language as restart is probably never necessary for python extensions
            CamiTKExtensionModel camitkExtensionModel;
            camitkExtensionModel.load(QFileInfo(camitkExtensionFile).absoluteFilePath());
            if (camitkExtensionModel.getModel().isValid()) {
                // it's python only if there is a language key and its value is python
                const VariantDataModel& language = camitkExtensionModel.getModel()["language"];
                if (!language.isValid() || language.toString() == "C++") {
                    Application::restart("Extension reloaded.<br/>It is recommended to restart the application after extension reload.<br/>Do you want to restart now?");
                }
            }

            // if the user decided not to restart, just refresh
            refreshApplication();
            return SUCCESS;
        }
        else {
            refreshApplication(); // to refresh dev menus
            return WARNING;
        }
    }
    else {
        refreshApplication(); // to refresh dev menus
        return WARNING;
    }
}

// -------------------- targetDefined --------------------
void RebuildAndReloadExtension::targetDefined() {

}

// -------------------- parameterChanged --------------------
void RebuildAndReloadExtension::parameterChanged(QString parameterName) {
}

// -------------------- init --------------------
void RebuildAndReloadExtension::init() {
}


