# Interface description for package maintainers

The document written with the assumption that the reader is a maintainer
of a package and would like to use `deb-build-artifact-gather` for extracting
artifacts during builds.

## What do you as a maintainer need to do?

If you use a standard packaging helper such as `debhelper` or `debputy`,
then they will already ensure standard logs are collected, when they
perform a build for you.

If you observe that a pattern for a standard build tool seems to be
missing, then please file a bug report against `deb-build-artifact-gather`
so we can add it.

If you have a special-case pattern that is unlikely to apply to many
packages or is not generic, you can use the `X-Build-Time-Aux-Artifacts`
field in the source stanza of `debian/control`. It is a multi-line
field with one pattern per **line**. As example:

```deb822
Source: foo
X-Build-Time-Aux-Artifacts:
 test-results/complex-case/*.fooresults
 test-results/anther-case/*.fooresult
```

## How can I use `deb-build-artifact-gather` to test my patterns?

The best way is to use your preferred tool for building packages
if it has `deb-build-artifact-gather` support.

Alternatively, you can also use `deb-build-artifact-gather` on
a build performed by the host system or where the host file system
has a bindmount to the chroot in its post build state (such as
`pbuilder --login` where the login session is still running).

Please refer to [man:deb-build-artifact-gather(1)](https://manpages.debian.org/deb-build-artifact-gather.1)
for how to do it.
