C @(#)ftddvt.for	19.1 (ES0-DMD) 02/25/03 13:17:33
C===========================================================================
C Copyright (C) 1995 European Southern Observatory (ESO)
C
C This program is free software; you can redistribute it and/or 
C modify it under the terms of the GNU General Public License as 
C published by the Free Software Foundation; either version 2 of 
C the License, or (at your option) any later version.
C
C This program is distributed in the hope that it will be useful,
C but WITHOUT ANY WARRANTY; without even the implied warranty of
C MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C GNU General Public License for more details.
C
C You should have received a copy of the GNU General Public 
C License along with this program; if not, write to the Free 
C Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
C MA 02139, USA.
C
C Corresponding concerning ESO-MIDAS should be addressed as follows:
C	Internet e-mail: midas@eso.org
C	Postal address: European Southern Observatory
C			Data Management Division 
C			Karl-Schwarzschild-Strasse 2
C			D 85748 Garching bei Muenchen 
C			GERMANY
C===========================================================================
C
      SUBROUTINE FTDDVT(NAME,DVAR,ISTAT)                                        
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++                   
C.COPYRIGHT: Copyright (c) 1987 European Southern Observatory,                  
C                                         all rights reserved                   
C                                                                               
C.VERSION: 1.0  ESO-FORTRAN Conversion, AA  17:25 - 13 JAN 1988                 
C                                                                               
C.LANGUAGE: F77+ESOext                                                          
C                                                                               
C.AUTHOR: J.D.PONZ                                                              
C                                                                               
C.IDENTIFICATION                                                                
C                                                                               
C  FITLIB.FOR   VERSION 1.0  27 MAR 1984                                        
C                                                                               
C.PURPOSE                                                                       
C                                                                               
C  INTERFACE ROUTINES FOR THE FITTING STRUCTURES                                
C DEFINE DEPENDENT VARIABLE AS COLUMN IN A TABLE                                
C                                                                               
C.ALGORITHM                                                                     
C                                                                               
C  USE MIDAS I/O INTERFACES TO FRAMES AND TABLES                                
C                                                                               
C.KEYWORDS                                                                      
C                                                                               
C  NON LINEAR FITTING                                                           
C                                                                               
C                                                                               
C----------------------------------------------------------------               
C                                                                               
C      IMPLICIT NONE                                                            
C                                                                               
C INPUT PARAMETERS                                                              
C NAME CHAR TABLE NAME                                                          
C DVAR CHAR COLUMN ACTING AS DEPENDENT VARIABLE                                 
C   AND OPTIONAL ERROR COLUMN                                                   
C                                                                               
C OUTPUT PARAMETERS                                                             
C ISTAT INTG STATUS RETURN                                                      
C                       
      INTEGER       TYPE,ISTAT,IND1,IND2                                                        
      CHARACTER*(*) NAME,DVAR                                                   
      CHARACTER*8 NAME1,FORM                                               
      CHARACTER*17 LAB1,LAB2                                                    
      CHARACTER*16 LABEL,UNIT                                                   
C
       INCLUDE 'MID_INCLUDE:TABLES.INC/NOLIST'                                     
       INCLUDE 'MID_INCLUDE:FITI.INC/NOLIST'                                     
       INCLUDE 'MID_INCLUDE:FITC.INC/NOLIST'                                     
       INCLUDE 'MID_INCLUDE:TABLED.INC/NOLIST'                                     
C
      DATA UNIT/' '/                                                            
      DATA FORM/'G14.7 '/                                            
C
      TYPE = D_R4_FORMAT
C                                                                               
C READ TABLE                                                                    
C                                                                               
      NAME1  = NAME                                                             
      IF (FZMAPPED.EQ.1 .AND. FZTYPE.EQ.'TBL ') THEN                        
          IF (FZNAME(1:8).NE.NAME1) THEN  !   TABLE MUST BE THE SAME          
              ISTAT  = FERTAB                                               
              RETURN                                                            
          END IF                                                                
      ELSE                                                                      
          IF (FZMAPPED.EQ.0) THEN                                             
              CALL TBTOPN(NAME,2,FZIDEN,ISTAT)                                           
              FZMAPPED = 1                                                    
              FZNAME = NAME                                                   
              FZTYPE = 'TBL '                                                 
          END IF                                                                
      END IF                                                                    
C                                                                               
C LAB1 CONTAINS THE COLUMN ACTING AS DEP VAR                                    
C LAB2 OPTIONAL WEIGHT                                                          
C                                                                               
      IND1   = INDEX(DVAR,',')                                                  
      IND2   = INDEX(DVAR,' ')                                                  
      IF (IND1.EQ.0) THEN                                                       
          LAB1   = DVAR(1:IND2-1)                                               
          LAB2   = ' '                                                          
      ELSE                                                                      
          LAB1   = DVAR(1:IND1-1)                                               
          LAB2   = DVAR(IND1+1:IND2-1)                                          
      END IF                                                                    
      CALL TBCSER(FZIDEN,LAB1,FZDVAR,ISTAT)                                     
      IF (FZDVAR.EQ.-1) THEN                                                  
          LABEL  = LAB1(2:)                                                     
          CALL TBCINI(FZIDEN,TYPE,1,FORM,UNIT,LABEL,FZDVAR,ISTAT)                 
      END IF                                                                    
      IF (LAB2(1:1).EQ.' ') THEN                                                
          FZWEIGHT = 0                                                        
      ELSE                                                                      
          CALL TBCSER(FZIDEN,LAB2,FZWEIGHT,ISTAT)                               
          IF (FZWEIGHT.EQ.-1) THEN                                            
              LABEL  = LAB2(2:)                                                 
              CALL TBCINI(FZIDEN,TYPE,1,FORM,UNIT,LABEL,FZWEIGHT,ISTAT)           
          END IF                                                                
                                                                                
      END IF                                                                    
                                                                                
      RETURN                                                                    
                                                                                
      END                                                                       
