C @(#)realin.for	19.1 (ES0-DMD) 02/25/03 13:29:45
C===========================================================================
C Copyright (C) 1995 European Southern Observatory (ESO)
C
C This program is free software; you can redistribute it and/or 
C modify it under the terms of the GNU General Public License as 
C published by the Free Software Foundation; either version 2 of 
C the License, or (at your option) any later version.
C
C This program is distributed in the hope that it will be useful,
C but WITHOUT ANY WARRANTY; without even the implied warranty of
C MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C GNU General Public License for more details.
C
C You should have received a copy of the GNU General Public 
C License along with this program; if not, write to the Free 
C Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
C MA 02139, USA.
C
C Corresponding concerning ESO-MIDAS should be addressed as follows:
C	Internet e-mail: midas@eso.org
C	Postal address: European Southern Observatory
C			Data Management Division 
C			Karl-Schwarzschild-Strasse 2
C			D 85748 Garching bei Muenchen 
C			GERMANY
C===========================================================================
C
      SUBROUTINE REALIN(NPL,NL,IY,IX,NV,A,DAT)
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C.IDENTIFICATION: REALIN.FOR
C.PURPOSE:        read a line of a frame
C.AUTHOR:         R. Buanonno
C.USE:            input:  NPL - number of pixel in the x direction
C                         NL  - number of pixels in the y direction
C                         IX  - start pixel to read
C                         IY  - line number to read
C                         NV  - number of pixels to read
C                 output: DAT - data array containing the pixels values
C.VERSION:        18-12-88  recoded and documented
C ---------------------------------------------------------------------
      IMPLICIT NONE
      INTEGER  NPL
      INTEGER  NL
      INTEGER  IY
      INTEGER  IX
      INTEGER  NV
      REAL     A(NPL,NL)
      REAL     DAT(NPL)
C
      INTEGER  I, K
C
      K=0
      DO 10 I=IX,IX+NV-1
         K     = K+1
         DAT(K) = A(I,IY)
   10 CONTINUE
C
      RETURN
      END
