/* -*- c-file-style: "GNU" -*- */
/*
 * Copyright (C) CNRS, INRIA, Universite Bordeaux 1, Telecom SudParis
 * See COPYING in top-level directory.
 */

#include "eztrace-lib/eztrace_mpi.h"

#if USE_MPI

#include <eztrace-lib/eztrace.h>
#include <mpi.h>


/* For MPI_Init and MPI_Init_thread, we *have* to call the Fortran version
 * of the function. Once it is done, we can call the _mpi_init_generic function
 */
void _mpi_init_generic();

extern void (*libmpi_init_)(int* e);
extern void (*libmpi_init_thread_)(int*, int*, int*);
extern void (*libmpi_finalize_)(int*);

extern void _eztrace_init_mpi_core();

void mpif_init_(void* error) {
  _eztrace_init_mpi_core();
  libmpi_init_((int*)error);
  _mpi_init_generic();
}

void mpif_init_thread_(int* r, int* p, int* error) {
  _eztrace_init_mpi_core();
  libmpi_init_thread_(r, p, error);
  _mpi_init_generic();
}

/* For all the remaining Fortran functions, we can just call the C version */
void mpif_finalize_(int* error) {
  *error = MPI_Finalize();
}


#endif
