! (C) Copyright 2005- ECMWF.
! (C) Copyright 2013- Meteo-France.
! 
! This software is licensed under the terms of the Apache Licence Version 2.0
! which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
! In applying this licence, ECMWF does not waive the privileges and immunities
! granted to it by virtue of its status as an intergovernmental organisation
! nor does it submit to any jurisdiction.
!

MODULE MPL_BYTES_MOD

USE EC_PARKIND, ONLY : JPIM, JPIB, JPRM, JPRD

IMPLICIT NONE

PRIVATE

PUBLIC :: MPL_BYTES

INTERFACE MPL_BYTES
MODULE PROCEDURE &
     & MPL_BYTES_IM, MPL_BYTES_IB, &
     & MPL_BYTES_RM, MPL_BYTES_RD
END INTERFACE MPL_BYTES

CONTAINS

! INTEGER*4
FUNCTION MPL_BYTES_IM(KVAR)
INTEGER(KIND=JPIM), INTENT(IN) :: KVAR
INTEGER(KIND=JPIM) MPL_BYTES_IM
MPL_BYTES_IM = SIZE(TRANSFER(KVAR, (/'A'/)))
END FUNCTION MPL_BYTES_IM

! INTEGER*8
FUNCTION MPL_BYTES_IB(KVAR)
INTEGER(KIND=JPIB), INTENT(IN) :: KVAR
INTEGER(KIND=JPIM) MPL_BYTES_IB
MPL_BYTES_IB = SIZE(TRANSFER(KVAR, (/'A'/)))
END FUNCTION MPL_BYTES_IB

! REAL*4
FUNCTION MPL_BYTES_RM(PVAR)
REAL(KIND=JPRM), INTENT(IN) :: PVAR
INTEGER(KIND=JPIM) MPL_BYTES_RM
MPL_BYTES_RM = SIZE(TRANSFER(PVAR, (/'A'/)))
END FUNCTION MPL_BYTES_RM

! REAL*8
FUNCTION MPL_BYTES_RD(PVAR)
REAL(KIND=JPRD), INTENT(IN) :: PVAR
INTEGER(KIND=JPIM) MPL_BYTES_RD
MPL_BYTES_RD = SIZE(TRANSFER(PVAR, (/'A'/)))
END FUNCTION MPL_BYTES_RD

END MODULE MPL_BYTES_MOD
