# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# Localized string used as the dialog window title.
# "Report" is a noun in this case, "Report for AddonName".
#
# Variables:
#   $addon-name (string) - Name of the add-on being reported
abuse-report-dialog-title = { $addon-name } ᱞᱟᱹᱜᱤᱫ ᱠᱷᱚᱵᱚᱨ ᱢᱮ
abuse-report-title-extension = ᱱᱚᱶᱟ ᱮᱠᱥᱴᱮᱱᱥᱚᱱ ᱫᱚ { -vendor-short-name } ᱴᱷᱮᱱ ᱠᱷᱚᱵᱚᱨ ᱢᱮ
abuse-report-title-sitepermission = ᱱᱚᱶᱟ ᱥᱟᱭᱤᱴ ᱮᱰᱚᱱ ᱫᱚ { -vendor-short-name } ᱴᱷᱮᱱ ᱠᱷᱚᱵᱚᱨ ᱢᱮ
abuse-report-title-theme = ᱱᱚᱶᱟ ᱴᱷᱤᱢ ᱫᱚ { -vendor-short-name } ᱴᱷᱮᱱ ᱠᱷᱚᱵᱚᱨ ᱢᱮ
abuse-report-subtitle = ᱮᱴᱠᱮᱴᱚᱬᱮ ᱪᱮᱫ ᱠᱟᱱᱟ ?
# Variables:
#   $author-name (string) - Name of the add-on author
abuse-report-addon-authored-by = ᱚᱱᱚᱞᱤᱭᱟᱹ <a data-l10n-name="author-name">{ $author-name }</a>
abuse-report-learnmore =
    ᱪᱮᱫ ᱵᱟᱝ ᱴᱷᱟᱹᱠᱟᱹ ᱫᱟᱲᱮᱭᱟᱜ ᱠᱟᱱᱟ ᱪᱮᱫᱮᱢ ᱵᱟᱪᱷᱟᱣ ᱟ?
    <a data-l10n-name="learnmore-link">ᱨᱤᱯᱚᱴᱤᱝ ᱮᱠᱥᱴᱮᱱᱥᱚᱱ ᱟᱨ ᱛᱷᱤᱢ ᱠᱚ ᱵᱟᱵᱚᱫᱽ ᱵᱟᱹᱲᱛᱤ ᱵᱟᱰᱟᱭ ᱢᱮ</a>
abuse-report-submit-description = ᱮᱴᱠᱮᱴᱚᱬᱮ ᱵᱟᱛᱟᱣ ᱢᱮ (ᱩᱱᱟᱹᱜ ᱵᱟᱝ ᱞᱟᱹᱠᱛᱤ)
abuse-report-textarea =
    .placeholder = ᱟᱢᱟᱜ ᱮᱴᱠᱮᱴᱚᱬᱮ ᱵᱩᱡᱷᱟᱹᱣ ᱞᱟᱹᱜᱤᱫ ᱟᱞᱮ ᱫᱚ ᱯᱩᱥᱴᱟᱹᱣ ᱥᱟᱹᱦᱤᱡ ᱞᱟᱹᱭᱟᱞᱮᱢ ᱾ ᱡᱟᱦᱟᱸ ᱢᱩᱥᱠᱤᱞᱮᱢ ᱵᱩᱡᱷᱟᱹᱣᱮᱫᱟ ᱞᱟᱹᱭᱢᱮ ᱾ ᱟᱢᱟᱜ ᱣᱮᱵᱽ  ᱜᱚᱲᱚ ᱮᱢ ᱞᱟᱹᱜᱤᱫ ᱟᱹᱰᱤ ᱥᱟᱨᱦᱟᱣ ᱾
abuse-report-submit-note =
    ᱞᱟᱹᱱᱟᱹᱭ : ᱱᱤᱡᱚᱨ ᱵᱟᱵᱚᱛ ᱛᱮ ᱵᱟᱰᱟᱭᱚᱜ ᱠᱟᱛᱷᱟ (ᱡᱮᱞᱮᱠᱟ - ᱧᱩᱛᱩᱢ, ᱤᱼᱢᱮᱞ, ᱯᱷᱚᱱ ᱱᱚᱢᱵᱚᱨ, ᱛᱟᱵᱮᱸᱱ ᱴᱷᱤᱠᱬᱟᱹ) ᱟᱞᱚᱢ ᱢᱮᱥᱟᱭᱟ ᱾
    { -vendor-short-name } ᱫᱚ ᱱᱚᱶᱟ ᱠᱚ ᱨᱮᱭᱟᱜ ᱵᱟᱝ ᱢᱮᱴᱟᱣᱜ ᱨᱮᱠᱚᱰ ᱮ ᱫᱚᱦᱚᱭᱟᱭ ᱾

## Panel buttons.

abuse-report-cancel-button = ᱵᱟᱹᱰᱨᱟᱹ
abuse-report-next-button = ᱤᱱᱟᱹ ᱛᱟᱭᱚᱢ
abuse-report-goback-button = ᱛᱟᱭᱚᱢ ᱥᱮᱫ ᱪᱟᱞᱟᱣ
abuse-report-submit-button = ᱡᱚᱢᱟᱭ ᱢᱮ

## Message bars descriptions.
##
## Variables:
##   $addon-name (string) - Name of the add-on

abuse-report-messagebar-aborted = <span data-l10n-name="addon-name">{ $addon-name }</span> ᱞᱟᱹᱜᱤᱫ ᱠᱷᱚᱵᱚᱨ ᱵᱷᱮᱡᱟᱜ ᱵᱟᱫ ᱮᱱᱟ ᱾
abuse-report-messagebar-submitting = <span data-l10n-name="addon-name">{ $addon-name }</span> ᱞᱟᱹᱜᱤᱫ ᱠᱷᱚᱵᱚᱨ ᱵᱷᱮᱡᱟᱜ ᱠᱟᱱᱟ ᱾
abuse-report-messagebar-submitted = ᱠᱷᱚᱵᱚᱨ ᱡᱚᱢᱟ ᱞᱟᱹᱜᱤᱫ ᱟᱹᱰᱤ ᱥᱟᱨᱦᱟᱣ ᱾ ᱟᱢ ᱫᱚ ᱪᱮᱫ <span data-l10n-name="addon-name">{ $addon-name }</span> ᱢᱮᱴᱟᱣ ᱥᱟᱱᱟᱢ ᱠᱟᱱᱟ ᱥᱮ ?
abuse-report-messagebar-submitted-noremove = ᱢᱤᱫᱴᱟᱝ ᱠᱷᱚᱵᱚᱨ ᱡᱚᱢᱟ ᱞᱟᱹᱜᱤᱫ ᱥᱟᱨᱦᱟᱣ ᱜᱮ ᱾
abuse-report-messagebar-removed-extension = ᱠᱷᱚᱵᱚᱨ ᱡᱚᱢᱟ ᱞᱟᱹᱜᱤᱫ ᱟᱹᱰᱤ ᱥᱟᱨᱦᱟᱣ ᱾ ᱟᱢ ᱫᱚ <span data-l10n-name="addon-name">{ $addon-name }</span> ᱮᱠᱥᱴᱮᱱᱥᱚᱱ ᱮᱢ ᱢᱮᱴᱟᱣ ᱚᱪᱚᱜᱽ ᱠᱮᱫᱼᱟ ᱾
abuse-report-messagebar-removed-sitepermission = ᱠᱷᱚᱵᱚᱨ ᱡᱚᱢᱟ ᱞᱟᱹᱜᱤᱫ ᱟᱹᱰᱤ ᱥᱟᱨᱦᱟᱣ ᱾ ᱟᱢ ᱫᱚ <span data-l10n-name="addon-name">{ $addon-name }</span> ᱨᱮ ᱥᱟᱭᱤᱴ ᱦᱚᱠ ᱮᱠᱥᱴᱮᱱᱥᱚᱱ ᱮᱢ ᱚᱪᱚᱜᱽ ᱠᱮᱫᱼᱟ ᱾
abuse-report-messagebar-removed-theme = ᱠᱷᱚᱵᱚᱨ ᱡᱚᱢᱟ ᱞᱟᱹᱜᱤᱫ ᱟᱹᱰᱤ ᱥᱟᱨᱦᱟᱣ ᱾ ᱟᱢ ᱫᱚ <span data-l10n-name="addon-name">{ $addon-name }</span> ᱛᱷᱤᱢ ᱚᱪᱚᱜᱽ ᱠᱮᱫᱼᱟ ᱾
abuse-report-messagebar-error = <span data-l10n-name="addon-name">{ $addon-name }</span> ᱞᱟᱹᱜᱤᱫ ᱠᱷᱚᱵᱚᱨ ᱵᱷᱮᱡᱟ ᱨᱮ ᱵᱷᱩᱞ ᱦᱩᱭᱮᱱᱟ ᱾
abuse-report-messagebar-error-recent-submit = <span data-l10n-name="addon-name">{ $addon-name }</span> ᱞᱟᱹᱜᱤᱫ ᱠᱷᱚᱵᱚᱨ ᱫᱚ ᱵᱷᱮᱡᱟ ᱵᱟᱭ ᱜᱟᱱ ᱞᱮᱱᱟ ᱪᱮᱫᱟᱜ ᱥᱮ ᱮᱴᱟᱜ ᱠᱷᱚᱵᱚᱨ ᱱᱮᱱᱮ ᱜᱚ ᱡᱚᱢᱟ ᱠᱟᱱᱟ ᱾

## Message bars actions.

abuse-report-messagebar-action-remove-extension = ᱦᱚᱭ, ᱚᱪᱚᱜᱽ ᱢᱮ ᱱᱚᱶᱟ
abuse-report-messagebar-action-keep-extension = ᱵᱟᱝᱟ, ᱤᱧ ᱫᱚ ᱫᱚᱦᱚᱭᱟᱹᱧ
abuse-report-messagebar-action-remove-sitepermission = ᱦᱚᱭ, ᱚᱪᱚᱜᱽ ᱢᱮ ᱱᱚᱶᱟ
abuse-report-messagebar-action-keep-sitepermission = ᱵᱟᱝᱟ, ᱤᱧ ᱫᱚ ᱫᱚᱦᱚᱭᱟᱹᱧ
abuse-report-messagebar-action-remove-theme = ᱦᱚᱭ, ᱚᱪᱚᱜᱽ ᱢᱮ ᱱᱚᱶᱟ
abuse-report-messagebar-action-keep-theme = ᱵᱟᱝᱟ, ᱤᱧ ᱫᱚ ᱫᱚᱦᱚᱭᱟᱹᱧ
abuse-report-messagebar-action-retry = ᱫᱚᱲᱟ ᱠᱩᱨᱩᱢᱩᱴᱩ
abuse-report-messagebar-action-cancel = ᱵᱟᱹᱰᱨᱟᱹ

## Abuse report reasons (optionally paired with related examples and/or suggestions)

abuse-report-damage-reason-v2 = ᱱᱚᱶᱟ ᱫᱚ ᱤᱧᱟᱜ ᱠᱚᱢᱯᱩᱴᱚᱨ ᱠᱷᱨᱟᱯ ᱠᱮᱜᱼᱟᱭ ᱥᱮ ᱤᱧᱟᱜ ᱰᱟᱴᱟ ᱯᱟᱥᱱᱟᱣ ᱠᱮᱜᱼᱟᱭ
abuse-report-damage-example = ᱫᱟᱹᱭᱠᱟᱹ : ᱢᱟᱞᱣᱮᱨ ᱵᱷᱚᱨᱛᱤ ᱠᱮᱜᱼᱟᱭ ᱥᱮ ᱠᱩᱢᱵᱽᱲᱩ ᱠᱮᱜᱼᱟᱭ
abuse-report-spam-reason-v2 = ᱱᱚᱶᱟ ᱨᱮ ᱥᱯᱟᱢ ᱥᱮ ᱵᱟᱝᱞᱟᱹᱠᱛᱤ ᱰᱷᱟᱶᱨᱟ ᱥᱟᱢᱵᱟᱣᱟᱭ
abuse-report-spam-example = ᱫᱟᱹᱭᱠᱟᱹ ᱺ ᱣᱮᱵᱽᱥᱟᱦᱴᱟ ᱠᱚᱨᱮ ᱰᱷᱟᱶᱨᱟ ᱥᱟᱢᱵᱟᱣᱟᱭ
abuse-report-settings-reason-v2 = ᱱᱚᱶᱟ ᱫᱚ ᱤᱧᱟᱜ ᱥᱮᱸᱫᱽᱨᱟ ᱤᱧᱡᱟᱱ, ᱚᱲᱟᱜᱥᱟᱦᱴᱟ, ᱥᱮ ᱱᱟᱶᱟ ᱴᱮᱵᱽ, ᱤᱧ ᱵᱤᱱ ᱠᱩᱠᱞᱤ ᱛᱮ ᱵᱚᱫᱚᱞ ᱠᱮᱜᱼᱟᱭ
abuse-report-settings-suggestions = ᱮᱠᱥᱴᱮᱱᱥᱚᱱ ᱠᱷᱚᱵᱚᱨ ᱢᱟᱲᱟᱝ ᱨᱮ, ᱟᱢ ᱫᱚ ᱥᱟᱡᱟᱣᱠᱚ ᱵᱚᱫᱚᱞ ᱠᱟᱛᱮ ᱧᱮᱞ ᱫᱟᱲᱮᱭᱟᱜᱼᱟᱢ :
abuse-report-settings-suggestions-search = ᱟᱢᱟᱜ ᱢᱩᱞ ᱥᱮᱸᱫᱽᱨᱟ ᱥᱟᱡᱟᱣᱠᱚ ᱵᱚᱫᱚᱞ ᱢᱮ
abuse-report-settings-suggestions-homepage = ᱟᱢᱟᱜ ᱚᱲᱟᱜᱥᱟᱦᱴᱟ ᱟᱨ ᱱᱚᱶᱟ ᱴᱮᱽ ᱵᱚᱫᱚᱞ ᱢᱮ
abuse-report-deceptive-reason-v2 = ᱱᱚᱶᱟ ᱫᱚ ᱡᱟᱦᱟᱸ ᱵᱩᱡᱷᱟᱹᱣᱜ ᱠᱟᱱᱟᱭ ᱚᱱᱟ ᱫᱚ ᱵᱟᱝ ᱠᱟᱱᱟᱭ
abuse-report-deceptive-example = ᱫᱟᱹᱭᱠᱟᱹ ᱺ ᱵᱟᱝᱯᱩᱥᱴᱟᱹᱶ ᱵᱤᱵᱨᱚᱬ ᱥᱮ ᱪᱤᱛᱟᱹᱨ
abuse-report-broken-reason-extension-v2 = ᱱᱚᱶᱟ ᱫᱚ ᱵᱟᱭ ᱠᱟᱹᱢᱤ ᱠᱟᱱᱟ, ᱣᱮᱵᱽᱥᱟᱭᱤᱴ ᱨᱟᱹᱯᱩᱫᱚᱜ ᱠᱟᱱᱟ, ᱥᱮ { -brand-product-name } ᱵᱟᱹᱭ ᱮᱫᱟᱭ
abuse-report-broken-reason-sitepermission-v2 = ᱱᱚᱶᱟ ᱫᱚ ᱵᱟᱭ ᱠᱟᱹᱢᱤ ᱠᱟᱱᱟ, ᱣᱮᱵᱽᱥᱟᱭᱤᱴ ᱨᱟᱹᱯᱩᱫᱚᱜ ᱠᱟᱱᱟ, ᱥᱮ { -brand-product-name } ᱵᱟᱹᱭ ᱮᱫᱟᱭ
abuse-report-broken-reason-theme-v2 = ᱱᱚᱶᱟ ᱫᱚ ᱵᱟᱭ ᱠᱟᱹᱢᱤᱮᱫᱟᱭ ᱥᱮ ᱵᱽᱨᱟᱣᱡᱚᱨ ᱰᱤᱥᱯᱞᱮ ᱨᱟᱹᱯᱩᱫᱮᱫᱟᱭ
abuse-report-broken-example = ᱫᱟᱹᱭᱠᱟᱹ : ᱯᱷᱤᱪᱚᱨ ᱵᱟᱹᱭᱼᱵᱟᱹᱭ ᱧᱚᱜ ᱜᱚᱭᱟ, ᱵᱮᱵᱷᱟᱨ ᱨᱮ ᱢᱩᱥᱠᱤᱞ ᱜᱮᱭᱟ, ᱥᱮ ᱵᱟᱭ ᱠᱟᱹᱢᱤ ᱮᱫᱟᱭ; ᱣᱮᱵᱽᱥᱟᱭᱤᱴ ᱨᱮᱱᱟᱜ ᱛᱤᱱᱟᱹᱜ ᱜᱟᱱ ᱡᱟᱭᱜᱟ ᱵᱟᱭ ᱞᱟᱫᱮᱜ ᱠᱟᱱᱟ ᱥᱮ ᱴᱷᱤᱠ ᱵᱟᱭ ᱧᱮᱞᱚᱜ ᱠᱟᱱᱟ
abuse-report-broken-suggestions-extension =
    ᱱᱚᱨᱟ ᱵᱩᱡᱷᱟᱹᱣᱜ ᱠᱟᱱᱟ ᱟᱢ ᱫᱚ ᱢᱤᱫᱴᱟᱝ ᱱᱟᱶᱟ ᱱᱚᱶᱟ ᱰᱤᱜᱟᱹᱣ ᱮᱢ ᱪᱤᱱᱦᱟᱹᱯ ᱠᱟᱫᱟ ᱾ ᱱᱚᱰᱮ ᱢᱤᱫᱴᱟᱝ ᱠᱷᱚᱵᱚᱨ ᱡᱚᱢᱟ ᱢᱟᱲᱟᱝ ᱨᱮ, ᱡᱷᱚᱛᱚ ᱠᱷᱚᱱ ᱵᱮᱥ
    ᱦᱩᱭᱩᱜᱼᱟ ᱱᱚᱶᱟ ᱮᱴᱠᱮᱴᱚᱬᱮ ᱵᱟᱵᱚᱛ ᱫᱚ ᱟᱢ ᱮᱠᱥᱴᱮᱱᱥᱚᱱ ᱛᱮᱭᱟᱨᱤᱭᱟᱹ ᱥᱟᱞᱟᱜ ᱠᱟᱛᱷᱟᱜ ᱢᱮ ᱾
    ᱛᱮᱭᱟᱨᱤᱭᱟᱹ ᱵᱟᱵᱚᱛ ᱵᱟᱹᱲᱛᱤ ᱵᱟᱲᱟᱭ ᱞᱟᱹᱜᱤᱫ <a data-l10n-name="support-link">ᱮᱠᱥᱴᱮᱱᱥᱚᱱ ᱣᱮᱵᱽᱥᱟᱭᱤᱴ ᱪᱟᱞᱟᱜ ᱢᱮ</a> ᱾
abuse-report-broken-suggestions-sitepermission =
    ᱱᱚᱨᱟ ᱵᱩᱡᱷᱟᱹᱣᱜ ᱠᱟᱱᱟ ᱟᱢ ᱫᱚ ᱢᱤᱫᱴᱟᱝ ᱱᱟᱶᱟ ᱱᱚᱶᱟ ᱰᱤᱜᱟᱹᱣ ᱮᱢ ᱪᱤᱱᱦᱟᱹᱯ ᱠᱟᱫᱟ ᱾ ᱱᱚᱰᱮ ᱢᱤᱫᱴᱟᱝ ᱠᱷᱚᱵᱚᱨ ᱡᱚᱢᱟ ᱢᱟᱲᱟᱝ ᱨᱮ, ᱡᱷᱚᱛᱚ ᱠᱷᱚᱱ ᱵᱮᱥ
    ᱦᱩᱭᱩᱜᱼᱟ ᱱᱚᱶᱟ ᱣᱮᱵᱽᱥᱟᱭᱤᱴ ᱵᱟᱵᱚᱛ ᱫᱚ ᱟᱢ ᱣᱮᱵᱽᱥᱟᱭᱤᱴ ᱛᱮᱭᱟᱨᱤᱭᱟᱹ ᱥᱟᱞᱟᱜ ᱠᱟᱛᱷᱟᱜ ᱢᱮ ᱾
    ᱛᱮᱭᱟᱨᱤᱭᱟᱹ ᱵᱟᱵᱚᱛ ᱵᱟᱹᱲᱛᱤ ᱵᱟᱲᱟᱭ ᱞᱟᱹᱜᱤᱫ <a data-l10n-name="support-link">ᱮᱠᱥᱴᱮᱱᱥᱚᱱ ᱣᱮᱵᱽᱥᱟᱭᱤᱴ ᱪᱟᱞᱟᱜ ᱢᱮ</a> ᱾
abuse-report-broken-suggestions-theme =
    ᱱᱚᱨᱟ ᱵᱩᱡᱷᱟᱹᱣᱜ ᱠᱟᱱᱟ ᱟᱢ ᱫᱚ ᱢᱤᱫᱴᱟᱝ ᱱᱟᱶᱟ ᱱᱚᱶᱟ ᱰᱤᱜᱟᱹᱣ ᱮᱢ ᱪᱤᱱᱦᱟᱹᱯ ᱠᱟᱫᱟ ᱾ ᱱᱚᱰᱮ ᱢᱤᱫᱴᱟᱝ ᱠᱷᱚᱵᱚᱨ ᱡᱚᱢᱟ ᱢᱟᱲᱟᱝ ᱨᱮ, ᱡᱷᱚᱛᱚ ᱠᱷᱚᱱ ᱵᱮᱥ
    ᱦᱩᱭᱩᱜᱼᱟ ᱱᱚᱶᱟ ᱛᱷᱤᱢ ᱵᱟᱵᱚᱛ ᱫᱚ ᱟᱢ ᱛᱷᱤᱢ ᱛᱮᱭᱟᱨᱤᱭᱟᱹ ᱥᱟᱞᱟᱜ ᱠᱟᱛᱷᱟᱜ ᱢᱮ ᱾
    ᱛᱮᱭᱟᱨᱤᱭᱟᱹ ᱵᱟᱵᱚᱛ ᱵᱟᱹᱲᱛᱤ ᱵᱟᱲᱟᱭ ᱞᱟᱹᱜᱤᱫ <a data-l10n-name="support-link">ᱮᱠᱥᱴᱮᱱᱥᱚᱱ ᱣᱮᱵᱽᱥᱟᱭᱤᱴ ᱪᱟᱞᱟᱜ ᱢᱮ</a> ᱾
abuse-report-policy-reason-v2 = ᱱᱚᱶᱟ ᱨᱮ ᱦᱤᱨᱠᱟᱹ, ᱦᱤᱸᱥᱟᱹᱞᱤᱭᱟᱹ ᱟᱨ ᱵᱟᱝ ᱵᱟᱝ ᱟᱹᱛᱷᱟᱹᱲᱤ ᱵᱮᱥᱟᱹᱨᱤᱭᱟᱹ ᱡᱤᱱᱤᱥ ᱢᱮᱱᱟᱜᱼᱟ
abuse-report-policy-suggestions =
    ᱧᱮᱞ ᱵᱤᱲᱟᱹᱣ ᱺ ᱱᱚᱠᱚᱞ ᱟᱨ ᱴᱨᱮᱰᱢᱟᱨᱠ ᱵᱚᱵᱚᱛ ᱢᱩᱫᱼᱫᱟ ᱫᱚ ᱮᱴᱟᱜ ᱡᱟᱭᱜᱟ ᱨᱮ ᱠᱷᱚᱵᱚᱨ ᱯᱮ ᱾
    ᱠᱷᱚᱵᱚᱨ ᱞᱟᱹᱜᱤᱫ <a data-l10n-name="report-infringement-link">ᱱᱚᱶᱟ ᱫᱤᱥᱟᱹᱩᱫᱩᱜ ᱵᱮᱵᱷᱟᱨ ᱢᱮ</a> ᱾
abuse-report-unwanted-reason-v2 = ᱤᱧ ᱛᱤᱥ ᱦᱚᱸ ᱵᱟᱹᱧ ᱫᱚᱠᱟᱨᱟᱜᱼᱟ ᱟᱨ ᱤᱧ ᱵᱟᱹᱧ ᱵᱟᱲᱟᱭᱟ ᱪᱮᱫ ᱞᱮᱠᱷᱟ ᱱᱚᱶᱟ ᱠᱷᱚᱱ ᱥᱟᱦᱟᱜᱼᱟ
abuse-report-unwanted-example = ᱫᱟᱹᱭᱠᱟᱹ ᱺ ᱤᱧᱟᱜ ᱵᱤᱱ ᱠᱩᱠᱞᱤ ᱛᱮ ᱢᱤᱫᱴᱟᱝ ᱮᱯᱞᱤᱠᱮᱥᱚᱱ ᱵᱚᱦᱚᱞ ᱮᱱᱟ
abuse-report-other-reason = ᱡᱟᱦᱱᱟᱜ ᱮᱴᱟᱜ ᱡᱤᱱᱤᱥ
