// This file was autogenerated by the `uniffi-bindgen-gecko-js` crate.
// Trust me, you don't want to mess with it!

import { UniFFITypeError } from "resource://gre/modules/UniFFI.sys.mjs";



// Objects intended to be used in the unit tests
export var UnitTestObjs = {};

let lazy = {};

ChromeUtils.defineLazyGetter(lazy, "decoder", () => new TextDecoder());
ChromeUtils.defineLazyGetter(lazy, "encoder", () => new TextEncoder());

// Write/Read data to/from an ArrayBuffer
class ArrayBufferDataStream {
    constructor(arrayBuffer) {
        this.dataView = new DataView(arrayBuffer);
        this.pos = 0;
    }

    readUint8() {
        let rv = this.dataView.getUint8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeUint8(value) {
        this.dataView.setUint8(this.pos, value);
        this.pos += 1;
    }

    readUint16() {
        let rv = this.dataView.getUint16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeUint16(value) {
        this.dataView.setUint16(this.pos, value);
        this.pos += 2;
    }

    readUint32() {
        let rv = this.dataView.getUint32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeUint32(value) {
        this.dataView.setUint32(this.pos, value);
        this.pos += 4;
    }

    readUint64() {
        let rv = this.dataView.getBigUint64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeUint64(value) {
        this.dataView.setBigUint64(this.pos, BigInt(value));
        this.pos += 8;
    }


    readInt8() {
        let rv = this.dataView.getInt8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeInt8(value) {
        this.dataView.setInt8(this.pos, value);
        this.pos += 1;
    }

    readInt16() {
        let rv = this.dataView.getInt16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeInt16(value) {
        this.dataView.setInt16(this.pos, value);
        this.pos += 2;
    }

    readInt32() {
        let rv = this.dataView.getInt32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeInt32(value) {
        this.dataView.setInt32(this.pos, value);
        this.pos += 4;
    }

    readInt64() {
        let rv = this.dataView.getBigInt64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeInt64(value) {
        this.dataView.setBigInt64(this.pos, BigInt(value));
        this.pos += 8;
    }

    readFloat32() {
        let rv = this.dataView.getFloat32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeFloat32(value) {
        this.dataView.setFloat32(this.pos, value);
        this.pos += 4;
    }

    readFloat64() {
        let rv = this.dataView.getFloat64(this.pos);
        this.pos += 8;
        return rv;
    }

    writeFloat64(value) {
        this.dataView.setFloat64(this.pos, value);
        this.pos += 8;
    }


    writeString(value) {
      // Note: in order to efficiently write this data, we first write the
      // string data, reserving 4 bytes for the size.
      const dest = new Uint8Array(this.dataView.buffer, this.pos + 4);
      const encodeResult = lazy.encoder.encodeInto(value, dest);
      if (encodeResult.read != value.length) {
        throw new UniFFIError(
            "writeString: out of space when writing to ArrayBuffer.  Did the computeSize() method returned the wrong result?"
        );
      }
      const size = encodeResult.written;
      // Next, go back and write the size before the string data
      this.dataView.setUint32(this.pos, size);
      // Finally, advance our position past both the size and string data
      this.pos += size + 4;
    }

    readString() {
      const size = this.readUint32();
      const source = new Uint8Array(this.dataView.buffer, this.pos, size)
      const value = lazy.decoder.decode(source);
      this.pos += size;
      return value;
    }

    readBytes() {
      const size = this.readInt32();
      const bytes = new Uint8Array(this.dataView.buffer, this.pos, size);
      this.pos += size;
      return bytes
    }

    writeBytes(value) {
      this.writeUint32(value.length);
      value.forEach((elt) => {
        this.writeUint8(elt);
      })
    }
}

function handleRustResult(result, liftCallback, liftErrCallback) {
    switch (result.code) {
        case "success":
            return liftCallback(result.data);

        case "error":
            throw liftErrCallback(result.data);

        case "internal-error":
            if (result.data) {
                throw new UniFFIInternalError(FfiConverterString.lift(result.data));
            } else {
                throw new UniFFIInternalError("Unknown error");
            }

        default:
            throw new UniFFIError(`Unexpected status code: ${result.code}`);
    }
}

class UniFFIError {
    constructor(message) {
        this.message = message;
    }

    toString() {
        return `UniFFIError: ${this.message}`
    }
}

class UniFFIInternalError extends UniFFIError {}

// Base class for FFI converters
class FfiConverter {
    // throw `UniFFITypeError` if a value to be converted has an invalid type
    static checkType(value) {
        if (value === undefined ) {
            throw new UniFFITypeError(`undefined`);
        }
        if (value === null ) {
            throw new UniFFITypeError(`null`);
        }
    }
}

// Base class for FFI converters that lift/lower by reading/writing to an ArrayBuffer
class FfiConverterArrayBuffer extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }

    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }

    /**
     * Computes the size of the value.
     *
     * @param {*} _value
     * @return {number}
     */
    static computeSize(_value) {
        throw new UniFFIInternalError("computeSize() should be declared in the derived class");
    }

    /**
     * Reads the type from a data stream.
     *
     * @param {ArrayBufferDataStream} _dataStream
     * @returns {any}
     */
    static read(_dataStream) {
        throw new UniFFIInternalError("read() should be declared in the derived class");
    }

    /**
     * Writes the type to a data stream.
     *
     * @param {ArrayBufferDataStream} _dataStream
     * @param {any} _value
     */
    static write(_dataStream, _value) {
        throw new UniFFIInternalError("write() should be declared in the derived class");
    }

}

// Symbols that are used to ensure that Object constructors
// can only be used with a proper UniFFI pointer
const uniffiObjectPtr = Symbol("uniffiObjectPtr");
const constructUniffiObject = Symbol("constructUniffiObject");
UnitTestObjs.uniffiObjectPtr = uniffiObjectPtr;

// Export the FFIConverter object to make external types work.
export class FfiConverterString extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (typeof value !== "string") {
            throw new UniFFITypeError(`${value} is not a string`);
        }
    }

    static lift(buf) {
        const utf8Arr = new Uint8Array(buf);
        return lazy.decoder.decode(utf8Arr);
    }
    static lower(value) {
        return lazy.encoder.encode(value).buffer;
    }

    static write(dataStream, value) {
        dataStream.writeString(value);
    }

    static read(dataStream) {
        return dataStream.readString();
    }

    static computeSize(value) {
        return 4 + lazy.encoder.encode(value).length
    }
}


/**
 * Enumeration for the different types of device.
 *
 * Firefox Accounts separates devices into broad categories for display purposes,
 * such as distinguishing a desktop PC from a mobile phone. Upon signin, the
 * application should inspect the device it is running on and select an appropriate
 * [`DeviceType`] to include in its device registration record.
 */
export const DeviceType = {
    /**
     * DESKTOP
     */
    DESKTOP:0,
    /**
     * MOBILE
     */
    MOBILE:1,
    /**
     * TABLET
     */
    TABLET:2,
    /**
     * VR
     */
    VR:3,
    /**
     * TV
     */
    TV:4,
    /**
     * UNKNOWN
     */
    UNKNOWN:5,
};

Object.freeze(DeviceType);
// Export the FFIConverter object to make external types work.
export class FfiConverterTypeDeviceType extends FfiConverterArrayBuffer {
    static #validValues = Object.values(DeviceType);

    static read(dataStream) {
        // Use sequential indices (1-based) for the wire format to match Python bindings
        switch (dataStream.readInt32()) {
            case 1:
                return DeviceType.DESKTOP
            case 2:
                return DeviceType.MOBILE
            case 3:
                return DeviceType.TABLET
            case 4:
                return DeviceType.VR
            case 5:
                return DeviceType.TV
            case 6:
                return DeviceType.UNKNOWN
            default:
                throw new UniFFITypeError("Unknown DeviceType variant");
        }
    }

    static write(dataStream, value) {
        if (value === DeviceType.DESKTOP) {
            dataStream.writeInt32(1);
            return;
        }
        if (value === DeviceType.MOBILE) {
            dataStream.writeInt32(2);
            return;
        }
        if (value === DeviceType.TABLET) {
            dataStream.writeInt32(3);
            return;
        }
        if (value === DeviceType.VR) {
            dataStream.writeInt32(4);
            return;
        }
        if (value === DeviceType.TV) {
            dataStream.writeInt32(5);
            return;
        }
        if (value === DeviceType.UNKNOWN) {
            dataStream.writeInt32(6);
            return;
        }
        throw new UniFFITypeError("Unknown DeviceType variant");
    }

    static computeSize(value) {
        return 4;
    }

    static checkType(value) {
      // Check that the value is a valid enum variant
      if (!this.#validValues.includes(value)) {
          throw new UniFFITypeError(`${value} is not a valid value for DeviceType`);
      }
    }
}





