import Semaphore from "semaphore-async-await";
import { defaultActionKit } from "../actions";
import { IExternalOptions } from "../config";
import { Goal, OrderGoalTypeList } from "../core/interface";
import { bindDefaultRulesAndFunctions, bindDefaultRuleTypes } from "../rule-types";
import { ISession, ISessionLocks } from "./interface";
export declare class Session implements ISession {
    private reporter;
    private readonly config;
    private director;
    readonly ruleTypes: ReturnType<typeof bindDefaultRuleTypes>;
    readonly rules: ReturnType<typeof bindDefaultRulesAndFunctions>["rules"];
    readonly predefinedFuncs: ReturnType<typeof bindDefaultRulesAndFunctions>["predefinedFuncs"];
    readonly actions: ReturnType<typeof defaultActionKit>;
    readonly locks: SessionLocks;
    userSelfTrackingSet: boolean;
    userSelfTrackingGoal: null | Goal<void, any>;
    selfTrackingGoal: null | Goal<void, any>;
    constructor();
    setSelfTracking(dependency?: null | Goal<void, any>): void;
    setJournal(path: string): void;
    deleteJournal(): void;
    bindConfig(options: IExternalOptions): void;
    createSelfTrackingRule(dependency?: null | Goal<any, any>): void;
    loadJournal(): Promise<void>;
    saveJournalSync(): void;
    userCancelSync(): void;
    start(...args: OrderGoalTypeList): Promise<void>;
}
declare class SessionLocks implements ISessionLocks {
    private m;
    alloc(key: string, capacity?: number): Semaphore;
}
export {};
