Contributing to Gammapy
=======================

Note: This text is freely inspired by the `Contribution.md <https://raw.githubusercontent.com/astropy/astropy/main/CONTRIBUTING.md>`
file of the [Astropy](https://www.astropy.org/) project.

Reporting Issues
----------------

When opening an issue to report a problem or request for a new feature, please try to provide a minimal code
example that reproduces the issue along with details of the operating system and `Gammapy` version you are using.


Contributing Code and Documentation
-----------------------------------

So you are interested in contributing to the Gammapy Project?  Excellent!
We love contributions! Gammapy is open source, built on open source, and
we'd love to have you hang out in our community.

How to Contribute, Best Practices
---------------------------------

Most contributions to Gammapy are done via [pull requests](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/about-pull-requests)
from GitHub users' forks of the [gammapy repository](https://github.com/gammapy/gammapy). If you are new to this
style of development, you will want to read over our [Developer guide](https://docs.gammapy.org/dev/development/intro.html).

Promoting contributions
-----------------------
Even in the Open Source landscape, promoting the work of any is not only *natural* but also a duty for the 
Gammapy leading parties. We are taking care that 
**each contribution is correctly awarded for each product of the Gammapy project**.  

An [Authorship Policy](https://github.com/gammapy/gammapy/blob/master/docs/development/pigs/pig-024.rst) 
has been settled of each type of products (releases, papers, conferences). Note that each code release
(LTS, feature release or bug release) will be published with an official DOI (though the 
[Zenodo deposit](https://zenodo.org/)) that you can use as an Open Science publication. This publication 
is associated with a list of *authors* stored into our metada files (``CITATION.cff`` and ``codemeta.json``).

In order to properly build the authors list with you as contributor, Gammapy is using the so-called 
**Developer Certificate of Origin** (DCO). This is a lightweight way for contributors to certify 
that they wrote or otherwise have the right to submit the code they are contributing to the project.
The used DCO is from the Linux Foundation and can be found 
[below](#markdown-header-gammapy-developer-certification-of-origin). The practical acceptation of our DCO
can be found 
[here](https://docs.gammapy.org/dev/development/intro.html#Acceptation-of-the-Developer-Certificate-of-Origin-(DCO)).

Gammapy Developer Certification of Origin
-----------------------------------------

> Developer Certificate of Origin
> Version 1.1
> 
> Copyright (C) 2004, 2006 The Linux Foundation and its contributors.
> 
> Everyone is permitted to copy and distribute verbatim copies of this
> license document, but changing it is not allowed.
> 
> 
> Developer's Certificate of Origin 1.1
> 
> By making a contribution to this project, I certify that:
> 
> (a) The contribution was created in whole or in part by me and I
>     have the right to submit it under the open source license
>     indicated in the file; or
> 
> (b) The contribution is based upon previous work that, to the best
>     of my knowledge, is covered under an appropriate open source
>     license and I have the right under that license to submit that
>     work with modifications, whether created in whole or in part
>     by me, under the same open source license (unless I am
>     permitted to submit under a different license), as indicated
>     in the file; or
> 
> (c) The contribution was provided directly to me by some other
>     person who certified (a), (b) or (c) and I have not modified
>     it.
> 
> (d) I understand and agree that this project and the contribution
>     are public and that a record of the contribution (including all
>     personal information I submit with it, including my sign-off) is
>     maintained indefinitely and may be redistributed consistent with
>     this project or the open source license(s) involved.
> 
 