{
ctypesmapping.pas
Copyright (C) 2011  Andrew Haines andrewd207@aol.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
unit girCTypesMapping;

{$mode objfpc}{$H+}

interface

type
  TGType = record
    CType: string;
    PType: string;
  end;

var
  GTypes: array of TGType = (
    (CType: 'void';                     PType: 'void'),
    (CType: 'gpointer';                 PType: 'pointer'),
    (CType: 'int';                      PType: 'cint'),
    (CType: 'gint';                     PType: 'cint'),
    (CType: 'guint';                    PType: 'cuint'),
    (CType: 'guint8';                   PType: 'cuint8'),
    (CType: 'guint16';                  PType: 'cuint16'),
    (CType: 'guint32';                  PType: 'cuint32'),
    (CType: 'guint64';                  PType: 'cuint64'),
    (CType: 'gint8';                    PType: 'cint8'),
    (CType: 'gint16';                   PType: 'cint16'),
    (CType: 'gint32';                   PType: 'cint32'),
    (CType: 'gint64';                   PType: 'cint64'),
    (CType: 'gsize';                    PType: 'csize_t'),
    (CType: 'glong';                    PType: 'clong'),
    (CType: 'gulong';                   PType: 'culong'),
    (CType: 'gushort';                  PType: 'cushort'),
    (CType: 'gshort';                   PType: 'cshort'),
    (CType: 'gchar';                    PType: 'char'),
    (CType: 'guchar';                   PType: 'byte'),
    (CType: 'gboolean';                 PType: 'Boolean32'),
    (CType: 'gssize';                   PType: 'PtrInt'),
    (CType: 'int32';                    PType: 'cint32'),
    (CType: 'size_t' ;                  PType: 'csize_t'),
    (CType: 'gconstpointer';            PType: 'gpointer'),
    (CType: 'gfloat';                   PType: 'cfloat'),
    (CType: 'gdouble';                  PType: 'cdouble'),
    (CType: 'double';                   PType: 'cdouble'),
    (CType: 'char';                     PType: 'char'),
    (CType: 'goffset';                  PType: 'Int64'),
    (CType: 'long double';              PType: 'Extended'),
    (CType: 'gunichar';                 PType: 'guint32'),
    (CType: 'gunichar2';                PType: 'guint32'),
    (CType: 'file';                     PType: 'file'),
    (CType: 'pid_t';                    PType: 'cint32'),
    (CType: 'time_t';                   PType: 'cint64'),
    (CType: 'uid_t';                    PType: 'cuint32'),
    (CType: 'unsigned long long';       PType: 'qword'),
    (CType: 'TGType';                   PType: 'gsize'),
	{Keep GType always at last position.}
    (CType: 'GType';                    PType: 'TGType')
  );

  function LookupGTypeToCType(AName: String): String;



implementation

function LookupGTypeToCType(AName: String): String;
var
  i: Integer;
begin
  //WriteLn('Looking up: ', AName);
  for i := Low(GTypes) to High(GTypes) do
    if AName = GTypes[i].CType then
      Exit(GTypes[i].PType);
  Result := '';
end;

end.

