// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An Amazon Web Services account within your environment that Amazon Inspector
// has been enabled for.
type Account struct {

	// The ID of the Amazon Web Services account.
	//
	// This member is required.
	AccountId *string

	// Details of the status of Amazon Inspector scans by resource type.
	//
	// This member is required.
	ResourceStatus *ResourceStatus

	// The status of Amazon Inspector for the account.
	//
	// This member is required.
	Status Status

	noSmithyDocumentSerde
}

// An object that contains details about an aggregation response based on Amazon
// Web Services accounts.
type AccountAggregation struct {

	// The type of finding.
	FindingType AggregationFindingType

	// The type of resource.
	ResourceType AggregationResourceType

	// The value to sort by.
	SortBy AccountSortBy

	// The sort order (ascending or descending).
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// An aggregation of findings by Amazon Web Services account ID.
type AccountAggregationResponse struct {

	// The Amazon Web Services account ID.
	AccountId *string

	//  The number of findings that have an exploit available.
	ExploitAvailableCount *int64

	//  Details about the number of fixes.
	FixAvailableCount *int64

	// The number of findings by severity.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// An object with details the status of an Amazon Web Services account within your
// Amazon Inspector environment.
type AccountState struct {

	// The Amazon Web Services account ID.
	//
	// This member is required.
	AccountId *string

	// An object detailing which resources Amazon Inspector is enabled to scan for the
	// account.
	//
	// This member is required.
	ResourceState *ResourceState

	// An object detailing the status of Amazon Inspector for the account.
	//
	// This member is required.
	State *State

	noSmithyDocumentSerde
}

// Contains details about an aggregation request.
//
// The following types satisfy this interface:
//
//	AggregationRequestMemberAccountAggregation
//	AggregationRequestMemberAmiAggregation
//	AggregationRequestMemberAwsEcrContainerAggregation
//	AggregationRequestMemberCodeRepositoryAggregation
//	AggregationRequestMemberEc2InstanceAggregation
//	AggregationRequestMemberFindingTypeAggregation
//	AggregationRequestMemberImageLayerAggregation
//	AggregationRequestMemberLambdaFunctionAggregation
//	AggregationRequestMemberLambdaLayerAggregation
//	AggregationRequestMemberPackageAggregation
//	AggregationRequestMemberRepositoryAggregation
//	AggregationRequestMemberTitleAggregation
type AggregationRequest interface {
	isAggregationRequest()
}

// An object that contains details about an aggregation request based on Amazon
// Web Services account IDs.
type AggregationRequestMemberAccountAggregation struct {
	Value AccountAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberAccountAggregation) isAggregationRequest() {}

// An object that contains details about an aggregation request based on Amazon
// Machine Images (AMIs).
type AggregationRequestMemberAmiAggregation struct {
	Value AmiAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberAmiAggregation) isAggregationRequest() {}

// An object that contains details about an aggregation request based on Amazon
// ECR container images.
type AggregationRequestMemberAwsEcrContainerAggregation struct {
	Value AwsEcrContainerAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberAwsEcrContainerAggregation) isAggregationRequest() {}

// An object that contains details about an aggregation request based on code
// repositories.
type AggregationRequestMemberCodeRepositoryAggregation struct {
	Value CodeRepositoryAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberCodeRepositoryAggregation) isAggregationRequest() {}

// An object that contains details about an aggregation request based on Amazon
// EC2 instances.
type AggregationRequestMemberEc2InstanceAggregation struct {
	Value Ec2InstanceAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberEc2InstanceAggregation) isAggregationRequest() {}

// An object that contains details about an aggregation request based on finding
// types.
type AggregationRequestMemberFindingTypeAggregation struct {
	Value FindingTypeAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberFindingTypeAggregation) isAggregationRequest() {}

// An object that contains details about an aggregation request based on container
// image layers.
type AggregationRequestMemberImageLayerAggregation struct {
	Value ImageLayerAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberImageLayerAggregation) isAggregationRequest() {}

// Returns an object with findings aggregated by Amazon Web Services Lambda
// function.
type AggregationRequestMemberLambdaFunctionAggregation struct {
	Value LambdaFunctionAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberLambdaFunctionAggregation) isAggregationRequest() {}

// Returns an object with findings aggregated by Amazon Web Services Lambda layer.
type AggregationRequestMemberLambdaLayerAggregation struct {
	Value LambdaLayerAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberLambdaLayerAggregation) isAggregationRequest() {}

// An object that contains details about an aggregation request based on operating
// system package type.
type AggregationRequestMemberPackageAggregation struct {
	Value PackageAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberPackageAggregation) isAggregationRequest() {}

// An object that contains details about an aggregation request based on Amazon
// ECR repositories.
type AggregationRequestMemberRepositoryAggregation struct {
	Value RepositoryAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberRepositoryAggregation) isAggregationRequest() {}

// An object that contains details about an aggregation request based on finding
// title.
type AggregationRequestMemberTitleAggregation struct {
	Value TitleAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberTitleAggregation) isAggregationRequest() {}

// A structure that contains details about the results of an aggregation type.
//
// The following types satisfy this interface:
//
//	AggregationResponseMemberAccountAggregation
//	AggregationResponseMemberAmiAggregation
//	AggregationResponseMemberAwsEcrContainerAggregation
//	AggregationResponseMemberCodeRepositoryAggregation
//	AggregationResponseMemberEc2InstanceAggregation
//	AggregationResponseMemberFindingTypeAggregation
//	AggregationResponseMemberImageLayerAggregation
//	AggregationResponseMemberLambdaFunctionAggregation
//	AggregationResponseMemberLambdaLayerAggregation
//	AggregationResponseMemberPackageAggregation
//	AggregationResponseMemberRepositoryAggregation
//	AggregationResponseMemberTitleAggregation
type AggregationResponse interface {
	isAggregationResponse()
}

// An object that contains details about an aggregation response based on Amazon
// Web Services account IDs.
type AggregationResponseMemberAccountAggregation struct {
	Value AccountAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberAccountAggregation) isAggregationResponse() {}

// An object that contains details about an aggregation response based on Amazon
// Machine Images (AMIs).
type AggregationResponseMemberAmiAggregation struct {
	Value AmiAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberAmiAggregation) isAggregationResponse() {}

// An object that contains details about an aggregation response based on Amazon
// ECR container images.
type AggregationResponseMemberAwsEcrContainerAggregation struct {
	Value AwsEcrContainerAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberAwsEcrContainerAggregation) isAggregationResponse() {}

// An object that contains details about an aggregation response based on code
// repositories.
type AggregationResponseMemberCodeRepositoryAggregation struct {
	Value CodeRepositoryAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberCodeRepositoryAggregation) isAggregationResponse() {}

// An object that contains details about an aggregation response based on Amazon
// EC2 instances.
type AggregationResponseMemberEc2InstanceAggregation struct {
	Value Ec2InstanceAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberEc2InstanceAggregation) isAggregationResponse() {}

// An object that contains details about an aggregation response based on finding
// types.
type AggregationResponseMemberFindingTypeAggregation struct {
	Value FindingTypeAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberFindingTypeAggregation) isAggregationResponse() {}

// An object that contains details about an aggregation response based on
// container image layers.
type AggregationResponseMemberImageLayerAggregation struct {
	Value ImageLayerAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberImageLayerAggregation) isAggregationResponse() {}

// An aggregation of findings by Amazon Web Services Lambda function.
type AggregationResponseMemberLambdaFunctionAggregation struct {
	Value LambdaFunctionAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberLambdaFunctionAggregation) isAggregationResponse() {}

// An aggregation of findings by Amazon Web Services Lambda layer.
type AggregationResponseMemberLambdaLayerAggregation struct {
	Value LambdaLayerAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberLambdaLayerAggregation) isAggregationResponse() {}

// An object that contains details about an aggregation response based on
// operating system package type.
type AggregationResponseMemberPackageAggregation struct {
	Value PackageAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberPackageAggregation) isAggregationResponse() {}

// An object that contains details about an aggregation response based on Amazon
// ECR repositories.
type AggregationResponseMemberRepositoryAggregation struct {
	Value RepositoryAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberRepositoryAggregation) isAggregationResponse() {}

// An object that contains details about an aggregation response based on finding
// title.
type AggregationResponseMemberTitleAggregation struct {
	Value TitleAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberTitleAggregation) isAggregationResponse() {}

// The details that define an aggregation based on Amazon machine images (AMIs).
type AmiAggregation struct {

	// The IDs of AMIs to aggregate findings for.
	Amis []StringFilter

	// The value to sort results by.
	SortBy AmiSortBy

	// The order to sort results by.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// A response that contains the results of a finding aggregation by AMI.
type AmiAggregationResponse struct {

	// The ID of the AMI that findings were aggregated for.
	//
	// This member is required.
	Ami *string

	// The Amazon Web Services account ID for the AMI.
	AccountId *string

	// The IDs of Amazon EC2 instances using this AMI.
	AffectedInstances *int64

	// An object that contains the count of matched findings per severity.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// Contains details about a request to associate a code repository with a scan
// configuration.
type AssociateConfigurationRequest struct {

	// Identifies a specific resource in a code repository that will be scanned.
	//
	// This member is required.
	Resource CodeSecurityResource

	// The Amazon Resource Name (ARN) of the scan configuration.
	//
	// This member is required.
	ScanConfigurationArn *string

	noSmithyDocumentSerde
}

// The Amazon Web Services Threat Intel Group (ATIG) details for a specific
// vulnerability.
type AtigData struct {

	// The date and time this vulnerability was first observed.
	FirstSeen *time.Time

	// The date and time this vulnerability was last observed.
	LastSeen *time.Time

	// The commercial sectors this vulnerability targets.
	Targets []string

	// The [MITRE ATT&CK] tactics, techniques, and procedures (TTPs) associated with vulnerability.
	//
	// [MITRE ATT&CK]: https://attack.mitre.org/
	Ttps []string

	noSmithyDocumentSerde
}

// Represents which scan types are automatically enabled for new members of your
// Amazon Inspector organization.
type AutoEnable struct {

	// Represents whether Amazon EC2 scans are automatically enabled for new members
	// of your Amazon Inspector organization.
	//
	// This member is required.
	Ec2 *bool

	// Represents whether Amazon ECR scans are automatically enabled for new members
	// of your Amazon Inspector organization.
	//
	// This member is required.
	Ecr *bool

	// Represents whether code repository scans are automatically enabled for new
	// members of your Amazon Inspector organization.
	CodeRepository *bool

	// Represents whether Amazon Web Services Lambda standard scans are automatically
	// enabled for new members of your Amazon Inspector organization.
	Lambda *bool

	// Represents whether Lambda code scans are automatically enabled for new members
	// of your Amazon Inspector organization.
	LambdaCode *bool

	noSmithyDocumentSerde
}

// Details of the Amazon EC2 instance involved in a finding.
type AwsEc2InstanceDetails struct {

	// The IAM instance profile ARN of the Amazon EC2 instance.
	IamInstanceProfileArn *string

	// The image ID of the Amazon EC2 instance.
	ImageId *string

	// The IPv4 addresses of the Amazon EC2 instance.
	IpV4Addresses []string

	// The IPv6 addresses of the Amazon EC2 instance.
	IpV6Addresses []string

	// The name of the key pair used to launch the Amazon EC2 instance.
	KeyName *string

	// The date and time the Amazon EC2 instance was launched at.
	LaunchedAt *time.Time

	// The platform of the Amazon EC2 instance.
	Platform *string

	// The subnet ID of the Amazon EC2 instance.
	SubnetId *string

	// The type of the Amazon EC2 instance.
	Type *string

	// The VPC ID of the Amazon EC2 instance.
	VpcId *string

	noSmithyDocumentSerde
}

// An aggregation of information about Amazon ECR containers.
type AwsEcrContainerAggregation struct {

	// The architecture of the containers.
	Architectures []StringFilter

	// The image SHA values.
	ImageShas []StringFilter

	// The image tags.
	ImageTags []StringFilter

	// The number of Amazon ECS tasks or Amazon EKS pods where the Amazon ECR
	// container image is in use.
	InUseCount []NumberFilter

	// The last time an Amazon ECR image was used in an Amazon ECS task or Amazon EKS
	// pod.
	LastInUseAt []DateFilter

	// The container repositories.
	Repositories []StringFilter

	// The container resource IDs.
	ResourceIds []StringFilter

	// The value to sort by.
	SortBy AwsEcrContainerSortBy

	// The sort order (ascending or descending).
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// An aggregation of information about Amazon ECR containers.
type AwsEcrContainerAggregationResponse struct {

	// The resource ID of the container.
	//
	// This member is required.
	ResourceId *string

	// The Amazon Web Services account ID of the account that owns the container.
	AccountId *string

	// The architecture of the container.
	Architecture *string

	// The SHA value of the container image.
	ImageSha *string

	// The container image stags.
	ImageTags []string

	// The number of Amazon ECS tasks or Amazon EKS pods where the Amazon ECR
	// container image is in use.
	InUseCount *int64

	// The last time an Amazon ECR image was used in an Amazon ECS task or Amazon EKS
	// pod.
	LastInUseAt *time.Time

	// The container repository.
	Repository *string

	// The number of finding by severity.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// The image details of the Amazon ECR container image.
type AwsEcrContainerImageDetails struct {

	// The image hash of the Amazon ECR container image.
	//
	// This member is required.
	ImageHash *string

	// The registry for the Amazon ECR container image.
	//
	// This member is required.
	Registry *string

	// The name of the repository the Amazon ECR container image resides in.
	//
	// This member is required.
	RepositoryName *string

	// The architecture of the Amazon ECR container image.
	Architecture *string

	// The image author of the Amazon ECR container image.
	Author *string

	// The image tags attached to the Amazon ECR container image.
	ImageTags []string

	// The number of Amazon ECS tasks or Amazon EKS pods where the Amazon ECR
	// container image is in use.
	InUseCount *int64

	// The last time an Amazon ECR image was used in an Amazon ECS task or Amazon EKS
	// pod.
	LastInUseAt *time.Time

	// The platform of the Amazon ECR container image.
	Platform *string

	// The date and time the Amazon ECR container image was pushed.
	PushedAt *time.Time

	noSmithyDocumentSerde
}

// Metadata about tasks where an image was in use.
type AwsEcsMetadataDetails struct {

	// The details group information for a task in a cluster.
	//
	// This member is required.
	DetailsGroup *string

	// The task definition ARN.
	//
	// This member is required.
	TaskDefinitionArn *string

	noSmithyDocumentSerde
}

// The metadata for an Amazon EKS pod where an Amazon ECR image is in use.
type AwsEksMetadataDetails struct {

	// The namespace for an Amazon EKS cluster.
	Namespace *string

	// The list of workloads.
	WorkloadInfoList []AwsEksWorkloadInfo

	noSmithyDocumentSerde
}

// Information about the workload.
type AwsEksWorkloadInfo struct {

	// The name of the workload.
	//
	// This member is required.
	Name *string

	// The workload type.
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// A summary of information about the Amazon Web Services Lambda function.
type AwsLambdaFunctionDetails struct {

	// The SHA256 hash of the Amazon Web Services Lambda function's deployment package.
	//
	// This member is required.
	CodeSha256 *string

	// The Amazon Web Services Lambda function's execution role.
	//
	// This member is required.
	ExecutionRoleArn *string

	// The name of the Amazon Web Services Lambda function.
	//
	// This member is required.
	FunctionName *string

	// The runtime environment for the Amazon Web Services Lambda function.
	//
	// This member is required.
	Runtime Runtime

	// The version of the Amazon Web Services Lambda function.
	//
	// This member is required.
	Version *string

	// The instruction set architecture that the Amazon Web Services Lambda function
	// supports. Architecture is a string array with one of the valid values. The
	// default architecture value is x86_64 .
	Architectures []Architecture

	// The date and time that a user last updated the configuration, in [ISO 8601 format]
	//
	// [ISO 8601 format]: https://www.iso.org/iso-8601-date-and-time-format.html
	LastModifiedAt *time.Time

	// The Amazon Web Services Lambda function's [layers]. A Lambda function can have up to
	// five layers.
	//
	// [layers]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html
	Layers []string

	// The type of deployment package. Set to Image for container image and set Zip
	// for .zip file archive.
	PackageType PackageType

	// The Amazon Web Services Lambda function's networking configuration.
	VpcConfig *LambdaVpcConfig

	noSmithyDocumentSerde
}

// The Cybersecurity and Infrastructure Security Agency (CISA) details for a
// specific vulnerability.
type CisaData struct {

	// The remediation action recommended by CISA for this vulnerability.
	Action *string

	// The date and time CISA added this vulnerability to their catalogue.
	DateAdded *time.Time

	// The date and time CISA expects a fix to have been provided vulnerability.
	DateDue *time.Time

	noSmithyDocumentSerde
}

// A CIS check.
type CisCheckAggregation struct {

	// The scan ARN for the CIS check scan ARN.
	//
	// This member is required.
	ScanArn *string

	// The account ID for the CIS check.
	AccountId *string

	// The description for the CIS check.
	CheckDescription *string

	// The check ID for the CIS check.
	CheckId *string

	// The CIS check level.
	Level CisSecurityLevel

	// The CIS check platform.
	Platform *string

	// The CIS check status counts.
	StatusCounts *StatusCounts

	// The CIS check title.
	Title *string

	noSmithyDocumentSerde
}

// The CIS date filter.
type CisDateFilter struct {

	// The CIS date filter's earliest scan start time.
	EarliestScanStartTime *time.Time

	// The CIS date filter's latest scan start time.
	LatestScanStartTime *time.Time

	noSmithyDocumentSerde
}

// The CIS finding status filter.
type CisFindingStatusFilter struct {

	// The comparison value of the CIS finding status filter.
	//
	// This member is required.
	Comparison CisFindingStatusComparison

	// The value of the CIS finding status filter.
	//
	// This member is required.
	Value CisFindingStatus

	noSmithyDocumentSerde
}

// The CIS number filter.
type CisNumberFilter struct {

	// The CIS number filter's lower inclusive.
	LowerInclusive *int32

	// The CIS number filter's upper inclusive.
	UpperInclusive *int32

	noSmithyDocumentSerde
}

// The CIS result status filter.
type CisResultStatusFilter struct {

	// The comparison value of the CIS result status filter.
	//
	// This member is required.
	Comparison CisResultStatusComparison

	// The value of the CIS result status filter.
	//
	// This member is required.
	Value CisResultStatus

	noSmithyDocumentSerde
}

// The CIS scan.
type CisScan struct {

	// The CIS scan's ARN.
	//
	// This member is required.
	ScanArn *string

	// The CIS scan's configuration ARN.
	//
	// This member is required.
	ScanConfigurationArn *string

	// The CIS scan's failed checks.
	FailedChecks *int32

	// The CIS scan's date.
	ScanDate *time.Time

	// The the name of the scan configuration that's associated with this scan.
	ScanName *string

	// The account or organization that schedules the CIS scan.
	ScheduledBy *string

	//  The security level for the CIS scan. Security level refers to the Benchmark
	// levels that CIS assigns to a profile.
	SecurityLevel CisSecurityLevel

	// The CIS scan's status.
	Status CisScanStatus

	// The CIS scan's targets.
	Targets *CisTargets

	// The CIS scan's total checks.
	TotalChecks *int32

	noSmithyDocumentSerde
}

// The CIS scan configuration.
type CisScanConfiguration struct {

	// The CIS scan configuration's scan configuration ARN.
	//
	// This member is required.
	ScanConfigurationArn *string

	// The CIS scan configuration's owner ID.
	OwnerId *string

	// The name of the CIS scan configuration.
	ScanName *string

	// The CIS scan configuration's schedule.
	Schedule Schedule

	// The CIS scan configuration's security level.
	SecurityLevel CisSecurityLevel

	// The CIS scan configuration's tags.
	Tags map[string]string

	// The CIS scan configuration's targets.
	Targets *CisTargets

	noSmithyDocumentSerde
}

// The CIS scan result details.
type CisScanResultDetails struct {

	// The CIS scan result details' scan ARN.
	//
	// This member is required.
	ScanArn *string

	// The CIS scan result details' account ID.
	AccountId *string

	// The account ID that's associated with the CIS scan result details.
	CheckDescription *string

	// The CIS scan result details' check ID.
	CheckId *string

	// The CIS scan result details' finding ARN.
	FindingArn *string

	// The CIS scan result details' level.
	Level CisSecurityLevel

	// The CIS scan result details' platform.
	Platform *string

	// The CIS scan result details' remediation.
	Remediation *string

	// The CIS scan result details' status.
	Status CisFindingStatus

	// The CIS scan result details' status reason.
	StatusReason *string

	// The CIS scan result details' target resource ID.
	TargetResourceId *string

	// The CIS scan result details' title.
	Title *string

	noSmithyDocumentSerde
}

// The CIS scan result details filter criteria.
type CisScanResultDetailsFilterCriteria struct {

	// The criteria's check ID filters.
	CheckIdFilters []CisStringFilter

	// The criteria's finding ARN filters.
	FindingArnFilters []CisStringFilter

	// The criteria's finding status filters.
	FindingStatusFilters []CisFindingStatusFilter

	//  The criteria's security level filters. . Security level refers to the
	// Benchmark levels that CIS assigns to a profile.
	SecurityLevelFilters []CisSecurityLevelFilter

	// The criteria's title filters.
	TitleFilters []CisStringFilter

	noSmithyDocumentSerde
}

// The scan results aggregated by checks filter criteria.
type CisScanResultsAggregatedByChecksFilterCriteria struct {

	// The criteria's account ID filters.
	AccountIdFilters []CisStringFilter

	// The criteria's check ID filters.
	CheckIdFilters []CisStringFilter

	// The criteria's failed resources filters.
	FailedResourcesFilters []CisNumberFilter

	// The criteria's platform filters.
	PlatformFilters []CisStringFilter

	// The criteria's security level filters.
	SecurityLevelFilters []CisSecurityLevelFilter

	// The criteria's title filters.
	TitleFilters []CisStringFilter

	noSmithyDocumentSerde
}

// The scan results aggregated by target resource filter criteria.
type CisScanResultsAggregatedByTargetResourceFilterCriteria struct {

	// The criteria's account ID filters.
	AccountIdFilters []CisStringFilter

	// The criteria's check ID filters.
	CheckIdFilters []CisStringFilter

	// The criteria's failed checks filters.
	FailedChecksFilters []CisNumberFilter

	// The criteria's platform filters.
	PlatformFilters []CisStringFilter

	// The criteria's status filter.
	StatusFilters []CisResultStatusFilter

	// The criteria's target resource ID filters.
	TargetResourceIdFilters []CisStringFilter

	// The criteria's target resource tag filters.
	TargetResourceTagFilters []TagFilter

	// The criteria's target status filters.
	TargetStatusFilters []CisTargetStatusFilter

	// The criteria's target status reason filters.
	TargetStatusReasonFilters []CisTargetStatusReasonFilter

	noSmithyDocumentSerde
}

// The CIS scan status filter.
type CisScanStatusFilter struct {

	// The filter comparison value.
	//
	// This member is required.
	Comparison CisScanStatusComparison

	// The filter value.
	//
	// This member is required.
	Value CisScanStatus

	noSmithyDocumentSerde
}

//	The CIS security level filter. Security level refers to the Benchmark levels
//
// that CIS assigns to a profile.
type CisSecurityLevelFilter struct {

	// The CIS security filter comparison value.
	//
	// This member is required.
	Comparison CisSecurityLevelComparison

	// The CIS security filter value.
	//
	// This member is required.
	Value CisSecurityLevel

	noSmithyDocumentSerde
}

// The CIS session message.
type CisSessionMessage struct {

	// The CIS rule details for the CIS session message.
	//
	// This member is required.
	CisRuleDetails []byte

	// The rule ID for the CIS session message.
	//
	// This member is required.
	RuleId *string

	// The status of the CIS session message.
	//
	// This member is required.
	Status CisRuleStatus

	noSmithyDocumentSerde
}

// The CIS string filter.
type CisStringFilter struct {

	// The comparison value of the CIS string filter.
	//
	// This member is required.
	Comparison CisStringComparison

	// The value of the CIS string filter.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The CIS target resource aggregation.
type CisTargetResourceAggregation struct {

	// The scan ARN for the CIS target resource.
	//
	// This member is required.
	ScanArn *string

	// The account ID for the CIS target resource.
	AccountId *string

	// The platform for the CIS target resource.
	Platform *string

	// The target resource status counts.
	StatusCounts *StatusCounts

	// The ID of the target resource.
	TargetResourceId *string

	// The tag for the target resource.
	TargetResourceTags map[string][]string

	// The status of the target resource.
	TargetStatus CisTargetStatus

	// The reason for the target resource.
	TargetStatusReason CisTargetStatusReason

	noSmithyDocumentSerde
}

// The CIS targets.
type CisTargets struct {

	// The CIS target account ids.
	AccountIds []string

	// The CIS target resource tags.
	TargetResourceTags map[string][]string

	noSmithyDocumentSerde
}

// The CIS target status filter.
type CisTargetStatusFilter struct {

	// The comparison value of the CIS target status filter.
	//
	// This member is required.
	Comparison CisTargetStatusComparison

	// The value of the CIS target status filter.
	//
	// This member is required.
	Value CisTargetStatus

	noSmithyDocumentSerde
}

// The CIS target status reason filter.
type CisTargetStatusReasonFilter struct {

	// The comparison value of the CIS target status reason filter.
	//
	// This member is required.
	Comparison CisTargetStatusComparison

	// The value of the CIS target status reason filter.
	//
	// This member is required.
	Value CisTargetStatusReason

	noSmithyDocumentSerde
}

// Details about the task or pod in the cluster.
type ClusterDetails struct {

	// The metadata for a cluster.
	//
	// This member is required.
	ClusterMetadata ClusterMetadata

	// The last timestamp when Amazon Inspector recorded the image in use in the task
	// or pod in the cluster.
	//
	// This member is required.
	LastInUse *time.Time

	// The number of tasks or pods where an image was running on the cluster.
	RunningUnitCount *int64

	// The number of tasks or pods where an image was stopped on the cluster in the
	// last 24 hours.
	StoppedUnitCount *int64

	noSmithyDocumentSerde
}

// The filter criteria to be used.
type ClusterForImageFilterCriteria struct {

	// The resource Id to be used in the filter criteria.
	//
	// This member is required.
	ResourceId *string

	noSmithyDocumentSerde
}

// Information about the cluster.
type ClusterInformation struct {

	// The cluster ARN.
	//
	// This member is required.
	ClusterArn *string

	// Details about the cluster.
	ClusterDetails []ClusterDetails

	noSmithyDocumentSerde
}

// The metadata for a cluster.
//
// The following types satisfy this interface:
//
//	ClusterMetadataMemberAwsEcsMetadataDetails
//	ClusterMetadataMemberAwsEksMetadataDetails
type ClusterMetadata interface {
	isClusterMetadata()
}

// The details for an Amazon ECS cluster in the cluster metadata.
type ClusterMetadataMemberAwsEcsMetadataDetails struct {
	Value AwsEcsMetadataDetails

	noSmithyDocumentSerde
}

func (*ClusterMetadataMemberAwsEcsMetadataDetails) isClusterMetadata() {}

// The details for an Amazon EKS cluster in the cluster metadata.
type ClusterMetadataMemberAwsEksMetadataDetails struct {
	Value AwsEksMetadataDetails

	noSmithyDocumentSerde
}

func (*ClusterMetadataMemberAwsEksMetadataDetails) isClusterMetadata() {}

// Contains information on where a code vulnerability is located in your Lambda
// function.
type CodeFilePath struct {

	// The line number of the last line of code that a vulnerability was found in.
	//
	// This member is required.
	EndLine *int32

	// The name of the file the code vulnerability was found in.
	//
	// This member is required.
	FileName *string

	// The file path to the code that a vulnerability was found in.
	//
	// This member is required.
	FilePath *string

	// The line number of the first line of code that a vulnerability was found in.
	//
	// This member is required.
	StartLine *int32

	noSmithyDocumentSerde
}

// Contains information on the lines of code associated with a code snippet.
type CodeLine struct {

	// The content of a line of code
	//
	// This member is required.
	Content *string

	// The line number that a section of code is located at.
	//
	// This member is required.
	LineNumber *int32

	noSmithyDocumentSerde
}

// The details that define an aggregation based on code repositories.
type CodeRepositoryAggregation struct {

	// The project names to include in the aggregation results.
	ProjectNames []StringFilter

	// The repository provider types to include in the aggregation results.
	ProviderTypes []StringFilter

	// The resource IDs to include in the aggregation results.
	ResourceIds []StringFilter

	// The value to sort results by in the code repository aggregation.
	SortBy CodeRepositorySortBy

	// The order to sort results by (ascending or descending) in the code repository
	// aggregation.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// A response that contains the results of a finding aggregation by code
// repository.
type CodeRepositoryAggregationResponse struct {

	// The names of the projects associated with the code repository.
	//
	// This member is required.
	ProjectNames *string

	// The Amazon Web Services account ID associated with the code repository.
	AccountId *string

	// The number of active findings that have an exploit available for the code
	// repository.
	ExploitAvailableActiveFindingsCount *int64

	// The number of active findings that have a fix available for the code repository.
	FixAvailableActiveFindingsCount *int64

	// The type of repository provider for the code repository.
	ProviderType *string

	// The resource ID of the code repository.
	ResourceId *string

	// An object that contains the counts of aggregated finding per severity.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// Contains details about a code repository associated with a finding.
type CodeRepositoryDetails struct {

	// The Amazon Resource Name (ARN) of the code security integration associated with
	// the repository.
	IntegrationArn *string

	// The name of the project in the code repository.
	ProjectName *string

	// The type of repository provider (such as GitHub, GitLab, etc.).
	ProviderType CodeRepositoryProviderType

	noSmithyDocumentSerde
}

// Contains metadata information about a code repository that is being scanned by
// Amazon Inspector.
type CodeRepositoryMetadata struct {

	// The name of the project in the code repository.
	//
	// This member is required.
	ProjectName *string

	// The type of repository provider (such as GitHub, GitLab, etc.).
	//
	// This member is required.
	ProviderType *string

	// The visibility setting of the repository (public or private).
	//
	// This member is required.
	ProviderTypeVisibility *string

	// The Amazon Resource Name (ARN) of the code security integration associated with
	// the repository.
	IntegrationArn *string

	// The ID of the last commit that was scanned in the repository.
	LastScannedCommitId *string

	// Information about on-demand scans performed on the repository.
	OnDemandScan *CodeRepositoryOnDemandScan

	// The scan configuration settings applied to the code repository.
	ScanConfiguration *ProjectCodeSecurityScanConfiguration

	noSmithyDocumentSerde
}

// Contains information about on-demand scans performed on a code repository.
type CodeRepositoryOnDemandScan struct {

	// The timestamp when the last on-demand scan was performed.
	LastScanAt *time.Time

	// The ID of the last commit that was scanned during an on-demand scan.
	LastScannedCommitId *string

	// The status of the scan.
	ScanStatus *ScanStatus

	noSmithyDocumentSerde
}

// A summary of information about a code security integration.
type CodeSecurityIntegrationSummary struct {

	// The timestamp when the code security integration was created.
	//
	// This member is required.
	CreatedOn *time.Time

	// The Amazon Resource Name (ARN) of the code security integration.
	//
	// This member is required.
	IntegrationArn *string

	// The timestamp when the code security integration was last updated.
	//
	// This member is required.
	LastUpdateOn *time.Time

	// The name of the code security integration.
	//
	// This member is required.
	Name *string

	// The current status of the code security integration.
	//
	// This member is required.
	Status IntegrationStatus

	// The reason for the current status of the code security integration.
	//
	// This member is required.
	StatusReason *string

	// The type of repository provider for the integration.
	//
	// This member is required.
	Type IntegrationType

	// The tags associated with the code security integration.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Identifies a specific resource in a code repository that will be scanned.
//
// The following types satisfy this interface:
//
//	CodeSecurityResourceMemberProjectId
type CodeSecurityResource interface {
	isCodeSecurityResource()
}

// The unique identifier of the project in the code repository.
type CodeSecurityResourceMemberProjectId struct {
	Value string

	noSmithyDocumentSerde
}

func (*CodeSecurityResourceMemberProjectId) isCodeSecurityResource() {}

// Contains the configuration settings for code security scans.
type CodeSecurityScanConfiguration struct {

	// The categories of security rules to be applied during the scan.
	//
	// This member is required.
	RuleSetCategories []RuleSetCategory

	// Configuration settings for continuous integration scans that run automatically
	// when code changes are made.
	ContinuousIntegrationScanConfiguration *ContinuousIntegrationScanConfiguration

	// Configuration settings for periodic scans that run on a scheduled basis.
	PeriodicScanConfiguration *PeriodicScanConfiguration

	noSmithyDocumentSerde
}

// A summary of an association between a code repository and a scan configuration.
type CodeSecurityScanConfigurationAssociationSummary struct {

	// Identifies a specific resource in a code repository that will be scanned.
	Resource CodeSecurityResource

	noSmithyDocumentSerde
}

// A summary of information about a code security scan configuration.
type CodeSecurityScanConfigurationSummary struct {

	// The name of the scan configuration.
	//
	// This member is required.
	Name *string

	// The Amazon Web Services account ID that owns the scan configuration.
	//
	// This member is required.
	OwnerAccountId *string

	// The categories of security rules applied during the scan.
	//
	// This member is required.
	RuleSetCategories []RuleSetCategory

	// The Amazon Resource Name (ARN) of the scan configuration.
	//
	// This member is required.
	ScanConfigurationArn *string

	// The repository events that trigger continuous integration scans.
	ContinuousIntegrationScanSupportedEvents []ContinuousIntegrationScanEvent

	// The schedule expression for periodic scans, in cron format.
	FrequencyExpression *string

	// The frequency at which periodic scans are performed.
	PeriodicScanFrequency PeriodicScanFrequency

	// The scope settings that define which repositories will be scanned. If the
	// ScopeSetting parameter is ALL the scan configuration applies to all existing
	// and future projects imported into Amazon Inspector.
	ScopeSettings *ScopeSettings

	// The tags associated with the scan configuration.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains information about any errors encountered while trying to retrieve a
// code snippet.
type CodeSnippetError struct {

	// The error code for the error that prevented a code snippet from being retrieved.
	//
	// This member is required.
	ErrorCode CodeSnippetErrorCode

	// The error message received when Amazon Inspector failed to retrieve a code
	// snippet.
	//
	// This member is required.
	ErrorMessage *string

	// The ARN of the finding that a code snippet couldn't be retrieved for.
	//
	// This member is required.
	FindingArn *string

	noSmithyDocumentSerde
}

// Contains information on a code snippet retrieved by Amazon Inspector from a
// code vulnerability finding.
type CodeSnippetResult struct {

	// Contains information on the retrieved code snippet.
	CodeSnippet []CodeLine

	// The line number of the last line of a code snippet.
	EndLine *int32

	// The ARN of a finding that the code snippet is associated with.
	FindingArn *string

	// The line number of the first line of a code snippet.
	StartLine *int32

	// Details of a suggested code fix.
	SuggestedFixes []SuggestedFix

	noSmithyDocumentSerde
}

// Contains information on the code vulnerability identified in your Lambda
// function.
type CodeVulnerabilityDetails struct {

	// The Common Weakness Enumeration (CWE) item associated with the detected
	// vulnerability.
	//
	// This member is required.
	Cwes []string

	// The ID for the Amazon CodeGuru detector associated with the finding. For more
	// information on detectors see [Amazon CodeGuru Detector Library].
	//
	// [Amazon CodeGuru Detector Library]: https://docs.aws.amazon.com/codeguru/detector-library
	//
	// This member is required.
	DetectorId *string

	// The name of the detector used to identify the code vulnerability. For more
	// information on detectors see [CodeGuru Detector Library].
	//
	// [CodeGuru Detector Library]: https://docs.aws.amazon.com/codeguru/detector-library
	//
	// This member is required.
	DetectorName *string

	// Contains information on where the code vulnerability is located in your code.
	//
	// This member is required.
	FilePath *CodeFilePath

	// The detector tag associated with the vulnerability. Detector tags group related
	// vulnerabilities by common themes or tactics. For a list of available tags by
	// programming language, see [Java tags], or [Python tags].
	//
	// [Python tags]: https://docs.aws.amazon.com/codeguru/detector-library/python/tags/
	// [Java tags]: https://docs.aws.amazon.com/codeguru/detector-library/java/tags/
	DetectorTags []string

	// A URL containing supporting documentation about the code vulnerability detected.
	ReferenceUrls []string

	// The identifier for a rule that was used to detect the code vulnerability.
	RuleId *string

	// The Amazon Resource Name (ARN) of the Lambda layer that the code vulnerability
	// was detected in.
	SourceLambdaLayerArn *string

	noSmithyDocumentSerde
}

// A compute platform.
type ComputePlatform struct {

	// The compute platform product.
	Product *string

	// The compute platform vendor.
	Vendor *string

	// The compute platform version.
	Version *string

	noSmithyDocumentSerde
}

// Configuration settings for continuous integration scans that run automatically
// when code changes are made.
type ContinuousIntegrationScanConfiguration struct {

	// The repository events that trigger continuous integration scans, such as pull
	// requests or commits.
	//
	// This member is required.
	SupportedEvents []ContinuousIntegrationScanEvent

	noSmithyDocumentSerde
}

// a structure that contains information on the count of resources within a group.
type Counts struct {

	// The number of resources.
	Count int64

	// The key associated with this group
	GroupKey GroupKey

	noSmithyDocumentSerde
}

// Contains details of a coverage date filter.
type CoverageDateFilter struct {

	// A timestamp representing the end of the time period to filter results by.
	EndInclusive *time.Time

	// A timestamp representing the start of the time period to filter results by.
	StartInclusive *time.Time

	noSmithyDocumentSerde
}

// A structure that identifies filter criteria for GetCoverageStatistics .
type CoverageFilterCriteria struct {

	// An array of Amazon Web Services account IDs to return coverage statistics for.
	AccountId []CoverageStringFilter

	// Filter criteria for code repositories based on project name.
	CodeRepositoryProjectName []CoverageStringFilter

	// Filter criteria for code repositories based on provider type (such as GitHub,
	// GitLab, etc.).
	CodeRepositoryProviderType []CoverageStringFilter

	// Filter criteria for code repositories based on visibility setting (public or
	// private).
	CodeRepositoryProviderTypeVisibility []CoverageStringFilter

	// The Amazon EC2 instance tags to filter on.
	Ec2InstanceTags []CoverageMapFilter

	// The number of Amazon ECR images in use.
	EcrImageInUseCount []CoverageNumberFilter

	// The Amazon ECR image that was last in use.
	EcrImageLastInUseAt []CoverageDateFilter

	// The Amazon ECR image tags to filter on.
	EcrImageTags []CoverageStringFilter

	// The Amazon ECR repository name to filter on.
	EcrRepositoryName []CoverageStringFilter

	// The date an image was last pulled at.
	ImagePulledAt []CoverageDateFilter

	// Returns coverage statistics for Amazon Web Services Lambda functions filtered
	// by function names.
	LambdaFunctionName []CoverageStringFilter

	// Returns coverage statistics for Amazon Web Services Lambda functions filtered
	// by runtime.
	LambdaFunctionRuntime []CoverageStringFilter

	// Returns coverage statistics for Amazon Web Services Lambda functions filtered
	// by tag.
	LambdaFunctionTags []CoverageMapFilter

	// Filters Amazon Web Services resources based on whether Amazon Inspector has
	// checked them for vulnerabilities within the specified time range.
	LastScannedAt []CoverageDateFilter

	// Filter criteria for code repositories based on the ID of the last scanned
	// commit.
	LastScannedCommitId []CoverageStringFilter

	// An array of Amazon Web Services resource IDs to return coverage statistics for.
	ResourceId []CoverageStringFilter

	// An array of Amazon Web Services resource types to return coverage statistics
	// for. The values can be AWS_EC2_INSTANCE , AWS_LAMBDA_FUNCTION ,
	// AWS_ECR_CONTAINER_IMAGE , AWS_ECR_REPOSITORY or AWS_ACCOUNT .
	ResourceType []CoverageStringFilter

	// The filter to search for Amazon EC2 instance coverage by scan mode. Valid
	// values are EC2_SSM_AGENT_BASED and EC2_AGENTLESS .
	ScanMode []CoverageStringFilter

	// The scan status code to filter on. Valid values are: ValidationException ,
	// InternalServerException , ResourceNotFoundException , BadRequestException , and
	// ThrottlingException .
	ScanStatusCode []CoverageStringFilter

	// The scan status reason to filter on.
	ScanStatusReason []CoverageStringFilter

	// An array of Amazon Inspector scan types to return coverage statistics for.
	ScanType []CoverageStringFilter

	noSmithyDocumentSerde
}

// Contains details of a coverage map filter.
type CoverageMapFilter struct {

	// The operator to compare coverage on.
	//
	// This member is required.
	Comparison CoverageMapComparison

	// The tag key associated with the coverage map filter.
	//
	// This member is required.
	Key *string

	// The tag value associated with the coverage map filter.
	Value *string

	noSmithyDocumentSerde
}

// The coverage number to be used in the filter.
type CoverageNumberFilter struct {

	// The lower inclusive for the coverage number.
	LowerInclusive *int64

	// The upper inclusive for the coverage number.>
	UpperInclusive *int64

	noSmithyDocumentSerde
}

// Contains details of a coverage string filter.
type CoverageStringFilter struct {

	// The operator to compare strings on.
	//
	// This member is required.
	Comparison CoverageStringComparison

	// The value to compare strings on.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// An object that contains details about a resource covered by Amazon Inspector.
type CoveredResource struct {

	// The Amazon Web Services account ID of the covered resource.
	//
	// This member is required.
	AccountId *string

	// The ID of the covered resource.
	//
	// This member is required.
	ResourceId *string

	// The type of the covered resource.
	//
	// This member is required.
	ResourceType CoverageResourceType

	// The Amazon Inspector scan type covering the resource.
	//
	// This member is required.
	ScanType ScanType

	// The date and time the resource was last checked for vulnerabilities.
	LastScannedAt *time.Time

	// An object that contains details about the metadata.
	ResourceMetadata *ResourceScanMetadata

	// The scan method that is applied to the instance.
	ScanMode ScanMode

	// The status of the scan covering the resource.
	ScanStatus *ScanStatus

	noSmithyDocumentSerde
}

// Creates CIS targets.
type CreateCisTargets struct {

	// The CIS target account ids.
	//
	// This member is required.
	AccountIds []string

	// The CIS target resource tags.
	//
	// This member is required.
	TargetResourceTags map[string][]string

	noSmithyDocumentSerde
}

// Contains details required to create an integration with a self-managed GitLab
// instance.
type CreateGitLabSelfManagedIntegrationDetail struct {

	// The personal access token used to authenticate with the self-managed GitLab
	// instance.
	//
	// This member is required.
	AccessToken *string

	// The URL of the self-managed GitLab instance.
	//
	// This member is required.
	InstanceUrl *string

	noSmithyDocumentSerde
}

// Contains details required to create a code security integration with a specific
// repository provider.
//
// The following types satisfy this interface:
//
//	CreateIntegrationDetailMemberGitlabSelfManaged
type CreateIntegrationDetail interface {
	isCreateIntegrationDetail()
}

// Details specific to creating an integration with a self-managed GitLab instance.
type CreateIntegrationDetailMemberGitlabSelfManaged struct {
	Value CreateGitLabSelfManagedIntegrationDetail

	noSmithyDocumentSerde
}

func (*CreateIntegrationDetailMemberGitlabSelfManaged) isCreateIntegrationDetail() {}

// The Common Vulnerability Scoring System (CVSS) version 2 details for the
// vulnerability.
type Cvss2 struct {

	// The CVSS v2 base score for the vulnerability.
	BaseScore float64

	// The scoring vector associated with the CVSS v2 score.
	ScoringVector *string

	noSmithyDocumentSerde
}

// The Common Vulnerability Scoring System (CVSS) version 3 details for the
// vulnerability.
type Cvss3 struct {

	// The CVSS v3 base score for the vulnerability.
	BaseScore float64

	// The scoring vector associated with the CVSS v3 score.
	ScoringVector *string

	noSmithyDocumentSerde
}

// The Common Vulnerability Scoring System (CVSS) version 4 details for the
// vulnerability.
type Cvss4 struct {

	// The base CVSS v4 score for the vulnerability finding, which rates the severity
	// of the vulnerability on a scale from 0 to 10.
	BaseScore float64

	// The CVSS v4 scoring vector, which contains the metrics and measurements that
	// were used to calculate the base score.
	ScoringVector *string

	noSmithyDocumentSerde
}

// The CVSS score for a finding.
type CvssScore struct {

	// The base CVSS score used for the finding.
	//
	// This member is required.
	BaseScore *float64

	// The vector string of the CVSS score.
	//
	// This member is required.
	ScoringVector *string

	// The source of the CVSS score.
	//
	// This member is required.
	Source *string

	// The version of CVSS used for the score.
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// Details on adjustments Amazon Inspector made to the CVSS score for a finding.
type CvssScoreAdjustment struct {

	// The metric used to adjust the CVSS score.
	//
	// This member is required.
	Metric *string

	// The reason the CVSS score has been adjustment.
	//
	// This member is required.
	Reason *string

	noSmithyDocumentSerde
}

// Information about the CVSS score.
type CvssScoreDetails struct {

	// The CVSS score.
	//
	// This member is required.
	Score *float64

	// The source for the CVSS score.
	//
	// This member is required.
	ScoreSource *string

	// The vector for the CVSS score.
	//
	// This member is required.
	ScoringVector *string

	// The CVSS version used in scoring.
	//
	// This member is required.
	Version *string

	// An object that contains details about adjustment Amazon Inspector made to the
	// CVSS score.
	Adjustments []CvssScoreAdjustment

	// The source of the CVSS data.
	CvssSource *string

	noSmithyDocumentSerde
}

// A daily schedule.
type DailySchedule struct {

	// The schedule start time.
	//
	// This member is required.
	StartTime *Time

	noSmithyDocumentSerde
}

// Contains details on the time range used to filter findings.
type DateFilter struct {

	// A timestamp representing the end of the time period filtered on.
	EndInclusive *time.Time

	// A timestamp representing the start of the time period filtered on.
	StartInclusive *time.Time

	noSmithyDocumentSerde
}

// Details of the Amazon Inspector delegated administrator for your organization.
type DelegatedAdmin struct {

	// The Amazon Web Services account ID of the Amazon Inspector delegated
	// administrator for your organization.
	AccountId *string

	// The status of the Amazon Inspector delegated administrator.
	RelationshipStatus RelationshipStatus

	noSmithyDocumentSerde
}

// Details of the Amazon Inspector delegated administrator for your organization.
type DelegatedAdminAccount struct {

	// The Amazon Web Services account ID of the Amazon Inspector delegated
	// administrator for your organization.
	AccountId *string

	// The status of the Amazon Inspector delegated administrator.
	Status DelegatedAdminStatus

	noSmithyDocumentSerde
}

// Contains details of the Amazon S3 bucket and KMS key used to export findings.
type Destination struct {

	// The name of the Amazon S3 bucket to export findings to.
	//
	// This member is required.
	BucketName *string

	// The ARN of the KMS key used to encrypt data when exporting findings.
	//
	// This member is required.
	KmsKeyArn *string

	// The prefix that the findings will be written under.
	KeyPrefix *string

	noSmithyDocumentSerde
}

// Contains details about a request to disassociate a code repository from a scan
// configuration.
type DisassociateConfigurationRequest struct {

	// Identifies a specific resource in a code repository that will be scanned.
	//
	// This member is required.
	Resource CodeSecurityResource

	// The Amazon Resource Name (ARN) of the scan configuration to disassociate from a
	// code repository.
	//
	// This member is required.
	ScanConfigurationArn *string

	noSmithyDocumentSerde
}

// Enables agent-based scanning, which scans instances that are not managed by SSM.
type Ec2Configuration struct {

	// The scan method that is applied to the instance.
	//
	// This member is required.
	ScanMode Ec2ScanMode

	noSmithyDocumentSerde
}

// Details about the state of the EC2 scan configuration for your environment.
type Ec2ConfigurationState struct {

	// An object that contains details about the state of the Amazon EC2 scan mode.
	ScanModeState *Ec2ScanModeState

	noSmithyDocumentSerde
}

// The details that define an aggregation based on Amazon EC2 instances.
type Ec2InstanceAggregation struct {

	// The AMI IDs associated with the Amazon EC2 instances to aggregate findings for.
	Amis []StringFilter

	// The Amazon EC2 instance IDs to aggregate findings for.
	InstanceIds []StringFilter

	// The Amazon EC2 instance tags to aggregate findings for.
	InstanceTags []MapFilter

	// The operating system types to aggregate findings for. Valid values must be
	// uppercase and underscore separated, examples are ORACLE_LINUX_7 and
	// ALPINE_LINUX_3_8 .
	OperatingSystems []StringFilter

	// The value to sort results by.
	SortBy Ec2InstanceSortBy

	// The order to sort results by.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// A response that contains the results of a finding aggregation by Amazon EC2
// instance.
type Ec2InstanceAggregationResponse struct {

	// The Amazon EC2 instance ID.
	//
	// This member is required.
	InstanceId *string

	// The Amazon Web Services account for the Amazon EC2 instance.
	AccountId *string

	// The Amazon Machine Image (AMI) of the Amazon EC2 instance.
	Ami *string

	// The tags attached to the instance.
	InstanceTags map[string]string

	// The number of network findings for the Amazon EC2 instance.
	NetworkFindings *int64

	// The operating system of the Amazon EC2 instance.
	OperatingSystem *string

	// An object that contains the count of matched findings per severity.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// Meta data details of an Amazon EC2 instance.
type Ec2Metadata struct {

	// The ID of the Amazon Machine Image (AMI) used to launch the instance.
	AmiId *string

	// The platform of the instance.
	Platform Ec2Platform

	// The tags attached to the instance.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The state of your Amazon EC2 scan mode configuration.
type Ec2ScanModeState struct {

	// The scan method that is applied to the instance.
	ScanMode Ec2ScanMode

	// The status of the Amazon EC2 scan mode setting.
	ScanModeStatus Ec2ScanModeStatus

	noSmithyDocumentSerde
}

// Details about the ECR automated re-scan duration setting for your environment.
type EcrConfiguration struct {

	// The rescan duration configured for image push date.
	//
	// This member is required.
	RescanDuration EcrRescanDuration

	// The rescan duration configured for image pull date.
	PullDateRescanDuration EcrPullDateRescanDuration

	// The pull date for the re-scan mode.
	PullDateRescanMode EcrPullDateRescanMode

	noSmithyDocumentSerde
}

// Details about the state of the ECR scans for your environment.
type EcrConfigurationState struct {

	// An object that contains details about the state of the ECR re-scan settings.
	RescanDurationState *EcrRescanDurationState

	noSmithyDocumentSerde
}

// Information on the Amazon ECR image metadata associated with a finding.
type EcrContainerImageMetadata struct {

	// The date an image was last pulled at.
	ImagePulledAt *time.Time

	// The number of Amazon ECS tasks or Amazon EKS pods where the Amazon ECR
	// container image is in use.
	InUseCount *int64

	// The last time an Amazon ECR image was used in an Amazon ECS task or Amazon EKS
	// pod.
	LastInUseAt *time.Time

	// Tags associated with the Amazon ECR image metadata.
	Tags []string

	noSmithyDocumentSerde
}

// Information on the Amazon ECR repository metadata associated with a finding.
type EcrRepositoryMetadata struct {

	// The name of the Amazon ECR repository.
	Name *string

	// The frequency of scans.
	ScanFrequency EcrScanFrequency

	noSmithyDocumentSerde
}

// Details about the state of your ECR re-scan duration settings. The ECR re-scan
// duration defines how long an ECR image will be actively scanned by Amazon
// Inspector. When the number of days since an image was last pushed exceeds the
// duration configured for image pull date, and the duration configured for image
// pull date, the monitoring state of that image becomes inactive and all
// associated findings are scheduled for closure.
type EcrRescanDurationState struct {

	// The rescan duration configured for image pull date.
	PullDateRescanDuration EcrPullDateRescanDuration

	// The pull date for the re-scan mode.
	PullDateRescanMode EcrPullDateRescanMode

	// The rescan duration configured for image push date.
	RescanDuration EcrRescanDuration

	// The status of changes to the ECR automated re-scan duration.
	Status EcrRescanDurationStatus

	// A timestamp representing when the last time the ECR scan duration setting was
	// changed.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Details about the Exploit Prediction Scoring System (EPSS) score.
type Epss struct {

	// The Exploit Prediction Scoring System (EPSS) score.
	Score float64

	noSmithyDocumentSerde
}

// Details about the Exploit Prediction Scoring System (EPSS) score for a finding.
type EpssDetails struct {

	// The EPSS score.
	Score float64

	noSmithyDocumentSerde
}

// Details of the evidence for a vulnerability identified in a finding.
type Evidence struct {

	// The evidence details.
	EvidenceDetail *string

	// The evidence rule.
	EvidenceRule *string

	// The evidence severity.
	Severity *string

	noSmithyDocumentSerde
}

// The details of an exploit available for a finding discovered in your
// environment.
type ExploitabilityDetails struct {

	// The date and time of the last exploit associated with a finding discovered in
	// your environment.
	LastKnownExploitAt *time.Time

	noSmithyDocumentSerde
}

// Contains information on when this exploit was observed.
type ExploitObserved struct {

	// The date an time when the exploit was first seen.
	FirstSeen *time.Time

	// The date an time when the exploit was last seen.
	LastSeen *time.Time

	noSmithyDocumentSerde
}

// An object with details on why an account failed to enable Amazon Inspector.
type FailedAccount struct {

	// The Amazon Web Services account ID.
	//
	// This member is required.
	AccountId *string

	// The error code explaining why the account failed to enable Amazon Inspector.
	//
	// This member is required.
	ErrorCode ErrorCode

	// The error message received when the account failed to enable Amazon Inspector.
	//
	// This member is required.
	ErrorMessage *string

	// An object detailing which resources Amazon Inspector is enabled to scan for the
	// account.
	ResourceStatus *ResourceStatus

	// The status of Amazon Inspector for the account.
	Status Status

	noSmithyDocumentSerde
}

// Details about a failed attempt to associate or disassociate a code repository
// with a scan configuration.
type FailedAssociationResult struct {

	// Identifies a specific resource in a code repository that will be scanned.
	Resource CodeSecurityResource

	// The Amazon Resource Name (ARN) of the scan configuration that failed to be
	// associated or disassociated.
	ScanConfigurationArn *string

	// The status code indicating why the association or disassociation failed.
	StatusCode AssociationResultStatusCode

	// A message explaining why the association or disassociation failed.
	StatusMessage *string

	noSmithyDocumentSerde
}

// An object that contains details about a member account in your organization
// that failed to activate Amazon Inspector deep inspection.
type FailedMemberAccountEc2DeepInspectionStatusState struct {

	// The unique identifier for the Amazon Web Services account of the organization
	// member that failed to activate Amazon Inspector deep inspection.
	//
	// This member is required.
	AccountId *string

	// The status of EC2 scanning in the account that failed to activate Amazon
	// Inspector deep inspection.
	Ec2ScanStatus Status

	// The error message explaining why the account failed to activate Amazon
	// Inspector deep inspection.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Details about a filter.
type Filter struct {

	// The action that is to be applied to the findings that match the filter.
	//
	// This member is required.
	Action FilterAction

	// The Amazon Resource Number (ARN) associated with this filter.
	//
	// This member is required.
	Arn *string

	// The date and time this filter was created at.
	//
	// This member is required.
	CreatedAt *time.Time

	// Details on the filter criteria associated with this filter.
	//
	// This member is required.
	Criteria *FilterCriteria

	// The name of the filter.
	//
	// This member is required.
	Name *string

	// The Amazon Web Services account ID of the account that created the filter.
	//
	// This member is required.
	OwnerId *string

	// The date and time the filter was last updated at.
	//
	// This member is required.
	UpdatedAt *time.Time

	// A description of the filter.
	Description *string

	// The reason for the filter.
	Reason *string

	// The tags attached to the filter.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Details on the criteria used to define the filter.
type FilterCriteria struct {

	// Details of the Amazon Web Services account IDs used to filter findings.
	AwsAccountId []StringFilter

	// Filter criteria for findings based on the project name in a code repository.
	CodeRepositoryProjectName []StringFilter

	// Filter criteria for findings based on the repository provider type (such as
	// GitHub, GitLab, etc.).
	CodeRepositoryProviderType []StringFilter

	// The name of the detector used to identify a code vulnerability in a Lambda
	// function used to filter findings.
	CodeVulnerabilityDetectorName []StringFilter

	// The detector type tag associated with the vulnerability used to filter
	// findings. Detector tags group related vulnerabilities by common themes or
	// tactics. For a list of available tags by programming language, see [Java tags], or [Python tags].
	//
	// [Python tags]: https://docs.aws.amazon.com/codeguru/detector-library/python/tags/
	// [Java tags]: https://docs.aws.amazon.com/codeguru/detector-library/java/tags/
	CodeVulnerabilityDetectorTags []StringFilter

	// The file path to the file in a Lambda function that contains a code
	// vulnerability used to filter findings.
	CodeVulnerabilityFilePath []StringFilter

	// Details of the component IDs used to filter findings.
	ComponentId []StringFilter

	// Details of the component types used to filter findings.
	ComponentType []StringFilter

	// Details of the Amazon EC2 instance image IDs used to filter findings.
	Ec2InstanceImageId []StringFilter

	// Details of the Amazon EC2 instance subnet IDs used to filter findings.
	Ec2InstanceSubnetId []StringFilter

	// Details of the Amazon EC2 instance VPC IDs used to filter findings.
	Ec2InstanceVpcId []StringFilter

	// Details of the Amazon ECR image architecture types used to filter findings.
	EcrImageArchitecture []StringFilter

	// Details of the Amazon ECR image hashes used to filter findings.
	EcrImageHash []StringFilter

	// Filter criteria indicating when details for an Amazon ECR image include when an
	// Amazon ECR image is in use.
	EcrImageInUseCount []NumberFilter

	// Filter criteria indicating when an Amazon ECR image was last used in an Amazon
	// ECS cluster task or Amazon EKS cluster pod.
	EcrImageLastInUseAt []DateFilter

	// Details on the Amazon ECR image push date and time used to filter findings.
	EcrImagePushedAt []DateFilter

	// Details on the Amazon ECR registry used to filter findings.
	EcrImageRegistry []StringFilter

	// Details on the name of the Amazon ECR repository used to filter findings.
	EcrImageRepositoryName []StringFilter

	// The tags attached to the Amazon ECR container image.
	EcrImageTags []StringFilter

	// The EPSS score used to filter findings.
	EpssScore []NumberFilter

	// Filters the list of Amazon Web Services Lambda findings by the availability of
	// exploits.
	ExploitAvailable []StringFilter

	// Details on the finding ARNs used to filter findings.
	FindingArn []StringFilter

	// Details on the finding status types used to filter findings.
	FindingStatus []StringFilter

	// Details on the finding types used to filter findings.
	FindingType []StringFilter

	// Details on the date and time a finding was first seen used to filter findings.
	FirstObservedAt []DateFilter

	// Details on whether a fix is available through a version update. This value can
	// be YES , NO , or PARTIAL . A PARTIAL fix means that some, but not all, of the
	// packages identified in the finding have fixes available through updated
	// versions.
	FixAvailable []StringFilter

	// The Amazon Inspector score to filter on.
	InspectorScore []NumberFilter

	// Filters the list of Amazon Web Services Lambda functions by execution role.
	LambdaFunctionExecutionRoleArn []StringFilter

	// Filters the list of Amazon Web Services Lambda functions by the date and time
	// that a user last updated the configuration, in [ISO 8601 format]
	//
	// [ISO 8601 format]: https://www.iso.org/iso-8601-date-and-time-format.html
	LambdaFunctionLastModifiedAt []DateFilter

	// Filters the list of Amazon Web Services Lambda functions by the function's [layers]. A
	// Lambda function can have up to five layers.
	//
	// [layers]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html
	LambdaFunctionLayers []StringFilter

	// Filters the list of Amazon Web Services Lambda functions by the name of the
	// function.
	LambdaFunctionName []StringFilter

	// Filters the list of Amazon Web Services Lambda functions by the runtime
	// environment for the Lambda function.
	LambdaFunctionRuntime []StringFilter

	// Details on the date and time a finding was last seen used to filter findings.
	LastObservedAt []DateFilter

	// Details on network protocol used to filter findings.
	NetworkProtocol []StringFilter

	// Details on the port ranges used to filter findings.
	PortRange []PortRangeFilter

	// Details on the related vulnerabilities used to filter findings.
	RelatedVulnerabilities []StringFilter

	// Details on the resource IDs used to filter findings.
	ResourceId []StringFilter

	// Details on the resource tags used to filter findings.
	ResourceTags []MapFilter

	// Details on the resource types used to filter findings.
	ResourceType []StringFilter

	// Details on the severity used to filter findings.
	Severity []StringFilter

	// Details on the finding title used to filter findings.
	Title []StringFilter

	// Details on the date and time a finding was last updated at used to filter
	// findings.
	UpdatedAt []DateFilter

	// Details on the vendor severity used to filter findings.
	VendorSeverity []StringFilter

	// Details on the vulnerability ID used to filter findings.
	VulnerabilityId []StringFilter

	// Details on the vulnerability type used to filter findings.
	VulnerabilitySource []StringFilter

	// Details on the vulnerable packages used to filter findings.
	VulnerablePackages []PackageFilter

	noSmithyDocumentSerde
}

// Details about an Amazon Inspector finding.
type Finding struct {

	// The Amazon Web Services account ID associated with the finding.
	//
	// This member is required.
	AwsAccountId *string

	// The description of the finding.
	//
	// This member is required.
	Description *string

	// The Amazon Resource Number (ARN) of the finding.
	//
	// This member is required.
	FindingArn *string

	// The date and time that the finding was first observed.
	//
	// This member is required.
	FirstObservedAt *time.Time

	//  The date and time the finding was last observed. This timestamp for this field
	// remains unchanged until a finding is updated.
	//
	// This member is required.
	LastObservedAt *time.Time

	// An object that contains the details about how to remediate a finding.
	//
	// This member is required.
	Remediation *Remediation

	// Contains information on the resources involved in a finding. The resource value
	// determines the valid values for type in your request. For more information, see [Finding types]
	// in the Amazon Inspector user guide.
	//
	// [Finding types]: https://docs.aws.amazon.com/inspector/latest/user/findings-types.html
	//
	// This member is required.
	Resources []Resource

	// The severity of the finding. UNTRIAGED applies to PACKAGE_VULNERABILITY type
	// findings that the vendor has not assigned a severity yet. For more information,
	// see [Severity levels for findings]in the Amazon Inspector user guide.
	//
	// [Severity levels for findings]: https://docs.aws.amazon.com/inspector/latest/user/findings-understanding-severity.html
	//
	// This member is required.
	Severity Severity

	// The status of the finding.
	//
	// This member is required.
	Status FindingStatus

	// The type of the finding. The type value determines the valid values for resource
	// in your request. For more information, see [Finding types]in the Amazon Inspector user guide.
	//
	// [Finding types]: https://docs.aws.amazon.com/inspector/latest/user/findings-types.html
	//
	// This member is required.
	Type FindingType

	// Details about the code vulnerability identified in a Lambda function used to
	// filter findings.
	CodeVulnerabilityDetails *CodeVulnerabilityDetails

	// The finding's EPSS score.
	Epss *EpssDetails

	// If a finding discovered in your environment has an exploit available.
	ExploitAvailable ExploitAvailable

	// The details of an exploit available for a finding discovered in your
	// environment.
	ExploitabilityDetails *ExploitabilityDetails

	// Details on whether a fix is available through a version update. This value can
	// be YES , NO , or PARTIAL . A PARTIAL fix means that some, but not all, of the
	// packages identified in the finding have fixes available through updated
	// versions.
	FixAvailable FixAvailable

	// The Amazon Inspector score given to the finding.
	InspectorScore *float64

	// An object that contains details of the Amazon Inspector score.
	InspectorScoreDetails *InspectorScoreDetails

	// An object that contains the details of a network reachability finding.
	NetworkReachabilityDetails *NetworkReachabilityDetails

	// An object that contains the details of a package vulnerability finding.
	PackageVulnerabilityDetails *PackageVulnerabilityDetails

	// The title of the finding.
	Title *string

	// The date and time the finding was last updated at.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Details of the vulnerability identified in a finding.
type FindingDetail struct {

	// The Cybersecurity and Infrastructure Security Agency (CISA) details for a
	// specific vulnerability.
	CisaData *CisaData

	// The Common Weakness Enumerations (CWEs) associated with the vulnerability.
	Cwes []string

	// The Exploit Prediction Scoring System (EPSS) score of the vulnerability.
	EpssScore *float64

	// Information on the evidence of the vulnerability.
	Evidences []Evidence

	// Contains information on when this exploit was observed.
	ExploitObserved *ExploitObserved

	// The finding ARN that the vulnerability details are associated with.
	FindingArn *string

	// The reference URLs for the vulnerability data.
	ReferenceUrls []string

	// The risk score of the vulnerability.
	RiskScore *int32

	// The known malware tools or kits that can exploit the vulnerability.
	Tools []string

	// The MITRE adversary tactics, techniques, or procedures (TTPs) associated with
	// the vulnerability.
	Ttps []string

	noSmithyDocumentSerde
}

// Details about an error encountered when trying to return vulnerability data for
// a finding.
type FindingDetailsError struct {

	// The error code.
	//
	// This member is required.
	ErrorCode FindingDetailsErrorCode

	// The error message.
	//
	// This member is required.
	ErrorMessage *string

	// The finding ARN that returned an error.
	//
	// This member is required.
	FindingArn *string

	noSmithyDocumentSerde
}

// The details that define an aggregation based on finding type.
type FindingTypeAggregation struct {

	// The finding type to aggregate.
	FindingType AggregationFindingType

	// The resource type to aggregate.
	ResourceType AggregationResourceType

	// The value to sort results by.
	SortBy FindingTypeSortBy

	// The order to sort results by.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// A response that contains the results of a finding type aggregation.
type FindingTypeAggregationResponse struct {

	// The ID of the Amazon Web Services account associated with the findings.
	AccountId *string

	// The number of findings that have an exploit available.
	ExploitAvailableCount *int64

	//  Details about the number of fixes.
	FixAvailableCount *int64

	// The value to sort results by.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// Information about the Amazon Inspector free trial for an account.
type FreeTrialAccountInfo struct {

	// The account associated with the Amazon Inspector free trial information.
	//
	// This member is required.
	AccountId *string

	// Contains information about the Amazon Inspector free trial for an account.
	//
	// This member is required.
	FreeTrialInfo []FreeTrialInfo

	noSmithyDocumentSerde
}

// An object that contains information about the Amazon Inspector free trial for
// an account.
type FreeTrialInfo struct {

	// The date and time that the Amazon Inspector free trail ends for a given account.
	//
	// This member is required.
	End *time.Time

	// The date and time that the Amazon Inspector free trail started for a given
	// account.
	//
	// This member is required.
	Start *time.Time

	// The order to sort results by.
	//
	// This member is required.
	Status FreeTrialStatus

	// The type of scan covered by the Amazon Inspector free trail.
	//
	// This member is required.
	Type FreeTrialType

	noSmithyDocumentSerde
}

// Information about an error received while accessing free trail data for an
// account.
type FreeTrialInfoError struct {

	// The account associated with the Amazon Inspector free trial information.
	//
	// This member is required.
	AccountId *string

	// The error code.
	//
	// This member is required.
	Code FreeTrialInfoErrorCode

	// The error message returned.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// The details that define an aggregation based on container image layers.
type ImageLayerAggregation struct {

	// The hashes associated with the layers.
	LayerHashes []StringFilter

	// The repository associated with the container image hosting the layers.
	Repositories []StringFilter

	// The ID of the container image layer.
	ResourceIds []StringFilter

	// The value to sort results by.
	SortBy ImageLayerSortBy

	// The order to sort results by.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// A response that contains the results of a finding aggregation by image layer.
type ImageLayerAggregationResponse struct {

	// The ID of the Amazon Web Services account that owns the container image hosting
	// the layer image.
	//
	// This member is required.
	AccountId *string

	// The layer hash.
	//
	// This member is required.
	LayerHash *string

	// The repository the layer resides in.
	//
	// This member is required.
	Repository *string

	// The resource ID of the container image layer.
	//
	// This member is required.
	ResourceId *string

	// An object that represents the count of matched findings per severity.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// Information about the Amazon Inspector score given to a finding.
type InspectorScoreDetails struct {

	// An object that contains details about the CVSS score given to a finding.
	AdjustedCvss *CvssScoreDetails

	noSmithyDocumentSerde
}

// The details that define a findings aggregation based on Amazon Web Services
// Lambda functions.
type LambdaFunctionAggregation struct {

	// The Amazon Web Services Lambda function names to include in the aggregation
	// results.
	FunctionNames []StringFilter

	// The tags to include in the aggregation results.
	FunctionTags []MapFilter

	// The resource IDs to include in the aggregation results.
	ResourceIds []StringFilter

	// Returns findings aggregated by Amazon Web Services Lambda function runtime
	// environments.
	Runtimes []StringFilter

	// The finding severity to use for sorting the results.
	SortBy LambdaFunctionSortBy

	// The order to use for sorting the results.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// A response that contains the results of an Amazon Web Services Lambda function
// finding aggregation.
type LambdaFunctionAggregationResponse struct {

	// The resource IDs included in the aggregation results.
	//
	// This member is required.
	ResourceId *string

	// The ID of the Amazon Web Services account that owns the Amazon Web Services
	// Lambda function.
	AccountId *string

	// The Amazon Web Services Lambda function names included in the aggregation
	// results.
	FunctionName *string

	// The tags included in the aggregation results.
	LambdaTags map[string]string

	// The date that the Amazon Web Services Lambda function included in the
	// aggregation results was last changed.
	LastModifiedAt *time.Time

	// The runtimes included in the aggregation results.
	Runtime *string

	// An object that contains the counts of aggregated finding per severity.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// The Amazon Web Services Lambda function metadata.
type LambdaFunctionMetadata struct {

	// The name of a function.
	FunctionName *string

	// The resource tags on an Amazon Web Services Lambda function.
	FunctionTags map[string]string

	// The layers for an Amazon Web Services Lambda function. A Lambda function can
	// have up to five layers.
	Layers []string

	// An Amazon Web Services Lambda function's runtime.
	Runtime Runtime

	noSmithyDocumentSerde
}

// The details that define a findings aggregation based on an Amazon Web Services
// Lambda function's layers.
type LambdaLayerAggregation struct {

	// The names of the Amazon Web Services Lambda functions associated with the
	// layers.
	FunctionNames []StringFilter

	// The Amazon Resource Name (ARN) of the Amazon Web Services Lambda function
	// layer.
	LayerArns []StringFilter

	// The resource IDs for the Amazon Web Services Lambda function layers.
	ResourceIds []StringFilter

	// The finding severity to use for sorting the results.
	SortBy LambdaLayerSortBy

	// The order to use for sorting the results.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// A response that contains the results of an Amazon Web Services Lambda function
// layer finding aggregation.
type LambdaLayerAggregationResponse struct {

	// The account ID of the Amazon Web Services Lambda function layer.
	//
	// This member is required.
	AccountId *string

	// The names of the Amazon Web Services Lambda functions associated with the
	// layers.
	//
	// This member is required.
	FunctionName *string

	// The Amazon Resource Name (ARN) of the Amazon Web Services Lambda function layer.
	//
	// This member is required.
	LayerArn *string

	// The Resource ID of the Amazon Web Services Lambda function layer.
	//
	// This member is required.
	ResourceId *string

	// An object that contains the counts of aggregated finding per severity.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// The VPC security groups and subnets that are attached to an Amazon Web Services
// Lambda function. For more information, see [VPC Settings].
//
// [VPC Settings]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html
type LambdaVpcConfig struct {

	// The VPC security groups and subnets that are attached to an Amazon Web Services
	// Lambda function. For more information, see [VPC Settings].
	//
	// [VPC Settings]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html
	SecurityGroupIds []string

	// A list of VPC subnet IDs.
	SubnetIds []string

	// The ID of the VPC.
	VpcId *string

	noSmithyDocumentSerde
}

// A list of CIS scan configurations filter criteria.
type ListCisScanConfigurationsFilterCriteria struct {

	// The list of scan configuration ARN filters.
	ScanConfigurationArnFilters []CisStringFilter

	// The list of scan name filters.
	ScanNameFilters []CisStringFilter

	// The list of target resource tag filters.
	TargetResourceTagFilters []TagFilter

	noSmithyDocumentSerde
}

// A list of CIS scans filter criteria.
type ListCisScansFilterCriteria struct {

	// The list of failed checks filters.
	FailedChecksFilters []CisNumberFilter

	// The list of scan ARN filters.
	ScanArnFilters []CisStringFilter

	// The list of scan at filters.
	ScanAtFilters []CisDateFilter

	// The list of scan configuration ARN filters.
	ScanConfigurationArnFilters []CisStringFilter

	// The list of scan name filters.
	ScanNameFilters []CisStringFilter

	// The list of scan status filters.
	ScanStatusFilters []CisScanStatusFilter

	// The list of scheduled by filters.
	ScheduledByFilters []CisStringFilter

	// The list of target account ID filters.
	TargetAccountIdFilters []CisStringFilter

	// The list of target resource ID filters.
	TargetResourceIdFilters []CisStringFilter

	// The list of target resource tag filters.
	TargetResourceTagFilters []TagFilter

	noSmithyDocumentSerde
}

// An object that describes details of a map filter.
type MapFilter struct {

	// The operator to use when comparing values in the filter.
	//
	// This member is required.
	Comparison MapComparison

	// The tag key used in the filter.
	//
	// This member is required.
	Key *string

	// The tag value used in the filter.
	Value *string

	noSmithyDocumentSerde
}

// Details on a member account in your organization.
type Member struct {

	// The Amazon Web Services account ID of the member account.
	AccountId *string

	// The Amazon Web Services account ID of the Amazon Inspector delegated
	// administrator for this member account.
	DelegatedAdminAccountId *string

	// The status of the member account.
	RelationshipStatus RelationshipStatus

	// A timestamp showing when the status of this member was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// An object that contains details about the status of Amazon Inspector deep
// inspection for a member account in your organization.
type MemberAccountEc2DeepInspectionStatus struct {

	// The unique identifier for the Amazon Web Services account of the organization
	// member.
	//
	// This member is required.
	AccountId *string

	// Whether Amazon Inspector deep inspection is active in the account. If TRUE
	// Amazon Inspector deep inspection is active, if FALSE it is not active.
	//
	// This member is required.
	ActivateDeepInspection *bool

	noSmithyDocumentSerde
}

// An object that contains details about the state of Amazon Inspector deep
// inspection for a member account.
type MemberAccountEc2DeepInspectionStatusState struct {

	// The unique identifier for the Amazon Web Services account of the organization
	// member
	//
	// This member is required.
	AccountId *string

	// The error message explaining why the account failed to activate Amazon
	// Inspector deep inspection.
	ErrorMessage *string

	// The state of Amazon Inspector deep inspection in the member account.
	Status Ec2DeepInspectionStatus

	noSmithyDocumentSerde
}

// A monthly schedule.
type MonthlySchedule struct {

	// The monthly schedule's day.
	//
	// This member is required.
	Day Day

	// The monthly schedule's start time.
	//
	// This member is required.
	StartTime *Time

	noSmithyDocumentSerde
}

// Information on the network path associated with a finding.
type NetworkPath struct {

	// The details on the steps in the network path.
	Steps []Step

	noSmithyDocumentSerde
}

// Contains the details of a network reachability finding.
type NetworkReachabilityDetails struct {

	// An object that contains details about a network path associated with a finding.
	//
	// This member is required.
	NetworkPath *NetworkPath

	// An object that contains details about the open port range associated with a
	// finding.
	//
	// This member is required.
	OpenPortRange *PortRange

	// The protocol associated with a finding.
	//
	// This member is required.
	Protocol NetworkProtocol

	noSmithyDocumentSerde
}

// An object that describes the details of a number filter.
type NumberFilter struct {

	// The lowest number to be included in the filter.
	LowerInclusive *float64

	// The highest number to be included in the filter.
	UpperInclusive *float64

	noSmithyDocumentSerde
}

// A one time schedule.
type OneTimeSchedule struct {
	noSmithyDocumentSerde
}

// The details that define an aggregation based on operating system package type.
type PackageAggregation struct {

	// The names of packages to aggregate findings on.
	PackageNames []StringFilter

	// The value to sort results by.
	SortBy PackageSortBy

	// The order to sort results by.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// A response that contains the results of a finding aggregation by image layer.
type PackageAggregationResponse struct {

	// The name of the operating system package.
	//
	// This member is required.
	PackageName *string

	// The ID of the Amazon Web Services account associated with the findings.
	AccountId *string

	// An object that contains the count of matched findings per severity.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// Contains information on the details of a package filter.
type PackageFilter struct {

	// An object that contains details on the package architecture type to filter on.
	Architecture *StringFilter

	// An object that contains details on the package epoch to filter on.
	Epoch *NumberFilter

	// An object that contains details on the package file path to filter on.
	FilePath *StringFilter

	// An object that contains details on the name of the package to filter on.
	Name *StringFilter

	// An object that contains details on the package release to filter on.
	Release *StringFilter

	// An object that describes the details of a string filter.
	SourceLambdaLayerArn *StringFilter

	// An object that contains details on the source layer hash to filter on.
	SourceLayerHash *StringFilter

	// The package version to filter on.
	Version *StringFilter

	noSmithyDocumentSerde
}

// Information about a package vulnerability finding.
type PackageVulnerabilityDetails struct {

	// The source of the vulnerability information.
	//
	// This member is required.
	Source *string

	// The ID given to this vulnerability.
	//
	// This member is required.
	VulnerabilityId *string

	// An object that contains details about the CVSS score of a finding.
	Cvss []CvssScore

	// One or more URLs that contain details about this vulnerability type.
	ReferenceUrls []string

	// One or more vulnerabilities related to the one identified in this finding.
	RelatedVulnerabilities []string

	// A URL to the source of the vulnerability information.
	SourceUrl *string

	// The date and time that this vulnerability was first added to the vendor's
	// database.
	VendorCreatedAt *time.Time

	// The severity the vendor has given to this vulnerability type.
	VendorSeverity *string

	// The date and time the vendor last updated this vulnerability in their database.
	VendorUpdatedAt *time.Time

	// The packages impacted by this vulnerability.
	VulnerablePackages []VulnerablePackage

	noSmithyDocumentSerde
}

// Configuration settings for periodic scans that run on a scheduled basis.
type PeriodicScanConfiguration struct {

	// The frequency at which periodic scans are performed (such as weekly or monthly).
	//
	// If you don't provide the frequencyExpression Amazon Inspector chooses day for
	// the scan to run. If you provide the frequencyExpression , the schedule must
	// match the specified frequency .
	Frequency PeriodicScanFrequency

	// The schedule expression for periodic scans, in cron format.
	FrequencyExpression *string

	noSmithyDocumentSerde
}

// Contains information on the permissions an account has within Amazon Inspector.
type Permission struct {

	// The operations that can be performed with the given permissions.
	//
	// This member is required.
	Operation Operation

	// The services that the permissions allow an account to perform the given
	// operations for.
	//
	// This member is required.
	Service Service

	noSmithyDocumentSerde
}

// Details about the port range associated with a finding.
type PortRange struct {

	// The beginning port in a port range.
	//
	// This member is required.
	Begin *int32

	// The ending port in a port range.
	//
	// This member is required.
	End *int32

	noSmithyDocumentSerde
}

// An object that describes the details of a port range filter.
type PortRangeFilter struct {

	// The port number the port range begins at.
	BeginInclusive *int32

	// The port number the port range ends at.
	EndInclusive *int32

	noSmithyDocumentSerde
}

// Contains the scan configuration settings applied to a specific project in a
// code repository.
type ProjectCodeSecurityScanConfiguration struct {

	// The continuous integration scan configurations applied to the project.
	ContinuousIntegrationScanConfigurations []ProjectContinuousIntegrationScanConfiguration

	// The periodic scan configurations applied to the project.
	PeriodicScanConfigurations []ProjectPeriodicScanConfiguration

	noSmithyDocumentSerde
}

// Contains the continuous integration scan configuration settings applied to a
// specific project.
type ProjectContinuousIntegrationScanConfiguration struct {

	// The categories of security rules applied during continuous integration scans
	// for the project.
	RuleSetCategories []RuleSetCategory

	// The repository event that triggers continuous integration scans for the project.
	SupportedEvent ContinuousIntegrationScanEvent

	noSmithyDocumentSerde
}

// Contains the periodic scan configuration settings applied to a specific project.
type ProjectPeriodicScanConfiguration struct {

	// The schedule expression for periodic scans, in cron format, applied to the
	// project.
	FrequencyExpression *string

	// The categories of security rules applied during periodic scans for the project.
	RuleSetCategories []RuleSetCategory

	noSmithyDocumentSerde
}

// Details about the recommended course of action to remediate the finding.
type Recommendation struct {

	// The recommended course of action to remediate the finding.
	Text *string

	// The URL address to the CVE remediation recommendations.
	Url *string

	noSmithyDocumentSerde
}

// Information on how to remediate a finding.
type Remediation struct {

	// An object that contains information about the recommended course of action to
	// remediate the finding.
	Recommendation *Recommendation

	noSmithyDocumentSerde
}

// The details that define an aggregation based on repository.
type RepositoryAggregation struct {

	// The names of repositories to aggregate findings on.
	Repositories []StringFilter

	// The value to sort results by.
	SortBy RepositorySortBy

	// The order to sort results by.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// A response that contains details on the results of a finding aggregation by
// repository.
type RepositoryAggregationResponse struct {

	// The name of the repository associated with the findings.
	//
	// This member is required.
	Repository *string

	// The ID of the Amazon Web Services account associated with the findings.
	AccountId *string

	// The number of container images impacted by the findings.
	AffectedImages *int64

	// An object that represent the count of matched findings per severity.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// Details about the resource involved in a finding.
type Resource struct {

	// The ID of the resource.
	//
	// This member is required.
	Id *string

	// The type of resource.
	//
	// This member is required.
	Type ResourceType

	// An object that contains details about the resource involved in a finding.
	Details *ResourceDetails

	// The partition of the resource.
	Partition *string

	// The Amazon Web Services Region the impacted resource is located in.
	Region *string

	// The tags attached to the resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains details about the resource involved in the finding.
type ResourceDetails struct {

	// An object that contains details about the Amazon EC2 instance involved in the
	// finding.
	AwsEc2Instance *AwsEc2InstanceDetails

	// An object that contains details about the Amazon ECR container image involved
	// in the finding.
	AwsEcrContainerImage *AwsEcrContainerImageDetails

	// A summary of the information about an Amazon Web Services Lambda function
	// affected by a finding.
	AwsLambdaFunction *AwsLambdaFunctionDetails

	// Contains details about a code repository resource associated with a finding.
	CodeRepository *CodeRepositoryDetails

	noSmithyDocumentSerde
}

// The resource filter criteria for a Software bill of materials (SBOM) report.
type ResourceFilterCriteria struct {

	// The account IDs used as resource filter criteria.
	AccountId []ResourceStringFilter

	// The EC2 instance tags used as resource filter criteria.
	Ec2InstanceTags []ResourceMapFilter

	// The ECR image tags used as resource filter criteria.
	EcrImageTags []ResourceStringFilter

	// The ECR repository names used as resource filter criteria.
	EcrRepositoryName []ResourceStringFilter

	// The Amazon Web Services Lambda function name used as resource filter criteria.
	LambdaFunctionName []ResourceStringFilter

	// The Amazon Web Services Lambda function tags used as resource filter criteria.
	LambdaFunctionTags []ResourceMapFilter

	// The resource IDs used as resource filter criteria.
	ResourceId []ResourceStringFilter

	// The resource types used as resource filter criteria.
	ResourceType []ResourceStringFilter

	noSmithyDocumentSerde
}

// A resource map filter for a software bill of material report.
type ResourceMapFilter struct {

	// The filter's comparison.
	//
	// This member is required.
	Comparison ResourceMapComparison

	// The filter's key.
	//
	// This member is required.
	Key *string

	// The filter's value.
	Value *string

	noSmithyDocumentSerde
}

// An object that contains details about the metadata for an Amazon ECR resource.
type ResourceScanMetadata struct {

	// Contains metadata about scan coverage for a code repository resource.
	CodeRepository *CodeRepositoryMetadata

	// An object that contains metadata details for an Amazon EC2 instance.
	Ec2 *Ec2Metadata

	// An object that contains details about the container metadata for an Amazon ECR
	// image.
	EcrImage *EcrContainerImageMetadata

	// An object that contains details about the repository an Amazon ECR image
	// resides in.
	EcrRepository *EcrRepositoryMetadata

	// An object that contains metadata details for an Amazon Web Services Lambda
	// function.
	LambdaFunction *LambdaFunctionMetadata

	noSmithyDocumentSerde
}

// Details the state of Amazon Inspector for each resource type Amazon Inspector
// scans.
type ResourceState struct {

	// An object detailing the state of Amazon Inspector scanning for Amazon EC2
	// resources.
	//
	// This member is required.
	Ec2 *State

	// An object detailing the state of Amazon Inspector scanning for Amazon ECR
	// resources.
	//
	// This member is required.
	Ecr *State

	// An object that described the state of Amazon Inspector scans for an account.
	CodeRepository *State

	// An object that described the state of Amazon Inspector scans for an account.
	Lambda *State

	// An object that described the state of Amazon Inspector scans for an account.
	LambdaCode *State

	noSmithyDocumentSerde
}

// Details the status of Amazon Inspector for each resource type Amazon Inspector
// scans.
type ResourceStatus struct {

	// The status of Amazon Inspector scanning for Amazon EC2 resources.
	//
	// This member is required.
	Ec2 Status

	// The status of Amazon Inspector scanning for Amazon ECR resources.
	//
	// This member is required.
	Ecr Status

	// The status of Amazon Inspector scanning for code repositories.
	CodeRepository Status

	// The status of Amazon Inspector scanning for Amazon Web Services Lambda function.
	Lambda Status

	// The status of Amazon Inspector scanning for custom application code for Amazon
	// Web Services Lambda functions.
	LambdaCode Status

	noSmithyDocumentSerde
}

// A resource string filter for a software bill of materials report.
type ResourceStringFilter struct {

	// The filter's comparison.
	//
	// This member is required.
	Comparison ResourceStringComparison

	// The filter's value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The status of the scan.
type ScanStatus struct {

	// The scan status. Possible return values and descriptions are:
	//
	// ACCESS_DENIED - Resource access policy restricting Amazon Inspector access.
	// Please update the IAM policy.
	//
	// ACCESS_DENIED_TO_ENCRYPTION_KEY - The KMS key policy doesn't allow Amazon
	// Inspector access. Update the key policy.
	//
	// DEEP_INSPECTION_COLLECTION_TIME_LIMIT_EXCEEDED - Amazon Inspector failed to
	// extract the package inventory because the package collection time exceeding the
	// maximum threshold of 15 minutes.
	//
	// DEEP_INSPECTION_DAILY_SSM_INVENTORY_LIMIT_EXCEEDED - The SSM agent couldn't
	// send inventory to Amazon Inspector because the SSM quota for Inventory data
	// collected per instance per day has already been reached for this instance.
	//
	// DEEP_INSPECTION_NO_INVENTORY - The Amazon Inspector plugin hasn't yet been able
	// to collect an inventory of packages for this instance. This is usually the
	// result of a pending scan, however, if this status persists after 6 hours, use
	// SSM to ensure that the required Amazon Inspector associations exist and are
	// running for the instance.
	//
	// DEEP_INSPECTION_PACKAGE_COLLECTION_LIMIT_EXCEEDED - The instance has exceeded
	// the 5000 package limit for Amazon Inspector Deep inspection. To resume Deep
	// inspection for this instance you can try to adjust the custom paths associated
	// with the account.
	//
	// EC2_INSTANCE_STOPPED - This EC2 instance is in a stopped state, therefore,
	// Amazon Inspector will pause scanning. The existing findings will continue to
	// exist until the instance is terminated. Once the instance is re-started,
	// Inspector will automatically start scanning the instance again. Please note that
	// you will not be charged for this instance while it's in a stopped state.
	//
	// EXCLUDED_BY_TAG - This resource was not scanned because it has been excluded by
	// a tag.
	//
	// IMAGE_SIZE_EXCEEDED - Reserved for future use.
	//
	// INTEGRATION_CONNNECTION_LOST - Amazon Inspector couldn't communicate with the
	// source code management platform.
	//
	// INTERNAL_ERROR - Amazon Inspector has encountered an internal error for this
	// resource. Amazon Inspector service will automatically resolve the issue and
	// resume the scanning. No action required from the user.
	//
	// NO_INVENTORY - Amazon Inspector couldn't find software application inventory to
	// scan for vulnerabilities. This might be caused due to required Amazon Inspector
	// associations being deleted or failing to run on your resource. Please verify the
	// status of InspectorInventoryCollection-do-not-delete association in the SSM
	// console for the resource. Additionally, you can verify the instance's inventory
	// in the SSM Fleet Manager console.
	//
	// NO_RESOURCES_FOUND - Reserved for future use.
	//
	// NO_SCAN_CONFIGURATION_ASSOCIATED - The code repository resource doesn't have an
	// associated scan configuration.
	//
	// PENDING_DISABLE - This resource is pending cleanup during disablement. The
	// customer will not be billed while a resource is in the pending disable status.
	//
	// PENDING_INITIAL_SCAN - This resource has been identified for scanning, results
	// will be available soon.
	//
	// RESOURCE_TERMINATED - This resource has been terminated. The findings and
	// coverage associated with this resource are in the process of being cleaned up.
	//
	// SCAN_ELIGIBILITY_EXPIRED - The configured scan duration has lapsed for this
	// image.
	//
	// SCAN_FREQUENCY_MANUAL - This image will not be covered by Amazon Inspector due
	// to the repository scan frequency configuration.
	//
	// SCAN_FREQUENCY_SCAN_ON_PUSH - This image will be scanned one time and will not
	// new findings because of the scan frequency configuration.
	//
	// SCAN_IN_PROGRESS - The resource is currently being scanned.
	//
	// STALE_INVENTORY - Amazon Inspector wasn't able to collect an updated software
	// application inventory in the last 7 days. Please confirm the required Amazon
	// Inspector associations still exist and you can still see an updated inventory in
	// the SSM console.
	//
	// SUCCESSFUL - The scan was successful.
	//
	// UNMANAGED_EC2_INSTANCE - The EC2 instance is not managed by SSM, please use the
	// following SSM automation to remediate the issue: [https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-troubleshoot-managed-instance.html]. Once the instance becomes
	// managed by SSM, Inspector will automatically begin scanning this instance.
	//
	// UNSUPPORTED_CONFIG_FILE - Reserved for future use.
	//
	// UNSUPPORTED_LANGUAGE - The scan was unsuccessful because the repository
	// contains files in an unsupported programming language.
	//
	// UNSUPPORTED_MEDIA_TYPE - The ECR image has an unsupported media type.
	//
	// UNSUPPORTED_OS - Amazon Inspector does not support this OS, architecture, or
	// image manifest type at this time. To see a complete list of supported operating
	// systems see: [https://docs.aws.amazon.com/inspector/latest/user/supported.html].
	//
	// UNSUPPORTED_RUNTIME - The function was not scanned because it has an
	// unsupported runtime. To see a complete list of supported runtimes see: [https://docs.aws.amazon.com/inspector/latest/user/supported.html].
	//
	// [https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-troubleshoot-managed-instance.html]: https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-troubleshoot-managed-instance.html
	// [https://docs.aws.amazon.com/inspector/latest/user/supported.html]: https://docs.aws.amazon.com/inspector/latest/user/supported.html
	//
	// This member is required.
	Reason ScanStatusReason

	// The status code of the scan.
	//
	// This member is required.
	StatusCode ScanStatusCode

	noSmithyDocumentSerde
}

// A schedule.
//
// The following types satisfy this interface:
//
//	ScheduleMemberDaily
//	ScheduleMemberMonthly
//	ScheduleMemberOneTime
//	ScheduleMemberWeekly
type Schedule interface {
	isSchedule()
}

// The schedule's daily.
type ScheduleMemberDaily struct {
	Value DailySchedule

	noSmithyDocumentSerde
}

func (*ScheduleMemberDaily) isSchedule() {}

// The schedule's monthly.
type ScheduleMemberMonthly struct {
	Value MonthlySchedule

	noSmithyDocumentSerde
}

func (*ScheduleMemberMonthly) isSchedule() {}

// The schedule's one time.
type ScheduleMemberOneTime struct {
	Value OneTimeSchedule

	noSmithyDocumentSerde
}

func (*ScheduleMemberOneTime) isSchedule() {}

// The schedule's weekly.
type ScheduleMemberWeekly struct {
	Value WeeklySchedule

	noSmithyDocumentSerde
}

func (*ScheduleMemberWeekly) isSchedule() {}

// Defines the scope of repositories to be included in code security scans.
type ScopeSettings struct {

	// The scope of projects to be selected for scanning within the integrated
	// repositories. Setting the value to ALL applies the scope settings to all
	// existing and future projects imported into Amazon Inspector.
	ProjectSelectionScope ProjectSelectionScope

	noSmithyDocumentSerde
}

// Details on the criteria used to define the filter for a vulnerability search.
type SearchVulnerabilitiesFilterCriteria struct {

	// The IDs for specific vulnerabilities.
	//
	// This member is required.
	VulnerabilityIds []string

	noSmithyDocumentSerde
}

// An object that contains the counts of aggregated finding per severity.
type SeverityCounts struct {

	// The total count of findings from all severities.
	All *int64

	// The total count of critical severity findings.
	Critical *int64

	// The total count of high severity findings.
	High *int64

	// The total count of medium severity findings.
	Medium *int64

	noSmithyDocumentSerde
}

// Details about the criteria used to sort finding results.
type SortCriteria struct {

	// The finding detail field by which results are sorted.
	//
	// This member is required.
	Field SortField

	// The order by which findings are sorted.
	//
	// This member is required.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// The start CIS session message.
type StartCisSessionMessage struct {

	// The unique token that identifies the CIS session.
	//
	// This member is required.
	SessionToken *string

	noSmithyDocumentSerde
}

// An object that described the state of Amazon Inspector scans for an account.
type State struct {

	// The error code explaining why the account failed to enable Amazon Inspector.
	//
	// This member is required.
	ErrorCode ErrorCode

	// The error message received when the account failed to enable Amazon Inspector.
	//
	// This member is required.
	ErrorMessage *string

	// The status of Amazon Inspector for the account.
	//
	// This member is required.
	Status Status

	noSmithyDocumentSerde
}

// The status counts.
type StatusCounts struct {

	// The number of checks that failed.
	Failed *int32

	// The number of checks that passed.
	Passed *int32

	// The number of checks that were skipped.
	Skipped *int32

	noSmithyDocumentSerde
}

// Details about the step associated with a finding.
type Step struct {

	// The component ID.
	//
	// This member is required.
	ComponentId *string

	// The component type.
	//
	// This member is required.
	ComponentType *string

	// The component ARN. The ARN can be null and is not displayed in the Amazon Web
	// Services console.
	ComponentArn *string

	noSmithyDocumentSerde
}

// The stop CIS message progress.
type StopCisMessageProgress struct {

	// The progress' error checks.
	ErrorChecks int32

	// The progress' failed checks.
	FailedChecks int32

	// The progress' informational checks.
	InformationalChecks int32

	// The progress' not applicable checks.
	NotApplicableChecks int32

	// The progress' not evaluated checks.
	NotEvaluatedChecks int32

	// The progress' successful checks.
	SuccessfulChecks int32

	// The progress' total checks.
	TotalChecks int32

	// The progress' unknown checks.
	UnknownChecks int32

	noSmithyDocumentSerde
}

// The stop CIS session message.
type StopCisSessionMessage struct {

	// The progress of the message.
	//
	// This member is required.
	Progress *StopCisMessageProgress

	// The status of the message.
	//
	// This member is required.
	Status StopCisSessionStatus

	// The message benchmark profile.
	BenchmarkProfile *string

	// The message benchmark version.
	BenchmarkVersion *string

	// The message compute platform.
	ComputePlatform *ComputePlatform

	// The reason for the message.
	Reason *string

	noSmithyDocumentSerde
}

// An object that describes the details of a string filter.
type StringFilter struct {

	// The operator to use when comparing values in the filter.
	//
	// This member is required.
	Comparison StringComparison

	// The value to filter on.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Details about a successful association or disassociation between a code
// repository and a scan configuration.
type SuccessfulAssociationResult struct {

	// Identifies a specific resource in a code repository that will be scanned.
	Resource CodeSecurityResource

	// The Amazon Resource Name (ARN) of the scan configuration that was successfully
	// associated or disassociated.
	ScanConfigurationArn *string

	noSmithyDocumentSerde
}

// A suggested fix for a vulnerability in your Lambda function code.
type SuggestedFix struct {

	// The fix's code.
	Code *string

	// The fix's description.
	Description *string

	noSmithyDocumentSerde
}

// The tag filter.
type TagFilter struct {

	// The tag filter comparison value.
	//
	// This member is required.
	Comparison TagComparison

	// The tag filter key.
	//
	// This member is required.
	Key *string

	// The tag filter value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The time.
type Time struct {

	// The time of day in 24-hour format (00:00).
	//
	// This member is required.
	TimeOfDay *string

	// The timezone.
	//
	// This member is required.
	Timezone *string

	noSmithyDocumentSerde
}

// The details that define an aggregation based on finding title.
type TitleAggregation struct {

	// The type of finding to aggregate on.
	FindingType AggregationFindingType

	// The resource type to aggregate on.
	ResourceType AggregationResourceType

	// The value to sort results by.
	SortBy TitleSortBy

	// The order to sort results by.
	SortOrder SortOrder

	// The finding titles to aggregate on.
	Titles []StringFilter

	// The vulnerability IDs of the findings.
	VulnerabilityIds []StringFilter

	noSmithyDocumentSerde
}

// A response that contains details on the results of a finding aggregation by
// title.
type TitleAggregationResponse struct {

	// The title that the findings were aggregated on.
	//
	// This member is required.
	Title *string

	// The ID of the Amazon Web Services account associated with the findings.
	AccountId *string

	// An object that represent the count of matched findings per severity.
	SeverityCounts *SeverityCounts

	// The vulnerability ID of the finding.
	VulnerabilityId *string

	noSmithyDocumentSerde
}

// Updates CIS targets.
type UpdateCisTargets struct {

	// The target account ids.
	AccountIds []string

	// The target resource tags.
	TargetResourceTags map[string][]string

	noSmithyDocumentSerde
}

// Contains details required to update an integration with GitHub.
type UpdateGitHubIntegrationDetail struct {

	// The authorization code received from GitHub to update the integration.
	//
	// This member is required.
	Code *string

	// The installation ID of the GitHub App associated with the integration.
	//
	// This member is required.
	InstallationId *string

	noSmithyDocumentSerde
}

// Contains details required to update an integration with a self-managed GitLab
// instance.
type UpdateGitLabSelfManagedIntegrationDetail struct {

	// The authorization code received from the self-managed GitLab instance to update
	// the integration.
	//
	// This member is required.
	AuthCode *string

	noSmithyDocumentSerde
}

// Contains details required to update a code security integration with a specific
// repository provider.
//
// The following types satisfy this interface:
//
//	UpdateIntegrationDetailsMemberGithub
//	UpdateIntegrationDetailsMemberGitlabSelfManaged
type UpdateIntegrationDetails interface {
	isUpdateIntegrationDetails()
}

// Details specific to updating an integration with GitHub.
type UpdateIntegrationDetailsMemberGithub struct {
	Value UpdateGitHubIntegrationDetail

	noSmithyDocumentSerde
}

func (*UpdateIntegrationDetailsMemberGithub) isUpdateIntegrationDetails() {}

// Details specific to updating an integration with a self-managed GitLab instance.
type UpdateIntegrationDetailsMemberGitlabSelfManaged struct {
	Value UpdateGitLabSelfManagedIntegrationDetail

	noSmithyDocumentSerde
}

func (*UpdateIntegrationDetailsMemberGitlabSelfManaged) isUpdateIntegrationDetails() {}

// Contains usage information about the cost of Amazon Inspector operation.
type Usage struct {

	// The currency type used when calculating usage data.
	Currency Currency

	// The estimated monthly cost of Amazon Inspector.
	EstimatedMonthlyCost float64

	// The total of usage.
	Total float64

	// The type scan.
	Type UsageType

	noSmithyDocumentSerde
}

// The total of usage for an account ID.
type UsageTotal struct {

	// The account ID of the account that usage data was retrieved for.
	AccountId *string

	// An object representing the total usage for an account.
	Usage []Usage

	noSmithyDocumentSerde
}

// An object that describes a validation exception.
type ValidationExceptionField struct {

	// The validation exception message.
	//
	// This member is required.
	Message *string

	// The name of the validation exception.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Contains details about a specific vulnerability Amazon Inspector can detect.
type Vulnerability struct {

	// The ID for the specific vulnerability.
	//
	// This member is required.
	Id *string

	// An object that contains information about the Amazon Web Services Threat Intel
	// Group (ATIG) details for the vulnerability.
	AtigData *AtigData

	// An object that contains the Cybersecurity and Infrastructure Security Agency
	// (CISA) details for the vulnerability.
	CisaData *CisaData

	// An object that contains the Common Vulnerability Scoring System (CVSS) Version
	// 2 details for the vulnerability.
	Cvss2 *Cvss2

	// An object that contains the Common Vulnerability Scoring System (CVSS) Version
	// 3 details for the vulnerability.
	Cvss3 *Cvss3

	// An object that contains the Common Vulnerability Scoring System (CVSS) Version
	// 4 details for the vulnerability.
	Cvss4 *Cvss4

	// The Common Weakness Enumeration (CWE) associated with the vulnerability.
	Cwes []string

	// A description of the vulnerability.
	Description *string

	// Platforms that the vulnerability can be detected on.
	DetectionPlatforms []string

	// An object that contains the Exploit Prediction Scoring System (EPSS) score for
	// a vulnerability.
	Epss *Epss

	// An object that contains details on when the exploit was observed.
	ExploitObserved *ExploitObserved

	// Links to various resources with more information on this vulnerability.
	ReferenceUrls []string

	// A list of related vulnerabilities.
	RelatedVulnerabilities []string

	// The source of the vulnerability information. Possible results are RHEL ,
	// AMAZON_CVE , DEBIAN or NVD .
	Source VulnerabilitySource

	// A link to the official source material for this vulnerability.
	SourceUrl *string

	// The date and time when the vendor created this vulnerability.
	VendorCreatedAt *time.Time

	// The severity assigned by the vendor.
	VendorSeverity *string

	// The date and time when the vendor last updated this vulnerability.
	VendorUpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Information on the vulnerable package identified by a finding.
type VulnerablePackage struct {

	// The name of the vulnerable package.
	//
	// This member is required.
	Name *string

	// The version of the vulnerable package.
	//
	// This member is required.
	Version *string

	// The architecture of the vulnerable package.
	Arch *string

	// The epoch of the vulnerable package.
	Epoch int32

	// The file path of the vulnerable package.
	FilePath *string

	// The version of the package that contains the vulnerability fix.
	FixedInVersion *string

	// The package manager of the vulnerable package.
	PackageManager PackageManager

	// The release of the vulnerable package.
	Release *string

	// The code to run in your environment to update packages with a fix available.
	Remediation *string

	// The Amazon Resource Number (ARN) of the Amazon Web Services Lambda function
	// affected by a finding.
	SourceLambdaLayerArn *string

	// The source layer hash of the vulnerable package.
	SourceLayerHash *string

	noSmithyDocumentSerde
}

// A weekly schedule.
type WeeklySchedule struct {

	// The weekly schedule's days.
	//
	// This member is required.
	Days []Day

	// The weekly schedule's start time.
	//
	// This member is required.
	StartTime *Time

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAggregationRequest()       {}
func (*UnknownUnionMember) isAggregationResponse()      {}
func (*UnknownUnionMember) isClusterMetadata()          {}
func (*UnknownUnionMember) isCodeSecurityResource()     {}
func (*UnknownUnionMember) isCreateIntegrationDetail()  {}
func (*UnknownUnionMember) isSchedule()                 {}
func (*UnknownUnionMember) isUpdateIntegrationDetails() {}
