// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Information about the checksum of a model deployed on a device.
type Checksum struct {

	// The checksum of the model.
	Sum *string

	// The type of the checksum.
	Type ChecksumType

	noSmithyDocumentSerde
}

type Definition struct {

	// The checksum information of the model.
	Checksum *Checksum

	// The unique model handle.
	ModelHandle *string

	// The absolute S3 location of the model.
	S3Url *string

	// The desired state of the model.
	State ModelState

	noSmithyDocumentSerde
}

type DeploymentModel struct {

	// The desired state of the model.
	DesiredState ModelState

	// The unique handle of the model.
	ModelHandle *string

	// The name of the model.
	ModelName *string

	// The version of the model.
	ModelVersion *string

	// Returns the error message if there is a rollback.
	RollbackFailureReason *string

	// Returns the current state of the model.
	State ModelState

	// Returns the deployment status of the model.
	Status DeploymentStatus

	// Returns the error message for the deployment status result.
	StatusReason *string

	noSmithyDocumentSerde
}

// Information about the result of a deployment on an edge device that is
// registered with SageMaker Edge Manager.
type DeploymentResult struct {

	// The timestamp of when the deployment was ended, and the agent got the
	// deployment results.
	DeploymentEndTime *time.Time

	// Returns a list of models deployed on the agent.
	DeploymentModels []DeploymentModel

	// The name and unique ID of the deployment.
	DeploymentName *string

	// The timestamp of when the deployment was started on the agent.
	DeploymentStartTime *time.Time

	// Returns the bucket error code.
	DeploymentStatus *string

	// Returns the detailed error message.
	DeploymentStatusMessage *string

	noSmithyDocumentSerde
}

// Information about a deployment on an edge device that is registered with
// SageMaker Edge Manager.
type EdgeDeployment struct {

	// Returns a list of Definition objects.
	Definitions []Definition

	// The name and unique ID of the deployment.
	DeploymentName *string

	// Determines whether to rollback to previous configuration if deployment fails.
	FailureHandlingPolicy FailureHandlingPolicy

	// The type of the deployment.
	Type DeploymentType

	noSmithyDocumentSerde
}

// Information required for edge device metrics.
type EdgeMetric struct {

	// The dimension of metrics published.
	Dimension *string

	// Returns the name of the metric.
	MetricName *string

	// Timestamp of when the metric was requested.
	Timestamp *time.Time

	// Returns the value of the metric.
	Value *float64

	noSmithyDocumentSerde
}

// Information about a model deployed on an edge device that is registered with
// SageMaker Edge Manager.
type Model struct {

	// The timestamp of the last inference that was made.
	LatestInference *time.Time

	// The timestamp of the last data sample taken.
	LatestSampleTime *time.Time

	// Information required for model metrics.
	ModelMetrics []EdgeMetric

	// The name of the model.
	ModelName *string

	// The version of the model.
	ModelVersion *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
