//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armalertsmanagement_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/alertsmanagement/armalertsmanagement"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a436672b07fb1fe276c203b086b3f0e0d0c4aa24/specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2019-05-05-preview/examples/AlertsMetaData_MonitorService.json
func ExampleAlertsClient_MetaData() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armalertsmanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAlertsClient().MetaData(ctx, armalertsmanagement.IdentifierMonitorServiceList, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AlertsMetaData = armalertsmanagement.AlertsMetaData{
	// 	Properties: &armalertsmanagement.MonitorServiceList{
	// 		MetadataIdentifier: to.Ptr(armalertsmanagement.MetadataIdentifierMonitorServiceList),
	// 		Data: []*armalertsmanagement.MonitorServiceDetails{
	// 			{
	// 				Name: to.Ptr("ActivityLog Administrative"),
	// 				DisplayName: to.Ptr("Activity Log - Administrative"),
	// 			},
	// 			{
	// 				Name: to.Ptr("ActivityLog Autoscale"),
	// 				DisplayName: to.Ptr("Activity Log - Autoscale"),
	// 			},
	// 			{
	// 				Name: to.Ptr("ActivityLog Policy"),
	// 				DisplayName: to.Ptr("Activity Log - Policy"),
	// 			},
	// 			{
	// 				Name: to.Ptr("ActivityLog Recommendation"),
	// 				DisplayName: to.Ptr("Activity Log - Recommendation"),
	// 			},
	// 			{
	// 				Name: to.Ptr("ActivityLog Security"),
	// 				DisplayName: to.Ptr("Activity Log - Security"),
	// 			},
	// 			{
	// 				Name: to.Ptr("Application Insights"),
	// 				DisplayName: to.Ptr("Application Insights"),
	// 			},
	// 			{
	// 				Name: to.Ptr("Azure Backup"),
	// 				DisplayName: to.Ptr("Azure Backup"),
	// 			},
	// 			{
	// 				Name: to.Ptr("Custom"),
	// 				DisplayName: to.Ptr("Custom"),
	// 			},
	// 			{
	// 				Name: to.Ptr("Data Box Edge"),
	// 				DisplayName: to.Ptr("Data Box Edge"),
	// 			},
	// 			{
	// 				Name: to.Ptr("VM Insights"),
	// 				DisplayName: to.Ptr("VM Insights"),
	// 			},
	// 			{
	// 				Name: to.Ptr("Log Analytics"),
	// 				DisplayName: to.Ptr("Log Analytics"),
	// 			},
	// 			{
	// 				Name: to.Ptr("Nagios"),
	// 				DisplayName: to.Ptr("NAGIOS"),
	// 			},
	// 			{
	// 				Name: to.Ptr("Platform"),
	// 				DisplayName: to.Ptr("Platform"),
	// 			},
	// 			{
	// 				Name: to.Ptr("Resource Health"),
	// 				DisplayName: to.Ptr("Resource Health"),
	// 			},
	// 			{
	// 				Name: to.Ptr("SCOM"),
	// 				DisplayName: to.Ptr("SCOM"),
	// 			},
	// 			{
	// 				Name: to.Ptr("ServiceHealth"),
	// 				DisplayName: to.Ptr("Service Health"),
	// 			},
	// 			{
	// 				Name: to.Ptr("Smart Detector"),
	// 				DisplayName: to.Ptr("SmartDetector"),
	// 			},
	// 			{
	// 				Name: to.Ptr("Zabbix"),
	// 				DisplayName: to.Ptr("ZABBIX"),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a436672b07fb1fe276c203b086b3f0e0d0c4aa24/specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2019-05-05-preview/examples/Alerts_List.json
func ExampleAlertsClient_NewGetAllPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armalertsmanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAlertsClient().NewGetAllPager(&armalertsmanagement.AlertsClientGetAllOptions{TargetResource: nil,
		TargetResourceType:  nil,
		TargetResourceGroup: nil,
		MonitorService:      nil,
		MonitorCondition:    nil,
		Severity:            nil,
		AlertState:          nil,
		AlertRule:           nil,
		SmartGroupID:        nil,
		IncludeContext:      nil,
		IncludeEgressConfig: nil,
		PageCount:           nil,
		SortBy:              nil,
		SortOrder:           nil,
		Select:              nil,
		TimeRange:           nil,
		CustomTimeRange:     nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AlertsList = armalertsmanagement.AlertsList{
		// 	Value: []*armalertsmanagement.Alert{
		// 		{
		// 			Name: to.Ptr("cpu alert"),
		// 			Type: to.Ptr("Microsoft.AlertsManagement/alerts"),
		// 			ID: to.Ptr("/subscriptions/9e261de7-c804-4b9d-9ebf-6f50fe350a9a/providers/Microsoft.AlertsManagement/alerts/66114d64-d9d9-478b-95c9-b789d6502100"),
		// 			Properties: &armalertsmanagement.AlertProperties{
		// 				Context: map[string]any{
		// 				},
		// 				EgressConfig: map[string]any{
		// 				},
		// 				Essentials: &armalertsmanagement.Essentials{
		// 					Description: to.Ptr("description of the alert"),
		// 					ActionStatus: &armalertsmanagement.ActionStatus{
		// 						IsSuppressed: to.Ptr(false),
		// 					},
		// 					AlertRule: to.Ptr("https://servisdffsdf.portal.mms.microsoft.com/#Workspace/overview/settings/details/Edit Alert Rule/details/index?savedSearchId=&scheduleId="),
		// 					AlertState: to.Ptr(armalertsmanagement.AlertStateAcknowledged),
		// 					LastModifiedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T15:51:02.000Z"); return t}()),
		// 					LastModifiedUserName: to.Ptr("System"),
		// 					MonitorCondition: to.Ptr(armalertsmanagement.MonitorConditionFired),
		// 					MonitorConditionResolvedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T15:51:02.000Z"); return t}()),
		// 					MonitorService: to.Ptr(armalertsmanagement.MonitorServiceApplicationInsights),
		// 					Severity: to.Ptr(armalertsmanagement.SeveritySev3),
		// 					SignalType: to.Ptr(armalertsmanagement.SignalTypeLog),
		// 					SmartGroupID: to.Ptr("23d6b2ce-8c54-468f-aff0-sd32aebb7e56"),
		// 					SmartGroupingReason: to.Ptr("Occurred frequently with other alerts"),
		// 					SourceCreatedID: to.Ptr("6cd6b2ce-8c54-468f-aff0-9d12aebb7e49"),
		// 					StartDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T15:51:02.000Z"); return t}()),
		// 					TargetResource: to.Ptr("/subscriptions/3b540246-808d-4331-99aa-917b808a9166/resourcegroups/servicedeskresourcegroup/providers/microsoft.insights/components/servicedeskappinsight"),
		// 					TargetResourceGroup: to.Ptr("servicedeskresourcegroup"),
		// 					TargetResourceName: to.Ptr("servicedeskappinsight"),
		// 					TargetResourceType: to.Ptr("components"),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("cpu alert"),
		// 			Type: to.Ptr("Microsoft.AlertsManagement/alerts"),
		// 			ID: to.Ptr("/subscriptions/9e261de7-c804-4b9d-9ebf-6f50fe350a9a/providers/Microsoft.AlertsManagement/alerts/66114d64-d9d9-478b-95c9-b789d6502100"),
		// 			Properties: &armalertsmanagement.AlertProperties{
		// 				Context: map[string]any{
		// 				},
		// 				EgressConfig: map[string]any{
		// 				},
		// 				Essentials: &armalertsmanagement.Essentials{
		// 					Description: to.Ptr("description of the alert"),
		// 					ActionStatus: &armalertsmanagement.ActionStatus{
		// 						IsSuppressed: to.Ptr(false),
		// 					},
		// 					AlertRule: to.Ptr("https://servicsdfsdf.portal.mms.microsoft.com/#Workspace/overview/settings/details/Edit Alert Rule/details/index?savedSearchId=&scheduleId="),
		// 					AlertState: to.Ptr(armalertsmanagement.AlertStateNew),
		// 					LastModifiedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T15:51:02.000Z"); return t}()),
		// 					LastModifiedUserName: to.Ptr("System"),
		// 					MonitorCondition: to.Ptr(armalertsmanagement.MonitorConditionFired),
		// 					MonitorConditionResolvedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T15:51:02.000Z"); return t}()),
		// 					MonitorService: to.Ptr(armalertsmanagement.MonitorServiceApplicationInsights),
		// 					Severity: to.Ptr(armalertsmanagement.SeveritySev3),
		// 					SignalType: to.Ptr(armalertsmanagement.SignalTypeLog),
		// 					SmartGroupID: to.Ptr("d1c49c89-ea95-4697-a299-c0f5ebac62f1"),
		// 					SmartGroupingReason: to.Ptr("Alerts that frequently occur together have been grouped."),
		// 					SourceCreatedID: to.Ptr("6cd6b2ce-8c54-468f-aff0-9d12aebb7e49"),
		// 					StartDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T15:51:02.000Z"); return t}()),
		// 					TargetResource: to.Ptr("/subscriptions/3b540246-808d-4331-99aa-917b808a9166/resourcegroups/cind/providers/microsoft.operationalinsights/workspaces/servicedeskwcus"),
		// 					TargetResourceGroup: to.Ptr("servicedeskresourcegroup"),
		// 					TargetResourceName: to.Ptr("servicedeskwcus"),
		// 					TargetResourceType: to.Ptr("components"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a436672b07fb1fe276c203b086b3f0e0d0c4aa24/specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2019-05-05-preview/examples/Alerts_GetById.json
func ExampleAlertsClient_GetByID() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armalertsmanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAlertsClient().GetByID(ctx, "66114d64-d9d9-478b-95c9-b789d6502100", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Alert = armalertsmanagement.Alert{
	// 	Name: to.Ptr("cpu alert"),
	// 	Type: to.Ptr("Microsoft.AlertsManagement/alerts"),
	// 	ID: to.Ptr("/subscriptions/9e261de7-c804-4b9d-9ebf-6f50fe350a9a/providers/Microsoft.AlertsManagement/alerts/66114d64-d9d9-478b-95c9-b789d6502100"),
	// 	Properties: &armalertsmanagement.AlertProperties{
	// 		Context: map[string]any{
	// 		},
	// 		EgressConfig: map[string]any{
	// 		},
	// 		Essentials: &armalertsmanagement.Essentials{
	// 			Description: to.Ptr("description of the alert"),
	// 			ActionStatus: &armalertsmanagement.ActionStatus{
	// 				IsSuppressed: to.Ptr(false),
	// 			},
	// 			AlertRule: to.Ptr("https://sersdfsdfinsight.portal.mms.microsoft.com/#Workspace/overview/settings/details/Edit Alert Rule/details/index?savedSearchId=&scheduleId="),
	// 			AlertState: to.Ptr(armalertsmanagement.AlertStateAcknowledged),
	// 			LastModifiedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T15:51:02.000Z"); return t}()),
	// 			LastModifiedUserName: to.Ptr("System"),
	// 			MonitorCondition: to.Ptr(armalertsmanagement.MonitorConditionFired),
	// 			MonitorConditionResolvedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T15:51:02.000Z"); return t}()),
	// 			MonitorService: to.Ptr(armalertsmanagement.MonitorServiceApplicationInsights),
	// 			Severity: to.Ptr(armalertsmanagement.SeveritySev3),
	// 			SignalType: to.Ptr(armalertsmanagement.SignalTypeLog),
	// 			SmartGroupID: to.Ptr("23d6b2ce-8c54-468f-aff0-sd32aebb7e56"),
	// 			SmartGroupingReason: to.Ptr("Occurred frequently with other alerts"),
	// 			SourceCreatedID: to.Ptr("6cd6b2ce-8c54-468f-aff0-9d12aebb7e49"),
	// 			StartDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T15:51:02.000Z"); return t}()),
	// 			TargetResource: to.Ptr("/subscriptions/3b540246-808d-4331-99aa-917b808a9166/resourcegroups/servicedeskresourcegroup/providers/microsoft.insights/components/servicedeskappinsight"),
	// 			TargetResourceGroup: to.Ptr("servicedeskresourcegroup"),
	// 			TargetResourceName: to.Ptr("servicedeskappinsight"),
	// 			TargetResourceType: to.Ptr("components"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a436672b07fb1fe276c203b086b3f0e0d0c4aa24/specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2019-05-05-preview/examples/Alerts_ChangeState.json
func ExampleAlertsClient_ChangeState() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armalertsmanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAlertsClient().ChangeState(ctx, "66114d64-d9d9-478b-95c9-b789d6502100", armalertsmanagement.AlertStateAcknowledged, &armalertsmanagement.AlertsClientChangeStateOptions{Comment: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Alert = armalertsmanagement.Alert{
	// 	Name: to.Ptr("cpu alert"),
	// 	Type: to.Ptr("Microsoft.AlertsManagement/alerts"),
	// 	ID: to.Ptr("/subscriptions/9e261de7-c804-4b9d-9ebf-6f50fe350a9a/providers/Microsoft.AlertsManagement/alerts/66114d64-d9d9-478b-95c9-b789d6502100"),
	// 	Properties: &armalertsmanagement.AlertProperties{
	// 		Context: map[string]any{
	// 		},
	// 		EgressConfig: map[string]any{
	// 		},
	// 		Essentials: &armalertsmanagement.Essentials{
	// 			Description: to.Ptr("description of the alert"),
	// 			ActionStatus: &armalertsmanagement.ActionStatus{
	// 				IsSuppressed: to.Ptr(false),
	// 			},
	// 			AlertRule: to.Ptr("https://servisdfsdfappinsight.portal.mms.microsoft.com/#Workspace/overview/settings/details/Edit Alert Rule/details/index?savedSearchId=&scheduleId="),
	// 			AlertState: to.Ptr(armalertsmanagement.AlertStateAcknowledged),
	// 			LastModifiedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T15:51:02.000Z"); return t}()),
	// 			LastModifiedUserName: to.Ptr("System"),
	// 			MonitorCondition: to.Ptr(armalertsmanagement.MonitorConditionFired),
	// 			MonitorConditionResolvedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T15:51:02.000Z"); return t}()),
	// 			MonitorService: to.Ptr(armalertsmanagement.MonitorServiceApplicationInsights),
	// 			Severity: to.Ptr(armalertsmanagement.SeveritySev3),
	// 			SignalType: to.Ptr(armalertsmanagement.SignalTypeLog),
	// 			SmartGroupID: to.Ptr("23d6b2ce-8c54-468f-aff0-sd32aebb7e56"),
	// 			SmartGroupingReason: to.Ptr("Occurred frequently with other alerts"),
	// 			SourceCreatedID: to.Ptr("6cd6b2ce-8c54-468f-aff0-9d12aebb7e49"),
	// 			StartDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T15:51:02.000Z"); return t}()),
	// 			TargetResource: to.Ptr("/subscriptions/3b540246-808d-4331-99aa-917b808a9166/resourcegroups/servicedeskresourcegroup/providers/microsoft.insights/components/servicedeskappinsight"),
	// 			TargetResourceGroup: to.Ptr("servicedeskresourcegroup"),
	// 			TargetResourceName: to.Ptr("servicedeskappinsight"),
	// 			TargetResourceType: to.Ptr("components"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a436672b07fb1fe276c203b086b3f0e0d0c4aa24/specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2019-05-05-preview/examples/Alerts_History.json
func ExampleAlertsClient_GetHistory() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armalertsmanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAlertsClient().GetHistory(ctx, "66114d64-d9d9-478b-95c9-b789d6502100", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AlertModification = armalertsmanagement.AlertModification{
	// 	Name: to.Ptr("CPU Alert"),
	// 	Type: to.Ptr("Microsoft.AlertsManagement/alerts"),
	// 	ID: to.Ptr("/subscriptions/9e261de7-c804-4b9d-9ebf-6f50fe350a9a/providers/Microsoft.AlertsManagement/alerts/66114d64-d9d9-478b-95c9-b789d6502100/history/default"),
	// 	Properties: &armalertsmanagement.AlertModificationProperties{
	// 		AlertID: to.Ptr("66114d64-d9d9-478b-95c9-b789d6502100"),
	// 		Modifications: []*armalertsmanagement.AlertModificationItem{
	// 			{
	// 				Description: to.Ptr("State changed from 'New' to 'Acknowledged'"),
	// 				Comments: to.Ptr("Acknowledging alert"),
	// 				ModificationEvent: to.Ptr(armalertsmanagement.AlertModificationEventStateChange),
	// 				ModifiedAt: to.Ptr("2018-06-13T06:14:15.7378737Z"),
	// 				ModifiedBy: to.Ptr("vikramm@microsoft.com"),
	// 				NewValue: to.Ptr("Acknowledged"),
	// 				OldValue: to.Ptr("New"),
	// 			},
	// 			{
	// 				Description: to.Ptr("New Alert Object is created"),
	// 				Comments: to.Ptr(""),
	// 				ModificationEvent: to.Ptr(armalertsmanagement.AlertModificationEventAlertCreated),
	// 				ModifiedAt: to.Ptr("2018-06-13T06:09:01Z"),
	// 				ModifiedBy: to.Ptr("System"),
	// 				NewValue: to.Ptr(""),
	// 				OldValue: to.Ptr(""),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a436672b07fb1fe276c203b086b3f0e0d0c4aa24/specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2019-05-05-preview/examples/Alerts_Summary.json
func ExampleAlertsClient_GetSummary() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armalertsmanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAlertsClient().GetSummary(ctx, armalertsmanagement.AlertsSummaryGroupByFields("severity,alertState"), &armalertsmanagement.AlertsClientGetSummaryOptions{IncludeSmartGroupsCount: nil,
		TargetResource:      nil,
		TargetResourceType:  nil,
		TargetResourceGroup: nil,
		MonitorService:      nil,
		MonitorCondition:    nil,
		Severity:            nil,
		AlertState:          nil,
		AlertRule:           nil,
		TimeRange:           nil,
		CustomTimeRange:     nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AlertsSummary = armalertsmanagement.AlertsSummary{
	// 	Name: to.Ptr("current"),
	// 	Type: to.Ptr("Microsoft.AlertsManagement/alertsSummary"),
	// 	ID: to.Ptr("/subscriptions/1e3ff1c0-771a-4119-a03b-be82a51e232d/providers/Microsoft.AlertsManagement/alertsSummary/current"),
	// 	Properties: &armalertsmanagement.AlertsSummaryGroup{
	// 		Groupedby: to.Ptr("severity"),
	// 		SmartGroupsCount: to.Ptr[int64](100),
	// 		Total: to.Ptr[int64](14189),
	// 		Values: []*armalertsmanagement.AlertsSummaryGroupItem{
	// 			{
	// 				Name: to.Ptr("Sev0"),
	// 				Count: to.Ptr[int64](6517),
	// 				Groupedby: to.Ptr("alertState"),
	// 				Values: []*armalertsmanagement.AlertsSummaryGroupItem{
	// 					{
	// 						Name: to.Ptr("New"),
	// 						Count: to.Ptr[int64](6517),
	// 					},
	// 					{
	// 						Name: to.Ptr("Acknowledged"),
	// 						Count: to.Ptr[int64](0),
	// 					},
	// 					{
	// 						Name: to.Ptr("Closed"),
	// 						Count: to.Ptr[int64](0),
	// 				}},
	// 			},
	// 			{
	// 				Name: to.Ptr("Sev1"),
	// 				Count: to.Ptr[int64](3175),
	// 				Groupedby: to.Ptr("alertState"),
	// 				Values: []*armalertsmanagement.AlertsSummaryGroupItem{
	// 					{
	// 						Name: to.Ptr("New"),
	// 						Count: to.Ptr[int64](3175),
	// 					},
	// 					{
	// 						Name: to.Ptr("Acknowledged"),
	// 						Count: to.Ptr[int64](0),
	// 					},
	// 					{
	// 						Name: to.Ptr("Closed"),
	// 						Count: to.Ptr[int64](0),
	// 				}},
	// 			},
	// 			{
	// 				Name: to.Ptr("Sev2"),
	// 				Count: to.Ptr[int64](1120),
	// 				Groupedby: to.Ptr("alertState"),
	// 				Values: []*armalertsmanagement.AlertsSummaryGroupItem{
	// 					{
	// 						Name: to.Ptr("New"),
	// 						Count: to.Ptr[int64](1120),
	// 					},
	// 					{
	// 						Name: to.Ptr("Acknowledged"),
	// 						Count: to.Ptr[int64](0),
	// 					},
	// 					{
	// 						Name: to.Ptr("Closed"),
	// 						Count: to.Ptr[int64](0),
	// 				}},
	// 			},
	// 			{
	// 				Name: to.Ptr("Sev3"),
	// 				Count: to.Ptr[int64](1902),
	// 				Groupedby: to.Ptr("alertState"),
	// 				Values: []*armalertsmanagement.AlertsSummaryGroupItem{
	// 					{
	// 						Name: to.Ptr("New"),
	// 						Count: to.Ptr[int64](1902),
	// 					},
	// 					{
	// 						Name: to.Ptr("Acknowledged"),
	// 						Count: to.Ptr[int64](0),
	// 					},
	// 					{
	// 						Name: to.Ptr("Closed"),
	// 						Count: to.Ptr[int64](0),
	// 				}},
	// 			},
	// 			{
	// 				Name: to.Ptr("Sev4"),
	// 				Count: to.Ptr[int64](1475),
	// 				Groupedby: to.Ptr("alertState"),
	// 				Values: []*armalertsmanagement.AlertsSummaryGroupItem{
	// 					{
	// 						Name: to.Ptr("New"),
	// 						Count: to.Ptr[int64](1475),
	// 					},
	// 					{
	// 						Name: to.Ptr("Acknowledged"),
	// 						Count: to.Ptr[int64](0),
	// 					},
	// 					{
	// 						Name: to.Ptr("Closed"),
	// 						Count: to.Ptr[int64](0),
	// 				}},
	// 		}},
	// 	},
	// }
}
