//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcostmanagement

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ExportsClient contains the methods for the Exports group.
// Don't use this type directly, use NewExportsClient() instead.
type ExportsClient struct {
	internal *arm.Client
}

// NewExportsClient creates a new instance of ExportsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewExportsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*ExportsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ExportsClient{
		internal: cl,
	}
	return client, nil
}

// CreateOrUpdate - The operation to create or update a export. Update operation requires latest eTag to be set in the request.
// You may obtain the latest eTag by performing a get operation. Create operation does not
// require eTag.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - scope - The scope associated with export operations. This includes '/subscriptions/{subscriptionId}/' for subscription
//     scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for
//     resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope and
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope,
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount
//     scope,
//     '/providers/Microsoft.Management/managementGroups/{managementGroupId} for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
//     for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}'
//     for invoiceSection scope, and
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for partners.
//   - exportName - Export Name.
//   - parameters - Parameters supplied to the CreateOrUpdate Export operation.
//   - options - ExportsClientCreateOrUpdateOptions contains the optional parameters for the ExportsClient.CreateOrUpdate method.
func (client *ExportsClient) CreateOrUpdate(ctx context.Context, scope string, exportName string, parameters Export, options *ExportsClientCreateOrUpdateOptions) (ExportsClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "ExportsClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, scope, exportName, parameters, options)
	if err != nil {
		return ExportsClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ExportsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ExportsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ExportsClient) createOrUpdateCreateRequest(ctx context.Context, scope string, exportName string, parameters Export, options *ExportsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.CostManagement/exports/{exportName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if exportName == "" {
		return nil, errors.New("parameter exportName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{exportName}", url.PathEscape(exportName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *ExportsClient) createOrUpdateHandleResponse(resp *http.Response) (ExportsClientCreateOrUpdateResponse, error) {
	result := ExportsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Export); err != nil {
		return ExportsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - The operation to delete a export.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - scope - The scope associated with export operations. This includes '/subscriptions/{subscriptionId}/' for subscription
//     scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for
//     resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope and
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope,
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount
//     scope,
//     '/providers/Microsoft.Management/managementGroups/{managementGroupId} for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
//     for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}'
//     for invoiceSection scope, and
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for partners.
//   - exportName - Export Name.
//   - options - ExportsClientDeleteOptions contains the optional parameters for the ExportsClient.Delete method.
func (client *ExportsClient) Delete(ctx context.Context, scope string, exportName string, options *ExportsClientDeleteOptions) (ExportsClientDeleteResponse, error) {
	var err error
	const operationName = "ExportsClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, scope, exportName, options)
	if err != nil {
		return ExportsClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ExportsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ExportsClientDeleteResponse{}, err
	}
	return ExportsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ExportsClient) deleteCreateRequest(ctx context.Context, scope string, exportName string, options *ExportsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.CostManagement/exports/{exportName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if exportName == "" {
		return nil, errors.New("parameter exportName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{exportName}", url.PathEscape(exportName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Execute - The operation to run an export.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - scope - The scope associated with export operations. This includes '/subscriptions/{subscriptionId}/' for subscription
//     scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for
//     resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope and
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope,
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount
//     scope,
//     '/providers/Microsoft.Management/managementGroups/{managementGroupId} for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
//     for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}'
//     for invoiceSection scope, and
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for partners.
//   - exportName - Export Name.
//   - options - ExportsClientExecuteOptions contains the optional parameters for the ExportsClient.Execute method.
func (client *ExportsClient) Execute(ctx context.Context, scope string, exportName string, options *ExportsClientExecuteOptions) (ExportsClientExecuteResponse, error) {
	var err error
	const operationName = "ExportsClient.Execute"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.executeCreateRequest(ctx, scope, exportName, options)
	if err != nil {
		return ExportsClientExecuteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ExportsClientExecuteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ExportsClientExecuteResponse{}, err
	}
	return ExportsClientExecuteResponse{}, nil
}

// executeCreateRequest creates the Execute request.
func (client *ExportsClient) executeCreateRequest(ctx context.Context, scope string, exportName string, options *ExportsClientExecuteOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.CostManagement/exports/{exportName}/run"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if exportName == "" {
		return nil, errors.New("parameter exportName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{exportName}", url.PathEscape(exportName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - The operation to get the export for the defined scope by export name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - scope - The scope associated with export operations. This includes '/subscriptions/{subscriptionId}/' for subscription
//     scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for
//     resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope and
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope,
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount
//     scope,
//     '/providers/Microsoft.Management/managementGroups/{managementGroupId} for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
//     for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}'
//     for invoiceSection scope, and
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for partners.
//   - exportName - Export Name.
//   - options - ExportsClientGetOptions contains the optional parameters for the ExportsClient.Get method.
func (client *ExportsClient) Get(ctx context.Context, scope string, exportName string, options *ExportsClientGetOptions) (ExportsClientGetResponse, error) {
	var err error
	const operationName = "ExportsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, scope, exportName, options)
	if err != nil {
		return ExportsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ExportsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ExportsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ExportsClient) getCreateRequest(ctx context.Context, scope string, exportName string, options *ExportsClientGetOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.CostManagement/exports/{exportName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if exportName == "" {
		return nil, errors.New("parameter exportName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{exportName}", url.PathEscape(exportName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ExportsClient) getHandleResponse(resp *http.Response) (ExportsClientGetResponse, error) {
	result := ExportsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Export); err != nil {
		return ExportsClientGetResponse{}, err
	}
	return result, nil
}

// GetExecutionHistory - The operation to get the run history of an export for the defined scope and export name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - scope - The scope associated with export operations. This includes '/subscriptions/{subscriptionId}/' for subscription
//     scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for
//     resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope and
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope,
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount
//     scope,
//     '/providers/Microsoft.Management/managementGroups/{managementGroupId} for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
//     for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}'
//     for invoiceSection scope, and
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for partners.
//   - exportName - Export Name.
//   - options - ExportsClientGetExecutionHistoryOptions contains the optional parameters for the ExportsClient.GetExecutionHistory
//     method.
func (client *ExportsClient) GetExecutionHistory(ctx context.Context, scope string, exportName string, options *ExportsClientGetExecutionHistoryOptions) (ExportsClientGetExecutionHistoryResponse, error) {
	var err error
	const operationName = "ExportsClient.GetExecutionHistory"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getExecutionHistoryCreateRequest(ctx, scope, exportName, options)
	if err != nil {
		return ExportsClientGetExecutionHistoryResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ExportsClientGetExecutionHistoryResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ExportsClientGetExecutionHistoryResponse{}, err
	}
	resp, err := client.getExecutionHistoryHandleResponse(httpResp)
	return resp, err
}

// getExecutionHistoryCreateRequest creates the GetExecutionHistory request.
func (client *ExportsClient) getExecutionHistoryCreateRequest(ctx context.Context, scope string, exportName string, options *ExportsClientGetExecutionHistoryOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.CostManagement/exports/{exportName}/runHistory"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if exportName == "" {
		return nil, errors.New("parameter exportName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{exportName}", url.PathEscape(exportName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getExecutionHistoryHandleResponse handles the GetExecutionHistory response.
func (client *ExportsClient) getExecutionHistoryHandleResponse(resp *http.Response) (ExportsClientGetExecutionHistoryResponse, error) {
	result := ExportsClientGetExecutionHistoryResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ExportExecutionListResult); err != nil {
		return ExportsClientGetExecutionHistoryResponse{}, err
	}
	return result, nil
}

// List - The operation to list all exports at the given scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - scope - The scope associated with export operations. This includes '/subscriptions/{subscriptionId}/' for subscription
//     scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for
//     resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope and
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope,
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount
//     scope,
//     '/providers/Microsoft.Management/managementGroups/{managementGroupId} for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
//     for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}'
//     for invoiceSection scope, and
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for partners.
//   - options - ExportsClientListOptions contains the optional parameters for the ExportsClient.List method.
func (client *ExportsClient) List(ctx context.Context, scope string, options *ExportsClientListOptions) (ExportsClientListResponse, error) {
	var err error
	const operationName = "ExportsClient.List"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listCreateRequest(ctx, scope, options)
	if err != nil {
		return ExportsClientListResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ExportsClientListResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ExportsClientListResponse{}, err
	}
	resp, err := client.listHandleResponse(httpResp)
	return resp, err
}

// listCreateRequest creates the List request.
func (client *ExportsClient) listCreateRequest(ctx context.Context, scope string, options *ExportsClientListOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.CostManagement/exports"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ExportsClient) listHandleResponse(resp *http.Response) (ExportsClientListResponse, error) {
	result := ExportsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ExportListResult); err != nil {
		return ExportsClientListResponse{}, err
	}
	return result, nil
}
