//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armselfhelp

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
)

// CheckNameAvailabilityClient contains the methods for the CheckNameAvailability group.
// Don't use this type directly, use NewCheckNameAvailabilityClient() instead.
type CheckNameAvailabilityClient struct {
	internal *arm.Client
}

// NewCheckNameAvailabilityClient creates a new instance of CheckNameAvailabilityClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewCheckNameAvailabilityClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*CheckNameAvailabilityClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &CheckNameAvailabilityClient{
		internal: cl,
	}
	return client, nil
}

// Post - This API is used to check the uniqueness of a resource name used for a diagnostic, troubleshooter or solutions
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
//   - scope - scope = resourceUri of affected resource.
//     For example: /subscriptions/0d0fcd2e-c4fd-4349-8497-200edb3923c6/resourcegroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-non-read
//   - options - CheckNameAvailabilityClientPostOptions contains the optional parameters for the CheckNameAvailabilityClient.Post
//     method.
func (client *CheckNameAvailabilityClient) Post(ctx context.Context, scope string, options *CheckNameAvailabilityClientPostOptions) (CheckNameAvailabilityClientPostResponse, error) {
	var err error
	const operationName = "CheckNameAvailabilityClient.Post"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.postCreateRequest(ctx, scope, options)
	if err != nil {
		return CheckNameAvailabilityClientPostResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CheckNameAvailabilityClientPostResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return CheckNameAvailabilityClientPostResponse{}, err
	}
	resp, err := client.postHandleResponse(httpResp)
	return resp, err
}

// postCreateRequest creates the Post request.
func (client *CheckNameAvailabilityClient) postCreateRequest(ctx context.Context, scope string, options *CheckNameAvailabilityClientPostOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Help/checkNameAvailability"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.CheckNameAvailabilityRequest != nil {
		if err := runtime.MarshalAsJSON(req, *options.CheckNameAvailabilityRequest); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// postHandleResponse handles the Post response.
func (client *CheckNameAvailabilityClient) postHandleResponse(resp *http.Response) (CheckNameAvailabilityClientPostResponse, error) {
	result := CheckNameAvailabilityClientPostResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CheckNameAvailabilityResponse); err != nil {
		return CheckNameAvailabilityClientPostResponse{}, err
	}
	return result, nil
}
