//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/support/armsupport/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ProblemClassificationsServer is a fake server for instances of the armsupport.ProblemClassificationsClient type.
type ProblemClassificationsServer struct {
	// Get is the fake for method ProblemClassificationsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, serviceName string, problemClassificationName string, options *armsupport.ProblemClassificationsClientGetOptions) (resp azfake.Responder[armsupport.ProblemClassificationsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ProblemClassificationsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(serviceName string, options *armsupport.ProblemClassificationsClientListOptions) (resp azfake.PagerResponder[armsupport.ProblemClassificationsClientListResponse])
}

// NewProblemClassificationsServerTransport creates a new instance of ProblemClassificationsServerTransport with the provided implementation.
// The returned ProblemClassificationsServerTransport instance is connected to an instance of armsupport.ProblemClassificationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewProblemClassificationsServerTransport(srv *ProblemClassificationsServer) *ProblemClassificationsServerTransport {
	return &ProblemClassificationsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armsupport.ProblemClassificationsClientListResponse]](),
	}
}

// ProblemClassificationsServerTransport connects instances of armsupport.ProblemClassificationsClient to instances of ProblemClassificationsServer.
// Don't use this type directly, use NewProblemClassificationsServerTransport instead.
type ProblemClassificationsServerTransport struct {
	srv          *ProblemClassificationsServer
	newListPager *tracker[azfake.PagerResponder[armsupport.ProblemClassificationsClientListResponse]]
}

// Do implements the policy.Transporter interface for ProblemClassificationsServerTransport.
func (p *ProblemClassificationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ProblemClassificationsClient.Get":
		resp, err = p.dispatchGet(req)
	case "ProblemClassificationsClient.NewListPager":
		resp, err = p.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *ProblemClassificationsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Support/services/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/problemClassifications/(?P<problemClassificationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	problemClassificationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("problemClassificationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), serviceNameParam, problemClassificationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProblemClassification, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProblemClassificationsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := p.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/providers/Microsoft\.Support/services/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/problemClassifications`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListPager(serviceNameParam, nil)
		newListPager = &resp
		p.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		p.newListPager.remove(req)
	}
	return resp, nil
}
