// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: brpb.proto

package backup

import (
	"fmt"
	"io"
	"math"

	proto "github.com/golang/protobuf/proto"

	_ "github.com/gogo/protobuf/gogoproto"

	encryptionpb "github.com/pingcap/kvproto/pkg/encryptionpb"

	errorpb "github.com/pingcap/kvproto/pkg/errorpb"

	kvrpcpb "github.com/pingcap/kvproto/pkg/kvrpcpb"

	context "golang.org/x/net/context"

	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// sst files compression algorithm
type CompressionType int32

const (
	CompressionType_UNKNOWN CompressionType = 0
	CompressionType_LZ4     CompressionType = 1
	CompressionType_SNAPPY  CompressionType = 2
	CompressionType_ZSTD    CompressionType = 3
)

var CompressionType_name = map[int32]string{
	0: "UNKNOWN",
	1: "LZ4",
	2: "SNAPPY",
	3: "ZSTD",
}
var CompressionType_value = map[string]int32{
	"UNKNOWN": 0,
	"LZ4":     1,
	"SNAPPY":  2,
	"ZSTD":    3,
}

func (x CompressionType) String() string {
	return proto.EnumName(CompressionType_name, int32(x))
}
func (CompressionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{0}
}

// The message save the metadata of a backup.
type BackupMeta struct {
	// ID and version of backuped cluster.
	ClusterId      uint64 `protobuf:"varint,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	ClusterVersion string `protobuf:"bytes,2,opt,name=cluster_version,json=clusterVersion,proto3" json:"cluster_version,omitempty"`
	// Save the version of BR running backup jobs.
	BrVersion string `protobuf:"bytes,11,opt,name=br_version,json=brVersion,proto3" json:"br_version,omitempty"`
	// The backupmeta scheme version.
	Version int32 `protobuf:"varint,12,opt,name=version,proto3" json:"version,omitempty"`
	// A set of files that compose a backup.
	// Note: `files` is deprecated, as it bloats backupmeta. It is kept for
	//       compatibility, so new BR can restore older backups.
	Files []*File `protobuf:"bytes,4,rep,name=files" json:"files,omitempty"`
	// An index to files contains data files.
	FileIndex *MetaFile `protobuf:"bytes,13,opt,name=file_index,json=fileIndex" json:"file_index,omitempty"`
	// A pair of timestamp specifies a time range of a backup.
	// For full backup, the start_version equals to the end_version,
	// it means point in time.
	// For incremental backup, the time range is specified as
	// (start_version, end_version].
	StartVersion uint64 `protobuf:"varint,5,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	EndVersion   uint64 `protobuf:"varint,6,opt,name=end_version,json=endVersion,proto3" json:"end_version,omitempty"`
	// Table metadata describes database and table info.
	// Note: `schemas` is deprecated, as it bloats backupmeta. It is kept for
	//       compatibility, so new BR can restore older backups.
	Schemas []*Schema `protobuf:"bytes,7,rep,name=schemas" json:"schemas,omitempty"`
	// An index to files contains Schemas.
	SchemaIndex *MetaFile `protobuf:"bytes,14,opt,name=schema_index,json=schemaIndex" json:"schema_index,omitempty"`
	// If in raw kv mode, `start_versions`, `end_versions` and `schemas` will be
	// ignored, and the backup data's range is represented by raw_ranges.
	IsRawKv bool `protobuf:"varint,8,opt,name=is_raw_kv,json=isRawKv,proto3" json:"is_raw_kv,omitempty"`
	// Note: `raw_ranges` is deprecated, as it bloats backupmeta. It is kept for
	//       compatibility, so new BR can restore older backups.
	RawRanges []*RawRange `protobuf:"bytes,9,rep,name=raw_ranges,json=rawRanges" json:"raw_ranges,omitempty"`
	// An index to files contains RawRanges.
	RawRangeIndex *MetaFile `protobuf:"bytes,15,opt,name=raw_range_index,json=rawRangeIndex" json:"raw_range_index,omitempty"`
	// In incremental backup, DDLs which are completed in
	// (lastBackupTS, backupTS] will be stored here.
	// Note: `raw_ranges` is deprecated, as it bloats backupmeta. It is kept for
	//       compatibility, so new BR can restore older backups.
	Ddls []byte `protobuf:"bytes,10,opt,name=ddls,proto3" json:"ddls,omitempty"`
	// An index to files contains DDLs.
	DdlIndexes *MetaFile `protobuf:"bytes,16,opt,name=ddl_indexes,json=ddlIndexes" json:"ddl_indexes,omitempty"`
	// the backup result into `backupmeta` file
	BackupResult string `protobuf:"bytes,17,opt,name=backup_result,json=backupResult,proto3" json:"backup_result,omitempty"`
	// API version implies the encode of the key and value.
	ApiVersion kvrpcpb.APIVersion `protobuf:"varint,18,opt,name=api_version,json=apiVersion,proto3,enum=kvrpcpb.APIVersion" json:"api_version,omitempty"`
	// the placement policy info in backup cluster. we assume the policy won't be too much for one cluster.
	Policies             []*PlacementPolicy `protobuf:"bytes,19,rep,name=policies" json:"policies,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *BackupMeta) Reset()         { *m = BackupMeta{} }
func (m *BackupMeta) String() string { return proto.CompactTextString(m) }
func (*BackupMeta) ProtoMessage()    {}
func (*BackupMeta) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{0}
}
func (m *BackupMeta) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BackupMeta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BackupMeta.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *BackupMeta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupMeta.Merge(dst, src)
}
func (m *BackupMeta) XXX_Size() int {
	return m.Size()
}
func (m *BackupMeta) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupMeta.DiscardUnknown(m)
}

var xxx_messageInfo_BackupMeta proto.InternalMessageInfo

func (m *BackupMeta) GetClusterId() uint64 {
	if m != nil {
		return m.ClusterId
	}
	return 0
}

func (m *BackupMeta) GetClusterVersion() string {
	if m != nil {
		return m.ClusterVersion
	}
	return ""
}

func (m *BackupMeta) GetBrVersion() string {
	if m != nil {
		return m.BrVersion
	}
	return ""
}

func (m *BackupMeta) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *BackupMeta) GetFiles() []*File {
	if m != nil {
		return m.Files
	}
	return nil
}

func (m *BackupMeta) GetFileIndex() *MetaFile {
	if m != nil {
		return m.FileIndex
	}
	return nil
}

func (m *BackupMeta) GetStartVersion() uint64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *BackupMeta) GetEndVersion() uint64 {
	if m != nil {
		return m.EndVersion
	}
	return 0
}

func (m *BackupMeta) GetSchemas() []*Schema {
	if m != nil {
		return m.Schemas
	}
	return nil
}

func (m *BackupMeta) GetSchemaIndex() *MetaFile {
	if m != nil {
		return m.SchemaIndex
	}
	return nil
}

func (m *BackupMeta) GetIsRawKv() bool {
	if m != nil {
		return m.IsRawKv
	}
	return false
}

func (m *BackupMeta) GetRawRanges() []*RawRange {
	if m != nil {
		return m.RawRanges
	}
	return nil
}

func (m *BackupMeta) GetRawRangeIndex() *MetaFile {
	if m != nil {
		return m.RawRangeIndex
	}
	return nil
}

func (m *BackupMeta) GetDdls() []byte {
	if m != nil {
		return m.Ddls
	}
	return nil
}

func (m *BackupMeta) GetDdlIndexes() *MetaFile {
	if m != nil {
		return m.DdlIndexes
	}
	return nil
}

func (m *BackupMeta) GetBackupResult() string {
	if m != nil {
		return m.BackupResult
	}
	return ""
}

func (m *BackupMeta) GetApiVersion() kvrpcpb.APIVersion {
	if m != nil {
		return m.ApiVersion
	}
	return kvrpcpb.APIVersion_V1
}

func (m *BackupMeta) GetPolicies() []*PlacementPolicy {
	if m != nil {
		return m.Policies
	}
	return nil
}

type File struct {
	Name         string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Sha256       []byte `protobuf:"bytes,2,opt,name=sha256,proto3" json:"sha256,omitempty"`
	StartKey     []byte `protobuf:"bytes,3,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey       []byte `protobuf:"bytes,4,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	StartVersion uint64 `protobuf:"varint,5,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	EndVersion   uint64 `protobuf:"varint,6,opt,name=end_version,json=endVersion,proto3" json:"end_version,omitempty"`
	Crc64Xor     uint64 `protobuf:"varint,7,opt,name=crc64xor,proto3" json:"crc64xor,omitempty"`
	TotalKvs     uint64 `protobuf:"varint,8,opt,name=total_kvs,json=totalKvs,proto3" json:"total_kvs,omitempty"`
	TotalBytes   uint64 `protobuf:"varint,9,opt,name=total_bytes,json=totalBytes,proto3" json:"total_bytes,omitempty"`
	Cf           string `protobuf:"bytes,10,opt,name=cf,proto3" json:"cf,omitempty"`
	Size_        uint64 `protobuf:"varint,11,opt,name=size,proto3" json:"size,omitempty"`
	// cipher_iv is used for AES cipher
	CipherIv             []byte   `protobuf:"bytes,12,opt,name=cipher_iv,json=cipherIv,proto3" json:"cipher_iv,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *File) Reset()         { *m = File{} }
func (m *File) String() string { return proto.CompactTextString(m) }
func (*File) ProtoMessage()    {}
func (*File) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{1}
}
func (m *File) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *File) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_File.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *File) XXX_Merge(src proto.Message) {
	xxx_messageInfo_File.Merge(dst, src)
}
func (m *File) XXX_Size() int {
	return m.Size()
}
func (m *File) XXX_DiscardUnknown() {
	xxx_messageInfo_File.DiscardUnknown(m)
}

var xxx_messageInfo_File proto.InternalMessageInfo

func (m *File) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *File) GetSha256() []byte {
	if m != nil {
		return m.Sha256
	}
	return nil
}

func (m *File) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *File) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *File) GetStartVersion() uint64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *File) GetEndVersion() uint64 {
	if m != nil {
		return m.EndVersion
	}
	return 0
}

func (m *File) GetCrc64Xor() uint64 {
	if m != nil {
		return m.Crc64Xor
	}
	return 0
}

func (m *File) GetTotalKvs() uint64 {
	if m != nil {
		return m.TotalKvs
	}
	return 0
}

func (m *File) GetTotalBytes() uint64 {
	if m != nil {
		return m.TotalBytes
	}
	return 0
}

func (m *File) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

func (m *File) GetSize_() uint64 {
	if m != nil {
		return m.Size_
	}
	return 0
}

func (m *File) GetCipherIv() []byte {
	if m != nil {
		return m.CipherIv
	}
	return nil
}

// MetaFile describes a multi-level index of data used in backup.
type MetaFile struct {
	// A set of files that contains a MetaFile.
	// It is used as a multi-level index.
	MetaFiles []*File `protobuf:"bytes,1,rep,name=meta_files,json=metaFiles" json:"meta_files,omitempty"`
	// A set of files that contains user data.
	DataFiles []*File `protobuf:"bytes,2,rep,name=data_files,json=dataFiles" json:"data_files,omitempty"`
	// A set of files that contains Schemas.
	Schemas []*Schema `protobuf:"bytes,3,rep,name=schemas" json:"schemas,omitempty"`
	// A set of files that contains RawRanges.
	RawRanges []*RawRange `protobuf:"bytes,4,rep,name=raw_ranges,json=rawRanges" json:"raw_ranges,omitempty"`
	// A set of files that contains DDLs.
	Ddls                 [][]byte `protobuf:"bytes,5,rep,name=ddls" json:"ddls,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MetaFile) Reset()         { *m = MetaFile{} }
func (m *MetaFile) String() string { return proto.CompactTextString(m) }
func (*MetaFile) ProtoMessage()    {}
func (*MetaFile) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{2}
}
func (m *MetaFile) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MetaFile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MetaFile.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *MetaFile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetaFile.Merge(dst, src)
}
func (m *MetaFile) XXX_Size() int {
	return m.Size()
}
func (m *MetaFile) XXX_DiscardUnknown() {
	xxx_messageInfo_MetaFile.DiscardUnknown(m)
}

var xxx_messageInfo_MetaFile proto.InternalMessageInfo

func (m *MetaFile) GetMetaFiles() []*File {
	if m != nil {
		return m.MetaFiles
	}
	return nil
}

func (m *MetaFile) GetDataFiles() []*File {
	if m != nil {
		return m.DataFiles
	}
	return nil
}

func (m *MetaFile) GetSchemas() []*Schema {
	if m != nil {
		return m.Schemas
	}
	return nil
}

func (m *MetaFile) GetRawRanges() []*RawRange {
	if m != nil {
		return m.RawRanges
	}
	return nil
}

func (m *MetaFile) GetDdls() [][]byte {
	if m != nil {
		return m.Ddls
	}
	return nil
}

type PlacementPolicy struct {
	Info                 []byte   `protobuf:"bytes,1,opt,name=info,proto3" json:"info,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PlacementPolicy) Reset()         { *m = PlacementPolicy{} }
func (m *PlacementPolicy) String() string { return proto.CompactTextString(m) }
func (*PlacementPolicy) ProtoMessage()    {}
func (*PlacementPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{3}
}
func (m *PlacementPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PlacementPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PlacementPolicy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *PlacementPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlacementPolicy.Merge(dst, src)
}
func (m *PlacementPolicy) XXX_Size() int {
	return m.Size()
}
func (m *PlacementPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_PlacementPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_PlacementPolicy proto.InternalMessageInfo

func (m *PlacementPolicy) GetInfo() []byte {
	if m != nil {
		return m.Info
	}
	return nil
}

type Schema struct {
	Db              []byte `protobuf:"bytes,1,opt,name=db,proto3" json:"db,omitempty"`
	Table           []byte `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
	Crc64Xor        uint64 `protobuf:"varint,3,opt,name=crc64xor,proto3" json:"crc64xor,omitempty"`
	TotalKvs        uint64 `protobuf:"varint,4,opt,name=total_kvs,json=totalKvs,proto3" json:"total_kvs,omitempty"`
	TotalBytes      uint64 `protobuf:"varint,5,opt,name=total_bytes,json=totalBytes,proto3" json:"total_bytes,omitempty"`
	TiflashReplicas uint32 `protobuf:"varint,6,opt,name=tiflash_replicas,json=tiflashReplicas,proto3" json:"tiflash_replicas,omitempty"`
	// stats represents the dump stats for a analyzed table, which generate by DumpStatsToJSON
	// https://github.com/pingcap/tidb/blob/e136429d8dc5d70f43cd3f94179b0b9f47595097/statistics/handle/dump.go#L116
	Stats                []byte   `protobuf:"bytes,7,opt,name=stats,proto3" json:"stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Schema) Reset()         { *m = Schema{} }
func (m *Schema) String() string { return proto.CompactTextString(m) }
func (*Schema) ProtoMessage()    {}
func (*Schema) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{4}
}
func (m *Schema) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Schema) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Schema.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Schema) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Schema.Merge(dst, src)
}
func (m *Schema) XXX_Size() int {
	return m.Size()
}
func (m *Schema) XXX_DiscardUnknown() {
	xxx_messageInfo_Schema.DiscardUnknown(m)
}

var xxx_messageInfo_Schema proto.InternalMessageInfo

func (m *Schema) GetDb() []byte {
	if m != nil {
		return m.Db
	}
	return nil
}

func (m *Schema) GetTable() []byte {
	if m != nil {
		return m.Table
	}
	return nil
}

func (m *Schema) GetCrc64Xor() uint64 {
	if m != nil {
		return m.Crc64Xor
	}
	return 0
}

func (m *Schema) GetTotalKvs() uint64 {
	if m != nil {
		return m.TotalKvs
	}
	return 0
}

func (m *Schema) GetTotalBytes() uint64 {
	if m != nil {
		return m.TotalBytes
	}
	return 0
}

func (m *Schema) GetTiflashReplicas() uint32 {
	if m != nil {
		return m.TiflashReplicas
	}
	return 0
}

func (m *Schema) GetStats() []byte {
	if m != nil {
		return m.Stats
	}
	return nil
}

type RawRange struct {
	StartKey             []byte   `protobuf:"bytes,1,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey               []byte   `protobuf:"bytes,2,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	Cf                   string   `protobuf:"bytes,3,opt,name=cf,proto3" json:"cf,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawRange) Reset()         { *m = RawRange{} }
func (m *RawRange) String() string { return proto.CompactTextString(m) }
func (*RawRange) ProtoMessage()    {}
func (*RawRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{5}
}
func (m *RawRange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawRange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *RawRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawRange.Merge(dst, src)
}
func (m *RawRange) XXX_Size() int {
	return m.Size()
}
func (m *RawRange) XXX_DiscardUnknown() {
	xxx_messageInfo_RawRange.DiscardUnknown(m)
}

var xxx_messageInfo_RawRange proto.InternalMessageInfo

func (m *RawRange) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *RawRange) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *RawRange) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

type ClusterIDError struct {
	Current              uint64   `protobuf:"varint,1,opt,name=current,proto3" json:"current,omitempty"`
	Request              uint64   `protobuf:"varint,2,opt,name=request,proto3" json:"request,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterIDError) Reset()         { *m = ClusterIDError{} }
func (m *ClusterIDError) String() string { return proto.CompactTextString(m) }
func (*ClusterIDError) ProtoMessage()    {}
func (*ClusterIDError) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{6}
}
func (m *ClusterIDError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterIDError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterIDError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ClusterIDError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterIDError.Merge(dst, src)
}
func (m *ClusterIDError) XXX_Size() int {
	return m.Size()
}
func (m *ClusterIDError) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterIDError.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterIDError proto.InternalMessageInfo

func (m *ClusterIDError) GetCurrent() uint64 {
	if m != nil {
		return m.Current
	}
	return 0
}

func (m *ClusterIDError) GetRequest() uint64 {
	if m != nil {
		return m.Request
	}
	return 0
}

type Error struct {
	Msg string `protobuf:"bytes,1,opt,name=msg,proto3" json:"msg,omitempty"`
	// Types that are valid to be assigned to Detail:
	//	*Error_ClusterIdError
	//	*Error_KvError
	//	*Error_RegionError
	Detail               isError_Detail `protobuf_oneof:"detail"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Error) Reset()         { *m = Error{} }
func (m *Error) String() string { return proto.CompactTextString(m) }
func (*Error) ProtoMessage()    {}
func (*Error) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{7}
}
func (m *Error) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Error) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Error.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Error) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Error.Merge(dst, src)
}
func (m *Error) XXX_Size() int {
	return m.Size()
}
func (m *Error) XXX_DiscardUnknown() {
	xxx_messageInfo_Error.DiscardUnknown(m)
}

var xxx_messageInfo_Error proto.InternalMessageInfo

type isError_Detail interface {
	isError_Detail()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Error_ClusterIdError struct {
	ClusterIdError *ClusterIDError `protobuf:"bytes,3,opt,name=cluster_id_error,json=clusterIdError,oneof"`
}
type Error_KvError struct {
	KvError *kvrpcpb.KeyError `protobuf:"bytes,4,opt,name=kv_error,json=kvError,oneof"`
}
type Error_RegionError struct {
	RegionError *errorpb.Error `protobuf:"bytes,5,opt,name=region_error,json=regionError,oneof"`
}

func (*Error_ClusterIdError) isError_Detail() {}
func (*Error_KvError) isError_Detail()        {}
func (*Error_RegionError) isError_Detail()    {}

func (m *Error) GetDetail() isError_Detail {
	if m != nil {
		return m.Detail
	}
	return nil
}

func (m *Error) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

func (m *Error) GetClusterIdError() *ClusterIDError {
	if x, ok := m.GetDetail().(*Error_ClusterIdError); ok {
		return x.ClusterIdError
	}
	return nil
}

func (m *Error) GetKvError() *kvrpcpb.KeyError {
	if x, ok := m.GetDetail().(*Error_KvError); ok {
		return x.KvError
	}
	return nil
}

func (m *Error) GetRegionError() *errorpb.Error {
	if x, ok := m.GetDetail().(*Error_RegionError); ok {
		return x.RegionError
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Error) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Error_OneofMarshaler, _Error_OneofUnmarshaler, _Error_OneofSizer, []interface{}{
		(*Error_ClusterIdError)(nil),
		(*Error_KvError)(nil),
		(*Error_RegionError)(nil),
	}
}

func _Error_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Error)
	// detail
	switch x := m.Detail.(type) {
	case *Error_ClusterIdError:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClusterIdError); err != nil {
			return err
		}
	case *Error_KvError:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.KvError); err != nil {
			return err
		}
	case *Error_RegionError:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RegionError); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Error.Detail has unexpected type %T", x)
	}
	return nil
}

func _Error_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Error)
	switch tag {
	case 3: // detail.cluster_id_error
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ClusterIDError)
		err := b.DecodeMessage(msg)
		m.Detail = &Error_ClusterIdError{msg}
		return true, err
	case 4: // detail.kv_error
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(kvrpcpb.KeyError)
		err := b.DecodeMessage(msg)
		m.Detail = &Error_KvError{msg}
		return true, err
	case 5: // detail.region_error
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(errorpb.Error)
		err := b.DecodeMessage(msg)
		m.Detail = &Error_RegionError{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Error_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Error)
	// detail
	switch x := m.Detail.(type) {
	case *Error_ClusterIdError:
		s := proto.Size(x.ClusterIdError)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Error_KvError:
		s := proto.Size(x.KvError)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Error_RegionError:
		s := proto.Size(x.RegionError)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type CipherInfo struct {
	CipherType           encryptionpb.EncryptionMethod `protobuf:"varint,1,opt,name=cipher_type,json=cipherType,proto3,enum=encryptionpb.EncryptionMethod" json:"cipher_type,omitempty"`
	CipherKey            []byte                        `protobuf:"bytes,2,opt,name=cipher_key,json=cipherKey,proto3" json:"cipher_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *CipherInfo) Reset()         { *m = CipherInfo{} }
func (m *CipherInfo) String() string { return proto.CompactTextString(m) }
func (*CipherInfo) ProtoMessage()    {}
func (*CipherInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{8}
}
func (m *CipherInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CipherInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CipherInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *CipherInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CipherInfo.Merge(dst, src)
}
func (m *CipherInfo) XXX_Size() int {
	return m.Size()
}
func (m *CipherInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CipherInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CipherInfo proto.InternalMessageInfo

func (m *CipherInfo) GetCipherType() encryptionpb.EncryptionMethod {
	if m != nil {
		return m.CipherType
	}
	return encryptionpb.EncryptionMethod_UNKNOWN
}

func (m *CipherInfo) GetCipherKey() []byte {
	if m != nil {
		return m.CipherKey
	}
	return nil
}

type BackupRequest struct {
	ClusterId    uint64 `protobuf:"varint,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	StartKey     []byte `protobuf:"bytes,2,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey       []byte `protobuf:"bytes,3,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	StartVersion uint64 `protobuf:"varint,4,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	EndVersion   uint64 `protobuf:"varint,5,opt,name=end_version,json=endVersion,proto3" json:"end_version,omitempty"`
	// The I/O rate limit for backup request.
	RateLimit uint64 `protobuf:"varint,7,opt,name=rate_limit,json=rateLimit,proto3" json:"rate_limit,omitempty"`
	// The concurrency for executing the backup request in every tikv node.
	Concurrency    uint32          `protobuf:"varint,8,opt,name=concurrency,proto3" json:"concurrency,omitempty"`
	StorageBackend *StorageBackend `protobuf:"bytes,9,opt,name=storage_backend,json=storageBackend" json:"storage_backend,omitempty"`
	// If raw kv mode is enabled, `start_version` and `end_version` will be ignored, and `cf`
	// specifies which cf to backup.
	IsRawKv bool   `protobuf:"varint,10,opt,name=is_raw_kv,json=isRawKv,proto3" json:"is_raw_kv,omitempty"`
	Cf      string `protobuf:"bytes,11,opt,name=cf,proto3" json:"cf,omitempty"`
	// algorithm used for compress sst files
	CompressionType CompressionType `protobuf:"varint,12,opt,name=compression_type,json=compressionType,proto3,enum=backup.CompressionType" json:"compression_type,omitempty"`
	// sst compression level, some algorithms support negative compression levels
	CompressionLevel int32 `protobuf:"varint,13,opt,name=compression_level,json=compressionLevel,proto3" json:"compression_level,omitempty"`
	// The cipher_info is Used to encrypt sst
	CipherInfo           *CipherInfo `protobuf:"bytes,14,opt,name=cipher_info,json=cipherInfo" json:"cipher_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *BackupRequest) Reset()         { *m = BackupRequest{} }
func (m *BackupRequest) String() string { return proto.CompactTextString(m) }
func (*BackupRequest) ProtoMessage()    {}
func (*BackupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{9}
}
func (m *BackupRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BackupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BackupRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *BackupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupRequest.Merge(dst, src)
}
func (m *BackupRequest) XXX_Size() int {
	return m.Size()
}
func (m *BackupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BackupRequest proto.InternalMessageInfo

func (m *BackupRequest) GetClusterId() uint64 {
	if m != nil {
		return m.ClusterId
	}
	return 0
}

func (m *BackupRequest) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *BackupRequest) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *BackupRequest) GetStartVersion() uint64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *BackupRequest) GetEndVersion() uint64 {
	if m != nil {
		return m.EndVersion
	}
	return 0
}

func (m *BackupRequest) GetRateLimit() uint64 {
	if m != nil {
		return m.RateLimit
	}
	return 0
}

func (m *BackupRequest) GetConcurrency() uint32 {
	if m != nil {
		return m.Concurrency
	}
	return 0
}

func (m *BackupRequest) GetStorageBackend() *StorageBackend {
	if m != nil {
		return m.StorageBackend
	}
	return nil
}

func (m *BackupRequest) GetIsRawKv() bool {
	if m != nil {
		return m.IsRawKv
	}
	return false
}

func (m *BackupRequest) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

func (m *BackupRequest) GetCompressionType() CompressionType {
	if m != nil {
		return m.CompressionType
	}
	return CompressionType_UNKNOWN
}

func (m *BackupRequest) GetCompressionLevel() int32 {
	if m != nil {
		return m.CompressionLevel
	}
	return 0
}

func (m *BackupRequest) GetCipherInfo() *CipherInfo {
	if m != nil {
		return m.CipherInfo
	}
	return nil
}

type StorageBackend struct {
	// Types that are valid to be assigned to Backend:
	//	*StorageBackend_Noop
	//	*StorageBackend_Local
	//	*StorageBackend_S3
	//	*StorageBackend_Gcs
	//	*StorageBackend_CloudDynamic
	//	*StorageBackend_Hdfs
	//	*StorageBackend_AzureBlobStorage
	Backend              isStorageBackend_Backend `protobuf_oneof:"backend"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *StorageBackend) Reset()         { *m = StorageBackend{} }
func (m *StorageBackend) String() string { return proto.CompactTextString(m) }
func (*StorageBackend) ProtoMessage()    {}
func (*StorageBackend) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{10}
}
func (m *StorageBackend) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StorageBackend) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StorageBackend.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *StorageBackend) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageBackend.Merge(dst, src)
}
func (m *StorageBackend) XXX_Size() int {
	return m.Size()
}
func (m *StorageBackend) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageBackend.DiscardUnknown(m)
}

var xxx_messageInfo_StorageBackend proto.InternalMessageInfo

type isStorageBackend_Backend interface {
	isStorageBackend_Backend()
	MarshalTo([]byte) (int, error)
	Size() int
}

type StorageBackend_Noop struct {
	Noop *Noop `protobuf:"bytes,1,opt,name=noop,oneof"`
}
type StorageBackend_Local struct {
	Local *Local `protobuf:"bytes,2,opt,name=local,oneof"`
}
type StorageBackend_S3 struct {
	S3 *S3 `protobuf:"bytes,3,opt,name=s3,oneof"`
}
type StorageBackend_Gcs struct {
	Gcs *GCS `protobuf:"bytes,4,opt,name=gcs,oneof"`
}
type StorageBackend_CloudDynamic struct {
	CloudDynamic *CloudDynamic `protobuf:"bytes,5,opt,name=cloud_dynamic,json=cloudDynamic,oneof"`
}
type StorageBackend_Hdfs struct {
	Hdfs *HDFS `protobuf:"bytes,6,opt,name=hdfs,oneof"`
}
type StorageBackend_AzureBlobStorage struct {
	AzureBlobStorage *AzureBlobStorage `protobuf:"bytes,7,opt,name=azure_blob_storage,json=azureBlobStorage,oneof"`
}

func (*StorageBackend_Noop) isStorageBackend_Backend()             {}
func (*StorageBackend_Local) isStorageBackend_Backend()            {}
func (*StorageBackend_S3) isStorageBackend_Backend()               {}
func (*StorageBackend_Gcs) isStorageBackend_Backend()              {}
func (*StorageBackend_CloudDynamic) isStorageBackend_Backend()     {}
func (*StorageBackend_Hdfs) isStorageBackend_Backend()             {}
func (*StorageBackend_AzureBlobStorage) isStorageBackend_Backend() {}

func (m *StorageBackend) GetBackend() isStorageBackend_Backend {
	if m != nil {
		return m.Backend
	}
	return nil
}

func (m *StorageBackend) GetNoop() *Noop {
	if x, ok := m.GetBackend().(*StorageBackend_Noop); ok {
		return x.Noop
	}
	return nil
}

func (m *StorageBackend) GetLocal() *Local {
	if x, ok := m.GetBackend().(*StorageBackend_Local); ok {
		return x.Local
	}
	return nil
}

func (m *StorageBackend) GetS3() *S3 {
	if x, ok := m.GetBackend().(*StorageBackend_S3); ok {
		return x.S3
	}
	return nil
}

func (m *StorageBackend) GetGcs() *GCS {
	if x, ok := m.GetBackend().(*StorageBackend_Gcs); ok {
		return x.Gcs
	}
	return nil
}

func (m *StorageBackend) GetCloudDynamic() *CloudDynamic {
	if x, ok := m.GetBackend().(*StorageBackend_CloudDynamic); ok {
		return x.CloudDynamic
	}
	return nil
}

func (m *StorageBackend) GetHdfs() *HDFS {
	if x, ok := m.GetBackend().(*StorageBackend_Hdfs); ok {
		return x.Hdfs
	}
	return nil
}

func (m *StorageBackend) GetAzureBlobStorage() *AzureBlobStorage {
	if x, ok := m.GetBackend().(*StorageBackend_AzureBlobStorage); ok {
		return x.AzureBlobStorage
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StorageBackend) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StorageBackend_OneofMarshaler, _StorageBackend_OneofUnmarshaler, _StorageBackend_OneofSizer, []interface{}{
		(*StorageBackend_Noop)(nil),
		(*StorageBackend_Local)(nil),
		(*StorageBackend_S3)(nil),
		(*StorageBackend_Gcs)(nil),
		(*StorageBackend_CloudDynamic)(nil),
		(*StorageBackend_Hdfs)(nil),
		(*StorageBackend_AzureBlobStorage)(nil),
	}
}

func _StorageBackend_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StorageBackend)
	// backend
	switch x := m.Backend.(type) {
	case *StorageBackend_Noop:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Noop); err != nil {
			return err
		}
	case *StorageBackend_Local:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Local); err != nil {
			return err
		}
	case *StorageBackend_S3:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.S3); err != nil {
			return err
		}
	case *StorageBackend_Gcs:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Gcs); err != nil {
			return err
		}
	case *StorageBackend_CloudDynamic:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CloudDynamic); err != nil {
			return err
		}
	case *StorageBackend_Hdfs:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Hdfs); err != nil {
			return err
		}
	case *StorageBackend_AzureBlobStorage:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AzureBlobStorage); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StorageBackend.Backend has unexpected type %T", x)
	}
	return nil
}

func _StorageBackend_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StorageBackend)
	switch tag {
	case 1: // backend.noop
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Noop)
		err := b.DecodeMessage(msg)
		m.Backend = &StorageBackend_Noop{msg}
		return true, err
	case 2: // backend.local
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Local)
		err := b.DecodeMessage(msg)
		m.Backend = &StorageBackend_Local{msg}
		return true, err
	case 3: // backend.s3
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(S3)
		err := b.DecodeMessage(msg)
		m.Backend = &StorageBackend_S3{msg}
		return true, err
	case 4: // backend.gcs
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GCS)
		err := b.DecodeMessage(msg)
		m.Backend = &StorageBackend_Gcs{msg}
		return true, err
	case 5: // backend.cloud_dynamic
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CloudDynamic)
		err := b.DecodeMessage(msg)
		m.Backend = &StorageBackend_CloudDynamic{msg}
		return true, err
	case 6: // backend.hdfs
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HDFS)
		err := b.DecodeMessage(msg)
		m.Backend = &StorageBackend_Hdfs{msg}
		return true, err
	case 7: // backend.azure_blob_storage
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AzureBlobStorage)
		err := b.DecodeMessage(msg)
		m.Backend = &StorageBackend_AzureBlobStorage{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StorageBackend_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StorageBackend)
	// backend
	switch x := m.Backend.(type) {
	case *StorageBackend_Noop:
		s := proto.Size(x.Noop)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StorageBackend_Local:
		s := proto.Size(x.Local)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StorageBackend_S3:
		s := proto.Size(x.S3)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StorageBackend_Gcs:
		s := proto.Size(x.Gcs)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StorageBackend_CloudDynamic:
		s := proto.Size(x.CloudDynamic)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StorageBackend_Hdfs:
		s := proto.Size(x.Hdfs)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StorageBackend_AzureBlobStorage:
		s := proto.Size(x.AzureBlobStorage)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Noop storage backend saves files into void.
type Noop struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Noop) Reset()         { *m = Noop{} }
func (m *Noop) String() string { return proto.CompactTextString(m) }
func (*Noop) ProtoMessage()    {}
func (*Noop) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{11}
}
func (m *Noop) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Noop) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Noop.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Noop) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Noop.Merge(dst, src)
}
func (m *Noop) XXX_Size() int {
	return m.Size()
}
func (m *Noop) XXX_DiscardUnknown() {
	xxx_messageInfo_Noop.DiscardUnknown(m)
}

var xxx_messageInfo_Noop proto.InternalMessageInfo

// Local storage backend saves files into local disk
type Local struct {
	Path                 string   `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Local) Reset()         { *m = Local{} }
func (m *Local) String() string { return proto.CompactTextString(m) }
func (*Local) ProtoMessage()    {}
func (*Local) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{12}
}
func (m *Local) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Local) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Local.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Local) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Local.Merge(dst, src)
}
func (m *Local) XXX_Size() int {
	return m.Size()
}
func (m *Local) XXX_DiscardUnknown() {
	xxx_messageInfo_Local.DiscardUnknown(m)
}

var xxx_messageInfo_Local proto.InternalMessageInfo

func (m *Local) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// S3 storage backend saves files into S3 compatible storages
// For non-aws providers, endpoint must be provided
type S3 struct {
	Endpoint     string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Region       string `protobuf:"bytes,2,opt,name=region,proto3" json:"region,omitempty"`
	Bucket       string `protobuf:"bytes,3,opt,name=bucket,proto3" json:"bucket,omitempty"`
	Prefix       string `protobuf:"bytes,4,opt,name=prefix,proto3" json:"prefix,omitempty"`
	StorageClass string `protobuf:"bytes,5,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	// server side encryption
	Sse                  string   `protobuf:"bytes,6,opt,name=sse,proto3" json:"sse,omitempty"`
	Acl                  string   `protobuf:"bytes,7,opt,name=acl,proto3" json:"acl,omitempty"`
	AccessKey            string   `protobuf:"bytes,8,opt,name=access_key,json=accessKey,proto3" json:"access_key,omitempty"`
	SecretAccessKey      string   `protobuf:"bytes,9,opt,name=secret_access_key,json=secretAccessKey,proto3" json:"secret_access_key,omitempty"`
	ForcePathStyle       bool     `protobuf:"varint,10,opt,name=force_path_style,json=forcePathStyle,proto3" json:"force_path_style,omitempty"`
	SseKmsKeyId          string   `protobuf:"bytes,11,opt,name=sse_kms_key_id,json=sseKmsKeyId,proto3" json:"sse_kms_key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *S3) Reset()         { *m = S3{} }
func (m *S3) String() string { return proto.CompactTextString(m) }
func (*S3) ProtoMessage()    {}
func (*S3) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{13}
}
func (m *S3) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *S3) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_S3.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *S3) XXX_Merge(src proto.Message) {
	xxx_messageInfo_S3.Merge(dst, src)
}
func (m *S3) XXX_Size() int {
	return m.Size()
}
func (m *S3) XXX_DiscardUnknown() {
	xxx_messageInfo_S3.DiscardUnknown(m)
}

var xxx_messageInfo_S3 proto.InternalMessageInfo

func (m *S3) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *S3) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *S3) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *S3) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *S3) GetStorageClass() string {
	if m != nil {
		return m.StorageClass
	}
	return ""
}

func (m *S3) GetSse() string {
	if m != nil {
		return m.Sse
	}
	return ""
}

func (m *S3) GetAcl() string {
	if m != nil {
		return m.Acl
	}
	return ""
}

func (m *S3) GetAccessKey() string {
	if m != nil {
		return m.AccessKey
	}
	return ""
}

func (m *S3) GetSecretAccessKey() string {
	if m != nil {
		return m.SecretAccessKey
	}
	return ""
}

func (m *S3) GetForcePathStyle() bool {
	if m != nil {
		return m.ForcePathStyle
	}
	return false
}

func (m *S3) GetSseKmsKeyId() string {
	if m != nil {
		return m.SseKmsKeyId
	}
	return ""
}

// GCS storage backend saves files into google cloud storage.
type GCS struct {
	Endpoint     string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Bucket       string `protobuf:"bytes,2,opt,name=bucket,proto3" json:"bucket,omitempty"`
	Prefix       string `protobuf:"bytes,3,opt,name=prefix,proto3" json:"prefix,omitempty"`
	StorageClass string `protobuf:"bytes,4,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	// If not empty, applies a predefined set of access controls.
	// See https://cloud.google.com/storage/docs/access-control/lists#predefined-acl
	// for valid values.
	PredefinedAcl string `protobuf:"bytes,5,opt,name=predefined_acl,json=predefinedAcl,proto3" json:"predefined_acl,omitempty"`
	// Service Account Credentials JSON blob
	// You can get one from https://console.cloud.google.com/apis/credentials, and
	// copy the content, set it as string here.
	CredentialsBlob      string   `protobuf:"bytes,6,opt,name=credentials_blob,json=credentialsBlob,proto3" json:"credentials_blob,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GCS) Reset()         { *m = GCS{} }
func (m *GCS) String() string { return proto.CompactTextString(m) }
func (*GCS) ProtoMessage()    {}
func (*GCS) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{14}
}
func (m *GCS) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GCS) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GCS.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *GCS) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GCS.Merge(dst, src)
}
func (m *GCS) XXX_Size() int {
	return m.Size()
}
func (m *GCS) XXX_DiscardUnknown() {
	xxx_messageInfo_GCS.DiscardUnknown(m)
}

var xxx_messageInfo_GCS proto.InternalMessageInfo

func (m *GCS) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *GCS) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *GCS) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *GCS) GetStorageClass() string {
	if m != nil {
		return m.StorageClass
	}
	return ""
}

func (m *GCS) GetPredefinedAcl() string {
	if m != nil {
		return m.PredefinedAcl
	}
	return ""
}

func (m *GCS) GetCredentialsBlob() string {
	if m != nil {
		return m.CredentialsBlob
	}
	return ""
}

// AzureBlobStorage storage backend saves files into azure blob storage.
type AzureBlobStorage struct {
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Alias: container
	Bucket string `protobuf:"bytes,2,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Notice: prefix starts without `/`, otherwise the first directory's name is empty.
	Prefix string `protobuf:"bytes,3,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// Alias: access_tier.
	// See https://docs.microsoft.com/en-us/azure/storage/blobs/access-tiers-overview
	StorageClass string `protobuf:"bytes,4,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	// if empty, try to read account_name from the node's environment variable $AZURE_STORAGE_ACCOUNT.
	AccountName string `protobuf:"bytes,5,opt,name=account_name,json=accountName,proto3" json:"account_name,omitempty"`
	// Use shared key to access the azure blob
	// If the node's environment variables($AZURE_CLIENT_ID, $AZURE_TENANT_ID, $AZURE_CLIENT_SECRET) exist,
	// prefer to use token to access the azure blob.
	//
	//   See https://docs.microsoft.com/en-us/azure/storage/common/identity-library-acquire-token?toc=/azure/storage/blobs/toc.json
	//
	// Otherwise, if empty, try to read shared key from the node's environment variable $AZURE_STORAGE_KEY.
	SharedKey            string   `protobuf:"bytes,6,opt,name=shared_key,json=sharedKey,proto3" json:"shared_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AzureBlobStorage) Reset()         { *m = AzureBlobStorage{} }
func (m *AzureBlobStorage) String() string { return proto.CompactTextString(m) }
func (*AzureBlobStorage) ProtoMessage()    {}
func (*AzureBlobStorage) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{15}
}
func (m *AzureBlobStorage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AzureBlobStorage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AzureBlobStorage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *AzureBlobStorage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AzureBlobStorage.Merge(dst, src)
}
func (m *AzureBlobStorage) XXX_Size() int {
	return m.Size()
}
func (m *AzureBlobStorage) XXX_DiscardUnknown() {
	xxx_messageInfo_AzureBlobStorage.DiscardUnknown(m)
}

var xxx_messageInfo_AzureBlobStorage proto.InternalMessageInfo

func (m *AzureBlobStorage) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *AzureBlobStorage) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *AzureBlobStorage) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *AzureBlobStorage) GetStorageClass() string {
	if m != nil {
		return m.StorageClass
	}
	return ""
}

func (m *AzureBlobStorage) GetAccountName() string {
	if m != nil {
		return m.AccountName
	}
	return ""
}

func (m *AzureBlobStorage) GetSharedKey() string {
	if m != nil {
		return m.SharedKey
	}
	return ""
}

type Bucket struct {
	Endpoint             string   `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Region               string   `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	Bucket               string   `protobuf:"bytes,4,opt,name=bucket,proto3" json:"bucket,omitempty"`
	Prefix               string   `protobuf:"bytes,5,opt,name=prefix,proto3" json:"prefix,omitempty"`
	StorageClass         string   `protobuf:"bytes,6,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Bucket) Reset()         { *m = Bucket{} }
func (m *Bucket) String() string { return proto.CompactTextString(m) }
func (*Bucket) ProtoMessage()    {}
func (*Bucket) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{16}
}
func (m *Bucket) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Bucket) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Bucket.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Bucket) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bucket.Merge(dst, src)
}
func (m *Bucket) XXX_Size() int {
	return m.Size()
}
func (m *Bucket) XXX_DiscardUnknown() {
	xxx_messageInfo_Bucket.DiscardUnknown(m)
}

var xxx_messageInfo_Bucket proto.InternalMessageInfo

func (m *Bucket) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *Bucket) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *Bucket) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *Bucket) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *Bucket) GetStorageClass() string {
	if m != nil {
		return m.StorageClass
	}
	return ""
}

// CloudDynamic allows testing new cloud providers and new fields without changing protobuf definitions
type CloudDynamic struct {
	Bucket               *Bucket           `protobuf:"bytes,1,opt,name=bucket" json:"bucket,omitempty"`
	ProviderName         string            `protobuf:"bytes,2,opt,name=provider_name,json=providerName,proto3" json:"provider_name,omitempty"`
	Attrs                map[string]string `protobuf:"bytes,3,rep,name=attrs" json:"attrs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CloudDynamic) Reset()         { *m = CloudDynamic{} }
func (m *CloudDynamic) String() string { return proto.CompactTextString(m) }
func (*CloudDynamic) ProtoMessage()    {}
func (*CloudDynamic) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{17}
}
func (m *CloudDynamic) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CloudDynamic) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CloudDynamic.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *CloudDynamic) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudDynamic.Merge(dst, src)
}
func (m *CloudDynamic) XXX_Size() int {
	return m.Size()
}
func (m *CloudDynamic) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudDynamic.DiscardUnknown(m)
}

var xxx_messageInfo_CloudDynamic proto.InternalMessageInfo

func (m *CloudDynamic) GetBucket() *Bucket {
	if m != nil {
		return m.Bucket
	}
	return nil
}

func (m *CloudDynamic) GetProviderName() string {
	if m != nil {
		return m.ProviderName
	}
	return ""
}

func (m *CloudDynamic) GetAttrs() map[string]string {
	if m != nil {
		return m.Attrs
	}
	return nil
}

// HDFS storage backend saves file into HDFS compatible storages
type HDFS struct {
	//  a URL: hdfs:///some/path or hdfs://host:port/some/path
	Remote               string   `protobuf:"bytes,1,opt,name=remote,proto3" json:"remote,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HDFS) Reset()         { *m = HDFS{} }
func (m *HDFS) String() string { return proto.CompactTextString(m) }
func (*HDFS) ProtoMessage()    {}
func (*HDFS) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{18}
}
func (m *HDFS) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HDFS) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HDFS.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *HDFS) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HDFS.Merge(dst, src)
}
func (m *HDFS) XXX_Size() int {
	return m.Size()
}
func (m *HDFS) XXX_DiscardUnknown() {
	xxx_messageInfo_HDFS.DiscardUnknown(m)
}

var xxx_messageInfo_HDFS proto.InternalMessageInfo

func (m *HDFS) GetRemote() string {
	if m != nil {
		return m.Remote
	}
	return ""
}

type BackupResponse struct {
	Error    *Error  `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	StartKey []byte  `protobuf:"bytes,2,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey   []byte  `protobuf:"bytes,3,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	Files    []*File `protobuf:"bytes,4,rep,name=files" json:"files,omitempty"`
	// API version implies the encode of the key and value.
	ApiVersion           kvrpcpb.APIVersion `protobuf:"varint,5,opt,name=api_version,json=apiVersion,proto3,enum=kvrpcpb.APIVersion" json:"api_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *BackupResponse) Reset()         { *m = BackupResponse{} }
func (m *BackupResponse) String() string { return proto.CompactTextString(m) }
func (*BackupResponse) ProtoMessage()    {}
func (*BackupResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{19}
}
func (m *BackupResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BackupResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BackupResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *BackupResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupResponse.Merge(dst, src)
}
func (m *BackupResponse) XXX_Size() int {
	return m.Size()
}
func (m *BackupResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BackupResponse proto.InternalMessageInfo

func (m *BackupResponse) GetError() *Error {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *BackupResponse) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *BackupResponse) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *BackupResponse) GetFiles() []*File {
	if m != nil {
		return m.Files
	}
	return nil
}

func (m *BackupResponse) GetApiVersion() kvrpcpb.APIVersion {
	if m != nil {
		return m.ApiVersion
	}
	return kvrpcpb.APIVersion_V1
}

type ExternalStorageRestoreRequest struct {
	StorageBackend       *StorageBackend `protobuf:"bytes,1,opt,name=storage_backend,json=storageBackend" json:"storage_backend,omitempty"`
	ObjectName           string          `protobuf:"bytes,2,opt,name=object_name,json=objectName,proto3" json:"object_name,omitempty"`
	RestoreName          string          `protobuf:"bytes,3,opt,name=restore_name,json=restoreName,proto3" json:"restore_name,omitempty"`
	ContentLength        uint64          `protobuf:"varint,4,opt,name=content_length,json=contentLength,proto3" json:"content_length,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ExternalStorageRestoreRequest) Reset()         { *m = ExternalStorageRestoreRequest{} }
func (m *ExternalStorageRestoreRequest) String() string { return proto.CompactTextString(m) }
func (*ExternalStorageRestoreRequest) ProtoMessage()    {}
func (*ExternalStorageRestoreRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{20}
}
func (m *ExternalStorageRestoreRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExternalStorageRestoreRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExternalStorageRestoreRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ExternalStorageRestoreRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalStorageRestoreRequest.Merge(dst, src)
}
func (m *ExternalStorageRestoreRequest) XXX_Size() int {
	return m.Size()
}
func (m *ExternalStorageRestoreRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalStorageRestoreRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalStorageRestoreRequest proto.InternalMessageInfo

func (m *ExternalStorageRestoreRequest) GetStorageBackend() *StorageBackend {
	if m != nil {
		return m.StorageBackend
	}
	return nil
}

func (m *ExternalStorageRestoreRequest) GetObjectName() string {
	if m != nil {
		return m.ObjectName
	}
	return ""
}

func (m *ExternalStorageRestoreRequest) GetRestoreName() string {
	if m != nil {
		return m.RestoreName
	}
	return ""
}

func (m *ExternalStorageRestoreRequest) GetContentLength() uint64 {
	if m != nil {
		return m.ContentLength
	}
	return 0
}

type ExternalStorageRestoreResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExternalStorageRestoreResponse) Reset()         { *m = ExternalStorageRestoreResponse{} }
func (m *ExternalStorageRestoreResponse) String() string { return proto.CompactTextString(m) }
func (*ExternalStorageRestoreResponse) ProtoMessage()    {}
func (*ExternalStorageRestoreResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{21}
}
func (m *ExternalStorageRestoreResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExternalStorageRestoreResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExternalStorageRestoreResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ExternalStorageRestoreResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalStorageRestoreResponse.Merge(dst, src)
}
func (m *ExternalStorageRestoreResponse) XXX_Size() int {
	return m.Size()
}
func (m *ExternalStorageRestoreResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalStorageRestoreResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalStorageRestoreResponse proto.InternalMessageInfo

type ExternalStorageSaveRequest struct {
	StorageBackend       *StorageBackend `protobuf:"bytes,1,opt,name=storage_backend,json=storageBackend" json:"storage_backend,omitempty"`
	ObjectName           string          `protobuf:"bytes,2,opt,name=object_name,json=objectName,proto3" json:"object_name,omitempty"`
	ContentLength        uint64          `protobuf:"varint,3,opt,name=content_length,json=contentLength,proto3" json:"content_length,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ExternalStorageSaveRequest) Reset()         { *m = ExternalStorageSaveRequest{} }
func (m *ExternalStorageSaveRequest) String() string { return proto.CompactTextString(m) }
func (*ExternalStorageSaveRequest) ProtoMessage()    {}
func (*ExternalStorageSaveRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{22}
}
func (m *ExternalStorageSaveRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExternalStorageSaveRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExternalStorageSaveRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ExternalStorageSaveRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalStorageSaveRequest.Merge(dst, src)
}
func (m *ExternalStorageSaveRequest) XXX_Size() int {
	return m.Size()
}
func (m *ExternalStorageSaveRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalStorageSaveRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalStorageSaveRequest proto.InternalMessageInfo

func (m *ExternalStorageSaveRequest) GetStorageBackend() *StorageBackend {
	if m != nil {
		return m.StorageBackend
	}
	return nil
}

func (m *ExternalStorageSaveRequest) GetObjectName() string {
	if m != nil {
		return m.ObjectName
	}
	return ""
}

func (m *ExternalStorageSaveRequest) GetContentLength() uint64 {
	if m != nil {
		return m.ContentLength
	}
	return 0
}

type ExternalStorageSaveResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExternalStorageSaveResponse) Reset()         { *m = ExternalStorageSaveResponse{} }
func (m *ExternalStorageSaveResponse) String() string { return proto.CompactTextString(m) }
func (*ExternalStorageSaveResponse) ProtoMessage()    {}
func (*ExternalStorageSaveResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_brpb_9a2c249b8987200a, []int{23}
}
func (m *ExternalStorageSaveResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExternalStorageSaveResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExternalStorageSaveResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ExternalStorageSaveResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalStorageSaveResponse.Merge(dst, src)
}
func (m *ExternalStorageSaveResponse) XXX_Size() int {
	return m.Size()
}
func (m *ExternalStorageSaveResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalStorageSaveResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalStorageSaveResponse proto.InternalMessageInfo

func init() {
	proto.RegisterType((*BackupMeta)(nil), "backup.BackupMeta")
	proto.RegisterType((*File)(nil), "backup.File")
	proto.RegisterType((*MetaFile)(nil), "backup.MetaFile")
	proto.RegisterType((*PlacementPolicy)(nil), "backup.PlacementPolicy")
	proto.RegisterType((*Schema)(nil), "backup.Schema")
	proto.RegisterType((*RawRange)(nil), "backup.RawRange")
	proto.RegisterType((*ClusterIDError)(nil), "backup.ClusterIDError")
	proto.RegisterType((*Error)(nil), "backup.Error")
	proto.RegisterType((*CipherInfo)(nil), "backup.CipherInfo")
	proto.RegisterType((*BackupRequest)(nil), "backup.BackupRequest")
	proto.RegisterType((*StorageBackend)(nil), "backup.StorageBackend")
	proto.RegisterType((*Noop)(nil), "backup.Noop")
	proto.RegisterType((*Local)(nil), "backup.Local")
	proto.RegisterType((*S3)(nil), "backup.S3")
	proto.RegisterType((*GCS)(nil), "backup.GCS")
	proto.RegisterType((*AzureBlobStorage)(nil), "backup.AzureBlobStorage")
	proto.RegisterType((*Bucket)(nil), "backup.Bucket")
	proto.RegisterType((*CloudDynamic)(nil), "backup.CloudDynamic")
	proto.RegisterMapType((map[string]string)(nil), "backup.CloudDynamic.AttrsEntry")
	proto.RegisterType((*HDFS)(nil), "backup.HDFS")
	proto.RegisterType((*BackupResponse)(nil), "backup.BackupResponse")
	proto.RegisterType((*ExternalStorageRestoreRequest)(nil), "backup.ExternalStorageRestoreRequest")
	proto.RegisterType((*ExternalStorageRestoreResponse)(nil), "backup.ExternalStorageRestoreResponse")
	proto.RegisterType((*ExternalStorageSaveRequest)(nil), "backup.ExternalStorageSaveRequest")
	proto.RegisterType((*ExternalStorageSaveResponse)(nil), "backup.ExternalStorageSaveResponse")
	proto.RegisterEnum("backup.CompressionType", CompressionType_name, CompressionType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Backup service

type BackupClient interface {
	Backup(ctx context.Context, in *BackupRequest, opts ...grpc.CallOption) (Backup_BackupClient, error)
}

type backupClient struct {
	cc *grpc.ClientConn
}

func NewBackupClient(cc *grpc.ClientConn) BackupClient {
	return &backupClient{cc}
}

func (c *backupClient) Backup(ctx context.Context, in *BackupRequest, opts ...grpc.CallOption) (Backup_BackupClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Backup_serviceDesc.Streams[0], "/backup.Backup/backup", opts...)
	if err != nil {
		return nil, err
	}
	x := &backupBackupClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Backup_BackupClient interface {
	Recv() (*BackupResponse, error)
	grpc.ClientStream
}

type backupBackupClient struct {
	grpc.ClientStream
}

func (x *backupBackupClient) Recv() (*BackupResponse, error) {
	m := new(BackupResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for Backup service

type BackupServer interface {
	Backup(*BackupRequest, Backup_BackupServer) error
}

func RegisterBackupServer(s *grpc.Server, srv BackupServer) {
	s.RegisterService(&_Backup_serviceDesc, srv)
}

func _Backup_Backup_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BackupRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BackupServer).Backup(m, &backupBackupServer{stream})
}

type Backup_BackupServer interface {
	Send(*BackupResponse) error
	grpc.ServerStream
}

type backupBackupServer struct {
	grpc.ServerStream
}

func (x *backupBackupServer) Send(m *BackupResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _Backup_serviceDesc = grpc.ServiceDesc{
	ServiceName: "backup.Backup",
	HandlerType: (*BackupServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "backup",
			Handler:       _Backup_Backup_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "brpb.proto",
}

// Client API for ExternalStorage service

type ExternalStorageClient interface {
	// Restore to a file
	Restore(ctx context.Context, in *ExternalStorageRestoreRequest, opts ...grpc.CallOption) (*ExternalStorageRestoreResponse, error)
	// Save a file to storage
	Save(ctx context.Context, in *ExternalStorageSaveRequest, opts ...grpc.CallOption) (*ExternalStorageSaveResponse, error)
}

type externalStorageClient struct {
	cc *grpc.ClientConn
}

func NewExternalStorageClient(cc *grpc.ClientConn) ExternalStorageClient {
	return &externalStorageClient{cc}
}

func (c *externalStorageClient) Restore(ctx context.Context, in *ExternalStorageRestoreRequest, opts ...grpc.CallOption) (*ExternalStorageRestoreResponse, error) {
	out := new(ExternalStorageRestoreResponse)
	err := c.cc.Invoke(ctx, "/backup.ExternalStorage/restore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *externalStorageClient) Save(ctx context.Context, in *ExternalStorageSaveRequest, opts ...grpc.CallOption) (*ExternalStorageSaveResponse, error) {
	out := new(ExternalStorageSaveResponse)
	err := c.cc.Invoke(ctx, "/backup.ExternalStorage/save", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ExternalStorage service

type ExternalStorageServer interface {
	// Restore to a file
	Restore(context.Context, *ExternalStorageRestoreRequest) (*ExternalStorageRestoreResponse, error)
	// Save a file to storage
	Save(context.Context, *ExternalStorageSaveRequest) (*ExternalStorageSaveResponse, error)
}

func RegisterExternalStorageServer(s *grpc.Server, srv ExternalStorageServer) {
	s.RegisterService(&_ExternalStorage_serviceDesc, srv)
}

func _ExternalStorage_Restore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExternalStorageRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalStorageServer).Restore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/backup.ExternalStorage/Restore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalStorageServer).Restore(ctx, req.(*ExternalStorageRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExternalStorage_Save_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExternalStorageSaveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalStorageServer).Save(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/backup.ExternalStorage/Save",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalStorageServer).Save(ctx, req.(*ExternalStorageSaveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ExternalStorage_serviceDesc = grpc.ServiceDesc{
	ServiceName: "backup.ExternalStorage",
	HandlerType: (*ExternalStorageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "restore",
			Handler:    _ExternalStorage_Restore_Handler,
		},
		{
			MethodName: "save",
			Handler:    _ExternalStorage_Save_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "brpb.proto",
}

func (m *BackupMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupMeta) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ClusterId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.ClusterId))
	}
	if len(m.ClusterVersion) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.ClusterVersion)))
		i += copy(dAtA[i:], m.ClusterVersion)
	}
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			dAtA[i] = 0x22
			i++
			i = encodeVarintBrpb(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.StartVersion != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.StartVersion))
	}
	if m.EndVersion != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.EndVersion))
	}
	if len(m.Schemas) > 0 {
		for _, msg := range m.Schemas {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintBrpb(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.IsRawKv {
		dAtA[i] = 0x40
		i++
		if m.IsRawKv {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.RawRanges) > 0 {
		for _, msg := range m.RawRanges {
			dAtA[i] = 0x4a
			i++
			i = encodeVarintBrpb(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Ddls) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Ddls)))
		i += copy(dAtA[i:], m.Ddls)
	}
	if len(m.BrVersion) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.BrVersion)))
		i += copy(dAtA[i:], m.BrVersion)
	}
	if m.Version != 0 {
		dAtA[i] = 0x60
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.Version))
	}
	if m.FileIndex != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.FileIndex.Size()))
		n1, err := m.FileIndex.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.SchemaIndex != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.SchemaIndex.Size()))
		n2, err := m.SchemaIndex.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.RawRangeIndex != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.RawRangeIndex.Size()))
		n3, err := m.RawRangeIndex.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.DdlIndexes != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.DdlIndexes.Size()))
		n4, err := m.DdlIndexes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if len(m.BackupResult) > 0 {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.BackupResult)))
		i += copy(dAtA[i:], m.BackupResult)
	}
	if m.ApiVersion != 0 {
		dAtA[i] = 0x90
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.ApiVersion))
	}
	if len(m.Policies) > 0 {
		for _, msg := range m.Policies {
			dAtA[i] = 0x9a
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintBrpb(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *File) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *File) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Sha256) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Sha256)))
		i += copy(dAtA[i:], m.Sha256)
	}
	if len(m.StartKey) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	if m.StartVersion != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.StartVersion))
	}
	if m.EndVersion != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.EndVersion))
	}
	if m.Crc64Xor != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.Crc64Xor))
	}
	if m.TotalKvs != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.TotalKvs))
	}
	if m.TotalBytes != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.TotalBytes))
	}
	if len(m.Cf) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Cf)))
		i += copy(dAtA[i:], m.Cf)
	}
	if m.Size_ != 0 {
		dAtA[i] = 0x58
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.Size_))
	}
	if len(m.CipherIv) > 0 {
		dAtA[i] = 0x62
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.CipherIv)))
		i += copy(dAtA[i:], m.CipherIv)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *MetaFile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetaFile) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.MetaFiles) > 0 {
		for _, msg := range m.MetaFiles {
			dAtA[i] = 0xa
			i++
			i = encodeVarintBrpb(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.DataFiles) > 0 {
		for _, msg := range m.DataFiles {
			dAtA[i] = 0x12
			i++
			i = encodeVarintBrpb(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Schemas) > 0 {
		for _, msg := range m.Schemas {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintBrpb(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RawRanges) > 0 {
		for _, msg := range m.RawRanges {
			dAtA[i] = 0x22
			i++
			i = encodeVarintBrpb(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Ddls) > 0 {
		for _, b := range m.Ddls {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintBrpb(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PlacementPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PlacementPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Info) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Info)))
		i += copy(dAtA[i:], m.Info)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Schema) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Schema) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Db) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Db)))
		i += copy(dAtA[i:], m.Db)
	}
	if len(m.Table) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Table)))
		i += copy(dAtA[i:], m.Table)
	}
	if m.Crc64Xor != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.Crc64Xor))
	}
	if m.TotalKvs != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.TotalKvs))
	}
	if m.TotalBytes != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.TotalBytes))
	}
	if m.TiflashReplicas != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.TiflashReplicas))
	}
	if len(m.Stats) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Stats)))
		i += copy(dAtA[i:], m.Stats)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RawRange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawRange) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.StartKey) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	if len(m.Cf) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Cf)))
		i += copy(dAtA[i:], m.Cf)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ClusterIDError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterIDError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Current != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.Current))
	}
	if m.Request != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.Request))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Error) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Error) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Msg) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Msg)))
		i += copy(dAtA[i:], m.Msg)
	}
	if m.Detail != nil {
		nn5, err := m.Detail.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn5
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Error_ClusterIdError) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ClusterIdError != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.ClusterIdError.Size()))
		n6, err := m.ClusterIdError.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}
func (m *Error_KvError) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.KvError != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.KvError.Size()))
		n7, err := m.KvError.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}
func (m *Error_RegionError) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RegionError != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.RegionError.Size()))
		n8, err := m.RegionError.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}
func (m *CipherInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CipherInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.CipherType != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.CipherType))
	}
	if len(m.CipherKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.CipherKey)))
		i += copy(dAtA[i:], m.CipherKey)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *BackupRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ClusterId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.ClusterId))
	}
	if len(m.StartKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	if m.StartVersion != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.StartVersion))
	}
	if m.EndVersion != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.EndVersion))
	}
	if m.RateLimit != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.RateLimit))
	}
	if m.Concurrency != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.Concurrency))
	}
	if m.StorageBackend != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.StorageBackend.Size()))
		n9, err := m.StorageBackend.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.IsRawKv {
		dAtA[i] = 0x50
		i++
		if m.IsRawKv {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Cf) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Cf)))
		i += copy(dAtA[i:], m.Cf)
	}
	if m.CompressionType != 0 {
		dAtA[i] = 0x60
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.CompressionType))
	}
	if m.CompressionLevel != 0 {
		dAtA[i] = 0x68
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.CompressionLevel))
	}
	if m.CipherInfo != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.CipherInfo.Size()))
		n10, err := m.CipherInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *StorageBackend) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StorageBackend) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Backend != nil {
		nn11, err := m.Backend.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn11
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *StorageBackend_Noop) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Noop != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.Noop.Size()))
		n12, err := m.Noop.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}
func (m *StorageBackend_Local) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Local != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.Local.Size()))
		n13, err := m.Local.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}
func (m *StorageBackend_S3) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.S3 != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.S3.Size()))
		n14, err := m.S3.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	return i, nil
}
func (m *StorageBackend_Gcs) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Gcs != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.Gcs.Size()))
		n15, err := m.Gcs.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}
func (m *StorageBackend_CloudDynamic) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.CloudDynamic != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.CloudDynamic.Size()))
		n16, err := m.CloudDynamic.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}
func (m *StorageBackend_Hdfs) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Hdfs != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.Hdfs.Size()))
		n17, err := m.Hdfs.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	return i, nil
}
func (m *StorageBackend_AzureBlobStorage) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AzureBlobStorage != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.AzureBlobStorage.Size()))
		n18, err := m.AzureBlobStorage.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	return i, nil
}
func (m *Noop) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Noop) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Local) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Local) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Path) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *S3) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *S3) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Endpoint) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Endpoint)))
		i += copy(dAtA[i:], m.Endpoint)
	}
	if len(m.Region) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Region)))
		i += copy(dAtA[i:], m.Region)
	}
	if len(m.Bucket) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Bucket)))
		i += copy(dAtA[i:], m.Bucket)
	}
	if len(m.Prefix) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Prefix)))
		i += copy(dAtA[i:], m.Prefix)
	}
	if len(m.StorageClass) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.StorageClass)))
		i += copy(dAtA[i:], m.StorageClass)
	}
	if len(m.Sse) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Sse)))
		i += copy(dAtA[i:], m.Sse)
	}
	if len(m.Acl) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Acl)))
		i += copy(dAtA[i:], m.Acl)
	}
	if len(m.AccessKey) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.AccessKey)))
		i += copy(dAtA[i:], m.AccessKey)
	}
	if len(m.SecretAccessKey) > 0 {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.SecretAccessKey)))
		i += copy(dAtA[i:], m.SecretAccessKey)
	}
	if m.ForcePathStyle {
		dAtA[i] = 0x50
		i++
		if m.ForcePathStyle {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.SseKmsKeyId) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.SseKmsKeyId)))
		i += copy(dAtA[i:], m.SseKmsKeyId)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *GCS) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCS) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Endpoint) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Endpoint)))
		i += copy(dAtA[i:], m.Endpoint)
	}
	if len(m.Bucket) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Bucket)))
		i += copy(dAtA[i:], m.Bucket)
	}
	if len(m.Prefix) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Prefix)))
		i += copy(dAtA[i:], m.Prefix)
	}
	if len(m.StorageClass) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.StorageClass)))
		i += copy(dAtA[i:], m.StorageClass)
	}
	if len(m.PredefinedAcl) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.PredefinedAcl)))
		i += copy(dAtA[i:], m.PredefinedAcl)
	}
	if len(m.CredentialsBlob) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.CredentialsBlob)))
		i += copy(dAtA[i:], m.CredentialsBlob)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AzureBlobStorage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AzureBlobStorage) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Endpoint) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Endpoint)))
		i += copy(dAtA[i:], m.Endpoint)
	}
	if len(m.Bucket) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Bucket)))
		i += copy(dAtA[i:], m.Bucket)
	}
	if len(m.Prefix) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Prefix)))
		i += copy(dAtA[i:], m.Prefix)
	}
	if len(m.StorageClass) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.StorageClass)))
		i += copy(dAtA[i:], m.StorageClass)
	}
	if len(m.AccountName) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.AccountName)))
		i += copy(dAtA[i:], m.AccountName)
	}
	if len(m.SharedKey) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.SharedKey)))
		i += copy(dAtA[i:], m.SharedKey)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Bucket) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Bucket) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Endpoint) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Endpoint)))
		i += copy(dAtA[i:], m.Endpoint)
	}
	if len(m.Region) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Region)))
		i += copy(dAtA[i:], m.Region)
	}
	if len(m.Bucket) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Bucket)))
		i += copy(dAtA[i:], m.Bucket)
	}
	if len(m.Prefix) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Prefix)))
		i += copy(dAtA[i:], m.Prefix)
	}
	if len(m.StorageClass) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.StorageClass)))
		i += copy(dAtA[i:], m.StorageClass)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CloudDynamic) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CloudDynamic) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Bucket != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.Bucket.Size()))
		n19, err := m.Bucket.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if len(m.ProviderName) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.ProviderName)))
		i += copy(dAtA[i:], m.ProviderName)
	}
	if len(m.Attrs) > 0 {
		for k, _ := range m.Attrs {
			dAtA[i] = 0x1a
			i++
			v := m.Attrs[k]
			mapSize := 1 + len(k) + sovBrpb(uint64(len(k))) + 1 + len(v) + sovBrpb(uint64(len(v)))
			i = encodeVarintBrpb(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintBrpb(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintBrpb(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HDFS) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HDFS) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Remote) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.Remote)))
		i += copy(dAtA[i:], m.Remote)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *BackupResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Error != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.Error.Size()))
		n20, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if len(m.StartKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			dAtA[i] = 0x22
			i++
			i = encodeVarintBrpb(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.ApiVersion != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.ApiVersion))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ExternalStorageRestoreRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExternalStorageRestoreRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.StorageBackend != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.StorageBackend.Size()))
		n21, err := m.StorageBackend.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if len(m.ObjectName) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.ObjectName)))
		i += copy(dAtA[i:], m.ObjectName)
	}
	if len(m.RestoreName) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.RestoreName)))
		i += copy(dAtA[i:], m.RestoreName)
	}
	if m.ContentLength != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.ContentLength))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ExternalStorageRestoreResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExternalStorageRestoreResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ExternalStorageSaveRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExternalStorageSaveRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.StorageBackend != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.StorageBackend.Size()))
		n22, err := m.StorageBackend.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if len(m.ObjectName) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(len(m.ObjectName)))
		i += copy(dAtA[i:], m.ObjectName)
	}
	if m.ContentLength != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintBrpb(dAtA, i, uint64(m.ContentLength))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ExternalStorageSaveResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExternalStorageSaveResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintBrpb(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *BackupMeta) Size() (n int) {
	var l int
	_ = l
	if m.ClusterId != 0 {
		n += 1 + sovBrpb(uint64(m.ClusterId))
	}
	l = len(m.ClusterVersion)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovBrpb(uint64(l))
		}
	}
	if m.StartVersion != 0 {
		n += 1 + sovBrpb(uint64(m.StartVersion))
	}
	if m.EndVersion != 0 {
		n += 1 + sovBrpb(uint64(m.EndVersion))
	}
	if len(m.Schemas) > 0 {
		for _, e := range m.Schemas {
			l = e.Size()
			n += 1 + l + sovBrpb(uint64(l))
		}
	}
	if m.IsRawKv {
		n += 2
	}
	if len(m.RawRanges) > 0 {
		for _, e := range m.RawRanges {
			l = e.Size()
			n += 1 + l + sovBrpb(uint64(l))
		}
	}
	l = len(m.Ddls)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.BrVersion)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.Version != 0 {
		n += 1 + sovBrpb(uint64(m.Version))
	}
	if m.FileIndex != nil {
		l = m.FileIndex.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.SchemaIndex != nil {
		l = m.SchemaIndex.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.RawRangeIndex != nil {
		l = m.RawRangeIndex.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.DdlIndexes != nil {
		l = m.DdlIndexes.Size()
		n += 2 + l + sovBrpb(uint64(l))
	}
	l = len(m.BackupResult)
	if l > 0 {
		n += 2 + l + sovBrpb(uint64(l))
	}
	if m.ApiVersion != 0 {
		n += 2 + sovBrpb(uint64(m.ApiVersion))
	}
	if len(m.Policies) > 0 {
		for _, e := range m.Policies {
			l = e.Size()
			n += 2 + l + sovBrpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *File) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.Sha256)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.StartVersion != 0 {
		n += 1 + sovBrpb(uint64(m.StartVersion))
	}
	if m.EndVersion != 0 {
		n += 1 + sovBrpb(uint64(m.EndVersion))
	}
	if m.Crc64Xor != 0 {
		n += 1 + sovBrpb(uint64(m.Crc64Xor))
	}
	if m.TotalKvs != 0 {
		n += 1 + sovBrpb(uint64(m.TotalKvs))
	}
	if m.TotalBytes != 0 {
		n += 1 + sovBrpb(uint64(m.TotalBytes))
	}
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.Size_ != 0 {
		n += 1 + sovBrpb(uint64(m.Size_))
	}
	l = len(m.CipherIv)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MetaFile) Size() (n int) {
	var l int
	_ = l
	if len(m.MetaFiles) > 0 {
		for _, e := range m.MetaFiles {
			l = e.Size()
			n += 1 + l + sovBrpb(uint64(l))
		}
	}
	if len(m.DataFiles) > 0 {
		for _, e := range m.DataFiles {
			l = e.Size()
			n += 1 + l + sovBrpb(uint64(l))
		}
	}
	if len(m.Schemas) > 0 {
		for _, e := range m.Schemas {
			l = e.Size()
			n += 1 + l + sovBrpb(uint64(l))
		}
	}
	if len(m.RawRanges) > 0 {
		for _, e := range m.RawRanges {
			l = e.Size()
			n += 1 + l + sovBrpb(uint64(l))
		}
	}
	if len(m.Ddls) > 0 {
		for _, b := range m.Ddls {
			l = len(b)
			n += 1 + l + sovBrpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PlacementPolicy) Size() (n int) {
	var l int
	_ = l
	l = len(m.Info)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Schema) Size() (n int) {
	var l int
	_ = l
	l = len(m.Db)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.Table)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.Crc64Xor != 0 {
		n += 1 + sovBrpb(uint64(m.Crc64Xor))
	}
	if m.TotalKvs != 0 {
		n += 1 + sovBrpb(uint64(m.TotalKvs))
	}
	if m.TotalBytes != 0 {
		n += 1 + sovBrpb(uint64(m.TotalBytes))
	}
	if m.TiflashReplicas != 0 {
		n += 1 + sovBrpb(uint64(m.TiflashReplicas))
	}
	l = len(m.Stats)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawRange) Size() (n int) {
	var l int
	_ = l
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClusterIDError) Size() (n int) {
	var l int
	_ = l
	if m.Current != 0 {
		n += 1 + sovBrpb(uint64(m.Current))
	}
	if m.Request != 0 {
		n += 1 + sovBrpb(uint64(m.Request))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Error) Size() (n int) {
	var l int
	_ = l
	l = len(m.Msg)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.Detail != nil {
		n += m.Detail.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Error_ClusterIdError) Size() (n int) {
	var l int
	_ = l
	if m.ClusterIdError != nil {
		l = m.ClusterIdError.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	return n
}
func (m *Error_KvError) Size() (n int) {
	var l int
	_ = l
	if m.KvError != nil {
		l = m.KvError.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	return n
}
func (m *Error_RegionError) Size() (n int) {
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	return n
}
func (m *CipherInfo) Size() (n int) {
	var l int
	_ = l
	if m.CipherType != 0 {
		n += 1 + sovBrpb(uint64(m.CipherType))
	}
	l = len(m.CipherKey)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BackupRequest) Size() (n int) {
	var l int
	_ = l
	if m.ClusterId != 0 {
		n += 1 + sovBrpb(uint64(m.ClusterId))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.StartVersion != 0 {
		n += 1 + sovBrpb(uint64(m.StartVersion))
	}
	if m.EndVersion != 0 {
		n += 1 + sovBrpb(uint64(m.EndVersion))
	}
	if m.RateLimit != 0 {
		n += 1 + sovBrpb(uint64(m.RateLimit))
	}
	if m.Concurrency != 0 {
		n += 1 + sovBrpb(uint64(m.Concurrency))
	}
	if m.StorageBackend != nil {
		l = m.StorageBackend.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.IsRawKv {
		n += 2
	}
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.CompressionType != 0 {
		n += 1 + sovBrpb(uint64(m.CompressionType))
	}
	if m.CompressionLevel != 0 {
		n += 1 + sovBrpb(uint64(m.CompressionLevel))
	}
	if m.CipherInfo != nil {
		l = m.CipherInfo.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StorageBackend) Size() (n int) {
	var l int
	_ = l
	if m.Backend != nil {
		n += m.Backend.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StorageBackend_Noop) Size() (n int) {
	var l int
	_ = l
	if m.Noop != nil {
		l = m.Noop.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	return n
}
func (m *StorageBackend_Local) Size() (n int) {
	var l int
	_ = l
	if m.Local != nil {
		l = m.Local.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	return n
}
func (m *StorageBackend_S3) Size() (n int) {
	var l int
	_ = l
	if m.S3 != nil {
		l = m.S3.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	return n
}
func (m *StorageBackend_Gcs) Size() (n int) {
	var l int
	_ = l
	if m.Gcs != nil {
		l = m.Gcs.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	return n
}
func (m *StorageBackend_CloudDynamic) Size() (n int) {
	var l int
	_ = l
	if m.CloudDynamic != nil {
		l = m.CloudDynamic.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	return n
}
func (m *StorageBackend_Hdfs) Size() (n int) {
	var l int
	_ = l
	if m.Hdfs != nil {
		l = m.Hdfs.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	return n
}
func (m *StorageBackend_AzureBlobStorage) Size() (n int) {
	var l int
	_ = l
	if m.AzureBlobStorage != nil {
		l = m.AzureBlobStorage.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	return n
}
func (m *Noop) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Local) Size() (n int) {
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *S3) Size() (n int) {
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.Region)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.Bucket)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.Prefix)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.StorageClass)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.Sse)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.Acl)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.AccessKey)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.SecretAccessKey)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.ForcePathStyle {
		n += 2
	}
	l = len(m.SseKmsKeyId)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GCS) Size() (n int) {
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.Bucket)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.Prefix)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.StorageClass)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.PredefinedAcl)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.CredentialsBlob)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AzureBlobStorage) Size() (n int) {
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.Bucket)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.Prefix)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.StorageClass)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.AccountName)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.SharedKey)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Bucket) Size() (n int) {
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.Region)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.Bucket)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.Prefix)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.StorageClass)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CloudDynamic) Size() (n int) {
	var l int
	_ = l
	if m.Bucket != nil {
		l = m.Bucket.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.ProviderName)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if len(m.Attrs) > 0 {
		for k, v := range m.Attrs {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovBrpb(uint64(len(k))) + 1 + len(v) + sovBrpb(uint64(len(v)))
			n += mapEntrySize + 1 + sovBrpb(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HDFS) Size() (n int) {
	var l int
	_ = l
	l = len(m.Remote)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BackupResponse) Size() (n int) {
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovBrpb(uint64(l))
		}
	}
	if m.ApiVersion != 0 {
		n += 1 + sovBrpb(uint64(m.ApiVersion))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExternalStorageRestoreRequest) Size() (n int) {
	var l int
	_ = l
	if m.StorageBackend != nil {
		l = m.StorageBackend.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.ObjectName)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.RestoreName)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.ContentLength != 0 {
		n += 1 + sovBrpb(uint64(m.ContentLength))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExternalStorageRestoreResponse) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExternalStorageSaveRequest) Size() (n int) {
	var l int
	_ = l
	if m.StorageBackend != nil {
		l = m.StorageBackend.Size()
		n += 1 + l + sovBrpb(uint64(l))
	}
	l = len(m.ObjectName)
	if l > 0 {
		n += 1 + l + sovBrpb(uint64(l))
	}
	if m.ContentLength != 0 {
		n += 1 + sovBrpb(uint64(m.ContentLength))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExternalStorageSaveResponse) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovBrpb(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozBrpb(x uint64) (n int) {
	return sovBrpb(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *BackupMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			m.ClusterId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ClusterId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, &File{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndVersion", wireType)
			}
			m.EndVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndVersion |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schemas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Schemas = append(m.Schemas, &Schema{})
			if err := m.Schemas[len(m.Schemas)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsRawKv", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsRawKv = bool(v != 0)
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawRanges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RawRanges = append(m.RawRanges, &RawRange{})
			if err := m.RawRanges[len(m.RawRanges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ddls", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ddls = append(m.Ddls[:0], dAtA[iNdEx:postIndex]...)
			if m.Ddls == nil {
				m.Ddls = []byte{}
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BrVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BrVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FileIndex", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FileIndex == nil {
				m.FileIndex = &MetaFile{}
			}
			if err := m.FileIndex.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaIndex", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SchemaIndex == nil {
				m.SchemaIndex = &MetaFile{}
			}
			if err := m.SchemaIndex.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawRangeIndex", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RawRangeIndex == nil {
				m.RawRangeIndex = &MetaFile{}
			}
			if err := m.RawRangeIndex.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DdlIndexes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DdlIndexes == nil {
				m.DdlIndexes = &MetaFile{}
			}
			if err := m.DdlIndexes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BackupResult", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BackupResult = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiVersion", wireType)
			}
			m.ApiVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ApiVersion |= (kvrpcpb.APIVersion(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Policies", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Policies = append(m.Policies, &PlacementPolicy{})
			if err := m.Policies[len(m.Policies)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *File) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: File: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: File: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sha256", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sha256 = append(m.Sha256[:0], dAtA[iNdEx:postIndex]...)
			if m.Sha256 == nil {
				m.Sha256 = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndVersion", wireType)
			}
			m.EndVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndVersion |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Crc64Xor", wireType)
			}
			m.Crc64Xor = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Crc64Xor |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalKvs", wireType)
			}
			m.TotalKvs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalKvs |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalBytes", wireType)
			}
			m.TotalBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalBytes |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size_", wireType)
			}
			m.Size_ = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Size_ |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CipherIv", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CipherIv = append(m.CipherIv[:0], dAtA[iNdEx:postIndex]...)
			if m.CipherIv == nil {
				m.CipherIv = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetaFile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetaFile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetaFile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetaFiles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MetaFiles = append(m.MetaFiles, &File{})
			if err := m.MetaFiles[len(m.MetaFiles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataFiles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataFiles = append(m.DataFiles, &File{})
			if err := m.DataFiles[len(m.DataFiles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schemas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Schemas = append(m.Schemas, &Schema{})
			if err := m.Schemas[len(m.Schemas)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawRanges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RawRanges = append(m.RawRanges, &RawRange{})
			if err := m.RawRanges[len(m.RawRanges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ddls", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ddls = append(m.Ddls, make([]byte, postIndex-iNdEx))
			copy(m.Ddls[len(m.Ddls)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PlacementPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PlacementPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PlacementPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Info = append(m.Info[:0], dAtA[iNdEx:postIndex]...)
			if m.Info == nil {
				m.Info = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Schema) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Schema: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Schema: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Db", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Db = append(m.Db[:0], dAtA[iNdEx:postIndex]...)
			if m.Db == nil {
				m.Db = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Table", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Table = append(m.Table[:0], dAtA[iNdEx:postIndex]...)
			if m.Table == nil {
				m.Table = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Crc64Xor", wireType)
			}
			m.Crc64Xor = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Crc64Xor |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalKvs", wireType)
			}
			m.TotalKvs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalKvs |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalBytes", wireType)
			}
			m.TotalBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalBytes |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TiflashReplicas", wireType)
			}
			m.TiflashReplicas = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TiflashReplicas |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Stats = append(m.Stats[:0], dAtA[iNdEx:postIndex]...)
			if m.Stats == nil {
				m.Stats = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawRange) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawRange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawRange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterIDError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterIDError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterIDError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Current", wireType)
			}
			m.Current = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Current |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Request", wireType)
			}
			m.Request = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Request |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Error) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Error: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Error: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterIdError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ClusterIDError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Detail = &Error_ClusterIdError{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KvError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &kvrpcpb.KeyError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Detail = &Error_KvError{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &errorpb.Error{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Detail = &Error_RegionError{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CipherInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CipherInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CipherInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CipherType", wireType)
			}
			m.CipherType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CipherType |= (encryptionpb.EncryptionMethod(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CipherKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CipherKey = append(m.CipherKey[:0], dAtA[iNdEx:postIndex]...)
			if m.CipherKey == nil {
				m.CipherKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackupRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			m.ClusterId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ClusterId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndVersion", wireType)
			}
			m.EndVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndVersion |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RateLimit", wireType)
			}
			m.RateLimit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RateLimit |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Concurrency", wireType)
			}
			m.Concurrency = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Concurrency |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StorageBackend", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StorageBackend == nil {
				m.StorageBackend = &StorageBackend{}
			}
			if err := m.StorageBackend.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsRawKv", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsRawKv = bool(v != 0)
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompressionType", wireType)
			}
			m.CompressionType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CompressionType |= (CompressionType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompressionLevel", wireType)
			}
			m.CompressionLevel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CompressionLevel |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CipherInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CipherInfo == nil {
				m.CipherInfo = &CipherInfo{}
			}
			if err := m.CipherInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StorageBackend) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StorageBackend: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StorageBackend: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Noop", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Noop{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &StorageBackend_Noop{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Local", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Local{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &StorageBackend_Local{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field S3", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &S3{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &StorageBackend_S3{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gcs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GCS{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &StorageBackend_Gcs{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloudDynamic", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CloudDynamic{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &StorageBackend_CloudDynamic{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hdfs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HDFS{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &StorageBackend_Hdfs{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AzureBlobStorage", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AzureBlobStorage{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &StorageBackend_AzureBlobStorage{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Noop) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Noop: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Noop: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Local) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Local: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Local: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *S3) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: S3: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: S3: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Region = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bucket", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bucket = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StorageClass", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StorageClass = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sse", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sse = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Acl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Acl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretAccessKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SecretAccessKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForcePathStyle", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForcePathStyle = bool(v != 0)
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SseKmsKeyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SseKmsKeyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GCS) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCS: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCS: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bucket", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bucket = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StorageClass", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StorageClass = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PredefinedAcl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PredefinedAcl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CredentialsBlob", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CredentialsBlob = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AzureBlobStorage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AzureBlobStorage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AzureBlobStorage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bucket", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bucket = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StorageClass", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StorageClass = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccountName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccountName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SharedKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SharedKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Bucket) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Bucket: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Bucket: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Region = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bucket", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bucket = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StorageClass", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StorageClass = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CloudDynamic) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CloudDynamic: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CloudDynamic: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bucket", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Bucket == nil {
				m.Bucket = &Bucket{}
			}
			if err := m.Bucket.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProviderName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProviderName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attrs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Attrs == nil {
				m.Attrs = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBrpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowBrpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthBrpb
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowBrpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthBrpb
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipBrpb(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthBrpb
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Attrs[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HDFS) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HDFS: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HDFS: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Remote", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Remote = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackupResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &Error{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, &File{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiVersion", wireType)
			}
			m.ApiVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ApiVersion |= (kvrpcpb.APIVersion(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExternalStorageRestoreRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExternalStorageRestoreRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExternalStorageRestoreRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StorageBackend", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StorageBackend == nil {
				m.StorageBackend = &StorageBackend{}
			}
			if err := m.StorageBackend.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ObjectName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RestoreName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RestoreName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContentLength", wireType)
			}
			m.ContentLength = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ContentLength |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExternalStorageRestoreResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExternalStorageRestoreResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExternalStorageRestoreResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExternalStorageSaveRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExternalStorageSaveRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExternalStorageSaveRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StorageBackend", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StorageBackend == nil {
				m.StorageBackend = &StorageBackend{}
			}
			if err := m.StorageBackend.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBrpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ObjectName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContentLength", wireType)
			}
			m.ContentLength = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ContentLength |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExternalStorageSaveResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExternalStorageSaveResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExternalStorageSaveResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipBrpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBrpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipBrpb(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowBrpb
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBrpb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthBrpb
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowBrpb
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipBrpb(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthBrpb = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowBrpb   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("brpb.proto", fileDescriptor_brpb_9a2c249b8987200a) }

var fileDescriptor_brpb_9a2c249b8987200a = []byte{
	// 2017 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0xdd, 0x6e, 0x1b, 0xc7,
	0x15, 0xe6, 0x92, 0xcb, 0x9f, 0x3d, 0xfc, 0xf5, 0xc4, 0x75, 0x08, 0xba, 0x96, 0x99, 0x35, 0xec,
	0xaa, 0x09, 0xc0, 0xb4, 0x92, 0x13, 0x18, 0x0d, 0x8a, 0x40, 0x94, 0x95, 0x48, 0x91, 0xa2, 0xaa,
	0xa3, 0xb4, 0x45, 0x7d, 0xb3, 0x58, 0xee, 0x0e, 0xc5, 0x2d, 0x97, 0xbb, 0xdb, 0x9d, 0x21, 0x6d,
	0xe6, 0x11, 0x7a, 0xd7, 0xbb, 0xbe, 0x40, 0x81, 0x3e, 0x46, 0x6f, 0x0a, 0x24, 0x48, 0x2f, 0x02,
	0xf4, 0xa6, 0x97, 0x85, 0xfb, 0x04, 0x7d, 0x83, 0xe2, 0xcc, 0xcc, 0xae, 0x48, 0x59, 0x94, 0xdd,
	0x22, 0xc8, 0x95, 0x66, 0xbe, 0x73, 0x66, 0x66, 0xe7, 0x3b, 0xdf, 0x39, 0x67, 0x28, 0x80, 0x51,
	0x9a, 0x8c, 0x06, 0x49, 0x1a, 0x8b, 0x98, 0x54, 0x46, 0xae, 0x37, 0x9d, 0x27, 0xbd, 0xe6, 0x74,
	0x91, 0x26, 0x5e, 0x06, 0xf7, 0x9a, 0x2c, 0x4d, 0xe3, 0xdc, 0xab, 0x47, 0x58, 0xe4, 0xa5, 0xcb,
	0x44, 0x04, 0x71, 0x94, 0x63, 0xb7, 0x2f, 0xe2, 0x8b, 0x58, 0x0e, 0xdf, 0xc7, 0x91, 0x46, 0xdb,
	0xe9, 0x9c, 0x0b, 0x39, 0x54, 0x80, 0xfd, 0x9f, 0x32, 0xc0, 0x50, 0x9e, 0xf1, 0x39, 0x13, 0x2e,
	0xb9, 0x07, 0xe0, 0x85, 0x73, 0x2e, 0x58, 0xea, 0x04, 0x7e, 0xd7, 0xe8, 0x1b, 0xdb, 0x26, 0xb5,
	0x34, 0x72, 0xe4, 0x93, 0x1f, 0x41, 0x3b, 0x33, 0x2f, 0x58, 0xca, 0x83, 0x38, 0xea, 0x16, 0xfb,
	0xc6, 0xb6, 0x45, 0x5b, 0x1a, 0xfe, 0xb5, 0x42, 0x89, 0x0d, 0xe5, 0x71, 0x10, 0x32, 0xde, 0x35,
	0xfb, 0xa5, 0xed, 0xfa, 0x4e, 0x63, 0xa0, 0xee, 0x31, 0xf8, 0x24, 0x08, 0x19, 0x55, 0x26, 0xf2,
	0x00, 0x9a, 0x5c, 0xb8, 0xa9, 0xc8, 0xb7, 0x2a, 0xcb, 0xe3, 0x1a, 0x12, 0xcc, 0x36, 0xba, 0x0f,
	0x75, 0x16, 0xf9, 0xb9, 0x4b, 0x45, 0xba, 0x00, 0x8b, 0xfc, 0xcc, 0x61, 0x1b, 0xaa, 0xdc, 0x9b,
	0xb0, 0x99, 0xcb, 0xbb, 0x55, 0x79, 0x56, 0x2b, 0x3b, 0xeb, 0x5c, 0xc2, 0x34, 0x33, 0x93, 0x1e,
	0x58, 0x01, 0x77, 0x52, 0xf7, 0xb9, 0x33, 0x5d, 0x74, 0x6b, 0x7d, 0x63, 0xbb, 0x46, 0xab, 0x01,
	0xa7, 0xee, 0xf3, 0xe3, 0x05, 0x79, 0x1f, 0x00, 0x0d, 0xa9, 0x1b, 0x5d, 0x30, 0xde, 0xb5, 0xe4,
	0x46, 0x9d, 0x6c, 0x23, 0xea, 0x3e, 0xa7, 0x68, 0xa0, 0x56, 0xaa, 0x47, 0x9c, 0x10, 0x30, 0x7d,
	0x3f, 0xe4, 0x5d, 0xe8, 0x1b, 0xdb, 0x0d, 0x2a, 0xc7, 0x48, 0xde, 0xe8, 0x92, 0x98, 0xba, 0x24,
	0xc6, 0x1a, 0xe5, 0x9c, 0x74, 0xa1, 0x9a, 0xd9, 0x1a, 0x7d, 0x63, 0xbb, 0x4c, 0xb3, 0x29, 0x9e,
	0x8e, 0x94, 0x38, 0x41, 0xe4, 0xb3, 0x17, 0xdd, 0x66, 0xdf, 0x58, 0x3d, 0x1d, 0xe3, 0x22, 0x69,
	0xb3, 0xd0, 0xe7, 0x08, 0x5d, 0xc8, 0x2e, 0x34, 0xd4, 0xad, 0xf4, 0x92, 0xd6, 0x86, 0x25, 0x75,
	0xe5, 0xa5, 0x16, 0x3d, 0x81, 0x76, 0x7e, 0x47, 0xbd, 0xae, 0xbd, 0x61, 0x5d, 0x33, 0xbb, 0xa8,
	0x5a, 0xf9, 0x53, 0xa8, 0xfb, 0x7e, 0xa8, 0xd6, 0x30, 0xde, 0xed, 0x6c, 0x58, 0x05, 0xbe, 0x1f,
	0x1e, 0x29, 0x1f, 0x0c, 0xae, 0x32, 0x3b, 0x29, 0xe3, 0xf3, 0x50, 0x74, 0x6f, 0x49, 0x3a, 0x1a,
	0x0a, 0xa4, 0x12, 0x23, 0x8f, 0xa1, 0xee, 0x26, 0x41, 0xce, 0x18, 0xe9, 0x1b, 0xdb, 0xad, 0x9d,
	0xb7, 0x06, 0x99, 0xd6, 0xf7, 0xce, 0x8e, 0x34, 0x77, 0x14, 0xdc, 0x24, 0xc8, 0x78, 0xdc, 0x85,
	0x5a, 0x12, 0x87, 0x81, 0x17, 0x30, 0xde, 0x7d, 0x4b, 0x46, 0xea, 0xed, 0xec, 0x53, 0xce, 0x42,
	0xd7, 0x63, 0x33, 0x16, 0x89, 0x33, 0x74, 0x58, 0xd2, 0xdc, 0xf1, 0x33, 0xb3, 0x56, 0xea, 0x98,
	0xd4, 0x4c, 0x5c, 0x31, 0xb1, 0xbf, 0x2e, 0x82, 0x89, 0x1f, 0x8c, 0x41, 0x8c, 0xdc, 0x19, 0x93,
	0x3a, 0xb7, 0xa8, 0x1c, 0x93, 0x3b, 0x50, 0xe1, 0x13, 0x77, 0xe7, 0x83, 0x0f, 0xa5, 0xb2, 0x1b,
	0x54, 0xcf, 0xc8, 0x5d, 0xb0, 0x94, 0x5a, 0xa7, 0x6c, 0xd9, 0x2d, 0x49, 0x53, 0x4d, 0x02, 0xc7,
	0x6c, 0x49, 0xde, 0x86, 0x2a, 0xaa, 0x14, 0x4d, 0xa6, 0x5a, 0xc5, 0x22, 0x1f, 0x0d, 0xdf, 0x8d,
	0xc6, 0x7b, 0x50, 0xf3, 0x52, 0xef, 0xc3, 0xc7, 0x2f, 0xe2, 0xb4, 0x5b, 0x95, 0xd6, 0x7c, 0x8e,
	0xdf, 0x25, 0x62, 0xe1, 0x86, 0xce, 0x74, 0xc1, 0xa5, 0xaa, 0x4d, 0x5a, 0x93, 0xc0, 0xf1, 0x82,
	0xe3, 0xce, 0xca, 0x38, 0x5a, 0x0a, 0xa9, 0x6b, 0xb9, 0xb3, 0x84, 0x86, 0x88, 0x90, 0x16, 0x14,
	0xbd, 0xb1, 0x14, 0xb1, 0x45, 0x8b, 0xde, 0x18, 0x19, 0xe1, 0xc1, 0x97, 0x4c, 0x8a, 0xd7, 0xa4,
	0x72, 0x8c, 0x27, 0x78, 0x41, 0x32, 0xc1, 0x92, 0xb0, 0x90, 0xca, 0x6d, 0xd0, 0x9a, 0x02, 0x8e,
	0x16, 0xf6, 0x3f, 0x0c, 0xa8, 0x65, 0x02, 0x20, 0xef, 0x01, 0xcc, 0x98, 0x70, 0x1d, 0x95, 0xfa,
	0xc6, 0x35, 0xa9, 0x6f, 0xcd, 0xb4, 0x2f, 0x47, 0x67, 0xdf, 0xcd, 0x9d, 0x8b, 0xd7, 0x39, 0xa3,
	0x5d, 0x39, 0xaf, 0x64, 0x79, 0xe9, 0xe6, 0x2c, 0x5f, 0xcf, 0x64, 0xf3, 0xcd, 0x33, 0xb9, 0xdc,
	0x2f, 0x65, 0x99, 0x6c, 0x3f, 0x84, 0xf6, 0x15, 0x29, 0xa1, 0x5b, 0x10, 0x8d, 0x63, 0xa9, 0x95,
	0x06, 0x95, 0x63, 0xfb, 0x6b, 0x03, 0x2a, 0xea, 0x7c, 0x24, 0xd2, 0x1f, 0x69, 0x63, 0xd1, 0x1f,
	0x91, 0xdb, 0x50, 0x16, 0xee, 0x28, 0x64, 0x5a, 0x45, 0x6a, 0xb2, 0x16, 0xc8, 0xd2, 0x4d, 0x81,
	0x34, 0x6f, 0x0e, 0x64, 0xf9, 0x95, 0x40, 0xfe, 0x18, 0x3a, 0x22, 0x18, 0x87, 0x2e, 0x9f, 0x38,
	0x29, 0x4b, 0xc2, 0xc0, 0x73, 0xb9, 0x14, 0x52, 0x93, 0xb6, 0x35, 0x4e, 0x35, 0x8c, 0x9f, 0xc6,
	0x85, 0x2b, 0xb8, 0x94, 0x52, 0x83, 0xaa, 0x89, 0x7d, 0x06, 0xb5, 0x8c, 0x9d, 0x75, 0xad, 0x1b,
	0x9b, 0xb5, 0x5e, 0x5c, 0xd3, 0xba, 0xd2, 0x52, 0x29, 0xd3, 0x92, 0xfd, 0x14, 0x5a, 0xfb, 0xba,
	0x73, 0x3c, 0x3d, 0xc0, 0x7e, 0x85, 0x15, 0xd0, 0x9b, 0xa7, 0x29, 0x8b, 0x84, 0x6e, 0x2d, 0xd9,
	0x14, 0x2d, 0x29, 0xfb, 0xfd, 0x9c, 0x71, 0x21, 0x37, 0x35, 0x69, 0x36, 0xb5, 0xff, 0x6e, 0x40,
	0x59, 0xad, 0xee, 0x40, 0x69, 0xc6, 0x2f, 0x74, 0xb2, 0xe2, 0x90, 0x0c, 0xa1, 0x73, 0xd9, 0xad,
	0x1c, 0xd9, 0x13, 0xe5, 0xf9, 0xf5, 0x9d, 0x3b, 0x59, 0xc4, 0xd7, 0xbf, 0xe0, 0xb0, 0x90, 0x77,
	0xaa, 0x23, 0x5f, 0xed, 0x3a, 0x80, 0xda, 0x74, 0xa1, 0xd7, 0x9a, 0x72, 0xed, 0xad, 0xbc, 0x00,
	0x1d, 0xb3, 0x65, 0xb6, 0xac, 0x3a, 0x5d, 0x28, 0xff, 0x5d, 0x68, 0xa4, 0xec, 0x22, 0x88, 0x23,
	0xbd, 0xa6, 0x2c, 0xd7, 0xb4, 0x06, 0x59, 0x47, 0xce, 0x16, 0xd4, 0x95, 0x97, 0x9c, 0x0e, 0x6b,
	0x50, 0xf1, 0x99, 0x70, 0x83, 0xd0, 0x0e, 0x01, 0xf6, 0x55, 0xee, 0x44, 0xe3, 0x98, 0x7c, 0x0c,
	0x75, 0x9d, 0x5a, 0x62, 0x99, 0xa8, 0x3a, 0xd4, 0xda, 0xd9, 0x1a, 0xac, 0xb5, 0xf3, 0x83, 0x7c,
	0xf2, 0x39, 0x13, 0x93, 0xd8, 0xa7, 0xa0, 0x96, 0x7c, 0xb1, 0x4c, 0x98, 0xec, 0xd7, 0x6a, 0x83,
	0xcb, 0x78, 0xe8, 0x6c, 0x3d, 0x66, 0x4b, 0xfb, 0x0f, 0x26, 0x34, 0x87, 0xba, 0xe2, 0x4a, 0x3a,
	0x5f, 0xd7, 0xe0, 0xd7, 0x22, 0x5f, 0xdc, 0x1c, 0xf9, 0xd2, 0xcd, 0x55, 0xce, 0x7c, 0x7d, 0x95,
	0x2b, 0xbf, 0x52, 0xe5, 0xee, 0x61, 0xe6, 0x0a, 0xe6, 0x84, 0xc1, 0x2c, 0x10, 0xba, 0xce, 0x59,
	0x88, 0x9c, 0x20, 0x40, 0xfa, 0x50, 0xf7, 0xe2, 0x48, 0x09, 0xc6, 0x5b, 0xca, 0x52, 0xd7, 0xa4,
	0xab, 0x10, 0xf9, 0x18, 0xda, 0x5c, 0xc4, 0xa9, 0x7b, 0xc1, 0x1c, 0x8c, 0x3e, 0x8b, 0x7c, 0x59,
	0xf1, 0x56, 0xd4, 0x70, 0xae, 0xcc, 0x43, 0x65, 0xa5, 0x2d, 0xbe, 0x36, 0x5f, 0x7f, 0x21, 0xc0,
	0xfa, 0x0b, 0x41, 0xa9, 0xbb, 0x9e, 0x57, 0x4a, 0xd4, 0x5e, 0x3c, 0x4b, 0x52, 0xc6, 0xf1, 0xe3,
	0x55, 0xfc, 0x1a, 0x32, 0x7e, 0x79, 0x37, 0xda, 0xbf, 0xb4, 0x63, 0xb0, 0x68, 0xdb, 0x5b, 0x07,
	0xc8, 0x7b, 0x70, 0x6b, 0x75, 0x8f, 0x90, 0x2d, 0x58, 0x28, 0xdb, 0x7f, 0x99, 0xae, 0x6e, 0x7e,
	0x82, 0x38, 0xd9, 0xcd, 0xb5, 0x22, 0xeb, 0x90, 0x6a, 0xf9, 0x24, 0x3f, 0x2b, 0x17, 0x55, 0xa6,
	0x0f, 0x1c, 0x7f, 0x66, 0xd6, 0x2a, 0x9d, 0xaa, 0x6e, 0x7b, 0xdf, 0x16, 0xa1, 0xb5, 0x4e, 0x00,
	0xb1, 0xc1, 0x8c, 0xe2, 0x38, 0x91, 0x3a, 0x58, 0xa9, 0xbe, 0xa7, 0x71, 0x9c, 0x1c, 0x16, 0xa8,
	0xb4, 0x91, 0x87, 0x50, 0x0e, 0x63, 0xcf, 0x0d, 0xa5, 0x1c, 0xea, 0x3b, 0xcd, 0xcc, 0xe9, 0x04,
	0xc1, 0xc3, 0x02, 0x55, 0x56, 0xf2, 0x43, 0x28, 0xf2, 0x5d, 0x9d, 0x7d, 0x90, 0xf3, 0xbd, 0x7b,
	0x58, 0xa0, 0x45, 0xbe, 0x4b, 0xee, 0x43, 0xe9, 0xc2, 0xe3, 0x3a, 0xc1, 0xea, 0x99, 0xf9, 0xd3,
	0xfd, 0xf3, 0xc3, 0x02, 0x45, 0x0b, 0xf9, 0x08, 0x9a, 0x5e, 0x18, 0xcf, 0x7d, 0xc7, 0x5f, 0x46,
	0xee, 0x2c, 0xf0, 0x74, 0x5e, 0xdd, 0xbe, 0xcc, 0xe3, 0x78, 0xee, 0x3f, 0x55, 0xb6, 0xc3, 0x02,
	0x6d, 0x78, 0x2b, 0x73, 0xbc, 0xc6, 0xc4, 0x1f, 0xab, 0x82, 0xb7, 0x72, 0x8d, 0xc3, 0xa7, 0x9f,
	0xe0, 0xfe, 0xd2, 0x46, 0x0e, 0x81, 0xb8, 0x5f, 0xce, 0x53, 0xe6, 0x8c, 0xc2, 0x78, 0xe4, 0xe8,
	0xc0, 0x4b, 0x95, 0xd5, 0x77, 0xba, 0xd9, 0x8a, 0x3d, 0xf4, 0x18, 0x86, 0xf1, 0x48, 0xf3, 0x74,
	0x58, 0xa0, 0x1d, 0xf7, 0x0a, 0x36, 0xb4, 0xa0, 0xaa, 0xe5, 0x65, 0x57, 0xc0, 0x44, 0xae, 0xec,
	0xbb, 0x50, 0x96, 0x74, 0x60, 0x97, 0x40, 0xae, 0xb3, 0x17, 0x85, 0xe4, 0xfd, 0x9b, 0x22, 0x14,
	0xcf, 0x77, 0xb1, 0xf6, 0xb3, 0xc8, 0x4f, 0xe2, 0x40, 0x57, 0x3f, 0x8b, 0xe6, 0x73, 0x7c, 0x74,
	0xa8, 0x72, 0xa1, 0x9f, 0xd3, 0x7a, 0x86, 0xf8, 0x68, 0xee, 0x4d, 0x99, 0xd0, 0x65, 0x55, 0xcf,
	0x10, 0x4f, 0x52, 0x36, 0x0e, 0x5e, 0x48, 0x46, 0x2d, 0xaa, 0x67, 0x2a, 0x11, 0x55, 0x06, 0x78,
	0xa1, 0xcb, 0x55, 0xa3, 0xb0, 0x30, 0x11, 0x25, 0xb8, 0x8f, 0x18, 0xd6, 0x51, 0xce, 0x99, 0x24,
	0xcb, 0xa2, 0x38, 0x44, 0xc4, 0xf5, 0x42, 0x49, 0x86, 0x45, 0x71, 0x88, 0xb9, 0xe8, 0x7a, 0x1e,
	0xe3, 0x5c, 0x66, 0x7b, 0x4d, 0x3d, 0x65, 0x15, 0x82, 0x09, 0xff, 0x2e, 0xdc, 0xe2, 0xcc, 0x4b,
	0x99, 0x70, 0x56, 0xbc, 0x2c, 0xe9, 0xd5, 0x56, 0x86, 0xbd, 0xdc, 0x77, 0x1b, 0x3a, 0xe3, 0x38,
	0xf5, 0x98, 0x83, 0x64, 0x38, 0x5c, 0x2c, 0x43, 0xa6, 0x73, 0xab, 0x25, 0xf1, 0x33, 0x57, 0x4c,
	0xce, 0x11, 0x25, 0x0f, 0xa0, 0xc5, 0x39, 0x73, 0xa6, 0x33, 0xb9, 0x1f, 0xd6, 0x27, 0x95, 0x6e,
	0x75, 0xce, 0xd9, 0xf1, 0x0c, 0x37, 0x3b, 0xf2, 0xed, 0xaf, 0x0c, 0x28, 0x7d, 0xba, 0x7f, 0xfe,
	0x3a, 0x3a, 0x35, 0x6d, 0xc5, 0x0d, 0xb4, 0x95, 0x6e, 0xa6, 0xcd, 0xbc, 0x86, 0xb6, 0x87, 0xd0,
	0x4a, 0x52, 0xe6, 0xb3, 0x71, 0x10, 0x31, 0xdf, 0x41, 0xbe, 0x14, 0xb9, 0xcd, 0x4b, 0x74, 0xcf,
	0x0b, 0xb1, 0x11, 0x7b, 0x08, 0x44, 0x22, 0x70, 0x43, 0x2e, 0xd5, 0xa6, 0xa9, 0x6e, 0xaf, 0xe0,
	0xa8, 0x27, 0xfb, 0x6f, 0x06, 0x74, 0xae, 0x2a, 0xee, 0xfb, 0xbf, 0xd7, 0x3b, 0xd0, 0x70, 0x3d,
	0x2f, 0x9e, 0x47, 0xc2, 0x91, 0x8f, 0x61, 0x75, 0xab, 0xba, 0xc6, 0x4e, 0xf1, 0x4d, 0x7c, 0x0f,
	0x80, 0x4f, 0xdc, 0x94, 0xa9, 0xda, 0xaf, 0x6e, 0x63, 0x29, 0x04, 0xbb, 0xcc, 0x1f, 0x0d, 0xa8,
	0x0c, 0xd5, 0x97, 0xbc, 0x99, 0xc8, 0x4b, 0x1b, 0x44, 0x6e, 0x6e, 0xb8, 0x55, 0xf9, 0xe6, 0x5b,
	0x55, 0x5e, 0xbd, 0x15, 0x3e, 0x1b, 0x1a, 0xab, 0x35, 0x83, 0x3c, 0xca, 0x4f, 0x31, 0x74, 0xc7,
	0xd6, 0x39, 0xaf, 0xbe, 0x3c, 0x3f, 0xf5, 0x01, 0x34, 0x93, 0x34, 0x5e, 0x04, 0x3e, 0x4b, 0x15,
	0x1f, 0x8a, 0xea, 0x46, 0x06, 0x4a, 0x42, 0x3e, 0x80, 0xb2, 0x2b, 0x44, 0x9a, 0x3d, 0x46, 0xef,
	0x5f, 0x57, 0xa5, 0x06, 0x7b, 0xe8, 0x71, 0x10, 0x89, 0x74, 0x49, 0x95, 0x77, 0xef, 0x09, 0xc0,
	0x25, 0x88, 0x59, 0x97, 0xbd, 0xaf, 0x2c, 0x8a, 0x43, 0x7c, 0x99, 0x2d, 0xdc, 0x70, 0x9e, 0x9d,
	0xa9, 0x26, 0x3f, 0x2b, 0x3e, 0x31, 0xec, 0x2d, 0x30, 0xb1, 0x9a, 0x29, 0x0e, 0x67, 0xb1, 0xc8,
	0x7e, 0xb3, 0xe8, 0x19, 0x4a, 0xa9, 0x95, 0x35, 0x7a, 0x9e, 0xc4, 0x11, 0xc7, 0x6c, 0x2a, 0xab,
	0x17, 0x8a, 0xb1, 0x5e, 0xb7, 0xe5, 0x8b, 0x84, 0x2a, 0xdb, 0xff, 0xd9, 0xef, 0xdf, 0xe4, 0xd7,
	0xfd, 0x95, 0xdf, 0x76, 0xe5, 0x37, 0xfa, 0x6d, 0x67, 0x7f, 0x63, 0xc0, 0xbd, 0x83, 0x17, 0x82,
	0xa5, 0x91, 0x1b, 0xea, 0x8c, 0xa0, 0x0c, 0x03, 0xcb, 0xb2, 0x07, 0xcc, 0x35, 0x4d, 0xde, 0xf8,
	0x9f, 0x9a, 0xfc, 0x7d, 0xa8, 0xc7, 0xa3, 0xdf, 0x31, 0x4f, 0xac, 0x86, 0x17, 0x14, 0x24, 0x83,
	0xfb, 0x0e, 0xbe, 0xf0, 0xe4, 0x99, 0xca, 0x43, 0xa9, 0xb5, 0xae, 0x31, 0xe9, 0xf2, 0x10, 0x5a,
	0x5e, 0x1c, 0x09, 0x16, 0x09, 0x27, 0x64, 0xd1, 0x85, 0x98, 0xe8, 0x17, 0x4f, 0x53, 0xa3, 0x27,
	0x12, 0xb4, 0xfb, 0xb0, 0xb5, 0xe9, 0x32, 0x2a, 0x48, 0xf6, 0x9f, 0x0d, 0xe8, 0x5d, 0x71, 0x39,
	0x77, 0x17, 0xdf, 0xe3, 0x65, 0x5f, 0xbd, 0x49, 0xe9, 0xba, 0x9b, 0xdc, 0x83, 0xbb, 0xd7, 0x7e,
	0xa6, 0xba, 0xc6, 0xbb, 0x3f, 0x87, 0xf6, 0x95, 0xc7, 0x0e, 0xa9, 0x43, 0xf5, 0x57, 0xa7, 0xc7,
	0xa7, 0xbf, 0xf8, 0xcd, 0x69, 0xa7, 0x40, 0xaa, 0x50, 0x3a, 0x79, 0xf6, 0xb8, 0x63, 0x10, 0x80,
	0xca, 0xf9, 0xe9, 0xde, 0xd9, 0xd9, 0x6f, 0x3b, 0x45, 0x52, 0x03, 0xf3, 0xd9, 0xf9, 0x17, 0x4f,
	0x3b, 0xa5, 0x9d, 0x03, 0xa8, 0x28, 0xf1, 0x92, 0x8f, 0x40, 0xff, 0xc7, 0x8b, 0xfc, 0x20, 0xcf,
	0xcf, 0xd5, 0xf7, 0x6b, 0xef, 0xce, 0x55, 0x58, 0x13, 0x59, 0xf8, 0x89, 0xb1, 0xf3, 0x57, 0x03,
	0xda, 0x57, 0xbe, 0x92, 0x3c, 0xc3, 0x1f, 0x16, 0x92, 0x73, 0xf2, 0x30, 0xcf, 0x80, 0x9b, 0x04,
	0xd6, 0x7b, 0xf4, 0x3a, 0xb7, 0xec, 0x44, 0xf2, 0x4b, 0x30, 0xb9, 0xbb, 0x60, 0xc4, 0xde, 0xb0,
	0x62, 0x25, 0x92, 0xbd, 0x07, 0x37, 0xfa, 0x64, 0x5b, 0x0e, 0x1f, 0xfd, 0xf3, 0x2f, 0x35, 0xe3,
	0xab, 0x97, 0x5b, 0xc6, 0xb7, 0x2f, 0xb7, 0x8c, 0x7f, 0xbd, 0xdc, 0x32, 0xfe, 0xf4, 0xef, 0xad,
	0x02, 0x74, 0xe2, 0xf4, 0x62, 0x20, 0x82, 0xe9, 0x62, 0x30, 0x5d, 0xc8, 0x7f, 0xdb, 0x8d, 0x2a,
	0xf2, 0xcf, 0xee, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x8d, 0x35, 0x92, 0x3d, 0x2c, 0x14, 0x00,
	0x00,
}
