// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/maps/routing/v2/route.proto

package routingpb

import (
	reflect "reflect"
	sync "sync"

	viewport "google.golang.org/genproto/googleapis/geo/type/viewport"
	localized_text "google.golang.org/genproto/googleapis/type/localized_text"
	money "google.golang.org/genproto/googleapis/type/money"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Contains a route, which consists of a series of connected road segments
// that join beginning, ending, and intermediate waypoints.
type Route struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Labels for the `Route` that are useful to identify specific properties
	// of the route to compare against others.
	RouteLabels []RouteLabel `protobuf:"varint,13,rep,packed,name=route_labels,json=routeLabels,proto3,enum=google.maps.routing.v2.RouteLabel" json:"route_labels,omitempty"`
	// A collection of legs (path segments between waypoints) that make up the
	// route. Each leg corresponds to the trip between two non-`via`
	// [`Waypoints`][google.maps.routing.v2.Waypoint]. For example, a route with
	// no intermediate waypoints has only one leg. A route that includes one
	// non-`via` intermediate waypoint has two legs. A route that includes one
	// `via` intermediate waypoint has one leg. The order of the legs matches the
	// order of waypoints from `origin` to `intermediates` to `destination`.
	Legs []*RouteLeg `protobuf:"bytes,1,rep,name=legs,proto3" json:"legs,omitempty"`
	// The travel distance of the route, in meters.
	DistanceMeters int32 `protobuf:"varint,2,opt,name=distance_meters,json=distanceMeters,proto3" json:"distance_meters,omitempty"`
	// The length of time needed to navigate the route. If you set the
	// `routing_preference` to `TRAFFIC_UNAWARE`, then this value is the same as
	// `static_duration`. If you set the `routing_preference` to either
	// `TRAFFIC_AWARE` or `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated
	// taking traffic conditions into account.
	Duration *durationpb.Duration `protobuf:"bytes,3,opt,name=duration,proto3" json:"duration,omitempty"`
	// The duration of travel through the route without taking traffic
	// conditions into consideration.
	StaticDuration *durationpb.Duration `protobuf:"bytes,4,opt,name=static_duration,json=staticDuration,proto3" json:"static_duration,omitempty"`
	// The overall route polyline. This polyline is the combined polyline of
	// all `legs`.
	Polyline *Polyline `protobuf:"bytes,5,opt,name=polyline,proto3" json:"polyline,omitempty"`
	// A description of the route.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// An array of warnings to show when displaying the route.
	Warnings []string `protobuf:"bytes,7,rep,name=warnings,proto3" json:"warnings,omitempty"`
	// The viewport bounding box of the polyline.
	Viewport *viewport.Viewport `protobuf:"bytes,8,opt,name=viewport,proto3" json:"viewport,omitempty"`
	// Additional information about the route.
	TravelAdvisory *RouteTravelAdvisory `protobuf:"bytes,9,opt,name=travel_advisory,json=travelAdvisory,proto3" json:"travel_advisory,omitempty"`
	// If you set
	// [`optimize_waypoint_order`][google.maps.routing.v2.ComputeRoutesRequest.optimize_waypoint_order]
	// to true, this field contains the optimized ordering of intermediate
	// waypoints. Otherwise, this field is empty.
	// For example, if you give an input of Origin: LA; Intermediate waypoints:
	// Dallas, Bangor, Phoenix; Destination: New York; and the optimized
	// intermediate waypoint order is Phoenix, Dallas, Bangor, then this field
	// contains the values [2, 0, 1]. The index starts with 0 for the first
	// intermediate waypoint provided in the input.
	OptimizedIntermediateWaypointIndex []int32 `protobuf:"varint,10,rep,packed,name=optimized_intermediate_waypoint_index,json=optimizedIntermediateWaypointIndex,proto3" json:"optimized_intermediate_waypoint_index,omitempty"`
	// Text representations of properties of the `Route`.
	LocalizedValues *Route_RouteLocalizedValues `protobuf:"bytes,11,opt,name=localized_values,json=localizedValues,proto3" json:"localized_values,omitempty"`
	// A web-safe, base64-encoded route token that can be passed to the Navigation
	// SDK, that allows the Navigation SDK to reconstruct the route during
	// navigation, and, in the event of rerouting, honor the original intention
	// when you created the route by calling ComputeRoutes. Customers should treat
	// this token as an opaque blob. It is not meant for reading or mutating.
	// NOTE: `Route.route_token` is only available for requests that have set
	// `ComputeRoutesRequest.routing_preference` to `TRAFFIC_AWARE` or
	// `TRAFFIC_AWARE_OPTIMAL`. `Route.route_token` is not supported for requests
	// that have Via waypoints.
	RouteToken string `protobuf:"bytes,12,opt,name=route_token,json=routeToken,proto3" json:"route_token,omitempty"`
}

func (x *Route) Reset() {
	*x = Route{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_route_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Route) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Route) ProtoMessage() {}

func (x *Route) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_route_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Route.ProtoReflect.Descriptor instead.
func (*Route) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_route_proto_rawDescGZIP(), []int{0}
}

func (x *Route) GetRouteLabels() []RouteLabel {
	if x != nil {
		return x.RouteLabels
	}
	return nil
}

func (x *Route) GetLegs() []*RouteLeg {
	if x != nil {
		return x.Legs
	}
	return nil
}

func (x *Route) GetDistanceMeters() int32 {
	if x != nil {
		return x.DistanceMeters
	}
	return 0
}

func (x *Route) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *Route) GetStaticDuration() *durationpb.Duration {
	if x != nil {
		return x.StaticDuration
	}
	return nil
}

func (x *Route) GetPolyline() *Polyline {
	if x != nil {
		return x.Polyline
	}
	return nil
}

func (x *Route) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Route) GetWarnings() []string {
	if x != nil {
		return x.Warnings
	}
	return nil
}

func (x *Route) GetViewport() *viewport.Viewport {
	if x != nil {
		return x.Viewport
	}
	return nil
}

func (x *Route) GetTravelAdvisory() *RouteTravelAdvisory {
	if x != nil {
		return x.TravelAdvisory
	}
	return nil
}

func (x *Route) GetOptimizedIntermediateWaypointIndex() []int32 {
	if x != nil {
		return x.OptimizedIntermediateWaypointIndex
	}
	return nil
}

func (x *Route) GetLocalizedValues() *Route_RouteLocalizedValues {
	if x != nil {
		return x.LocalizedValues
	}
	return nil
}

func (x *Route) GetRouteToken() string {
	if x != nil {
		return x.RouteToken
	}
	return ""
}

// Contains the additional information that the user should be informed
// about, such as possible traffic zone restrictions.
type RouteTravelAdvisory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains information about tolls on the route. This field is only populated
	// if tolls are expected on the route. If this field is set, but the
	// `estimatedPrice` subfield is not populated, then the route contains tolls,
	// but the estimated price is unknown. If this field is not set, then there
	// are no tolls expected on the route.
	TollInfo *TollInfo `protobuf:"bytes,2,opt,name=toll_info,json=tollInfo,proto3" json:"toll_info,omitempty"`
	// Speed reading intervals detailing traffic density. Applicable in case of
	// `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
	// The intervals cover the entire polyline of the route without overlap.
	// The start point of a specified interval is the same as the end point of the
	// preceding interval.
	//
	// Example:
	//
	//	polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
	//	speed_reading_intervals: [A,C), [C,D), [D,G).
	SpeedReadingIntervals []*SpeedReadingInterval `protobuf:"bytes,3,rep,name=speed_reading_intervals,json=speedReadingIntervals,proto3" json:"speed_reading_intervals,omitempty"`
	// The predicted fuel consumption in microliters.
	FuelConsumptionMicroliters int64 `protobuf:"varint,5,opt,name=fuel_consumption_microliters,json=fuelConsumptionMicroliters,proto3" json:"fuel_consumption_microliters,omitempty"`
	// Returned route may have restrictions that are not suitable for requested
	// travel mode or route modifiers.
	RouteRestrictionsPartiallyIgnored bool `protobuf:"varint,6,opt,name=route_restrictions_partially_ignored,json=routeRestrictionsPartiallyIgnored,proto3" json:"route_restrictions_partially_ignored,omitempty"`
	// If present, contains the total fare or ticket costs on this route
	// This property is only returned for `TRANSIT` requests and only
	// for routes where fare information is available for all transit steps.
	TransitFare *money.Money `protobuf:"bytes,7,opt,name=transit_fare,json=transitFare,proto3" json:"transit_fare,omitempty"`
}

func (x *RouteTravelAdvisory) Reset() {
	*x = RouteTravelAdvisory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_route_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteTravelAdvisory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteTravelAdvisory) ProtoMessage() {}

func (x *RouteTravelAdvisory) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_route_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteTravelAdvisory.ProtoReflect.Descriptor instead.
func (*RouteTravelAdvisory) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_route_proto_rawDescGZIP(), []int{1}
}

func (x *RouteTravelAdvisory) GetTollInfo() *TollInfo {
	if x != nil {
		return x.TollInfo
	}
	return nil
}

func (x *RouteTravelAdvisory) GetSpeedReadingIntervals() []*SpeedReadingInterval {
	if x != nil {
		return x.SpeedReadingIntervals
	}
	return nil
}

func (x *RouteTravelAdvisory) GetFuelConsumptionMicroliters() int64 {
	if x != nil {
		return x.FuelConsumptionMicroliters
	}
	return 0
}

func (x *RouteTravelAdvisory) GetRouteRestrictionsPartiallyIgnored() bool {
	if x != nil {
		return x.RouteRestrictionsPartiallyIgnored
	}
	return false
}

func (x *RouteTravelAdvisory) GetTransitFare() *money.Money {
	if x != nil {
		return x.TransitFare
	}
	return nil
}

// Contains the additional information that the user should be informed
// about on a leg step, such as possible traffic zone restrictions.
type RouteLegTravelAdvisory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains information about tolls on the specific `RouteLeg`.
	// This field is only populated if we expect there are tolls on the
	// `RouteLeg`. If this field is set but the estimated_price subfield is not
	// populated, we expect that road contains tolls but we do not know an
	// estimated price. If this field does not exist, then there is no toll on the
	// `RouteLeg`.
	TollInfo *TollInfo `protobuf:"bytes,1,opt,name=toll_info,json=tollInfo,proto3" json:"toll_info,omitempty"`
	// Speed reading intervals detailing traffic density. Applicable in case of
	// `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
	// The intervals cover the entire polyline of the `RouteLeg` without overlap.
	// The start point of a specified interval is the same as the end point of the
	// preceding interval.
	//
	// Example:
	//
	//	polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
	//	speed_reading_intervals: [A,C), [C,D), [D,G).
	SpeedReadingIntervals []*SpeedReadingInterval `protobuf:"bytes,2,rep,name=speed_reading_intervals,json=speedReadingIntervals,proto3" json:"speed_reading_intervals,omitempty"`
}

func (x *RouteLegTravelAdvisory) Reset() {
	*x = RouteLegTravelAdvisory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_route_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteLegTravelAdvisory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteLegTravelAdvisory) ProtoMessage() {}

func (x *RouteLegTravelAdvisory) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_route_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteLegTravelAdvisory.ProtoReflect.Descriptor instead.
func (*RouteLegTravelAdvisory) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_route_proto_rawDescGZIP(), []int{2}
}

func (x *RouteLegTravelAdvisory) GetTollInfo() *TollInfo {
	if x != nil {
		return x.TollInfo
	}
	return nil
}

func (x *RouteLegTravelAdvisory) GetSpeedReadingIntervals() []*SpeedReadingInterval {
	if x != nil {
		return x.SpeedReadingIntervals
	}
	return nil
}

// Contains the additional information that the user should be informed
// about, such as possible traffic zone restrictions on a leg step.
type RouteLegStepTravelAdvisory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// NOTE: This field is not currently populated.
	SpeedReadingIntervals []*SpeedReadingInterval `protobuf:"bytes,1,rep,name=speed_reading_intervals,json=speedReadingIntervals,proto3" json:"speed_reading_intervals,omitempty"`
}

func (x *RouteLegStepTravelAdvisory) Reset() {
	*x = RouteLegStepTravelAdvisory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_route_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteLegStepTravelAdvisory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteLegStepTravelAdvisory) ProtoMessage() {}

func (x *RouteLegStepTravelAdvisory) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_route_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteLegStepTravelAdvisory.ProtoReflect.Descriptor instead.
func (*RouteLegStepTravelAdvisory) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_route_proto_rawDescGZIP(), []int{3}
}

func (x *RouteLegStepTravelAdvisory) GetSpeedReadingIntervals() []*SpeedReadingInterval {
	if x != nil {
		return x.SpeedReadingIntervals
	}
	return nil
}

// Contains a segment between non-`via` waypoints.
type RouteLeg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The travel distance of the route leg, in meters.
	DistanceMeters int32 `protobuf:"varint,1,opt,name=distance_meters,json=distanceMeters,proto3" json:"distance_meters,omitempty"`
	// The length of time needed to navigate the leg. If the `route_preference`
	// is set to `TRAFFIC_UNAWARE`, then this value is the same as
	// `static_duration`. If the `route_preference` is either `TRAFFIC_AWARE` or
	// `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated taking traffic
	// conditions into account.
	Duration *durationpb.Duration `protobuf:"bytes,2,opt,name=duration,proto3" json:"duration,omitempty"`
	// The duration of travel through the leg, calculated without taking
	// traffic conditions into consideration.
	StaticDuration *durationpb.Duration `protobuf:"bytes,3,opt,name=static_duration,json=staticDuration,proto3" json:"static_duration,omitempty"`
	// The overall polyline for this leg that includes each `step`'s
	// polyline.
	Polyline *Polyline `protobuf:"bytes,4,opt,name=polyline,proto3" json:"polyline,omitempty"`
	// The start location of this leg. This location might be different from the
	// provided `origin`. For example, when the provided `origin` is not near a
	// road, this is a point on the road.
	StartLocation *Location `protobuf:"bytes,5,opt,name=start_location,json=startLocation,proto3" json:"start_location,omitempty"`
	// The end location of this leg. This location might be different from the
	// provided `destination`. For example, when the provided `destination` is not
	// near a road, this is a point on the road.
	EndLocation *Location `protobuf:"bytes,6,opt,name=end_location,json=endLocation,proto3" json:"end_location,omitempty"`
	// An array of steps denoting segments within this leg. Each step represents
	// one navigation instruction.
	Steps []*RouteLegStep `protobuf:"bytes,7,rep,name=steps,proto3" json:"steps,omitempty"`
	// Contains the additional information that the user should be informed
	// about, such as possible traffic zone restrictions, on a route leg.
	TravelAdvisory *RouteLegTravelAdvisory `protobuf:"bytes,8,opt,name=travel_advisory,json=travelAdvisory,proto3" json:"travel_advisory,omitempty"`
	// Text representations of properties of the `RouteLeg`.
	LocalizedValues *RouteLeg_RouteLegLocalizedValues `protobuf:"bytes,9,opt,name=localized_values,json=localizedValues,proto3" json:"localized_values,omitempty"`
	// Overview information about the steps in this `RouteLeg`. This field is only
	// populated for TRANSIT routes.
	StepsOverview *RouteLeg_StepsOverview `protobuf:"bytes,10,opt,name=steps_overview,json=stepsOverview,proto3" json:"steps_overview,omitempty"`
}

func (x *RouteLeg) Reset() {
	*x = RouteLeg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_route_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteLeg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteLeg) ProtoMessage() {}

func (x *RouteLeg) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_route_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteLeg.ProtoReflect.Descriptor instead.
func (*RouteLeg) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_route_proto_rawDescGZIP(), []int{4}
}

func (x *RouteLeg) GetDistanceMeters() int32 {
	if x != nil {
		return x.DistanceMeters
	}
	return 0
}

func (x *RouteLeg) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *RouteLeg) GetStaticDuration() *durationpb.Duration {
	if x != nil {
		return x.StaticDuration
	}
	return nil
}

func (x *RouteLeg) GetPolyline() *Polyline {
	if x != nil {
		return x.Polyline
	}
	return nil
}

func (x *RouteLeg) GetStartLocation() *Location {
	if x != nil {
		return x.StartLocation
	}
	return nil
}

func (x *RouteLeg) GetEndLocation() *Location {
	if x != nil {
		return x.EndLocation
	}
	return nil
}

func (x *RouteLeg) GetSteps() []*RouteLegStep {
	if x != nil {
		return x.Steps
	}
	return nil
}

func (x *RouteLeg) GetTravelAdvisory() *RouteLegTravelAdvisory {
	if x != nil {
		return x.TravelAdvisory
	}
	return nil
}

func (x *RouteLeg) GetLocalizedValues() *RouteLeg_RouteLegLocalizedValues {
	if x != nil {
		return x.LocalizedValues
	}
	return nil
}

func (x *RouteLeg) GetStepsOverview() *RouteLeg_StepsOverview {
	if x != nil {
		return x.StepsOverview
	}
	return nil
}

// Contains a segment of a [`RouteLeg`][google.maps.routing.v2.RouteLeg]. A
// step corresponds to a single navigation instruction. Route legs are made up
// of steps.
type RouteLegStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The travel distance of this step, in meters. In some circumstances, this
	// field might not have a value.
	DistanceMeters int32 `protobuf:"varint,1,opt,name=distance_meters,json=distanceMeters,proto3" json:"distance_meters,omitempty"`
	// The duration of travel through this step without taking traffic conditions
	// into consideration. In some circumstances, this field might not have a
	// value.
	StaticDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=static_duration,json=staticDuration,proto3" json:"static_duration,omitempty"`
	// The polyline associated with this step.
	Polyline *Polyline `protobuf:"bytes,3,opt,name=polyline,proto3" json:"polyline,omitempty"`
	// The start location of this step.
	StartLocation *Location `protobuf:"bytes,4,opt,name=start_location,json=startLocation,proto3" json:"start_location,omitempty"`
	// The end location of this step.
	EndLocation *Location `protobuf:"bytes,5,opt,name=end_location,json=endLocation,proto3" json:"end_location,omitempty"`
	// Navigation instructions.
	NavigationInstruction *NavigationInstruction `protobuf:"bytes,6,opt,name=navigation_instruction,json=navigationInstruction,proto3" json:"navigation_instruction,omitempty"`
	// Contains the additional information that the user should be informed
	// about, such as possible traffic zone restrictions, on a leg step.
	TravelAdvisory *RouteLegStepTravelAdvisory `protobuf:"bytes,7,opt,name=travel_advisory,json=travelAdvisory,proto3" json:"travel_advisory,omitempty"`
	// Text representations of properties of the `RouteLegStep`.
	LocalizedValues *RouteLegStep_RouteLegStepLocalizedValues `protobuf:"bytes,8,opt,name=localized_values,json=localizedValues,proto3" json:"localized_values,omitempty"`
	// Details pertaining to this step if the travel mode is `TRANSIT`.
	TransitDetails *RouteLegStepTransitDetails `protobuf:"bytes,9,opt,name=transit_details,json=transitDetails,proto3" json:"transit_details,omitempty"`
	// The travel mode used for this step.
	TravelMode RouteTravelMode `protobuf:"varint,10,opt,name=travel_mode,json=travelMode,proto3,enum=google.maps.routing.v2.RouteTravelMode" json:"travel_mode,omitempty"`
}

func (x *RouteLegStep) Reset() {
	*x = RouteLegStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_route_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteLegStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteLegStep) ProtoMessage() {}

func (x *RouteLegStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_route_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteLegStep.ProtoReflect.Descriptor instead.
func (*RouteLegStep) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_route_proto_rawDescGZIP(), []int{5}
}

func (x *RouteLegStep) GetDistanceMeters() int32 {
	if x != nil {
		return x.DistanceMeters
	}
	return 0
}

func (x *RouteLegStep) GetStaticDuration() *durationpb.Duration {
	if x != nil {
		return x.StaticDuration
	}
	return nil
}

func (x *RouteLegStep) GetPolyline() *Polyline {
	if x != nil {
		return x.Polyline
	}
	return nil
}

func (x *RouteLegStep) GetStartLocation() *Location {
	if x != nil {
		return x.StartLocation
	}
	return nil
}

func (x *RouteLegStep) GetEndLocation() *Location {
	if x != nil {
		return x.EndLocation
	}
	return nil
}

func (x *RouteLegStep) GetNavigationInstruction() *NavigationInstruction {
	if x != nil {
		return x.NavigationInstruction
	}
	return nil
}

func (x *RouteLegStep) GetTravelAdvisory() *RouteLegStepTravelAdvisory {
	if x != nil {
		return x.TravelAdvisory
	}
	return nil
}

func (x *RouteLegStep) GetLocalizedValues() *RouteLegStep_RouteLegStepLocalizedValues {
	if x != nil {
		return x.LocalizedValues
	}
	return nil
}

func (x *RouteLegStep) GetTransitDetails() *RouteLegStepTransitDetails {
	if x != nil {
		return x.TransitDetails
	}
	return nil
}

func (x *RouteLegStep) GetTravelMode() RouteTravelMode {
	if x != nil {
		return x.TravelMode
	}
	return RouteTravelMode_TRAVEL_MODE_UNSPECIFIED
}

// Additional information for the `RouteLegStep` related to `TRANSIT` routes.
type RouteLegStepTransitDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about the arrival and departure stops for the step.
	StopDetails *RouteLegStepTransitDetails_TransitStopDetails `protobuf:"bytes,1,opt,name=stop_details,json=stopDetails,proto3" json:"stop_details,omitempty"`
	// Text representations of properties of the `RouteLegStepTransitDetails`.
	LocalizedValues *RouteLegStepTransitDetails_TransitDetailsLocalizedValues `protobuf:"bytes,2,opt,name=localized_values,json=localizedValues,proto3" json:"localized_values,omitempty"`
	// Specifies the direction in which to travel on this line as marked on
	// the vehicle or at the departure stop. The direction is often the terminus
	// station.
	Headsign string `protobuf:"bytes,3,opt,name=headsign,proto3" json:"headsign,omitempty"`
	// Specifies the expected time as a duration between departures from the same
	// stop at this time. For example, with a headway seconds value of 600, you
	// would expect a ten minute wait if you should miss your bus.
	Headway *durationpb.Duration `protobuf:"bytes,4,opt,name=headway,proto3" json:"headway,omitempty"`
	// Information about the transit line used in this step.
	TransitLine *TransitLine `protobuf:"bytes,5,opt,name=transit_line,json=transitLine,proto3" json:"transit_line,omitempty"`
	// The number of stops from the departure to the arrival stop. This count
	// includes the arrival stop, but excludes the departure stop. For example, if
	// your route leaves from Stop A, passes through stops B and C, and arrives at
	// stop D, stop_count will return 3.
	StopCount int32 `protobuf:"varint,6,opt,name=stop_count,json=stopCount,proto3" json:"stop_count,omitempty"`
	// The text that appears in schedules and sign boards to identify a transit
	// trip to passengers. The text should uniquely identify a trip within a
	// service day. For example, "538" is the `trip_short_text` of the Amtrak
	// train that leaves San Jose, CA at 15:10 on weekdays to Sacramento, CA.
	TripShortText string `protobuf:"bytes,7,opt,name=trip_short_text,json=tripShortText,proto3" json:"trip_short_text,omitempty"`
}

func (x *RouteLegStepTransitDetails) Reset() {
	*x = RouteLegStepTransitDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_route_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteLegStepTransitDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteLegStepTransitDetails) ProtoMessage() {}

func (x *RouteLegStepTransitDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_route_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteLegStepTransitDetails.ProtoReflect.Descriptor instead.
func (*RouteLegStepTransitDetails) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_route_proto_rawDescGZIP(), []int{6}
}

func (x *RouteLegStepTransitDetails) GetStopDetails() *RouteLegStepTransitDetails_TransitStopDetails {
	if x != nil {
		return x.StopDetails
	}
	return nil
}

func (x *RouteLegStepTransitDetails) GetLocalizedValues() *RouteLegStepTransitDetails_TransitDetailsLocalizedValues {
	if x != nil {
		return x.LocalizedValues
	}
	return nil
}

func (x *RouteLegStepTransitDetails) GetHeadsign() string {
	if x != nil {
		return x.Headsign
	}
	return ""
}

func (x *RouteLegStepTransitDetails) GetHeadway() *durationpb.Duration {
	if x != nil {
		return x.Headway
	}
	return nil
}

func (x *RouteLegStepTransitDetails) GetTransitLine() *TransitLine {
	if x != nil {
		return x.TransitLine
	}
	return nil
}

func (x *RouteLegStepTransitDetails) GetStopCount() int32 {
	if x != nil {
		return x.StopCount
	}
	return 0
}

func (x *RouteLegStepTransitDetails) GetTripShortText() string {
	if x != nil {
		return x.TripShortText
	}
	return ""
}

// Text representations of certain properties.
type Route_RouteLocalizedValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Travel distance represented in text form.
	Distance *localized_text.LocalizedText `protobuf:"bytes,1,opt,name=distance,proto3" json:"distance,omitempty"`
	// Duration taking traffic conditions into consideration, represented in
	// text form. Note: If you did not request traffic information, this value
	// will be the same value as `static_duration`.
	Duration *localized_text.LocalizedText `protobuf:"bytes,2,opt,name=duration,proto3" json:"duration,omitempty"`
	// Duration without taking traffic conditions into consideration,
	// represented in text form.
	StaticDuration *localized_text.LocalizedText `protobuf:"bytes,3,opt,name=static_duration,json=staticDuration,proto3" json:"static_duration,omitempty"`
	// Transit fare represented in text form.
	TransitFare *localized_text.LocalizedText `protobuf:"bytes,4,opt,name=transit_fare,json=transitFare,proto3" json:"transit_fare,omitempty"`
}

func (x *Route_RouteLocalizedValues) Reset() {
	*x = Route_RouteLocalizedValues{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_route_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Route_RouteLocalizedValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Route_RouteLocalizedValues) ProtoMessage() {}

func (x *Route_RouteLocalizedValues) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_route_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Route_RouteLocalizedValues.ProtoReflect.Descriptor instead.
func (*Route_RouteLocalizedValues) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_route_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Route_RouteLocalizedValues) GetDistance() *localized_text.LocalizedText {
	if x != nil {
		return x.Distance
	}
	return nil
}

func (x *Route_RouteLocalizedValues) GetDuration() *localized_text.LocalizedText {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *Route_RouteLocalizedValues) GetStaticDuration() *localized_text.LocalizedText {
	if x != nil {
		return x.StaticDuration
	}
	return nil
}

func (x *Route_RouteLocalizedValues) GetTransitFare() *localized_text.LocalizedText {
	if x != nil {
		return x.TransitFare
	}
	return nil
}

// Text representations of certain properties.
type RouteLeg_RouteLegLocalizedValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Travel distance represented in text form.
	Distance *localized_text.LocalizedText `protobuf:"bytes,1,opt,name=distance,proto3" json:"distance,omitempty"`
	// Duration taking traffic conditions into consideration represented in text
	// form. Note: If you did not request traffic information, this value will
	// be the same value as static_duration.
	Duration *localized_text.LocalizedText `protobuf:"bytes,2,opt,name=duration,proto3" json:"duration,omitempty"`
	// Duration without taking traffic conditions into
	// consideration, represented in text form.
	StaticDuration *localized_text.LocalizedText `protobuf:"bytes,3,opt,name=static_duration,json=staticDuration,proto3" json:"static_duration,omitempty"`
}

func (x *RouteLeg_RouteLegLocalizedValues) Reset() {
	*x = RouteLeg_RouteLegLocalizedValues{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_route_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteLeg_RouteLegLocalizedValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteLeg_RouteLegLocalizedValues) ProtoMessage() {}

func (x *RouteLeg_RouteLegLocalizedValues) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_route_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteLeg_RouteLegLocalizedValues.ProtoReflect.Descriptor instead.
func (*RouteLeg_RouteLegLocalizedValues) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_route_proto_rawDescGZIP(), []int{4, 0}
}

func (x *RouteLeg_RouteLegLocalizedValues) GetDistance() *localized_text.LocalizedText {
	if x != nil {
		return x.Distance
	}
	return nil
}

func (x *RouteLeg_RouteLegLocalizedValues) GetDuration() *localized_text.LocalizedText {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *RouteLeg_RouteLegLocalizedValues) GetStaticDuration() *localized_text.LocalizedText {
	if x != nil {
		return x.StaticDuration
	}
	return nil
}

// Provides overview information about a list of `RouteLegStep`s.
type RouteLeg_StepsOverview struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Summarized information about different multi-modal segments of
	// the `RouteLeg.steps`. This field is not populated if the `RouteLeg` does
	// not contain any multi-modal segments in the steps.
	MultiModalSegments []*RouteLeg_StepsOverview_MultiModalSegment `protobuf:"bytes,1,rep,name=multi_modal_segments,json=multiModalSegments,proto3" json:"multi_modal_segments,omitempty"`
}

func (x *RouteLeg_StepsOverview) Reset() {
	*x = RouteLeg_StepsOverview{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_route_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteLeg_StepsOverview) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteLeg_StepsOverview) ProtoMessage() {}

func (x *RouteLeg_StepsOverview) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_route_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteLeg_StepsOverview.ProtoReflect.Descriptor instead.
func (*RouteLeg_StepsOverview) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_route_proto_rawDescGZIP(), []int{4, 1}
}

func (x *RouteLeg_StepsOverview) GetMultiModalSegments() []*RouteLeg_StepsOverview_MultiModalSegment {
	if x != nil {
		return x.MultiModalSegments
	}
	return nil
}

// Provides summarized information about different multi-modal segments of
// the `RouteLeg.steps`. A multi-modal segment is defined as one or more
// contiguous `RouteLegStep` that have the same `RouteTravelMode`.
// This field is not populated if the `RouteLeg` does not contain any
// multi-modal segments in the steps.
type RouteLeg_StepsOverview_MultiModalSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The corresponding `RouteLegStep` index that is the start of a
	// multi-modal segment.
	StepStartIndex *int32 `protobuf:"varint,1,opt,name=step_start_index,json=stepStartIndex,proto3,oneof" json:"step_start_index,omitempty"`
	// The corresponding `RouteLegStep` index that is the end of a
	// multi-modal segment.
	StepEndIndex *int32 `protobuf:"varint,2,opt,name=step_end_index,json=stepEndIndex,proto3,oneof" json:"step_end_index,omitempty"`
	// NavigationInstruction for the multi-modal segment.
	NavigationInstruction *NavigationInstruction `protobuf:"bytes,3,opt,name=navigation_instruction,json=navigationInstruction,proto3" json:"navigation_instruction,omitempty"`
	// The travel mode of the multi-modal segment.
	TravelMode RouteTravelMode `protobuf:"varint,4,opt,name=travel_mode,json=travelMode,proto3,enum=google.maps.routing.v2.RouteTravelMode" json:"travel_mode,omitempty"`
}

func (x *RouteLeg_StepsOverview_MultiModalSegment) Reset() {
	*x = RouteLeg_StepsOverview_MultiModalSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_route_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteLeg_StepsOverview_MultiModalSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteLeg_StepsOverview_MultiModalSegment) ProtoMessage() {}

func (x *RouteLeg_StepsOverview_MultiModalSegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_route_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteLeg_StepsOverview_MultiModalSegment.ProtoReflect.Descriptor instead.
func (*RouteLeg_StepsOverview_MultiModalSegment) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_route_proto_rawDescGZIP(), []int{4, 1, 0}
}

func (x *RouteLeg_StepsOverview_MultiModalSegment) GetStepStartIndex() int32 {
	if x != nil && x.StepStartIndex != nil {
		return *x.StepStartIndex
	}
	return 0
}

func (x *RouteLeg_StepsOverview_MultiModalSegment) GetStepEndIndex() int32 {
	if x != nil && x.StepEndIndex != nil {
		return *x.StepEndIndex
	}
	return 0
}

func (x *RouteLeg_StepsOverview_MultiModalSegment) GetNavigationInstruction() *NavigationInstruction {
	if x != nil {
		return x.NavigationInstruction
	}
	return nil
}

func (x *RouteLeg_StepsOverview_MultiModalSegment) GetTravelMode() RouteTravelMode {
	if x != nil {
		return x.TravelMode
	}
	return RouteTravelMode_TRAVEL_MODE_UNSPECIFIED
}

// Text representations of certain properties.
type RouteLegStep_RouteLegStepLocalizedValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Travel distance represented in text form.
	Distance *localized_text.LocalizedText `protobuf:"bytes,1,opt,name=distance,proto3" json:"distance,omitempty"`
	// Duration without taking traffic conditions into
	// consideration, represented in text form.
	StaticDuration *localized_text.LocalizedText `protobuf:"bytes,3,opt,name=static_duration,json=staticDuration,proto3" json:"static_duration,omitempty"`
}

func (x *RouteLegStep_RouteLegStepLocalizedValues) Reset() {
	*x = RouteLegStep_RouteLegStepLocalizedValues{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_route_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteLegStep_RouteLegStepLocalizedValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteLegStep_RouteLegStepLocalizedValues) ProtoMessage() {}

func (x *RouteLegStep_RouteLegStepLocalizedValues) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_route_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteLegStep_RouteLegStepLocalizedValues.ProtoReflect.Descriptor instead.
func (*RouteLegStep_RouteLegStepLocalizedValues) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_route_proto_rawDescGZIP(), []int{5, 0}
}

func (x *RouteLegStep_RouteLegStepLocalizedValues) GetDistance() *localized_text.LocalizedText {
	if x != nil {
		return x.Distance
	}
	return nil
}

func (x *RouteLegStep_RouteLegStepLocalizedValues) GetStaticDuration() *localized_text.LocalizedText {
	if x != nil {
		return x.StaticDuration
	}
	return nil
}

// Details about the transit stops for the `RouteLegStep`.
type RouteLegStepTransitDetails_TransitStopDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about the arrival stop for the step.
	ArrivalStop *TransitStop `protobuf:"bytes,1,opt,name=arrival_stop,json=arrivalStop,proto3" json:"arrival_stop,omitempty"`
	// The estimated time of arrival for the step.
	ArrivalTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=arrival_time,json=arrivalTime,proto3" json:"arrival_time,omitempty"`
	// Information about the departure stop for the step.
	DepartureStop *TransitStop `protobuf:"bytes,3,opt,name=departure_stop,json=departureStop,proto3" json:"departure_stop,omitempty"`
	// The estimated time of departure for the step.
	DepartureTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=departure_time,json=departureTime,proto3" json:"departure_time,omitempty"`
}

func (x *RouteLegStepTransitDetails_TransitStopDetails) Reset() {
	*x = RouteLegStepTransitDetails_TransitStopDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_route_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteLegStepTransitDetails_TransitStopDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteLegStepTransitDetails_TransitStopDetails) ProtoMessage() {}

func (x *RouteLegStepTransitDetails_TransitStopDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_route_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteLegStepTransitDetails_TransitStopDetails.ProtoReflect.Descriptor instead.
func (*RouteLegStepTransitDetails_TransitStopDetails) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_route_proto_rawDescGZIP(), []int{6, 0}
}

func (x *RouteLegStepTransitDetails_TransitStopDetails) GetArrivalStop() *TransitStop {
	if x != nil {
		return x.ArrivalStop
	}
	return nil
}

func (x *RouteLegStepTransitDetails_TransitStopDetails) GetArrivalTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ArrivalTime
	}
	return nil
}

func (x *RouteLegStepTransitDetails_TransitStopDetails) GetDepartureStop() *TransitStop {
	if x != nil {
		return x.DepartureStop
	}
	return nil
}

func (x *RouteLegStepTransitDetails_TransitStopDetails) GetDepartureTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DepartureTime
	}
	return nil
}

// Localized descriptions of values for `RouteTransitDetails`.
type RouteLegStepTransitDetails_TransitDetailsLocalizedValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time in its formatted text representation with a corresponding time zone.
	ArrivalTime *LocalizedTime `protobuf:"bytes,1,opt,name=arrival_time,json=arrivalTime,proto3" json:"arrival_time,omitempty"`
	// Time in its formatted text representation with a corresponding time zone.
	DepartureTime *LocalizedTime `protobuf:"bytes,2,opt,name=departure_time,json=departureTime,proto3" json:"departure_time,omitempty"`
}

func (x *RouteLegStepTransitDetails_TransitDetailsLocalizedValues) Reset() {
	*x = RouteLegStepTransitDetails_TransitDetailsLocalizedValues{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_route_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteLegStepTransitDetails_TransitDetailsLocalizedValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteLegStepTransitDetails_TransitDetailsLocalizedValues) ProtoMessage() {}

func (x *RouteLegStepTransitDetails_TransitDetailsLocalizedValues) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_route_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteLegStepTransitDetails_TransitDetailsLocalizedValues.ProtoReflect.Descriptor instead.
func (*RouteLegStepTransitDetails_TransitDetailsLocalizedValues) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_route_proto_rawDescGZIP(), []int{6, 1}
}

func (x *RouteLegStepTransitDetails_TransitDetailsLocalizedValues) GetArrivalTime() *LocalizedTime {
	if x != nil {
		return x.ArrivalTime
	}
	return nil
}

func (x *RouteLegStepTransitDetails_TransitDetailsLocalizedValues) GetDepartureTime() *LocalizedTime {
	if x != nil {
		return x.DepartureTime
	}
	return nil
}

var File_google_maps_routing_v2_route_proto protoreflect.FileDescriptor

var file_google_maps_routing_v2_route_proto_rawDesc = []byte{
	0x0a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x67, 0x65, 0x6f, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x76, 0x69,
	0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x2f, 0x76, 0x32, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76,
	0x32, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x6e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61,
	0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x70, 0x6f,
	0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d,
	0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d,
	0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x73,
	0x70, 0x65, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x2f, 0x76, 0x32, 0x2f, 0x74, 0x6f, 0x6c, 0x6c, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73,
	0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x69, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x64, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x91, 0x08, 0x0a, 0x05, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12,
	0x45, 0x0a, 0x0c, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x0d, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x0b, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x34, 0x0a, 0x04, 0x6c, 0x65, 0x67, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x4c, 0x65, 0x67, 0x52, 0x04, 0x6c, 0x65, 0x67, 0x73, 0x12, 0x27, 0x0a, 0x0f,
	0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x0f,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x3c, 0x0a, 0x08, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x6f, 0x6c, 0x79,
	0x6c, 0x69, 0x6e, 0x65, 0x52, 0x08, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1a, 0x0a, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x07, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x35, 0x0a, 0x08,
	0x76, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6f, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x56, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x08, 0x76, 0x69, 0x65, 0x77, 0x70,
	0x6f, 0x72, 0x74, 0x12, 0x54, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x61, 0x64,
	0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x72, 0x61, 0x76, 0x65,
	0x6c, 0x41, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x76, 0x65,
	0x6c, 0x41, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x12, 0x51, 0x0a, 0x25, 0x6f, 0x70, 0x74,
	0x69, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x69,
	0x61, 0x74, 0x65, 0x5f, 0x77, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x05, 0x52, 0x22, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69,
	0x7a, 0x65, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x57,
	0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x5d, 0x0a, 0x10,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x0f, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x1a, 0x8a, 0x02, 0x0a,
	0x14, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x36, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54,
	0x65, 0x78, 0x74, 0x52, 0x08, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x36, 0x0a,
	0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x52, 0x08, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x63, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x0c, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x66, 0x61, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c,
	0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x52, 0x0b, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x69, 0x74, 0x46, 0x61, 0x72, 0x65, 0x22, 0x84, 0x03, 0x0a, 0x13, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x54, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x41, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72,
	0x79, 0x12, 0x3d, 0x0a, 0x09, 0x74, 0x6f, 0x6c, 0x6c, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x6f,
	0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x74, 0x6f, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x64, 0x0a, 0x17, 0x73, 0x70, 0x65, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e,
	0x67, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x64,
	0x52, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x52,
	0x15, 0x73, 0x70, 0x65, 0x65, 0x64, 0x52, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x1c, 0x66, 0x75, 0x65, 0x6c, 0x5f, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f,
	0x6c, 0x69, 0x74, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1a, 0x66, 0x75,
	0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x69, 0x63,
	0x72, 0x6f, 0x6c, 0x69, 0x74, 0x65, 0x72, 0x73, 0x12, 0x4f, 0x0a, 0x24, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x6c, 0x79, 0x5f, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x64,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x21, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c,
	0x6c, 0x79, 0x49, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x64, 0x12, 0x35, 0x0a, 0x0c, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x69, 0x74, 0x5f, 0x66, 0x61, 0x72, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f,
	0x6e, 0x65, 0x79, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x46, 0x61, 0x72, 0x65,
	0x22, 0xbd, 0x01, 0x0a, 0x16, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4c, 0x65, 0x67, 0x54, 0x72, 0x61,
	0x76, 0x65, 0x6c, 0x41, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x12, 0x3d, 0x0a, 0x09, 0x74,
	0x6f, 0x6c, 0x6c, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x6f, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x08, 0x74, 0x6f, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x64, 0x0a, 0x17, 0x73, 0x70,
	0x65, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x64, 0x52, 0x65, 0x61, 0x64, 0x69, 0x6e,
	0x67, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x52, 0x15, 0x73, 0x70, 0x65, 0x65, 0x64,
	0x52, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x73,
	0x22, 0x82, 0x01, 0x0a, 0x1a, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4c, 0x65, 0x67, 0x53, 0x74, 0x65,
	0x70, 0x54, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x41, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x12,
	0x64, 0x0a, 0x17, 0x73, 0x70, 0x65, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x64, 0x52,
	0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x52, 0x15,
	0x73, 0x70, 0x65, 0x65, 0x64, 0x52, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x73, 0x22, 0xea, 0x0a, 0x0a, 0x08, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4c,
	0x65, 0x67, 0x12, 0x27, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x64, 0x69, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x35, 0x0a, 0x08, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x08, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69,
	0x6e, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x32, 0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x08, 0x70, 0x6f, 0x6c, 0x79,
	0x6c, 0x69, 0x6e, 0x65, 0x12, 0x47, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a,
	0x0c, 0x65, 0x6e, 0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x65, 0x6e, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x4c, 0x65, 0x67, 0x53, 0x74, 0x65, 0x70, 0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x12, 0x57,
	0x0a, 0x0f, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x61, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72,
	0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32,
	0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4c, 0x65, 0x67, 0x54, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x41,
	0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x41,
	0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x12, 0x63, 0x0a, 0x10, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x4c, 0x65, 0x67, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4c, 0x65, 0x67, 0x4c, 0x6f, 0x63, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x0f, 0x6c, 0x6f, 0x63,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x55, 0x0a, 0x0e,
	0x73, 0x74, 0x65, 0x70, 0x73, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x4c, 0x65, 0x67, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x73, 0x4f, 0x76, 0x65, 0x72,
	0x76, 0x69, 0x65, 0x77, 0x52, 0x0d, 0x73, 0x74, 0x65, 0x70, 0x73, 0x4f, 0x76, 0x65, 0x72, 0x76,
	0x69, 0x65, 0x77, 0x1a, 0xce, 0x01, 0x0a, 0x17, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4c, 0x65, 0x67,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12,
	0x36, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x52, 0x08, 0x64,
	0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x36, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x64, 0x54, 0x65, 0x78, 0x74, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x43, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x54, 0x65, 0x78, 0x74, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xcb, 0x03, 0x0a, 0x0d, 0x53, 0x74, 0x65, 0x70, 0x73, 0x4f, 0x76,
	0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x12, 0x72, 0x0a, 0x14, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f,
	0x6d, 0x6f, 0x64, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x4c, 0x65, 0x67, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x73, 0x4f, 0x76, 0x65, 0x72,
	0x76, 0x69, 0x65, 0x77, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x12, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x4d, 0x6f, 0x64,
	0x61, 0x6c, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0xc5, 0x02, 0x0a, 0x11, 0x4d,
	0x75, 0x6c, 0x74, 0x69, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x2d, 0x0a, 0x10, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x74,
	0x65, 0x70, 0x53, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x88, 0x01, 0x01, 0x12,
	0x29, 0x0a, 0x0e, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x0c, 0x73, 0x74, 0x65, 0x70, 0x45,
	0x6e, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x88, 0x01, 0x01, 0x12, 0x64, 0x0a, 0x16, 0x6e, 0x61,
	0x76, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x6e, 0x61, 0x76, 0x69, 0x67,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x48, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x54, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0a,
	0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x73,
	0x74, 0x65, 0x70, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x42,
	0x11, 0x0a, 0x0f, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x22, 0xbb, 0x07, 0x0a, 0x0c, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4c, 0x65, 0x67, 0x53,
	0x74, 0x65, 0x70, 0x12, 0x27, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x64, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x42, 0x0a, 0x0f,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x3c, 0x0a, 0x08, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x6f, 0x6c, 0x79,
	0x6c, 0x69, 0x6e, 0x65, 0x52, 0x08, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x47,
	0x0a, 0x0e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x0c, 0x65, 0x6e, 0x64, 0x5f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0b, 0x65, 0x6e, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x16,
	0x6e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x6e, 0x61, 0x76,
	0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x61, 0x64, 0x76,
	0x69, 0x73, 0x6f, 0x72, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4c, 0x65, 0x67, 0x53, 0x74, 0x65,
	0x70, 0x54, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x41, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x52,
	0x0e, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x41, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x12,
	0x6b, 0x0a, 0x10, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4c, 0x65, 0x67, 0x53, 0x74, 0x65, 0x70, 0x2e,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x4c, 0x65, 0x67, 0x53, 0x74, 0x65, 0x70, 0x4c, 0x6f, 0x63, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x0f, 0x6c, 0x6f, 0x63,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x5b, 0x0a, 0x0f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x4c, 0x65, 0x67, 0x53, 0x74, 0x65, 0x70, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x69, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x69, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x48, 0x0a, 0x0b, 0x74, 0x72, 0x61,
	0x76, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x72, 0x61,
	0x76, 0x65, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x4d,
	0x6f, 0x64, 0x65, 0x1a, 0x9a, 0x01, 0x0a, 0x1b, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4c, 0x65, 0x67,
	0x53, 0x74, 0x65, 0x70, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x12, 0x36, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78,
	0x74, 0x52, 0x08, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x43, 0x0a, 0x0f, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74,
	0x52, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xca, 0x07, 0x0a, 0x1a, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4c, 0x65, 0x67, 0x53, 0x74, 0x65,
	0x70, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12,
	0x68, 0x0a, 0x0c, 0x73, 0x74, 0x6f, 0x70, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x4c, 0x65, 0x67, 0x53, 0x74, 0x65, 0x70, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x69, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69,
	0x74, 0x53, 0x74, 0x6f, 0x70, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x0b, 0x73, 0x74,
	0x6f, 0x70, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x7b, 0x0a, 0x10, 0x6c, 0x6f, 0x63,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x4c, 0x65, 0x67, 0x53, 0x74, 0x65, 0x70, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x65, 0x61, 0x64, 0x73, 0x69,
	0x67, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x65, 0x61, 0x64, 0x73, 0x69,
	0x67, 0x6e, 0x12, 0x33, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x77, 0x61, 0x79, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07,
	0x68, 0x65, 0x61, 0x64, 0x77, 0x61, 0x79, 0x12, 0x46, 0x0a, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x69, 0x74, 0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x4c, 0x69,
	0x6e, 0x65, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x4c, 0x69, 0x6e, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x6f, 0x70, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x09, 0x73, 0x74, 0x6f, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x26,
	0x0a, 0x0f, 0x74, 0x72, 0x69, 0x70, 0x5f, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x74, 0x72, 0x69, 0x70, 0x53, 0x68, 0x6f,
	0x72, 0x74, 0x54, 0x65, 0x78, 0x74, 0x1a, 0xaa, 0x02, 0x0a, 0x12, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x69, 0x74, 0x53, 0x74, 0x6f, 0x70, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x46, 0x0a,
	0x0c, 0x61, 0x72, 0x72, 0x69, 0x76, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x6f, 0x70, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x69, 0x74, 0x53, 0x74, 0x6f, 0x70, 0x52, 0x0b, 0x61, 0x72, 0x72, 0x69, 0x76, 0x61,
	0x6c, 0x53, 0x74, 0x6f, 0x70, 0x12, 0x3d, 0x0a, 0x0c, 0x61, 0x72, 0x72, 0x69, 0x76, 0x61, 0x6c,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x61, 0x72, 0x72, 0x69, 0x76, 0x61, 0x6c,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x0e, 0x64, 0x65, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72,
	0x65, 0x5f, 0x73, 0x74, 0x6f, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x53, 0x74, 0x6f,
	0x70, 0x52, 0x0d, 0x64, 0x65, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x6f, 0x70,
	0x12, 0x41, 0x0a, 0x0e, 0x64, 0x65, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d, 0x64, 0x65, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x1a, 0xb7, 0x01, 0x0a, 0x1d, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x0c, 0x61, 0x72, 0x72, 0x69, 0x76, 0x61, 0x6c,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x52, 0x0b, 0x61, 0x72, 0x72, 0x69, 0x76, 0x61, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x4c, 0x0a, 0x0e, 0x64, 0x65, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32,
	0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x0d,
	0x64, 0x65, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x42, 0xbf, 0x01,
	0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x42, 0x0a, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3a, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x32, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x70, 0x62, 0x3b, 0x72, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x67, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x05, 0x47, 0x4d, 0x52, 0x56,
	0x32, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x4d, 0x61, 0x70, 0x73, 0x2e,
	0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x4d, 0x61, 0x70, 0x73, 0x5c, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x5c, 0x56, 0x32, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x4d, 0x61,
	0x70, 0x73, 0x3a, 0x3a, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x56, 0x32, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_maps_routing_v2_route_proto_rawDescOnce sync.Once
	file_google_maps_routing_v2_route_proto_rawDescData = file_google_maps_routing_v2_route_proto_rawDesc
)

func file_google_maps_routing_v2_route_proto_rawDescGZIP() []byte {
	file_google_maps_routing_v2_route_proto_rawDescOnce.Do(func() {
		file_google_maps_routing_v2_route_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_routing_v2_route_proto_rawDescData)
	})
	return file_google_maps_routing_v2_route_proto_rawDescData
}

var file_google_maps_routing_v2_route_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_maps_routing_v2_route_proto_goTypes = []interface{}{
	(*Route)(nil),                                                    // 0: google.maps.routing.v2.Route
	(*RouteTravelAdvisory)(nil),                                      // 1: google.maps.routing.v2.RouteTravelAdvisory
	(*RouteLegTravelAdvisory)(nil),                                   // 2: google.maps.routing.v2.RouteLegTravelAdvisory
	(*RouteLegStepTravelAdvisory)(nil),                               // 3: google.maps.routing.v2.RouteLegStepTravelAdvisory
	(*RouteLeg)(nil),                                                 // 4: google.maps.routing.v2.RouteLeg
	(*RouteLegStep)(nil),                                             // 5: google.maps.routing.v2.RouteLegStep
	(*RouteLegStepTransitDetails)(nil),                               // 6: google.maps.routing.v2.RouteLegStepTransitDetails
	(*Route_RouteLocalizedValues)(nil),                               // 7: google.maps.routing.v2.Route.RouteLocalizedValues
	(*RouteLeg_RouteLegLocalizedValues)(nil),                         // 8: google.maps.routing.v2.RouteLeg.RouteLegLocalizedValues
	(*RouteLeg_StepsOverview)(nil),                                   // 9: google.maps.routing.v2.RouteLeg.StepsOverview
	(*RouteLeg_StepsOverview_MultiModalSegment)(nil),                 // 10: google.maps.routing.v2.RouteLeg.StepsOverview.MultiModalSegment
	(*RouteLegStep_RouteLegStepLocalizedValues)(nil),                 // 11: google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues
	(*RouteLegStepTransitDetails_TransitStopDetails)(nil),            // 12: google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
	(*RouteLegStepTransitDetails_TransitDetailsLocalizedValues)(nil), // 13: google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
	(RouteLabel)(0),                                                  // 14: google.maps.routing.v2.RouteLabel
	(*durationpb.Duration)(nil),                                      // 15: google.protobuf.Duration
	(*Polyline)(nil),                                                 // 16: google.maps.routing.v2.Polyline
	(*viewport.Viewport)(nil),                                        // 17: google.geo.type.Viewport
	(*TollInfo)(nil),                                                 // 18: google.maps.routing.v2.TollInfo
	(*SpeedReadingInterval)(nil),                                     // 19: google.maps.routing.v2.SpeedReadingInterval
	(*money.Money)(nil),                                              // 20: google.type.Money
	(*Location)(nil),                                                 // 21: google.maps.routing.v2.Location
	(*NavigationInstruction)(nil),                                    // 22: google.maps.routing.v2.NavigationInstruction
	(RouteTravelMode)(0),                                             // 23: google.maps.routing.v2.RouteTravelMode
	(*TransitLine)(nil),                                              // 24: google.maps.routing.v2.TransitLine
	(*localized_text.LocalizedText)(nil),                             // 25: google.type.LocalizedText
	(*TransitStop)(nil),                                              // 26: google.maps.routing.v2.TransitStop
	(*timestamppb.Timestamp)(nil),                                    // 27: google.protobuf.Timestamp
	(*LocalizedTime)(nil),                                            // 28: google.maps.routing.v2.LocalizedTime
}
var file_google_maps_routing_v2_route_proto_depIdxs = []int32{
	14, // 0: google.maps.routing.v2.Route.route_labels:type_name -> google.maps.routing.v2.RouteLabel
	4,  // 1: google.maps.routing.v2.Route.legs:type_name -> google.maps.routing.v2.RouteLeg
	15, // 2: google.maps.routing.v2.Route.duration:type_name -> google.protobuf.Duration
	15, // 3: google.maps.routing.v2.Route.static_duration:type_name -> google.protobuf.Duration
	16, // 4: google.maps.routing.v2.Route.polyline:type_name -> google.maps.routing.v2.Polyline
	17, // 5: google.maps.routing.v2.Route.viewport:type_name -> google.geo.type.Viewport
	1,  // 6: google.maps.routing.v2.Route.travel_advisory:type_name -> google.maps.routing.v2.RouteTravelAdvisory
	7,  // 7: google.maps.routing.v2.Route.localized_values:type_name -> google.maps.routing.v2.Route.RouteLocalizedValues
	18, // 8: google.maps.routing.v2.RouteTravelAdvisory.toll_info:type_name -> google.maps.routing.v2.TollInfo
	19, // 9: google.maps.routing.v2.RouteTravelAdvisory.speed_reading_intervals:type_name -> google.maps.routing.v2.SpeedReadingInterval
	20, // 10: google.maps.routing.v2.RouteTravelAdvisory.transit_fare:type_name -> google.type.Money
	18, // 11: google.maps.routing.v2.RouteLegTravelAdvisory.toll_info:type_name -> google.maps.routing.v2.TollInfo
	19, // 12: google.maps.routing.v2.RouteLegTravelAdvisory.speed_reading_intervals:type_name -> google.maps.routing.v2.SpeedReadingInterval
	19, // 13: google.maps.routing.v2.RouteLegStepTravelAdvisory.speed_reading_intervals:type_name -> google.maps.routing.v2.SpeedReadingInterval
	15, // 14: google.maps.routing.v2.RouteLeg.duration:type_name -> google.protobuf.Duration
	15, // 15: google.maps.routing.v2.RouteLeg.static_duration:type_name -> google.protobuf.Duration
	16, // 16: google.maps.routing.v2.RouteLeg.polyline:type_name -> google.maps.routing.v2.Polyline
	21, // 17: google.maps.routing.v2.RouteLeg.start_location:type_name -> google.maps.routing.v2.Location
	21, // 18: google.maps.routing.v2.RouteLeg.end_location:type_name -> google.maps.routing.v2.Location
	5,  // 19: google.maps.routing.v2.RouteLeg.steps:type_name -> google.maps.routing.v2.RouteLegStep
	2,  // 20: google.maps.routing.v2.RouteLeg.travel_advisory:type_name -> google.maps.routing.v2.RouteLegTravelAdvisory
	8,  // 21: google.maps.routing.v2.RouteLeg.localized_values:type_name -> google.maps.routing.v2.RouteLeg.RouteLegLocalizedValues
	9,  // 22: google.maps.routing.v2.RouteLeg.steps_overview:type_name -> google.maps.routing.v2.RouteLeg.StepsOverview
	15, // 23: google.maps.routing.v2.RouteLegStep.static_duration:type_name -> google.protobuf.Duration
	16, // 24: google.maps.routing.v2.RouteLegStep.polyline:type_name -> google.maps.routing.v2.Polyline
	21, // 25: google.maps.routing.v2.RouteLegStep.start_location:type_name -> google.maps.routing.v2.Location
	21, // 26: google.maps.routing.v2.RouteLegStep.end_location:type_name -> google.maps.routing.v2.Location
	22, // 27: google.maps.routing.v2.RouteLegStep.navigation_instruction:type_name -> google.maps.routing.v2.NavigationInstruction
	3,  // 28: google.maps.routing.v2.RouteLegStep.travel_advisory:type_name -> google.maps.routing.v2.RouteLegStepTravelAdvisory
	11, // 29: google.maps.routing.v2.RouteLegStep.localized_values:type_name -> google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues
	6,  // 30: google.maps.routing.v2.RouteLegStep.transit_details:type_name -> google.maps.routing.v2.RouteLegStepTransitDetails
	23, // 31: google.maps.routing.v2.RouteLegStep.travel_mode:type_name -> google.maps.routing.v2.RouteTravelMode
	12, // 32: google.maps.routing.v2.RouteLegStepTransitDetails.stop_details:type_name -> google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
	13, // 33: google.maps.routing.v2.RouteLegStepTransitDetails.localized_values:type_name -> google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
	15, // 34: google.maps.routing.v2.RouteLegStepTransitDetails.headway:type_name -> google.protobuf.Duration
	24, // 35: google.maps.routing.v2.RouteLegStepTransitDetails.transit_line:type_name -> google.maps.routing.v2.TransitLine
	25, // 36: google.maps.routing.v2.Route.RouteLocalizedValues.distance:type_name -> google.type.LocalizedText
	25, // 37: google.maps.routing.v2.Route.RouteLocalizedValues.duration:type_name -> google.type.LocalizedText
	25, // 38: google.maps.routing.v2.Route.RouteLocalizedValues.static_duration:type_name -> google.type.LocalizedText
	25, // 39: google.maps.routing.v2.Route.RouteLocalizedValues.transit_fare:type_name -> google.type.LocalizedText
	25, // 40: google.maps.routing.v2.RouteLeg.RouteLegLocalizedValues.distance:type_name -> google.type.LocalizedText
	25, // 41: google.maps.routing.v2.RouteLeg.RouteLegLocalizedValues.duration:type_name -> google.type.LocalizedText
	25, // 42: google.maps.routing.v2.RouteLeg.RouteLegLocalizedValues.static_duration:type_name -> google.type.LocalizedText
	10, // 43: google.maps.routing.v2.RouteLeg.StepsOverview.multi_modal_segments:type_name -> google.maps.routing.v2.RouteLeg.StepsOverview.MultiModalSegment
	22, // 44: google.maps.routing.v2.RouteLeg.StepsOverview.MultiModalSegment.navigation_instruction:type_name -> google.maps.routing.v2.NavigationInstruction
	23, // 45: google.maps.routing.v2.RouteLeg.StepsOverview.MultiModalSegment.travel_mode:type_name -> google.maps.routing.v2.RouteTravelMode
	25, // 46: google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues.distance:type_name -> google.type.LocalizedText
	25, // 47: google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues.static_duration:type_name -> google.type.LocalizedText
	26, // 48: google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails.arrival_stop:type_name -> google.maps.routing.v2.TransitStop
	27, // 49: google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails.arrival_time:type_name -> google.protobuf.Timestamp
	26, // 50: google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails.departure_stop:type_name -> google.maps.routing.v2.TransitStop
	27, // 51: google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails.departure_time:type_name -> google.protobuf.Timestamp
	28, // 52: google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues.arrival_time:type_name -> google.maps.routing.v2.LocalizedTime
	28, // 53: google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues.departure_time:type_name -> google.maps.routing.v2.LocalizedTime
	54, // [54:54] is the sub-list for method output_type
	54, // [54:54] is the sub-list for method input_type
	54, // [54:54] is the sub-list for extension type_name
	54, // [54:54] is the sub-list for extension extendee
	0,  // [0:54] is the sub-list for field type_name
}

func init() { file_google_maps_routing_v2_route_proto_init() }
func file_google_maps_routing_v2_route_proto_init() {
	if File_google_maps_routing_v2_route_proto != nil {
		return
	}
	file_google_maps_routing_v2_localized_time_proto_init()
	file_google_maps_routing_v2_location_proto_init()
	file_google_maps_routing_v2_navigation_instruction_proto_init()
	file_google_maps_routing_v2_polyline_proto_init()
	file_google_maps_routing_v2_route_label_proto_init()
	file_google_maps_routing_v2_route_travel_mode_proto_init()
	file_google_maps_routing_v2_speed_reading_interval_proto_init()
	file_google_maps_routing_v2_toll_info_proto_init()
	file_google_maps_routing_v2_transit_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_maps_routing_v2_route_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Route); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_route_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteTravelAdvisory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_route_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteLegTravelAdvisory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_route_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteLegStepTravelAdvisory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_route_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteLeg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_route_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteLegStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_route_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteLegStepTransitDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_route_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Route_RouteLocalizedValues); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_route_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteLeg_RouteLegLocalizedValues); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_route_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteLeg_StepsOverview); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_route_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteLeg_StepsOverview_MultiModalSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_route_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteLegStep_RouteLegStepLocalizedValues); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_route_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteLegStepTransitDetails_TransitStopDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_route_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteLegStepTransitDetails_TransitDetailsLocalizedValues); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_maps_routing_v2_route_proto_msgTypes[10].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_routing_v2_route_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_maps_routing_v2_route_proto_goTypes,
		DependencyIndexes: file_google_maps_routing_v2_route_proto_depIdxs,
		MessageInfos:      file_google_maps_routing_v2_route_proto_msgTypes,
	}.Build()
	File_google_maps_routing_v2_route_proto = out.File
	file_google_maps_routing_v2_route_proto_rawDesc = nil
	file_google_maps_routing_v2_route_proto_goTypes = nil
	file_google_maps_routing_v2_route_proto_depIdxs = nil
}
