#pragma once
/*
 *  $Id: inventory-store.h 28233 2025-07-16 10:46:57Z yeti-dn $
 *  Copyright (C) 2005-2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_INVENTORY_STORE_H__
#define __GWYUI_INVENTORY_STORE_H__

#include <gtk/gtk.h>
#include <libgwyddion/inventory.h>

G_BEGIN_DECLS

#define GWY_TYPE_INVENTORY_STORE            (gwy_inventory_store_get_type())
#define GWY_INVENTORY_STORE(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_INVENTORY_STORE, GwyInventoryStore))
#define GWY_INVENTORY_STORE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_INVENTORY_STORE, GwyInventoryStoreClass))
#define GWY_IS_INVENTORY_STORE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_INVENTORY_STORE))
#define GWY_IS_INVENTORY_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_INVENTORY_STORE))
#define GWY_INVENTORY_STORE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_INVENTORY_STORE, GwyInventoryStoreClass))

typedef struct _GwyInventoryStore             GwyInventoryStore;
typedef struct _GwyInventoryStoreClass        GwyInventoryStoreClass;
typedef struct _GwyInventoryStorePrivate      GwyInventoryStorePrivate;

struct _GwyInventoryStore {
    GObject parent_instance;
    GwyInventoryStorePrivate *priv;
};

struct _GwyInventoryStoreClass {
    GObjectClass parent_class;

    void (*reserved1)(void);
    void (*reserved2)(void);
};

GType              gwy_inventory_store_get_type          (void)                      G_GNUC_CONST;
GwyInventoryStore* gwy_inventory_store_new               (GwyInventory *inventory);
GwyInventory*      gwy_inventory_store_get_inventory     (GwyInventoryStore *store);
gint               gwy_inventory_store_get_column_by_name(GwyInventoryStore *store,
                                                          const gchar *name);
gboolean           gwy_inventory_store_get_iter          (GwyInventoryStore *store,
                                                          const gchar *name,
                                                          GtkTreeIter *iter);
gboolean           gwy_inventory_store_iter_is_valid     (GwyInventoryStore *store,
                                                          GtkTreeIter *iter);

G_END_DECLS

#endif /* __GWYUI_INVENTORY_STORE_H__ */

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
