#!/bin/bash

set -e

VERSION=$2

TMPDIR=$(mktemp -d -p ../ -t haskell-hadrian-repack.XXXXX)
echo Using temporary directory ${TMPDIR}

echo Unpack tarball
tar -xf ../haskell-hadrian_${VERSION}.orig.tar.xz -C ${TMPDIR}

echo Repack only the hadrian directory
mkdir ${TMPDIR}/ghc-${VERSION}/haskell-hadrian
mkdir ${TMPDIR}/ghc-${VERSION}/haskell-hadrian/utils
mkdir ${TMPDIR}/ghc-${VERSION}/haskell-hadrian/libraries
mv ${TMPDIR}/ghc-${VERSION}/hadrian ${TMPDIR}/ghc-${VERSION}/haskell-hadrian/
mv ${TMPDIR}/ghc-${VERSION}/utils/ghc-toolchain ${TMPDIR}/ghc-${VERSION}/haskell-hadrian/utils/
mv ${TMPDIR}/ghc-${VERSION}/libraries/ghc-platform ${TMPDIR}/ghc-${VERSION}/haskell-hadrian/libraries/
tar -cJf ../haskell-hadrian_${VERSION}.orig.tar.xz -C ${TMPDIR}/ghc-${VERSION} haskell-hadrian

echo Remove temporary directory
rm -rf ${TMPDIR}
