; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s | FileCheck %s
target datalayout = "E-m:e-i64:64-n32:64"
target triple = "powerpc64-unknown-linux-gnu"

define void @a32min(ptr nocapture dereferenceable(4) %minimum, i32 %val) #0 {
; CHECK-LABEL: a32min:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:  .LBB0_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 5, 0, 3
; CHECK-NEXT:    cmpw 5, 4
; CHECK-NEXT:    bltlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 4, 0, 3
; CHECK-NEXT:    bne- 0, .LBB0_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw min ptr %minimum, i32 %val monotonic
  ret void

}

define void @a32max(ptr nocapture dereferenceable(4) %minimum, i32 %val) #0 {
; CHECK-LABEL: a32max:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:  .LBB1_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 5, 0, 3
; CHECK-NEXT:    cmpw 5, 4
; CHECK-NEXT:    bgtlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 4, 0, 3
; CHECK-NEXT:    bne- 0, .LBB1_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw max ptr %minimum, i32 %val monotonic
  ret void

}

define void @a32umin(ptr nocapture dereferenceable(4) %minimum, i32 %val) #0 {
; CHECK-LABEL: a32umin:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:  .LBB2_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 5, 0, 3
; CHECK-NEXT:    cmplw 5, 4
; CHECK-NEXT:    bltlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 4, 0, 3
; CHECK-NEXT:    bne- 0, .LBB2_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw umin ptr %minimum, i32 %val monotonic
  ret void

}

define void @a32umax(ptr nocapture dereferenceable(4) %minimum, i32 %val) #0 {
; CHECK-LABEL: a32umax:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:  .LBB3_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 5, 0, 3
; CHECK-NEXT:    cmplw 5, 4
; CHECK-NEXT:    bgtlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 4, 0, 3
; CHECK-NEXT:    bne- 0, .LBB3_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw umax ptr %minimum, i32 %val monotonic
  ret void

}

define void @a16min(ptr nocapture dereferenceable(4) %minimum, i16 %val) #1 {
; CHECK-LABEL: a16min:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    extsh 4, 4
; CHECK-NEXT:  .LBB4_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 5, 0, 3
; CHECK-NEXT:    extsh 5, 5
; CHECK-NEXT:    cmpw 5, 4
; CHECK-NEXT:    bltlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    sthcx. 4, 0, 3
; CHECK-NEXT:    bne- 0, .LBB4_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw min ptr %minimum, i16 %val monotonic
  ret void

}

define void @a16max(ptr nocapture dereferenceable(4) %minimum, i16 %val) #1 {
; CHECK-LABEL: a16max:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    extsh 4, 4
; CHECK-NEXT:  .LBB5_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 5, 0, 3
; CHECK-NEXT:    extsh 5, 5
; CHECK-NEXT:    cmpw 5, 4
; CHECK-NEXT:    bgtlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    sthcx. 4, 0, 3
; CHECK-NEXT:    bne- 0, .LBB5_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw max ptr %minimum, i16 %val monotonic
  ret void

}

define void @a16umin(ptr nocapture dereferenceable(4) %minimum, i16 %val) #1 {
; CHECK-LABEL: a16umin:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:  .LBB6_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 5, 0, 3
; CHECK-NEXT:    cmplw 5, 4
; CHECK-NEXT:    bltlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    sthcx. 4, 0, 3
; CHECK-NEXT:    bne- 0, .LBB6_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw umin ptr %minimum, i16 %val monotonic
  ret void

}

define void @a16umax(ptr nocapture dereferenceable(4) %minimum, i16 %val) #1 {
; CHECK-LABEL: a16umax:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:  .LBB7_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 5, 0, 3
; CHECK-NEXT:    cmplw 5, 4
; CHECK-NEXT:    bgtlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    sthcx. 4, 0, 3
; CHECK-NEXT:    bne- 0, .LBB7_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw umax ptr %minimum, i16 %val monotonic
  ret void

}

define void @a8min(ptr nocapture dereferenceable(4) %minimum, i8 %val) #1 {
; CHECK-LABEL: a8min:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    extsb 4, 4
; CHECK-NEXT:  .LBB8_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 5, 0, 3
; CHECK-NEXT:    extsb 5, 5
; CHECK-NEXT:    cmpw 5, 4
; CHECK-NEXT:    bltlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stbcx. 4, 0, 3
; CHECK-NEXT:    bne- 0, .LBB8_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw min ptr %minimum, i8 %val monotonic
  ret void

}

define void @a8max(ptr nocapture dereferenceable(4) %minimum, i8 %val) #1 {
; CHECK-LABEL: a8max:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    extsb 4, 4
; CHECK-NEXT:  .LBB9_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 5, 0, 3
; CHECK-NEXT:    extsb 5, 5
; CHECK-NEXT:    cmpw 5, 4
; CHECK-NEXT:    bgtlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stbcx. 4, 0, 3
; CHECK-NEXT:    bne- 0, .LBB9_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw max ptr %minimum, i8 %val monotonic
  ret void

}

define void @a8umin(ptr nocapture dereferenceable(4) %minimum, i8 %val) #1 {
; CHECK-LABEL: a8umin:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:  .LBB10_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 5, 0, 3
; CHECK-NEXT:    cmplw 5, 4
; CHECK-NEXT:    bltlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stbcx. 4, 0, 3
; CHECK-NEXT:    bne- 0, .LBB10_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw umin ptr %minimum, i8 %val monotonic
  ret void

}

define void @a8umax(ptr nocapture dereferenceable(4) %minimum, i8 %val) #1 {
; CHECK-LABEL: a8umax:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:  .LBB11_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 5, 0, 3
; CHECK-NEXT:    cmplw 5, 4
; CHECK-NEXT:    bgtlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stbcx. 4, 0, 3
; CHECK-NEXT:    bne- 0, .LBB11_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw umax ptr %minimum, i8 %val monotonic
  ret void

}

define void @a64min(ptr nocapture dereferenceable(4) %minimum, i64 %val) #0 {
; CHECK-LABEL: a64min:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:  .LBB12_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 5, 0, 3
; CHECK-NEXT:    cmpd 5, 4
; CHECK-NEXT:    bltlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stdcx. 4, 0, 3
; CHECK-NEXT:    bne- 0, .LBB12_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw min ptr %minimum, i64 %val monotonic
  ret void

}

define void @a64max(ptr nocapture dereferenceable(4) %minimum, i64 %val) #0 {
; CHECK-LABEL: a64max:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:  .LBB13_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 5, 0, 3
; CHECK-NEXT:    cmpd 5, 4
; CHECK-NEXT:    bgtlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stdcx. 4, 0, 3
; CHECK-NEXT:    bne- 0, .LBB13_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw max ptr %minimum, i64 %val monotonic
  ret void

}

define void @a64umin(ptr nocapture dereferenceable(4) %minimum, i64 %val) #0 {
; CHECK-LABEL: a64umin:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:  .LBB14_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 5, 0, 3
; CHECK-NEXT:    cmpld 5, 4
; CHECK-NEXT:    bltlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stdcx. 4, 0, 3
; CHECK-NEXT:    bne- 0, .LBB14_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw umin ptr %minimum, i64 %val monotonic
  ret void

}

define void @a64umax(ptr nocapture dereferenceable(4) %minimum, i64 %val) #0 {
; CHECK-LABEL: a64umax:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:  .LBB15_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 5, 0, 3
; CHECK-NEXT:    cmpld 5, 4
; CHECK-NEXT:    bgtlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stdcx. 4, 0, 3
; CHECK-NEXT:    bne- 0, .LBB15_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw umax ptr %minimum, i64 %val monotonic
  ret void

}

define void @ae16min(ptr nocapture dereferenceable(4) %minimum, i16 %val) #0 {
; CHECK-LABEL: ae16min:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li 5, 0
; CHECK-NEXT:    rlwinm 6, 3, 3, 27, 27
; CHECK-NEXT:    extsh 4, 4
; CHECK-NEXT:    ori 7, 5, 65535
; CHECK-NEXT:    xori 5, 6, 16
; CHECK-NEXT:    rldicr 3, 3, 0, 61
; CHECK-NEXT:    slw 8, 4, 5
; CHECK-NEXT:    slw 6, 7, 5
; CHECK-NEXT:    and 7, 8, 6
; CHECK-NEXT:  .LBB16_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 8, 0, 3
; CHECK-NEXT:    and 9, 8, 6
; CHECK-NEXT:    srw 9, 9, 5
; CHECK-NEXT:    extsh 9, 9
; CHECK-NEXT:    cmpw 9, 4
; CHECK-NEXT:    bltlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    andc 8, 8, 6
; CHECK-NEXT:    or 8, 7, 8
; CHECK-NEXT:    stwcx. 8, 0, 3
; CHECK-NEXT:    bne- 0, .LBB16_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw min ptr %minimum, i16 %val monotonic
  ret void

}

define void @ae16max(ptr nocapture dereferenceable(4) %minimum, i16 %val) #0 {
; CHECK-LABEL: ae16max:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li 5, 0
; CHECK-NEXT:    rlwinm 6, 3, 3, 27, 27
; CHECK-NEXT:    extsh 4, 4
; CHECK-NEXT:    ori 7, 5, 65535
; CHECK-NEXT:    xori 5, 6, 16
; CHECK-NEXT:    rldicr 3, 3, 0, 61
; CHECK-NEXT:    slw 8, 4, 5
; CHECK-NEXT:    slw 6, 7, 5
; CHECK-NEXT:    and 7, 8, 6
; CHECK-NEXT:  .LBB17_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 8, 0, 3
; CHECK-NEXT:    and 9, 8, 6
; CHECK-NEXT:    srw 9, 9, 5
; CHECK-NEXT:    extsh 9, 9
; CHECK-NEXT:    cmpw 9, 4
; CHECK-NEXT:    bgtlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    andc 8, 8, 6
; CHECK-NEXT:    or 8, 7, 8
; CHECK-NEXT:    stwcx. 8, 0, 3
; CHECK-NEXT:    bne- 0, .LBB17_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw max ptr %minimum, i16 %val monotonic
  ret void

}

define void @ae16umin(ptr nocapture dereferenceable(4) %minimum, i16 %val) #0 {
; CHECK-LABEL: ae16umin:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li 5, 0
; CHECK-NEXT:    rlwinm 6, 3, 3, 27, 27
; CHECK-NEXT:    ori 5, 5, 65535
; CHECK-NEXT:    xori 6, 6, 16
; CHECK-NEXT:    slw 4, 4, 6
; CHECK-NEXT:    slw 5, 5, 6
; CHECK-NEXT:    rldicr 3, 3, 0, 61
; CHECK-NEXT:    and 6, 4, 5
; CHECK-NEXT:  .LBB18_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 7, 0, 3
; CHECK-NEXT:    and 8, 7, 5
; CHECK-NEXT:    cmplw 8, 4
; CHECK-NEXT:    bltlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    andc 7, 7, 5
; CHECK-NEXT:    or 7, 6, 7
; CHECK-NEXT:    stwcx. 7, 0, 3
; CHECK-NEXT:    bne- 0, .LBB18_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw umin ptr %minimum, i16 %val monotonic
  ret void

}

define void @ae16umax(ptr nocapture dereferenceable(4) %minimum, i16 %val) #0 {
; CHECK-LABEL: ae16umax:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li 5, 0
; CHECK-NEXT:    rlwinm 6, 3, 3, 27, 27
; CHECK-NEXT:    ori 5, 5, 65535
; CHECK-NEXT:    xori 6, 6, 16
; CHECK-NEXT:    slw 4, 4, 6
; CHECK-NEXT:    slw 5, 5, 6
; CHECK-NEXT:    rldicr 3, 3, 0, 61
; CHECK-NEXT:    and 6, 4, 5
; CHECK-NEXT:  .LBB19_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 7, 0, 3
; CHECK-NEXT:    and 8, 7, 5
; CHECK-NEXT:    cmplw 8, 4
; CHECK-NEXT:    bgtlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    andc 7, 7, 5
; CHECK-NEXT:    or 7, 6, 7
; CHECK-NEXT:    stwcx. 7, 0, 3
; CHECK-NEXT:    bne- 0, .LBB19_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw umax ptr %minimum, i16 %val monotonic
  ret void

}

define void @ae8min(ptr nocapture dereferenceable(4) %minimum, i8 %val) #0 {
; CHECK-LABEL: ae8min:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rlwinm 5, 3, 3, 27, 28
; CHECK-NEXT:    li 6, 255
; CHECK-NEXT:    extsb 4, 4
; CHECK-NEXT:    xori 5, 5, 24
; CHECK-NEXT:    slw 7, 4, 5
; CHECK-NEXT:    slw 6, 6, 5
; CHECK-NEXT:    rldicr 3, 3, 0, 61
; CHECK-NEXT:    and 7, 7, 6
; CHECK-NEXT:  .LBB20_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 8, 0, 3
; CHECK-NEXT:    and 9, 8, 6
; CHECK-NEXT:    srw 9, 9, 5
; CHECK-NEXT:    extsb 9, 9
; CHECK-NEXT:    cmpw 9, 4
; CHECK-NEXT:    bltlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    andc 8, 8, 6
; CHECK-NEXT:    or 8, 7, 8
; CHECK-NEXT:    stwcx. 8, 0, 3
; CHECK-NEXT:    bne- 0, .LBB20_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw min ptr %minimum, i8 %val monotonic
  ret void

}

define void @ae8max(ptr nocapture dereferenceable(4) %minimum, i8 %val) #0 {
; CHECK-LABEL: ae8max:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rlwinm 5, 3, 3, 27, 28
; CHECK-NEXT:    li 6, 255
; CHECK-NEXT:    extsb 4, 4
; CHECK-NEXT:    xori 5, 5, 24
; CHECK-NEXT:    slw 7, 4, 5
; CHECK-NEXT:    slw 6, 6, 5
; CHECK-NEXT:    rldicr 3, 3, 0, 61
; CHECK-NEXT:    and 7, 7, 6
; CHECK-NEXT:  .LBB21_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 8, 0, 3
; CHECK-NEXT:    and 9, 8, 6
; CHECK-NEXT:    srw 9, 9, 5
; CHECK-NEXT:    extsb 9, 9
; CHECK-NEXT:    cmpw 9, 4
; CHECK-NEXT:    bgtlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    andc 8, 8, 6
; CHECK-NEXT:    or 8, 7, 8
; CHECK-NEXT:    stwcx. 8, 0, 3
; CHECK-NEXT:    bne- 0, .LBB21_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw max ptr %minimum, i8 %val monotonic
  ret void

}

define void @ae8umin(ptr nocapture dereferenceable(4) %minimum, i8 %val) #0 {
; CHECK-LABEL: ae8umin:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rlwinm 6, 3, 3, 27, 28
; CHECK-NEXT:    li 5, 255
; CHECK-NEXT:    xori 6, 6, 24
; CHECK-NEXT:    rldicr 3, 3, 0, 61
; CHECK-NEXT:    slw 4, 4, 6
; CHECK-NEXT:    slw 5, 5, 6
; CHECK-NEXT:    and 6, 4, 5
; CHECK-NEXT:  .LBB22_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 7, 0, 3
; CHECK-NEXT:    and 8, 7, 5
; CHECK-NEXT:    cmplw 8, 4
; CHECK-NEXT:    bltlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    andc 7, 7, 5
; CHECK-NEXT:    or 7, 6, 7
; CHECK-NEXT:    stwcx. 7, 0, 3
; CHECK-NEXT:    bne- 0, .LBB22_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw umin ptr %minimum, i8 %val monotonic
  ret void

}

define void @ae8umax(ptr nocapture dereferenceable(4) %minimum, i8 %val) #0 {
; CHECK-LABEL: ae8umax:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rlwinm 6, 3, 3, 27, 28
; CHECK-NEXT:    li 5, 255
; CHECK-NEXT:    xori 6, 6, 24
; CHECK-NEXT:    rldicr 3, 3, 0, 61
; CHECK-NEXT:    slw 4, 4, 6
; CHECK-NEXT:    slw 5, 5, 6
; CHECK-NEXT:    and 6, 4, 5
; CHECK-NEXT:  .LBB23_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 7, 0, 3
; CHECK-NEXT:    and 8, 7, 5
; CHECK-NEXT:    cmplw 8, 4
; CHECK-NEXT:    bgtlr 0
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    andc 7, 7, 5
; CHECK-NEXT:    or 7, 6, 7
; CHECK-NEXT:    stwcx. 7, 0, 3
; CHECK-NEXT:    bne- 0, .LBB23_1
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    blr
entry:
  %0 = atomicrmw umax ptr %minimum, i8 %val monotonic
  ret void

}

attributes #0 = { nounwind "target-cpu"="ppc64" }
attributes #1 = { nounwind "target-cpu"="pwr8" }

