; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=thumbv6m-eabi %s -o - | FileCheck %s -check-prefix=THUMB1
; RUN: llc -mtriple=thumbv7-apple-darwin %s -o - | FileCheck %s -check-prefix=THUMB2
; RUN: llc -mtriple thumbv8.1m.main-none-eabi -o - %s | FileCheck %s --check-prefix=V81M

define i8 @scmp_8_8(i8 signext %x, i8 signext %y) nounwind {
; THUMB1-LABEL: scmp_8_8:
; THUMB1:       @ %bb.0:
; THUMB1-NEXT:    movs r2, #1
; THUMB1-NEXT:    movs r3, #0
; THUMB1-NEXT:    cmp r0, r1
; THUMB1-NEXT:    mov r0, r2
; THUMB1-NEXT:    bge .LBB0_3
; THUMB1-NEXT:  @ %bb.1:
; THUMB1-NEXT:    ble .LBB0_4
; THUMB1-NEXT:  .LBB0_2:
; THUMB1-NEXT:    subs r0, r2, r0
; THUMB1-NEXT:    bx lr
; THUMB1-NEXT:  .LBB0_3:
; THUMB1-NEXT:    mov r0, r3
; THUMB1-NEXT:    bgt .LBB0_2
; THUMB1-NEXT:  .LBB0_4:
; THUMB1-NEXT:    mov r2, r3
; THUMB1-NEXT:    subs r0, r2, r0
; THUMB1-NEXT:    bx lr
;
; THUMB2-LABEL: scmp_8_8:
; THUMB2:       @ %bb.0:
; THUMB2-NEXT:    subs r0, r0, r1
; THUMB2-NEXT:    it gt
; THUMB2-NEXT:    movgt r0, #1
; THUMB2-NEXT:    it lt
; THUMB2-NEXT:    movlt.w r0, #-1
; THUMB2-NEXT:    bx lr
;
; V81M-LABEL: scmp_8_8:
; V81M:       @ %bb.0:
; V81M-NEXT:    cmp r0, r1
; V81M-NEXT:    cset r0, gt
; V81M-NEXT:    it lt
; V81M-NEXT:    movlt.w r0, #-1
; V81M-NEXT:    bx lr
  %1 = call i8 @llvm.scmp(i8 %x, i8 %y)
  ret i8 %1
}

define i8 @scmp_8_16(i16 signext %x, i16 signext %y) nounwind {
; THUMB1-LABEL: scmp_8_16:
; THUMB1:       @ %bb.0:
; THUMB1-NEXT:    movs r2, #1
; THUMB1-NEXT:    movs r3, #0
; THUMB1-NEXT:    cmp r0, r1
; THUMB1-NEXT:    mov r0, r2
; THUMB1-NEXT:    bge .LBB1_3
; THUMB1-NEXT:  @ %bb.1:
; THUMB1-NEXT:    ble .LBB1_4
; THUMB1-NEXT:  .LBB1_2:
; THUMB1-NEXT:    subs r0, r2, r0
; THUMB1-NEXT:    bx lr
; THUMB1-NEXT:  .LBB1_3:
; THUMB1-NEXT:    mov r0, r3
; THUMB1-NEXT:    bgt .LBB1_2
; THUMB1-NEXT:  .LBB1_4:
; THUMB1-NEXT:    mov r2, r3
; THUMB1-NEXT:    subs r0, r2, r0
; THUMB1-NEXT:    bx lr
;
; THUMB2-LABEL: scmp_8_16:
; THUMB2:       @ %bb.0:
; THUMB2-NEXT:    subs r0, r0, r1
; THUMB2-NEXT:    it gt
; THUMB2-NEXT:    movgt r0, #1
; THUMB2-NEXT:    it lt
; THUMB2-NEXT:    movlt.w r0, #-1
; THUMB2-NEXT:    bx lr
;
; V81M-LABEL: scmp_8_16:
; V81M:       @ %bb.0:
; V81M-NEXT:    cmp r0, r1
; V81M-NEXT:    cset r0, gt
; V81M-NEXT:    it lt
; V81M-NEXT:    movlt.w r0, #-1
; V81M-NEXT:    bx lr
  %1 = call i8 @llvm.scmp(i16 %x, i16 %y)
  ret i8 %1
}

define i8 @scmp_8_32(i32 %x, i32 %y) nounwind {
; THUMB1-LABEL: scmp_8_32:
; THUMB1:       @ %bb.0:
; THUMB1-NEXT:    movs r2, #1
; THUMB1-NEXT:    movs r3, #0
; THUMB1-NEXT:    cmp r0, r1
; THUMB1-NEXT:    mov r0, r2
; THUMB1-NEXT:    bge .LBB2_3
; THUMB1-NEXT:  @ %bb.1:
; THUMB1-NEXT:    ble .LBB2_4
; THUMB1-NEXT:  .LBB2_2:
; THUMB1-NEXT:    subs r0, r2, r0
; THUMB1-NEXT:    bx lr
; THUMB1-NEXT:  .LBB2_3:
; THUMB1-NEXT:    mov r0, r3
; THUMB1-NEXT:    bgt .LBB2_2
; THUMB1-NEXT:  .LBB2_4:
; THUMB1-NEXT:    mov r2, r3
; THUMB1-NEXT:    subs r0, r2, r0
; THUMB1-NEXT:    bx lr
;
; THUMB2-LABEL: scmp_8_32:
; THUMB2:       @ %bb.0:
; THUMB2-NEXT:    subs r0, r0, r1
; THUMB2-NEXT:    it gt
; THUMB2-NEXT:    movgt r0, #1
; THUMB2-NEXT:    it lt
; THUMB2-NEXT:    movlt.w r0, #-1
; THUMB2-NEXT:    bx lr
;
; V81M-LABEL: scmp_8_32:
; V81M:       @ %bb.0:
; V81M-NEXT:    cmp r0, r1
; V81M-NEXT:    cset r0, gt
; V81M-NEXT:    it lt
; V81M-NEXT:    movlt.w r0, #-1
; V81M-NEXT:    bx lr
  %1 = call i8 @llvm.scmp(i32 %x, i32 %y)
  ret i8 %1
}

define i8 @scmp_8_64(i64 %x, i64 %y) nounwind {
; THUMB1-LABEL: scmp_8_64:
; THUMB1:       @ %bb.0:
; THUMB1-NEXT:    .save {r4, r5, r6, lr}
; THUMB1-NEXT:    push {r4, r5, r6, lr}
; THUMB1-NEXT:    movs r4, #1
; THUMB1-NEXT:    movs r5, #0
; THUMB1-NEXT:    subs r6, r0, r2
; THUMB1-NEXT:    mov r6, r1
; THUMB1-NEXT:    sbcs r6, r3
; THUMB1-NEXT:    mov r6, r4
; THUMB1-NEXT:    blt .LBB3_2
; THUMB1-NEXT:  @ %bb.1:
; THUMB1-NEXT:    mov r6, r5
; THUMB1-NEXT:  .LBB3_2:
; THUMB1-NEXT:    subs r0, r2, r0
; THUMB1-NEXT:    sbcs r3, r1
; THUMB1-NEXT:    blt .LBB3_4
; THUMB1-NEXT:  @ %bb.3:
; THUMB1-NEXT:    mov r4, r5
; THUMB1-NEXT:  .LBB3_4:
; THUMB1-NEXT:    subs r0, r4, r6
; THUMB1-NEXT:    pop {r4, r5, r6, pc}
;
; THUMB2-LABEL: scmp_8_64:
; THUMB2:       @ %bb.0:
; THUMB2-NEXT:    subs.w r12, r0, r2
; THUMB2-NEXT:    mov.w r9, #0
; THUMB2-NEXT:    sbcs.w r12, r1, r3
; THUMB2-NEXT:    mov.w r12, #0
; THUMB2-NEXT:    it lt
; THUMB2-NEXT:    movlt.w r12, #1
; THUMB2-NEXT:    subs r0, r2, r0
; THUMB2-NEXT:    sbcs.w r0, r3, r1
; THUMB2-NEXT:    it lt
; THUMB2-NEXT:    movlt.w r9, #1
; THUMB2-NEXT:    sub.w r0, r9, r12
; THUMB2-NEXT:    bx lr
;
; V81M-LABEL: scmp_8_64:
; V81M:       @ %bb.0:
; V81M-NEXT:    subs.w r12, r0, r2
; V81M-NEXT:    sbcs.w r12, r1, r3
; V81M-NEXT:    cset r12, lt
; V81M-NEXT:    subs r0, r2, r0
; V81M-NEXT:    sbcs.w r0, r3, r1
; V81M-NEXT:    cset r0, lt
; V81M-NEXT:    sub.w r0, r0, r12
; V81M-NEXT:    bx lr
  %1 = call i8 @llvm.scmp(i64 %x, i64 %y)
  ret i8 %1
}

define i8 @scmp_8_128(i128 %x, i128 %y) nounwind {
; THUMB1-LABEL: scmp_8_128:
; THUMB1:       @ %bb.0:
; THUMB1-NEXT:    .save {r4, r5, r6, r7, lr}
; THUMB1-NEXT:    push {r4, r5, r6, r7, lr}
; THUMB1-NEXT:    .pad #20
; THUMB1-NEXT:    sub sp, #20
; THUMB1-NEXT:    str r3, [sp, #16] @ 4-byte Spill
; THUMB1-NEXT:    movs r3, #1
; THUMB1-NEXT:    str r3, [sp] @ 4-byte Spill
; THUMB1-NEXT:    movs r3, #0
; THUMB1-NEXT:    str r3, [sp, #12] @ 4-byte Spill
; THUMB1-NEXT:    ldr r6, [sp, #52]
; THUMB1-NEXT:    add r7, sp, #40
; THUMB1-NEXT:    ldm r7, {r3, r5, r7}
; THUMB1-NEXT:    subs r4, r0, r3
; THUMB1-NEXT:    str r1, [sp, #4] @ 4-byte Spill
; THUMB1-NEXT:    mov r4, r1
; THUMB1-NEXT:    ldr r1, [sp] @ 4-byte Reload
; THUMB1-NEXT:    sbcs r4, r5
; THUMB1-NEXT:    str r2, [sp, #8] @ 4-byte Spill
; THUMB1-NEXT:    mov r4, r2
; THUMB1-NEXT:    sbcs r4, r7
; THUMB1-NEXT:    ldr r4, [sp, #16] @ 4-byte Reload
; THUMB1-NEXT:    sbcs r4, r6
; THUMB1-NEXT:    mov r2, r1
; THUMB1-NEXT:    blt .LBB4_2
; THUMB1-NEXT:  @ %bb.1:
; THUMB1-NEXT:    ldr r2, [sp, #12] @ 4-byte Reload
; THUMB1-NEXT:  .LBB4_2:
; THUMB1-NEXT:    subs r0, r3, r0
; THUMB1-NEXT:    ldr r0, [sp, #4] @ 4-byte Reload
; THUMB1-NEXT:    sbcs r5, r0
; THUMB1-NEXT:    ldr r0, [sp, #8] @ 4-byte Reload
; THUMB1-NEXT:    sbcs r7, r0
; THUMB1-NEXT:    ldr r0, [sp, #16] @ 4-byte Reload
; THUMB1-NEXT:    sbcs r6, r0
; THUMB1-NEXT:    blt .LBB4_4
; THUMB1-NEXT:  @ %bb.3:
; THUMB1-NEXT:    ldr r1, [sp, #12] @ 4-byte Reload
; THUMB1-NEXT:  .LBB4_4:
; THUMB1-NEXT:    subs r0, r1, r2
; THUMB1-NEXT:    add sp, #20
; THUMB1-NEXT:    pop {r4, r5, r6, r7, pc}
;
; THUMB2-LABEL: scmp_8_128:
; THUMB2:       @ %bb.0:
; THUMB2-NEXT:    push {r4, r5, r6, lr}
; THUMB2-NEXT:    add.w lr, sp, #16
; THUMB2-NEXT:    ldr r4, [sp, #28]
; THUMB2-NEXT:    movs r5, #0
; THUMB2-NEXT:    ldm.w lr, {r9, r12, lr}
; THUMB2-NEXT:    subs.w r6, r0, r9
; THUMB2-NEXT:    sbcs.w r6, r1, r12
; THUMB2-NEXT:    sbcs.w r6, r2, lr
; THUMB2-NEXT:    sbcs.w r6, r3, r4
; THUMB2-NEXT:    mov.w r6, #0
; THUMB2-NEXT:    it lt
; THUMB2-NEXT:    movlt r6, #1
; THUMB2-NEXT:    subs.w r0, r9, r0
; THUMB2-NEXT:    sbcs.w r0, r12, r1
; THUMB2-NEXT:    sbcs.w r0, lr, r2
; THUMB2-NEXT:    sbcs.w r0, r4, r3
; THUMB2-NEXT:    it lt
; THUMB2-NEXT:    movlt r5, #1
; THUMB2-NEXT:    subs r0, r5, r6
; THUMB2-NEXT:    pop {r4, r5, r6, pc}
;
; V81M-LABEL: scmp_8_128:
; V81M:       @ %bb.0:
; V81M-NEXT:    .save {r4, r5, r6, lr}
; V81M-NEXT:    push {r4, r5, r6, lr}
; V81M-NEXT:    ldrd r5, r4, [sp, #16]
; V81M-NEXT:    ldrd lr, r12, [sp, #24]
; V81M-NEXT:    subs r6, r0, r5
; V81M-NEXT:    sbcs.w r6, r1, r4
; V81M-NEXT:    sbcs.w r6, r2, lr
; V81M-NEXT:    sbcs.w r6, r3, r12
; V81M-NEXT:    cset r6, lt
; V81M-NEXT:    subs r0, r5, r0
; V81M-NEXT:    sbcs.w r0, r4, r1
; V81M-NEXT:    sbcs.w r0, lr, r2
; V81M-NEXT:    sbcs.w r0, r12, r3
; V81M-NEXT:    cset r0, lt
; V81M-NEXT:    subs r0, r0, r6
; V81M-NEXT:    pop {r4, r5, r6, pc}
  %1 = call i8 @llvm.scmp(i128 %x, i128 %y)
  ret i8 %1
}

define i32 @scmp_32_32(i32 %x, i32 %y) nounwind {
; THUMB1-LABEL: scmp_32_32:
; THUMB1:       @ %bb.0:
; THUMB1-NEXT:    movs r2, #1
; THUMB1-NEXT:    movs r3, #0
; THUMB1-NEXT:    cmp r0, r1
; THUMB1-NEXT:    mov r0, r2
; THUMB1-NEXT:    bge .LBB5_3
; THUMB1-NEXT:  @ %bb.1:
; THUMB1-NEXT:    ble .LBB5_4
; THUMB1-NEXT:  .LBB5_2:
; THUMB1-NEXT:    subs r0, r2, r0
; THUMB1-NEXT:    bx lr
; THUMB1-NEXT:  .LBB5_3:
; THUMB1-NEXT:    mov r0, r3
; THUMB1-NEXT:    bgt .LBB5_2
; THUMB1-NEXT:  .LBB5_4:
; THUMB1-NEXT:    mov r2, r3
; THUMB1-NEXT:    subs r0, r2, r0
; THUMB1-NEXT:    bx lr
;
; THUMB2-LABEL: scmp_32_32:
; THUMB2:       @ %bb.0:
; THUMB2-NEXT:    subs r0, r0, r1
; THUMB2-NEXT:    it gt
; THUMB2-NEXT:    movgt r0, #1
; THUMB2-NEXT:    it lt
; THUMB2-NEXT:    movlt.w r0, #-1
; THUMB2-NEXT:    bx lr
;
; V81M-LABEL: scmp_32_32:
; V81M:       @ %bb.0:
; V81M-NEXT:    cmp r0, r1
; V81M-NEXT:    cset r0, gt
; V81M-NEXT:    it lt
; V81M-NEXT:    movlt.w r0, #-1
; V81M-NEXT:    bx lr
  %1 = call i32 @llvm.scmp(i32 %x, i32 %y)
  ret i32 %1
}

define i32 @scmp_32_64(i64 %x, i64 %y) nounwind {
; THUMB1-LABEL: scmp_32_64:
; THUMB1:       @ %bb.0:
; THUMB1-NEXT:    .save {r4, r5, r6, lr}
; THUMB1-NEXT:    push {r4, r5, r6, lr}
; THUMB1-NEXT:    movs r4, #1
; THUMB1-NEXT:    movs r5, #0
; THUMB1-NEXT:    subs r6, r0, r2
; THUMB1-NEXT:    mov r6, r1
; THUMB1-NEXT:    sbcs r6, r3
; THUMB1-NEXT:    mov r6, r4
; THUMB1-NEXT:    blt .LBB6_2
; THUMB1-NEXT:  @ %bb.1:
; THUMB1-NEXT:    mov r6, r5
; THUMB1-NEXT:  .LBB6_2:
; THUMB1-NEXT:    subs r0, r2, r0
; THUMB1-NEXT:    sbcs r3, r1
; THUMB1-NEXT:    blt .LBB6_4
; THUMB1-NEXT:  @ %bb.3:
; THUMB1-NEXT:    mov r4, r5
; THUMB1-NEXT:  .LBB6_4:
; THUMB1-NEXT:    subs r0, r4, r6
; THUMB1-NEXT:    pop {r4, r5, r6, pc}
;
; THUMB2-LABEL: scmp_32_64:
; THUMB2:       @ %bb.0:
; THUMB2-NEXT:    subs.w r12, r0, r2
; THUMB2-NEXT:    mov.w r9, #0
; THUMB2-NEXT:    sbcs.w r12, r1, r3
; THUMB2-NEXT:    mov.w r12, #0
; THUMB2-NEXT:    it lt
; THUMB2-NEXT:    movlt.w r12, #1
; THUMB2-NEXT:    subs r0, r2, r0
; THUMB2-NEXT:    sbcs.w r0, r3, r1
; THUMB2-NEXT:    it lt
; THUMB2-NEXT:    movlt.w r9, #1
; THUMB2-NEXT:    sub.w r0, r9, r12
; THUMB2-NEXT:    bx lr
;
; V81M-LABEL: scmp_32_64:
; V81M:       @ %bb.0:
; V81M-NEXT:    subs.w r12, r0, r2
; V81M-NEXT:    sbcs.w r12, r1, r3
; V81M-NEXT:    cset r12, lt
; V81M-NEXT:    subs r0, r2, r0
; V81M-NEXT:    sbcs.w r0, r3, r1
; V81M-NEXT:    cset r0, lt
; V81M-NEXT:    sub.w r0, r0, r12
; V81M-NEXT:    bx lr
  %1 = call i32 @llvm.scmp(i64 %x, i64 %y)
  ret i32 %1
}

define i64 @scmp_64_64(i64 %x, i64 %y) nounwind {
; THUMB1-LABEL: scmp_64_64:
; THUMB1:       @ %bb.0:
; THUMB1-NEXT:    .save {r4, r5, r6, lr}
; THUMB1-NEXT:    push {r4, r5, r6, lr}
; THUMB1-NEXT:    movs r4, #1
; THUMB1-NEXT:    movs r5, #0
; THUMB1-NEXT:    subs r6, r0, r2
; THUMB1-NEXT:    mov r6, r1
; THUMB1-NEXT:    sbcs r6, r3
; THUMB1-NEXT:    mov r6, r4
; THUMB1-NEXT:    blt .LBB7_2
; THUMB1-NEXT:  @ %bb.1:
; THUMB1-NEXT:    mov r6, r5
; THUMB1-NEXT:  .LBB7_2:
; THUMB1-NEXT:    subs r0, r2, r0
; THUMB1-NEXT:    sbcs r3, r1
; THUMB1-NEXT:    blt .LBB7_4
; THUMB1-NEXT:  @ %bb.3:
; THUMB1-NEXT:    mov r4, r5
; THUMB1-NEXT:  .LBB7_4:
; THUMB1-NEXT:    subs r0, r4, r6
; THUMB1-NEXT:    asrs r1, r0, #31
; THUMB1-NEXT:    pop {r4, r5, r6, pc}
;
; THUMB2-LABEL: scmp_64_64:
; THUMB2:       @ %bb.0:
; THUMB2-NEXT:    subs.w r12, r0, r2
; THUMB2-NEXT:    mov.w r9, #0
; THUMB2-NEXT:    sbcs.w r12, r1, r3
; THUMB2-NEXT:    mov.w r12, #0
; THUMB2-NEXT:    it lt
; THUMB2-NEXT:    movlt.w r12, #1
; THUMB2-NEXT:    subs r0, r2, r0
; THUMB2-NEXT:    sbcs.w r0, r3, r1
; THUMB2-NEXT:    it lt
; THUMB2-NEXT:    movlt.w r9, #1
; THUMB2-NEXT:    sub.w r0, r9, r12
; THUMB2-NEXT:    asrs r1, r0, #31
; THUMB2-NEXT:    bx lr
;
; V81M-LABEL: scmp_64_64:
; V81M:       @ %bb.0:
; V81M-NEXT:    subs.w r12, r0, r2
; V81M-NEXT:    sbcs.w r12, r1, r3
; V81M-NEXT:    cset r12, lt
; V81M-NEXT:    subs r0, r2, r0
; V81M-NEXT:    sbcs.w r0, r3, r1
; V81M-NEXT:    cset r0, lt
; V81M-NEXT:    sub.w r0, r0, r12
; V81M-NEXT:    asrs r1, r0, #31
; V81M-NEXT:    bx lr
  %1 = call i64 @llvm.scmp(i64 %x, i64 %y)
  ret i64 %1
}
