/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once


/////////////////////// Qt includes
#include <QString>


/////////////////////// Local includes
#include "MsXpS/libXpertMassCore/globals.hpp"
#include "MsXpS/libXpertMassCore/PolChemDef.hpp"
#include "MsXpS/libXpertMassCore/Formula.hpp"


namespace MsXpS
{
namespace libXpertMassCore
{


class DECLSPEC CleavageRule
{
  public:
  CleavageRule(PolChemDefCstSPtr pol_chem_def_csp = nullptr,
               const QString &name                = QString(),
               const QString &leftCode            = QString(),
               const QString &leftFormula         = QString(),
               const QString &rightCode           = QString(),
               const QString &rightFormula        = QString());

  CleavageRule(const CleavageRule &other);

  ~CleavageRule();

  //////////////// THE POLCHEMDEF /////////////////////
  void setPolchemDefCstSPtr(PolChemDefCstSPtr pol_chem_def_csp);
  PolChemDefCstSPtr getPolchemDefCstSPtr() const;

  //////////////// THE NAME /////////////////////
  void setName(const QString &name);
  const QString &getName() const;

  //////////////// THE LEFT CODE /////////////////////
  void setLeftCode(const QString &code);
  const QString &getLeftCode() const;

  //////////////// THE RIGHT CODE /////////////////////
  void setRightCode(const QString &code);
  const QString &getRightCode() const;

  //////////////// THE LEFT FORMULA /////////////////////
  void setLeftFormula(const Formula &formula);
  const Formula &getLeftFormula() const;

  //////////////// THE RIGHT FORMULA /////////////////////
  void setRightFormula(const Formula &formula);
  const Formula &getRightFormula() const;

  //////////////// OPERATORS /////////////////////
  CleavageRule &operator=(const CleavageRule &other);
  bool operator==(const CleavageRule &other) const;
  bool operator!=(const CleavageRule &other) const;

  //////////////// VALIDATIONS /////////////////////
  bool validate(ErrorList *error_list_p) const;
  bool isValid() const;

  //////////////// XML DATA LOADING WRITING /////////////////////
  bool renderXmlClrElement(const QDomElement &element, int version);
  QString
  formatXmlClrElement(int offset,
                      const QString &indent = Utils::xmlIndentationToken);

  protected:
  PolChemDefCstSPtr mcsp_polChemDef = nullptr;

  QString m_name = "";

  QString m_leftCode = "";
  Formula m_leftFormula;

  QString m_rightCode = "";
  Formula m_rightFormula;

  mutable bool m_isValid = false;
};

typedef std::shared_ptr<CleavageRule> CleavageRuleSPtr;
typedef std::shared_ptr<const CleavageRule> CleavageRuleCstSPtr;

} // namespace libXpertMassCore
} // namespace MsXpS
