# Configuring Mir

This section provides information for end-users running a Mir-based compositor.

Mir is a compositor, not a full desktop environment. The documents in this section provide
information about configuring both external components — such as remote desktop capabilities,
on-screen keyboards, and other components you may want to integrate into your desktop environment —
and internal features of Mir itself, such as accessibility options and other built-in capabilities.

## In this documentation

These pages cover the key aspects of configuring Mir based compositors.

````{grid} 1 1 2 2

```{grid-item-card} [How-to](configuring-how-to-index)
**How-to guides** - step-by-step guides covering key operations and common tasks
```

```{grid-item-card} [Explanation](configuring-explanation-index)
 **Discussion and clarification** of key topics
```
````

## Project and community

Mir is a member of the Ubuntu family. It’s an open source project that warmly welcomes community projects, contributions, suggestions, fixes and constructive feedback.

- [Release Notes](https://github.com/canonical/mir/releases)
- [Code of conduct](https://ubuntu.com/community/docs/ethos/code-of-conduct)
- [Get support](https://discourse.ubuntu.com/c/project/mir/15)
- [Join our online chat](https://matrix.to/#/#mir-server:matrix.org)
- {ref}`Contribute <howto-contribute>`

Thinking about using Mir for your next project? [Get in touch](https://canonical.com/mir)!

```{toctree}
---
hidden:
---
how-to/index
explanation/index
reference/index
```
