Managed Code Performance Guidelines
===================================

Different applications have different needs when it comes to performance.  For libraries that may be used in any of them and potentially on critical paths, however, it is of the utmost importance that code is as efficient as possible.  The code in CoreFX should strive to be high-performing, including minimizing the number and size of allocations, minimizing the number of branches involved in code, and overall minimizing the amount of work that must be done to perform any given operation.

Much has been written about writing high-performance code in C#.  This page provides links to some of that material and will expand over time as additional resources are found and identified as being relevant and useful.

You can read [CoreCLR Performance Requirements](https://github.com/dotnet/coreclr/blob/master/Documentation/project-docs/performance-guidelines.md) to learn more.

# Memory Management

* **Avoiding delegate and closure allocations for lambdas**.  The code generated by the C# compiler for anonymous methods and lambdas may involve one or more allocations.  Certain patterns in APIs can help to avoid these allocations.  See [Know Thine Implicit Allocations](http://blogs.msdn.com/b/pfxteam/archive/2012/02/03/10263921.aspx) for more information.

# Asynchrony

* **Best practices for async/await performance**.  The C# async/await feature makes it easy to write asynchronous code in the same manner that you'd write synchronous code, but it comes with its own set of costs, and understanding these costs can help you to avoid them.  This [presentation from Build](http://channel9.msdn.com/Events/BUILD/BUILD2011/TOOL-829T) and this [MSDN Magazine article](http://msdn.microsoft.com/en-us/magazine/hh456402.aspx) outline some best practices.
