using System;
using System.Linq;
using System.Security.Cryptography;
using System.Security.Cryptography.X509Certificates;

using NUnit.Framework;

namespace MonoTests.System.Security.Cryptography 
{
	[TestFixture]
	public class X509Certificate2ExtensionsTests 
	{
		static byte[] selfSignedCertData = { 48,130,10,73,2,1,3,48,130,10,5,6,9,42,134,72,134,247,13,1,7,1,160,130,9,246,4,130,9,242,48,130,9,238,48,130,6,7,6,9,42,134,72,134,247,13,1,7,1,160,130,5,248,4,130,5,244,48,130,5,240,48,130,5,236,6,11,42,134,72,134,247,13,1,12,10,1,2,160,130,4,246,48,130,4,242,48,28,6,10,42,134,72,134,247,13,1,12,1,3,48,14,4,8,183,24,178,64,55,187,89,192,2,2,7,208,4,130,4,208,85,96,57,23,163,136,131,116,70,109,5,14,149,108,104,0,10,33,156,192,186,217,74,35,181,5,143,106,201,127,16,78,231,237,3,15,217,6,92,63,162,172,254,45,66,23,162,53,227,223,129,181,51,204,237,16,236,138,241,198,11,33,88,119,177,201,149,114,170,37,23,194,221,85,102,157,172,211,78,4,217,88,120,213,140,142,202,233,8,48,48,46,173,29,23,194,39,143,114,66,29,17,210,0,138,20,236,35,125,110,38,190,22,249,147,196,245,117,10,141,122,98,35,93,35,28,128,39,52,45,38,116,176,160,91,247,142,54,5,178,106,154,35,5,69,84,99,13,190,58,208,194,128,176,20,14,43,113,165,110,88,189,240,164,7,77,95,8,20,165,59,159,48,31,159,237,177,194,12,69,7,222,149,191,59,16,184,227,76,16,225,147,236,129,240,144,252,163,222,226,133,243,8,97,201,79,149,119,181,22,71,233,55,224,2,116,63,126,50,58,224,83,46,216,64,34,2,64,215,20,198,253,83,66,59,224,169,231,95,117,56,134,152,147,147,62,244,39,96,245,131,122,199,167,222,59,218,225,176,78,115,235,127,44,162,188,207,57,152,226,134,218,36,34,66,30,18,217,50,118,129,13,94,85,202,123,181,66,60,124,89,115,249,133,42,82,200,61,48,248,194,140,195,113,72,15,211,1,230,31,24,106,126,157,193,114,244,28,177,100,199,58,194,15,225,206,216,121,108,95,166,106,232,216,157,238,206,211,66,200,117,180,113,118,180,63,133,172,151,84,143,97,28,105,46,226,75,194,180,193,194,78,201,211,9,79,212,226,212,200,102,76,128,215,209,146,73,47,175,250,139,20,98,64,220,164,180,117,26,141,45,169,98,200,223,78,11,38,8,105,192,110,190,183,40,65,184,194,24,12,9,233,36,115,107,71,175,110,77,126,230,19,101,136,180,145,58,126,231,154,91,201,83,155,194,215,12,188,97,35,134,169,91,220,9,80,156,157,62,230,246,214,216,242,49,227,14,24,67,68,179,80,125,52,153,236,40,196,10,217,181,188,247,118,150,196,181,111,215,128,87,91,7,202,22,37,172,103,217,255,37,117,208,9,246,174,204,105,176,1,9,42,191,204,183,101,5,90,155,230,188,227,226,250,65,186,119,5,5,23,153,242,0,99,234,51,61,31,14,58,151,175,86,44,247,40,231,226,92,43,59,69,66,207,167,37,106,32,181,150,54,107,168,55,121,164,41,195,74,43,220,173,218,180,7,38,250,237,200,135,51,249,231,201,208,179,12,151,127,23,228,218,89,19,132,154,173,71,72,34,174,19,139,231,2,207,202,32,171,152,27,3,207,218,72,200,102,135,86,178,80,6,187,56,156,57,213,160,33,205,209,81,199,89,79,168,254,139,72,202,9,91,132,216,89,29,152,113,145,230,129,3,211,145,130,164,112,229,103,36,112,71,67,241,8,96,170,30,0,198,68,130,101,20,2,227,55,206,127,138,42,36,87,66,117,175,21,16,234,121,64,169,236,199,61,63,16,184,202,190,189,124,6,127,228,215,167,127,240,111,29,58,105,42,56,244,206,169,0,73,110,143,109,182,200,248,199,86,243,158,237,92,139,126,196,14,0,162,82,46,157,12,120,135,25,28,116,233,162,250,24,173,164,86,15,172,138,13,67,209,243,35,126,117,136,229,181,37,99,78,8,224,253,57,102,169,77,174,69,46,253,70,248,190,196,248,113,222,240,82,71,60,155,86,64,127,61,28,90,87,173,247,199,67,16,200,155,23,81,40,87,157,76,72,117,159,163,35,218,117,19,76,55,153,179,164,158,204,170,103,41,148,126,190,210,229,162,240,50,101,192,201,109,157,255,65,4,173,50,181,157,178,241,245,85,41,223,84,146,133,184,201,14,155,175,40,123,136,253,10,197,153,183,161,28,74,36,91,223,8,206,95,147,53,187,84,73,151,66,66,24,11,224,23,171,12,190,165,205,183,228,197,131,170,153,43,39,123,18,164,182,108,12,11,36,49,216,86,110,202,173,188,19,26,211,172,119,151,246,76,121,52,168,214,24,70,249,239,184,93,128,135,7,243,97,216,7,168,159,103,3,82,100,120,26,91,144,154,213,234,234,199,142,134,82,108,25,161,149,56,128,65,136,9,136,35,20,15,254,228,210,207,104,152,78,245,97,75,167,187,52,243,77,104,242,89,117,145,153,206,148,167,72,254,154,86,132,164,231,178,35,149,122,186,40,223,144,134,39,231,35,205,133,15,67,90,58,31,163,189,8,132,97,55,215,62,225,205,207,211,141,221,146,247,19,118,52,85,124,80,208,61,72,115,243,185,123,179,97,151,172,146,65,149,208,46,13,187,211,21,172,82,232,221,200,129,15,160,157,189,59,215,4,70,159,203,162,228,37,213,47,126,163,137,91,107,253,242,247,169,121,16,55,182,32,197,3,155,185,253,87,97,166,151,77,161,71,238,50,252,182,186,62,4,101,213,153,209,124,237,34,101,117,247,46,140,30,3,195,227,187,63,32,20,224,85,224,6,140,31,14,173,228,131,161,92,47,64,7,250,181,149,90,93,55,186,227,159,222,188,2,87,49,230,2,136,208,239,182,66,148,255,231,77,52,19,173,180,134,3,143,142,172,140,243,59,39,238,34,111,18,110,234,185,102,222,2,170,225,129,86,24,159,79,229,203,53,86,243,59,130,253,187,151,0,61,159,153,72,192,149,58,174,116,109,157,188,247,142,213,222,98,49,129,226,48,13,6,9,43,6,1,4,1,130,55,17,2,49,0,48,19,6,9,42,134,72,134,247,13,1,9,21,49,6,4,4,1,0,0,0,48,93,6,9,42,134,72,134,247,13,1,9,20,49,80,30,78,0,116,0,101,0,45,0,53,0,57,0,50,0,48,0,56,0,51,0,50,0,100,0,45,0,50,0,50,0,98,0,57,0,45,0,52,0,98,0,48,0,54,0,45,0,56,0,57,0,50,0,54,0,45,0,102,0,97,0,98,0,56,0,51,0,52,0,99,0,49,0,55,0,51,0,57,0,55,48,93,6,9,43,6,1,4,1,130,55,17,1,49,80,30,78,0,77,0,105,0,99,0,114,0,111,0,115,0,111,0,102,0,116,0,32,0,83,0,111,0,102,0,116,0,119,0,97,0,114,0,101,0,32,0,75,0,101,0,121,0,32,0,83,0,116,0,111,0,114,0,97,0,103,0,101,0,32,0,80,0,114,0,111,0,118,0,105,0,100,0,101,0,114,48,130,3,223,6,9,42,134,72,134,247,13,1,7,6,160,130,3,208,48,130,3,204,2,1,0,48,130,3,197,6,9,42,134,72,134,247,13,1,7,1,48,28,6,10,42,134,72,134,247,13,1,12,1,3,48,14,4,8,214,81,167,28,241,31,30,206,2,2,7,208,128,130,3,152,253,185,228,156,166,74,70,154,36,22,89,54,196,161,168,68,62,230,221,254,51,153,72,247,108,10,115,58,196,238,45,66,44,45,40,231,102,43,166,8,67,139,141,126,30,106,239,246,16,31,10,95,21,162,226,130,141,183,224,79,232,249,115,88,154,165,44,116,237,236,112,184,134,137,140,228,119,11,5,69,53,203,227,94,60,164,75,192,47,177,1,175,223,49,141,203,255,34,109,231,136,14,241,52,130,179,15,226,243,210,16,204,253,193,131,220,164,93,134,100,129,5,191,250,1,161,25,9,200,128,20,130,145,53,23,140,107,86,58,129,223,173,156,72,78,113,160,146,65,177,224,12,186,209,181,198,56,63,72,38,81,217,194,45,135,4,84,182,137,117,118,133,241,84,253,253,33,53,175,3,60,174,47,36,145,43,91,101,43,168,132,237,126,202,200,116,3,106,77,21,77,60,17,45,240,207,102,25,24,210,74,79,171,203,89,99,171,46,7,133,91,16,182,238,3,93,224,65,24,226,17,151,152,94,98,125,148,5,220,104,9,100,134,230,99,77,29,210,223,221,59,10,19,103,249,19,163,83,89,111,132,98,80,15,44,244,97,211,151,87,68,22,113,244,121,74,50,26,208,227,234,58,182,238,178,114,196,232,151,232,84,162,130,246,33,213,85,21,122,233,68,173,20,33,95,135,159,211,172,50,45,198,42,170,223,202,45,155,169,120,205,151,190,150,74,121,32,242,73,31,111,46,98,199,23,159,169,58,69,57,222,149,242,95,181,232,24,135,47,7,220,147,52,61,56,116,169,204,169,240,230,145,6,17,23,88,119,245,184,206,27,28,139,84,157,93,100,222,235,1,19,82,13,144,73,127,217,22,217,183,79,28,249,144,63,4,198,177,219,204,5,52,118,158,73,32,53,187,2,138,255,64,74,19,44,226,9,7,123,9,145,34,210,0,22,57,230,96,172,81,206,131,32,45,153,69,192,25,75,157,38,18,205,119,99,163,196,216,142,105,192,121,28,23,161,198,83,5,178,65,168,213,138,197,166,89,124,88,110,90,213,73,123,19,52,67,70,25,180,191,164,120,248,103,116,99,106,34,78,228,55,99,96,47,56,76,239,47,170,103,30,16,118,86,194,73,213,229,164,112,168,248,153,164,187,102,185,251,221,167,139,231,198,119,223,251,47,82,197,23,52,11,42,245,167,223,100,26,95,223,140,131,37,108,4,6,37,54,194,202,54,89,200,36,31,81,9,157,62,112,215,229,244,105,114,121,27,89,35,16,101,242,68,124,244,149,42,202,61,193,7,52,67,134,239,74,59,130,223,88,42,254,187,86,247,206,1,217,26,223,202,167,199,31,77,23,143,99,139,68,142,161,233,30,123,212,73,17,212,62,42,215,144,174,167,242,235,159,83,243,205,24,103,237,210,198,96,151,249,19,162,102,100,3,110,157,63,113,220,3,118,174,130,212,71,108,165,34,170,206,31,240,211,56,243,103,88,109,50,233,71,46,110,232,208,140,210,30,173,148,115,168,125,74,203,28,140,73,69,186,79,181,234,236,74,55,133,118,246,58,21,246,89,120,212,166,129,182,228,193,78,230,114,168,181,63,164,85,68,86,92,154,244,103,240,244,126,115,134,194,78,211,162,149,74,248,225,182,210,21,15,11,20,37,101,107,96,65,190,194,18,56,42,171,50,191,189,75,175,40,92,154,114,161,177,252,114,89,180,119,143,70,125,187,54,4,30,121,179,67,136,197,14,219,172,185,68,226,167,2,221,10,16,44,0,234,116,70,146,117,132,165,113,146,249,221,126,56,111,168,137,136,54,9,30,86,140,180,150,103,232,208,125,153,192,152,59,173,107,30,122,39,117,217,85,81,62,152,16,63,129,45,96,16,213,137,213,199,37,124,197,199,102,66,188,92,232,142,170,52,61,82,224,227,162,41,252,156,116,196,161,113,126,64,234,207,89,5,146,21,18,147,234,22,244,66,242,131,23,3,105,44,43,178,47,242,110,19,242,101,6,91,121,157,9,59,245,12,234,65,125,103,244,213,114,131,177,18,76,188,48,59,48,31,48,7,6,5,43,14,3,2,26,4,20,47,103,153,234,19,89,118,152,198,100,80,184,21,42,139,82,249,121,221,73,4,20,197,190,54,187,203,64,251,171,142,28,173,106,125,51,50,31,184,10,167,38,2,2,7,208 };

		[Test]
		public void PublicKeyIsReusable()
		{
			var cert = new X509Certificate2 (selfSignedCertData, "MonoTemp123");
			var src = new byte[] { 1, 2, 3, 4, 5, 6, 7, 8 };
			var padding = RSAEncryptionPadding.Pkcs1;
			byte[] encrypted1 = EncryptData (cert, src, padding);
			byte[] encrypted2 = EncryptData (cert, src, padding);

			RSA privateKey = cert.GetRSAPrivateKey ();
			byte[] decrypted1 = DecryptData (cert, encrypted1, padding);
			byte[] decrypted2 = DecryptData (cert, encrypted2, padding);

			CollectionAssert.AreEqual (src, decrypted1);
			CollectionAssert.AreEqual (src, decrypted2);
		}

		static byte[] EncryptData(X509Certificate2 cert, byte[] data, RSAEncryptionPadding padding)
		{
			using (RSA rsa = cert.GetRSAPublicKey ())
				return rsa.Encrypt (data, padding);
		}

		static byte[] DecryptData(X509Certificate2 cert, byte[] data, RSAEncryptionPadding padding)
		{
			using (RSA rsa = cert.GetRSAPrivateKey ())
				return rsa.Decrypt (data, padding);
		}
	}
}