//
// System.Drawing.gdipEnums.cs
//
// Authors:
//	Alexandre Pigolkine (pigolkine@gmx.de)
//	Sebastien Pouliot  <sebastien@ximian.com>
//
// Copyright (C) 2004, 2007 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

namespace System.Drawing {

	internal enum Status {
		Ok = 0,
		GenericError = 1,
		InvalidParameter = 2,
		OutOfMemory = 3,
		ObjectBusy = 4,
		InsufficientBuffer = 5,
		NotImplemented = 6,
		Win32Error = 7,
		WrongState = 8,
		Aborted = 9,
		FileNotFound = 10,
		ValueOverflow = 11,
		AccessDenied = 12,
		UnknownImageFormat = 13,
		FontFamilyNotFound = 14,
		FontStyleNotFound = 15,
		NotTrueTypeFont = 16,
		UnsupportedGdiplusVersion = 17,
		GdiplusNotInitialized = 18,
		PropertyNotFound = 19,
		PropertyNotSupported = 20,
		ProfileNotFound = 21
	}

        internal enum BrushType {
                BrushTypeSolidColor = 0,
                BrushTypeHatchFill = 1,
                BrushTypeTextureFill = 2,
                BrushTypePathGradient = 3,
                BrushTypeLinearGradient = 4
        }

	internal enum ImageType {
		Unknown = 0,
		Bitmap = 1,
		Metafile = 2
	}

	internal enum GetSysColorIndex {
		COLOR_SCROLLBAR			= 0,
		COLOR_BACKGROUND		= 1,
		COLOR_ACTIVECAPTION		= 2,
		COLOR_INACTIVECAPTION		= 3,
		COLOR_MENU			= 4,
		COLOR_WINDOW			= 5,
		COLOR_WINDOWFRAME		= 6,
		COLOR_MENUTEXT			= 7,
		COLOR_WINDOWTEXT		= 8,
		COLOR_CAPTIONTEXT		= 9,
		COLOR_ACTIVEBORDER		= 10,
		COLOR_INACTIVEBORDER		= 11,
		COLOR_APPWORKSPACE		= 12,
		COLOR_HIGHLIGHT			= 13,
		COLOR_HIGHLIGHTTEXT		= 14,
		COLOR_BTNFACE			= 15,
		COLOR_BTNSHADOW			= 16,
		COLOR_GRAYTEXT			= 17,
		COLOR_BTNTEXT			= 18,
		COLOR_INACTIVECAPTIONTEXT	= 19,
		COLOR_BTNHIGHLIGHT		= 20,
		COLOR_3DDKSHADOW		= 21,
		COLOR_3DLIGHT			= 22,
		COLOR_INFOTEXT			= 23,
		COLOR_INFOBK			= 24,
			
		COLOR_HOTLIGHT			= 26,
		COLOR_GRADIENTACTIVECAPTION	= 27,
		COLOR_GRADIENTINACTIVECAPTION	= 28,
		COLOR_MENUHIGHLIGHT		= 29,
		COLOR_MENUBAR			= 30,

		COLOR_DESKTOP			= 1,
		COLOR_3DFACE			= 16,
		COLOR_3DSHADOW			= 16,
		COLOR_3DHIGHLIGHT		= 20,
		COLOR_3DHILIGHT			= 20,
		COLOR_BTNHILIGHT		= 20,

		COLOR_MAXVALUE			= 30,/* Maximum value */
	}       
}
