// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Copyright (c) 2005 Novell, Inc. (http://www.novell.com)
//
// Author:
//	Pedro Martínez Juliá <pedromj@gmail.com>
//


namespace System.Windows.Forms {

	public class DataGridViewCellFormattingEventArgs : ConvertEventArgs {

		private int columnIndex;
		private DataGridViewCellStyle cellStyle;
		private bool formattingApplied = false;
		private int rowIndex;

		public DataGridViewCellFormattingEventArgs (int columnIndex, int rowIndex, object value, Type desiredType, DataGridViewCellStyle cellStyle) : base (value, desiredType) {
			this.columnIndex = columnIndex;
			this.rowIndex = rowIndex;
			this.cellStyle = cellStyle;
		}

		public DataGridViewCellStyle CellStyle {
			get { return cellStyle; }
			set {
				cellStyle = value;
			}
		}

		public int ColumnIndex {
			get { return columnIndex; }
		}

		////////////////////////////////////////////////
		public bool FormattingApplied {
			get { return formattingApplied; }
			set { formattingApplied = value; }
		}

		public int RowIndex {
			get { return rowIndex; }
		}

	}

}

