// instantiate pll with both original and generated clocks available
// pass clocks to test points out1, out2

module top(
	input clk12m_in,
	output out1,
	output out2
	);

wire clk25m;
wire clk12m;

pll pll0(
	.PACKAGEPIN(clk12m_in),
	.PLLOUTGLOBALA(clk12m),
	.PLLOUTGLOBALB(clk25m),
	.PLLOUTCOREA(),
	.PLLOUTCOREB(),
	.LOCK(),
	.RESET(1'b1)
	);

assign out1 = clk25m;
assign out2 = clk12m;

endmodule


// below generated by lattice icecube2

module pll(PACKAGEPIN,
           PLLOUTCOREA,
           PLLOUTCOREB,
           PLLOUTGLOBALA,
           PLLOUTGLOBALB,
           RESET,
           LOCK);

inout PACKAGEPIN;
input RESET;    /* To initialize the simulation properly, the RESET signal (Active Low) must be asserted at the beginning of the simulation */ 
output PLLOUTCOREA;
output PLLOUTCOREB;
output PLLOUTGLOBALA;
output PLLOUTGLOBALB;
output LOCK;

SB_PLL40_2_PAD pll_inst(.PACKAGEPIN(PACKAGEPIN),
                        .PLLOUTCOREA(PLLOUTCOREA),
                        .PLLOUTCOREB(PLLOUTCOREB),
                        .PLLOUTGLOBALA(PLLOUTGLOBALA),
                        .PLLOUTGLOBALB(PLLOUTGLOBALB),
                        .EXTFEEDBACK(),
                        .DYNAMICDELAY(),
                        .RESETB(RESET),
                        .BYPASS(1'b0),
                        .LATCHINPUTVALUE(),
                        .LOCK(LOCK),
                        .SDI(),
                        .SDO(),
                        .SCLK());

//\\ Fin=12, Fout=25;
defparam pll_inst.DIVR = 4'b0000;
defparam pll_inst.DIVF = 7'b1000010;
defparam pll_inst.DIVQ = 3'b101;
defparam pll_inst.FILTER_RANGE = 3'b001;
defparam pll_inst.FEEDBACK_PATH = "SIMPLE";
defparam pll_inst.DELAY_ADJUSTMENT_MODE_FEEDBACK = "FIXED";
defparam pll_inst.FDA_FEEDBACK = 4'b0000;
defparam pll_inst.SHIFTREG_DIV_MODE = 2'b00;
defparam pll_inst.PLLOUT_SELECT_PORTB = "GENCLK";
defparam pll_inst.ENABLE_ICEGATE_PORTA = 1'b0;
defparam pll_inst.ENABLE_ICEGATE_PORTB = 1'b0;

endmodule
