/*
 * Copyright (c) 2008-2025 Jonathan Schleifer <js@nil.im>
 *
 * All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3.0 only,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3.0 along with this program. If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* This file is automatically generated from amiga-library.xml */

#include "config.h"

#import "amiga-library-glue.h"

__asm__ (
    ".section .text\n"
    ".align 2\n"
    "__restore_r13:\n"
    "	lwz	%r13, 44(%r12)\n"
    "	blr\n"
);

bool __saveds
glue_objc_init(unsigned int version, struct objc_linklib_context *_Nonnull ctx)
{
	return objc_init(version, ctx);
}

void __saveds
glue___objc_exec_class(struct objc_module *_Nonnull module)
{
	__objc_exec_class(module);
}

IMP _Nonnull __saveds
glue_objc_msg_lookup(id _Nullable object, SEL _Nonnull selector)
{
	return objc_msg_lookup(object, selector);
}

IMP _Nonnull __saveds
glue_objc_msg_lookup_stret(id _Nullable object, SEL _Nonnull selector)
{
	return objc_msg_lookup_stret(object, selector);
}

IMP _Nonnull __saveds
glue_objc_msg_lookup_super(struct objc_super *_Nonnull super, SEL _Nonnull selector)
{
	return objc_msg_lookup_super(super, selector);
}

IMP _Nonnull __saveds
glue_objc_msg_lookup_super_stret(struct objc_super *_Nonnull super, SEL _Nonnull selector)
{
	return objc_msg_lookup_super_stret(super, selector);
}

Class _Nullable __saveds
glue_objc_lookUpClass(const char *_Nonnull name)
{
	return objc_lookUpClass(name);
}

Class _Nullable __saveds
glue_objc_getClass(const char *_Nonnull name)
{
	return objc_getClass(name);
}

Class _Nonnull __saveds
glue_objc_getRequiredClass(const char *_Nonnull name)
{
	return objc_getRequiredClass(name);
}

Class _Nullable __saveds
glue_objc_lookup_class(const char *_Nonnull name)
{
	return objc_lookup_class(name);
}

Class _Nonnull __saveds
glue_objc_get_class(const char *_Nonnull name)
{
	return objc_get_class(name);
}

void __saveds
glue_objc_exception_throw(id _Nonnull object)
{
	objc_exception_throw(object);
}

int __saveds
glue_objc_sync_enter(id _Nullable object)
{
	return objc_sync_enter(object);
}

int __saveds
glue_objc_sync_exit(id _Nullable object)
{
	return objc_sync_exit(object);
}

id _Nullable __saveds
glue_objc_getProperty(id _Nonnull self, SEL _Nonnull _cmd, ptrdiff_t offset, bool atomic)
{
	return objc_getProperty(self, _cmd, offset, atomic);
}

void __saveds
glue_objc_setProperty(id _Nonnull self, SEL _Nonnull _cmd, ptrdiff_t offset, id _Nullable value, bool atomic, signed char copy)
{
	objc_setProperty(self, _cmd, offset, value, atomic, copy);
}

void __saveds
glue_objc_getPropertyStruct(void *_Nonnull dest, const void *_Nonnull src, ptrdiff_t size, bool atomic, bool strong)
{
	objc_getPropertyStruct(dest, src, size, atomic, strong);
}

void __saveds
glue_objc_setPropertyStruct(void *_Nonnull dest, const void *_Nonnull src, ptrdiff_t size, bool atomic, bool strong)
{
	objc_setPropertyStruct(dest, src, size, atomic, strong);
}

void __saveds
glue_objc_enumerationMutation(id _Nonnull object)
{
	objc_enumerationMutation(object);
}

int __saveds
glue___gnu_objc_personality_v0(int version, int actions, uint64_t _Nonnull exClass, void *_Nonnull ex, void *_Nonnull ctx)
{
	return __gnu_objc_personality_v0(version, actions, exClass, ex, ctx);
}

id _Nullable __saveds
glue_objc_retain(id _Nullable object)
{
	return objc_retain(object);
}

id _Nullable __saveds
glue_objc_retainBlock(id _Nullable block)
{
	return objc_retainBlock(block);
}

id _Nullable __saveds
glue_objc_retainAutorelease(id _Nullable object)
{
	return objc_retainAutorelease(object);
}

void __saveds
glue_objc_release(id _Nullable object)
{
	objc_release(object);
}

id _Nullable __saveds
glue_objc_autorelease(id _Nullable object)
{
	return objc_autorelease(object);
}

id _Nullable __saveds
glue_objc_autoreleaseReturnValue(id _Nullable object)
{
	return objc_autoreleaseReturnValue(object);
}

id _Nullable __saveds
glue_objc_retainAutoreleaseReturnValue(id _Nullable object)
{
	return objc_retainAutoreleaseReturnValue(object);
}

id _Nullable __saveds
glue_objc_retainAutoreleasedReturnValue(id _Nullable object)
{
	return objc_retainAutoreleasedReturnValue(object);
}

id _Nullable __saveds
glue_objc_storeStrong(id _Nullable *_Nonnull object, id _Nullable value)
{
	return objc_storeStrong(object, value);
}

id _Nullable __saveds
glue_objc_storeWeak(id _Nullable *_Nonnull object, id _Nullable value)
{
	return objc_storeWeak(object, value);
}

id _Nullable __saveds
glue_objc_loadWeakRetained(id _Nullable *_Nonnull object)
{
	return objc_loadWeakRetained(object);
}

id _Nullable __saveds
glue_objc_initWeak(id _Nullable *_Nonnull object, id _Nullable value)
{
	return objc_initWeak(object, value);
}

void __saveds
glue_objc_destroyWeak(id _Nullable *_Nonnull object)
{
	objc_destroyWeak(object);
}

id _Nullable __saveds
glue_objc_loadWeak(id _Nullable *_Nonnull object)
{
	return objc_loadWeak(object);
}

void __saveds
glue_objc_copyWeak(id _Nullable *_Nonnull dest, id _Nullable *_Nonnull src)
{
	objc_copyWeak(dest, src);
}

void __saveds
glue_objc_moveWeak(id _Nullable *_Nonnull dest, id _Nullable *_Nonnull src)
{
	objc_moveWeak(dest, src);
}

SEL _Nonnull __saveds
glue_sel_registerName(const char *_Nonnull name)
{
	return sel_registerName(name);
}

const char *_Nonnull __saveds
glue_sel_getName(SEL _Nonnull selector)
{
	return sel_getName(selector);
}

bool __saveds
glue_sel_isEqual(SEL _Nonnull selector1, SEL _Nonnull selector2)
{
	return sel_isEqual(selector1, selector2);
}

Class _Nonnull __saveds
glue_objc_allocateClassPair(Class _Nullable superclass, const char *_Nonnull name, size_t extraBytes)
{
	return objc_allocateClassPair(superclass, name, extraBytes);
}

void __saveds
glue_objc_registerClassPair(Class _Nonnull class_)
{
	objc_registerClassPair(class_);
}

unsigned int __saveds
glue_objc_getClassList(Class _Nonnull *_Nullable buffer, unsigned int count)
{
	return objc_getClassList(buffer, count);
}

Class _Nonnull *_Nonnull __saveds
glue_objc_copyClassList(unsigned int *_Nullable length)
{
	return objc_copyClassList(length);
}

bool __saveds
glue_class_isMetaClass(Class _Nullable class_)
{
	return class_isMetaClass(class_);
}

const char *_Nullable __saveds
glue_class_getName(Class _Nullable class_)
{
	return class_getName(class_);
}

Class _Nullable __saveds
glue_class_getSuperclass(Class _Nullable class_)
{
	return class_getSuperclass(class_);
}

unsigned long __saveds
glue_class_getInstanceSize(Class _Nullable class_)
{
	return class_getInstanceSize(class_);
}

bool __saveds
glue_class_respondsToSelector(Class _Nullable class_, SEL _Nonnull selector)
{
	return class_respondsToSelector(class_, selector);
}

bool __saveds
glue_class_conformsToProtocol(Class _Nullable class_, Protocol *_Nonnull p)
{
	return class_conformsToProtocol(class_, p);
}

IMP _Nullable __saveds
glue_class_getMethodImplementation(Class _Nullable class_, SEL _Nonnull selector)
{
	return class_getMethodImplementation(class_, selector);
}

IMP _Nullable __saveds
glue_class_getMethodImplementation_stret(Class _Nullable class_, SEL _Nonnull selector)
{
	return class_getMethodImplementation_stret(class_, selector);
}

#if defined(OF_MORPHOS)
const char *_Nullable __saveds
glue__class_getMethodTypeEncoding(Class _Nullable class_, SEL _Nonnull selector)
{
	return _class_getMethodTypeEncoding(class_, selector);
}
#endif

bool __saveds
glue_class_addMethod(Class _Nonnull class_, SEL _Nonnull selector, IMP _Nonnull implementation, const char *_Nullable typeEncoding)
{
	return class_addMethod(class_, selector, implementation, typeEncoding);
}

IMP _Nullable __saveds
glue_class_replaceMethod(Class _Nonnull class_, SEL _Nonnull selector, IMP _Nonnull implementation, const char *_Nullable typeEncoding)
{
	return class_replaceMethod(class_, selector, implementation, typeEncoding);
}

Class _Nullable __saveds
glue_object_getClass(id _Nullable object)
{
	return object_getClass(object);
}

Class _Nullable __saveds
glue_object_setClass(id _Nullable object, Class _Nonnull class_)
{
	return object_setClass(object, class_);
}

const char *_Nullable __saveds
glue_object_getClassName(id _Nullable object)
{
	return object_getClassName(object);
}

const char *_Nonnull __saveds
glue_protocol_getName(Protocol *_Nonnull protocol)
{
	return protocol_getName(protocol);
}

bool __saveds
glue_protocol_isEqual(Protocol *_Nonnull protocol1, Protocol *_Nonnull protocol2)
{
	return protocol_isEqual(protocol1, protocol2);
}

bool __saveds
glue_protocol_conformsToProtocol(Protocol *_Nonnull protocol1, Protocol *_Nonnull protocol2)
{
	return protocol_conformsToProtocol(protocol1, protocol2);
}

_Nullable objc_uncaught_exception_handler __saveds
glue_objc_setUncaughtExceptionHandler(objc_uncaught_exception_handler _Nullable handler)
{
	return objc_setUncaughtExceptionHandler(handler);
}

void __saveds
glue_objc_setForwardHandler(IMP _Nullable forward, IMP _Nullable stretForward)
{
	objc_setForwardHandler(forward, stretForward);
}

void __saveds
glue_objc_setEnumerationMutationHandler(objc_enumeration_mutation_handler _Nullable hadler)
{
	objc_setEnumerationMutationHandler(hadler);
}

#if defined(OF_MORPHOS)
void __saveds
glue__objc_zeroWeakReferences(id _Nullable value)
{
	_objc_zeroWeakReferences(value);
}
#endif

void __saveds
glue_objc_deinit(void)
{
	objc_deinit();
}

Ivar _Nullable *_Nullable __saveds
glue_class_copyIvarList(Class _Nullable class_, unsigned int *_Nullable outCount)
{
	return class_copyIvarList(class_, outCount);
}

const char *_Nonnull __saveds
glue_ivar_getName(Ivar _Nonnull ivar)
{
	return ivar_getName(ivar);
}

const char *_Nonnull __saveds
glue_ivar_getTypeEncoding(Ivar _Nonnull ivar)
{
	return ivar_getTypeEncoding(ivar);
}

ptrdiff_t __saveds
glue_ivar_getOffset(Ivar _Nonnull ivar)
{
	return ivar_getOffset(ivar);
}

void __saveds
glue_class_registerAlias_np(Class _Nonnull class_, const char *_Nonnull name)
{
	class_registerAlias_np(class_, name);
}

Method _Nullable __saveds
glue_class_getInstanceMethod(Class _Nullable class_, SEL _Nonnull selector)
{
	return class_getInstanceMethod(class_, selector);
}

Method _Nullable *_Nullable __saveds
glue_class_copyMethodList(Class _Nullable class_, unsigned int *_Nullable outCount)
{
	return class_copyMethodList(class_, outCount);
}

SEL _Nonnull __saveds
glue_method_getName(Method _Nonnull method)
{
	return method_getName(method);
}

const char *_Nullable __saveds
glue_method_getTypeEncoding(Method _Nonnull method)
{
	return method_getTypeEncoding(method);
}

objc_property_t _Nullable *_Nullable __saveds
glue_class_copyPropertyList(Class _Nullable class_, unsigned int *_Nullable outCount)
{
	return class_copyPropertyList(class_, outCount);
}

const char *_Nonnull __saveds
glue_property_getName(objc_property_t _Nonnull property)
{
	return property_getName(property);
}

char *_Nullable __saveds
glue_property_copyAttributeValue(objc_property_t _Nonnull property, const char *_Nonnull name)
{
	return property_copyAttributeValue(property, name);
}

id _Nullable __saveds
glue_objc_constructInstance(Class _Nullable class_, void *_Nullable bytes)
{
	return objc_constructInstance(class_, bytes);
}

void *_Nullable __saveds
glue_objc_destructInstance(id _Nullable object)
{
	return objc_destructInstance(object);
}

id _Nullable __saveds
glue_class_createInstance(Class _Nullable class_, size_t extraBytes)
{
	return class_createInstance(class_, extraBytes);
}

id _Nullable __saveds
glue_object_dispose(id _Nullable object)
{
	return object_dispose(object);
}

id _Nonnull __saveds
glue__objc_rootRetain(id _Nonnull object)
{
	return _objc_rootRetain(object);
}

unsigned int __saveds
glue__objc_rootRetainCount(id _Nonnull object)
{
	return _objc_rootRetainCount(object);
}

void __saveds
glue__objc_rootRelease(id _Nonnull object)
{
	_objc_rootRelease(object);
}

void *_Null_unspecified __saveds
glue_objc_autoreleasePoolPush(void)
{
	return objc_autoreleasePoolPush();
}

void __saveds
glue_objc_autoreleasePoolPop(void *_Null_unspecified pool)
{
	objc_autoreleasePoolPop(pool);
}

id _Nullable __saveds
glue__objc_rootAutorelease(id _Nullable object)
{
	return _objc_rootAutorelease(object);
}

void __saveds
glue_objc_setTaggedPointerSecret(uintptr_t secret)
{
	objc_setTaggedPointerSecret(secret);
}

int __saveds
glue_objc_registerTaggedPointerClass(Class _Nonnull class_)
{
	return objc_registerTaggedPointerClass(class_);
}

bool __saveds
glue_object_isTaggedPointer(id _Nullable object)
{
	return object_isTaggedPointer(object);
}

uintptr_t __saveds
glue_object_getTaggedPointerValue(id _Nonnull object)
{
	return object_getTaggedPointerValue(object);
}

id _Nullable __saveds
glue_objc_createTaggedPointer(int class_, uintptr_t value)
{
	return objc_createTaggedPointer(class_, value);
}

void __saveds
glue_objc_setAssociatedObject(id _Nonnull object, const void *_Nonnull key, id _Nullable value, objc_associationPolicy policy)
{
	objc_setAssociatedObject(object, key, value, policy);
}

id _Nullable __saveds
glue_objc_getAssociatedObject(id _Nonnull object, const void *_Nonnull key)
{
	return objc_getAssociatedObject(object, key);
}

void __saveds
glue_objc_removeAssociatedObjects(id _Nonnull object)
{
	objc_removeAssociatedObjects(object);
}
