/*
 * Copyright (c) 2017, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


/*
 * @test
 *
 * @summary converted from VM Testbase nsk/jdwp/VirtualMachine/AllClasses/allclasses001.
 * VM Testbase keywords: [jpda, jdwp]
 * VM Testbase readme:
 * DESCRIPTION
 *     This test performs checking for
 *         command set: VirtualMachine
 *         command: AllClasses
 *     Test checks that debugee accept command and replies
 *     with correct reply packet.
 *     First, test launches debuggee VM using support classes
 *     and connects to it.
 *     Then test sends AllClasses command and waits for a
 *     reply packet.
 *     Then test checks if the received reply packet has proper
 *     structure and extracts class signatures from the packet data.
 *     Also test check if debugee class signature is in the
 *     among the received classes.
 *     After JDWP command has been tested, test sends debugee VM
 *     signal to quit, waits for debugee VM exits and exits too
 *     with a proper exit code.
 *
 * @library /vmTestbase /test/hotspot/jtreg/vmTestbase
 *          /test/lib
 * @run driver jdk.test.lib.FileInstaller . .
 * @build nsk.jdwp.VirtualMachine.AllClasses.allclasses001
 *        nsk.jdwp.VirtualMachine.AllClasses.allclasses001a
 * @run main/othervm PropertyResolvingWrapper
 *      nsk.jdwp.VirtualMachine.AllClasses.allclasses001
 *      -arch=${os.family}-${os.simpleArch}
 *      -verbose
 *      -waittime=5
 *      -debugee.vmkind=java
 *      -transport.address=dynamic
 *      -debugee.vmkeys="${test.vm.opts} ${test.java.opts}"
 */

