/*
 * Copyright (c) 2013, 2015, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @bug 8007566
 * @summary DocLint too aggressive with not allowed here: <p>
 * @modules jdk.compiler/com.sun.tools.doclint
 * @build DocLintTester
 * @run main DocLintTester -Xmsgs ParaTagTest.java
 */

/**
 * First line.
 * <p> Para c1.</p>
 * <p> Para c2.
 * <p> Para c3.</p>
 */
public class ParaTagTest {
    /**
     * m1 <code>code </code>.
     * <p> Para m1.
     * <p> Para m2.
     */
    public void m() {}

    /**
     * m2.
     * <p> Para z1.
     * <p> Para z2.
     * <pre>
     *    Preformat 1.
     * </pre>
     */
    public void z() {}
}
