/*
 * Copyright (c) 2015-2020 Cisco Systems, Inc.  All rights reserved
 * Copyright (c) 2019-2020 Intel, Inc.  All rights reserved.
 * Copyright (c) 2019      Research Organization for Information Science
 *                         and Technology (RIST).  All rights reserved.
 * Copyright (c) 2022      Nanook Consulting.  All rights reserved.
 * $COPYRIGHT$
 *
 * Additional copyrights may follow
 *
 * $HEADER$
 */

#ifndef PRTE_DL_DLOPEN
#define PRTE_DL_DLOPEN

#include "prte_config.h"

#include "src/mca/prtedl/prtedl.h"

PRTE_EXPORT extern prte_prtedl_base_module_t prte_prtedl_dlopen_module;

/*
 * Dynamic library handles generated by this component.
 *
 * If we're debugging, keep a copy of the name of the file we've opened.
 */
struct prte_dl_handle_t {
    void *dlopen_handle;
#if PRTE_ENABLE_DEBUG
    void *filename;
#endif
};

typedef struct {
    prte_prtedl_base_component_t base;

    char *filename_suffixes_mca_storage;
    char **filename_suffixes;
} prte_prtedl_dlopen_component_t;

PRTE_EXPORT extern prte_prtedl_dlopen_component_t prte_mca_prtedl_dlopen_component;

#endif /* PRTE_DL_DLOPEN */
