# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.netapp.aio import NetAppManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetAppManagementVolumesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetAppManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_list(self, resource_group):
        response = self.client.volumes.list(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            api_version="2025-06-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_get(self, resource_group):
        response = await self.client.volumes.get(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            volume_name="str",
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.volumes.begin_create_or_update(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                body={
                    "creationToken": "str",
                    "location": "str",
                    "subnetId": "str",
                    "usageThreshold": 107374182400,
                    "acceptGrowCapacityPoolForShortTermCloneSplit": "str",
                    "actualThroughputMibps": 0.0,
                    "avsDataStore": "Disabled",
                    "backupId": "str",
                    "baremetalTenantId": "str",
                    "capacityPoolResourceId": "str",
                    "cloneProgress": 0,
                    "coolAccess": False,
                    "coolAccessRetrievalPolicy": "str",
                    "coolAccessTieringPolicy": "str",
                    "coolnessPeriod": 0,
                    "dataProtection": {
                        "backup": {"backupPolicyId": "str", "backupVaultId": "str", "policyEnforced": bool},
                        "replication": {
                            "destinationReplications": [
                                {"region": "str", "replicationType": "str", "resourceId": "str", "zone": "str"}
                            ],
                            "endpointType": "str",
                            "remotePath": {"externalHostName": "str", "serverName": "str", "volumeName": "str"},
                            "remoteVolumeRegion": "str",
                            "remoteVolumeResourceId": "str",
                            "replicationId": "str",
                            "replicationSchedule": "str",
                        },
                        "snapshot": {"snapshotPolicyId": "str"},
                        "volumeRelocation": {"readyToBeFinalized": bool, "relocationRequested": bool},
                    },
                    "dataStoreResourceId": ["str"],
                    "defaultGroupQuotaInKiBs": 0,
                    "defaultUserQuotaInKiBs": 0,
                    "deleteBaseSnapshot": bool,
                    "effectiveNetworkFeatures": "Basic",
                    "enableSubvolumes": "Disabled",
                    "encrypted": bool,
                    "encryptionKeySource": "Microsoft.NetApp",
                    "etag": "str",
                    "exportPolicy": {
                        "rules": [
                            {
                                "allowedClients": "str",
                                "chownMode": "Restricted",
                                "cifs": bool,
                                "hasRootAccess": True,
                                "kerberos5ReadOnly": False,
                                "kerberos5ReadWrite": False,
                                "kerberos5iReadOnly": False,
                                "kerberos5iReadWrite": False,
                                "kerberos5pReadOnly": False,
                                "kerberos5pReadWrite": False,
                                "nfsv3": bool,
                                "nfsv41": bool,
                                "ruleIndex": 0,
                                "unixReadOnly": bool,
                                "unixReadWrite": bool,
                            }
                        ]
                    },
                    "fileAccessLogs": "Disabled",
                    "fileSystemId": "str",
                    "id": "str",
                    "inheritedSizeInBytes": 0,
                    "isDefaultQuotaEnabled": False,
                    "isLargeVolume": False,
                    "isRestoring": bool,
                    "kerberosEnabled": False,
                    "keyVaultPrivateEndpointResourceId": "str",
                    "ldapEnabled": False,
                    "maximumNumberOfFiles": 0,
                    "mountTargets": [
                        {"fileSystemId": "str", "ipAddress": "str", "mountTargetId": "str", "smbServerFqdn": "str"}
                    ],
                    "name": "str",
                    "networkFeatures": "Basic",
                    "networkSiblingSetId": "str",
                    "originatingResourceId": "str",
                    "placementRules": [{"key": "str", "value": "str"}],
                    "protocolTypes": ["str"],
                    "provisionedAvailabilityZone": "str",
                    "provisioningState": "str",
                    "proximityPlacementGroup": "str",
                    "securityStyle": "unix",
                    "serviceLevel": "Premium",
                    "smbAccessBasedEnumeration": "str",
                    "smbContinuouslyAvailable": False,
                    "smbEncryption": False,
                    "smbNonBrowsable": "str",
                    "snapshotDirectoryVisible": True,
                    "snapshotId": "str",
                    "storageToNetworkProximity": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "t2Network": "str",
                    "tags": {"str": "str"},
                    "throughputMibps": 0.0,
                    "type": "str",
                    "unixPermissions": "str",
                    "volumeGroupName": "str",
                    "volumeSpecName": "str",
                    "volumeType": "str",
                    "zones": ["str"],
                },
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_update(self, resource_group):
        response = await (
            await self.client.volumes.begin_update(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                body={
                    "coolAccess": bool,
                    "coolAccessRetrievalPolicy": "str",
                    "coolAccessTieringPolicy": "str",
                    "coolnessPeriod": 0,
                    "dataProtection": {
                        "backup": {"backupPolicyId": "str", "backupVaultId": "str", "policyEnforced": bool},
                        "snapshot": {"snapshotPolicyId": "str"},
                    },
                    "defaultGroupQuotaInKiBs": 0,
                    "defaultUserQuotaInKiBs": 0,
                    "exportPolicy": {
                        "rules": [
                            {
                                "allowedClients": "str",
                                "chownMode": "Restricted",
                                "cifs": bool,
                                "hasRootAccess": True,
                                "kerberos5ReadOnly": False,
                                "kerberos5ReadWrite": False,
                                "kerberos5iReadOnly": False,
                                "kerberos5iReadWrite": False,
                                "kerberos5pReadOnly": False,
                                "kerberos5pReadWrite": False,
                                "nfsv3": bool,
                                "nfsv41": bool,
                                "ruleIndex": 0,
                                "unixReadOnly": bool,
                                "unixReadWrite": bool,
                            }
                        ]
                    },
                    "id": "str",
                    "isDefaultQuotaEnabled": False,
                    "location": "str",
                    "name": "str",
                    "protocolTypes": ["str"],
                    "serviceLevel": "Premium",
                    "smbAccessBasedEnumeration": "str",
                    "smbNonBrowsable": "str",
                    "snapshotDirectoryVisible": bool,
                    "tags": {"str": "str"},
                    "throughputMibps": 0.0,
                    "type": "str",
                    "unixPermissions": "str",
                    "usageThreshold": 107374182400,
                },
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_delete(self, resource_group):
        response = await (
            await self.client.volumes.begin_delete(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_populate_availability_zone(self, resource_group):
        response = await (
            await self.client.volumes.begin_populate_availability_zone(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_revert(self, resource_group):
        response = await (
            await self.client.volumes.begin_revert(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                body={"snapshotId": "str"},
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_reset_cifs_password(self, resource_group):
        response = await (
            await self.client.volumes.begin_reset_cifs_password(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_split_clone_from_parent(self, resource_group):
        response = await (
            await self.client.volumes.begin_split_clone_from_parent(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_break_file_locks(self, resource_group):
        response = await (
            await self.client.volumes.begin_break_file_locks(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_list_get_group_id_list_for_ldap_user(self, resource_group):
        response = await (
            await self.client.volumes.begin_list_get_group_id_list_for_ldap_user(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                body={"username": "str"},
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_break_replication(self, resource_group):
        response = await (
            await self.client.volumes.begin_break_replication(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_reestablish_replication(self, resource_group):
        response = await (
            await self.client.volumes.begin_reestablish_replication(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                body={"sourceVolumeId": "str"},
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_replication_status(self, resource_group):
        response = await self.client.volumes.replication_status(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            volume_name="str",
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_list_replications(self, resource_group):
        response = self.client.volumes.list_replications(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            volume_name="str",
            api_version="2025-06-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_resync_replication(self, resource_group):
        response = await (
            await self.client.volumes.begin_resync_replication(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_delete_replication(self, resource_group):
        response = await (
            await self.client.volumes.begin_delete_replication(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_authorize_replication(self, resource_group):
        response = await (
            await self.client.volumes.begin_authorize_replication(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                body={"remoteVolumeResourceId": "str"},
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_re_initialize_replication(self, resource_group):
        response = await (
            await self.client.volumes.begin_re_initialize_replication(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_peer_external_cluster(self, resource_group):
        response = await (
            await self.client.volumes.begin_peer_external_cluster(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                body={"peerIpAddresses": ["str"]},
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_authorize_external_replication(self, resource_group):
        response = await (
            await self.client.volumes.begin_authorize_external_replication(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_finalize_external_replication(self, resource_group):
        response = await (
            await self.client.volumes.begin_finalize_external_replication(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_perform_replication_transfer(self, resource_group):
        response = await (
            await self.client.volumes.begin_perform_replication_transfer(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_pool_change(self, resource_group):
        response = await (
            await self.client.volumes.begin_pool_change(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                body={"newPoolResourceId": "str"},
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_relocate(self, resource_group):
        response = await (
            await self.client.volumes.begin_relocate(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_finalize_relocation(self, resource_group):
        response = await (
            await self.client.volumes.begin_finalize_relocation(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_volumes_begin_revert_relocation(self, resource_group):
        response = await (
            await self.client.volumes.begin_revert_relocation(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                api_version="2025-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
