# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.hybridconnectivity import HybridConnectivityMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestHybridConnectivityMgmtServiceConfigurationsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(HybridConnectivityMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_service_configurations_get(self, resource_group):
        response = self.client.service_configurations.get(
            resource_uri="str",
            endpoint_name="str",
            service_configuration_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_service_configurations_create_orupdate(self, resource_group):
        response = self.client.service_configurations.create_orupdate(
            resource_uri="str",
            endpoint_name="str",
            service_configuration_name="str",
            service_configuration_resource={
                "id": "str",
                "name": "str",
                "properties": {"serviceName": "str", "port": 0, "provisioningState": "str", "resourceId": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_service_configurations_update(self, resource_group):
        response = self.client.service_configurations.update(
            resource_uri="str",
            endpoint_name="str",
            service_configuration_name="str",
            service_configuration_resource={"properties": {"port": 0}},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_service_configurations_delete(self, resource_group):
        response = self.client.service_configurations.delete(
            resource_uri="str",
            endpoint_name="str",
            service_configuration_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_service_configurations_list_by_endpoint_resource(self, resource_group):
        response = self.client.service_configurations.list_by_endpoint_resource(
            resource_uri="str",
            endpoint_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
