# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import json
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, List, Optional, Type, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._model_base import SdkJSONEncoder, _deserialize
from ...operations._operations import (
    build_indexes_create_or_update_request,
    build_indexes_get_latest_request,
    build_indexes_get_next_version_request,
    build_indexes_get_request,
    build_indexes_list_latest_request,
    build_indexes_list_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class IndexesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azureaiassetsv20240401.aio.MachineLearningServicesClient`'s
        :attr:`indexes` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(self, name: str, version: str, **kwargs: Any) -> _models.Index:
        # pylint: disable=line-too-long
        """Fetch a IndexVersion by name.

        :param name: Name of the index. Required.
        :type name: str
        :param version: Version of the index. Required.
        :type version: str
        :return: Index. The Index is compatible with MutableMapping
        :rtype: ~azureaiassetsv20240401.models.Index
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Fully qualified resource Id:
                      azureml://workspace/{workspaceName}/indexes/{name}/versions/{version} of the
                      index. Required.
                    "stage": "str",  # Update stage to 'Archive' for soft delete. Default is
                      Development, which means the asset is under development. Required.
                    "storageUri": "str",  # Default workspace blob storage Uri. Should work
                      across storage types and auth scenarios. Required.
                    "description": "str",  # Optional. Description information of the asset.
                    "properties": {
                        "str": "str"  # Optional. Asset's properties.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",  # Optional. The timestamp the
                          resource was created at.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The identity type that created
                          the resource.
                        "lastModifiedAt": "2020-02-20 00:00:00"  # Optional. The timestamp of
                          resource last modification (UTC).
                    },
                    "tags": {
                        "str": "str"  # Optional. Asset's tags.
                    }
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Index] = kwargs.pop("cls", None)

        _request = build_indexes_get_request(
            name=name,
            version=version,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
            "subscriptionId": self._serialize.url("self._config.subscription_id", self._config.subscription_id, "str"),
            "resourceGroupName": self._serialize.url(
                "self._config.resource_group_name", self._config.resource_group_name, "str"
            ),
            "workspaceName": self._serialize.url("self._config.workspace_name", self._config.workspace_name, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Index, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update(
        self, name: str, version: str, body: _models.Index, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Index:
        # pylint: disable=line-too-long
        """Creates or updates a IndexVersion.

        :param name: Name of the index. Required.
        :type name: str
        :param version: Version of the index. Required.
        :type version: str
        :param body: Properties of an Index Version. Required.
        :type body: ~azureaiassetsv20240401.models.Index
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Index. The Index is compatible with MutableMapping
        :rtype: ~azureaiassetsv20240401.models.Index
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "id": "str",  # Fully qualified resource Id:
                      azureml://workspace/{workspaceName}/indexes/{name}/versions/{version} of the
                      index. Required.
                    "stage": "str",  # Update stage to 'Archive' for soft delete. Default is
                      Development, which means the asset is under development. Required.
                    "storageUri": "str",  # Default workspace blob storage Uri. Should work
                      across storage types and auth scenarios. Required.
                    "description": "str",  # Optional. Description information of the asset.
                    "properties": {
                        "str": "str"  # Optional. Asset's properties.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",  # Optional. The timestamp the
                          resource was created at.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The identity type that created
                          the resource.
                        "lastModifiedAt": "2020-02-20 00:00:00"  # Optional. The timestamp of
                          resource last modification (UTC).
                    },
                    "tags": {
                        "str": "str"  # Optional. Asset's tags.
                    }
                }

                # response body for status code(s): 201, 200
                response == {
                    "id": "str",  # Fully qualified resource Id:
                      azureml://workspace/{workspaceName}/indexes/{name}/versions/{version} of the
                      index. Required.
                    "stage": "str",  # Update stage to 'Archive' for soft delete. Default is
                      Development, which means the asset is under development. Required.
                    "storageUri": "str",  # Default workspace blob storage Uri. Should work
                      across storage types and auth scenarios. Required.
                    "description": "str",  # Optional. Description information of the asset.
                    "properties": {
                        "str": "str"  # Optional. Asset's properties.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",  # Optional. The timestamp the
                          resource was created at.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The identity type that created
                          the resource.
                        "lastModifiedAt": "2020-02-20 00:00:00"  # Optional. The timestamp of
                          resource last modification (UTC).
                    },
                    "tags": {
                        "str": "str"  # Optional. Asset's tags.
                    }
                }
        """

    @overload
    async def create_or_update(
        self, name: str, version: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Index:
        # pylint: disable=line-too-long
        """Creates or updates a IndexVersion.

        :param name: Name of the index. Required.
        :type name: str
        :param version: Version of the index. Required.
        :type version: str
        :param body: Properties of an Index Version. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Index. The Index is compatible with MutableMapping
        :rtype: ~azureaiassetsv20240401.models.Index
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 201, 200
                response == {
                    "id": "str",  # Fully qualified resource Id:
                      azureml://workspace/{workspaceName}/indexes/{name}/versions/{version} of the
                      index. Required.
                    "stage": "str",  # Update stage to 'Archive' for soft delete. Default is
                      Development, which means the asset is under development. Required.
                    "storageUri": "str",  # Default workspace blob storage Uri. Should work
                      across storage types and auth scenarios. Required.
                    "description": "str",  # Optional. Description information of the asset.
                    "properties": {
                        "str": "str"  # Optional. Asset's properties.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",  # Optional. The timestamp the
                          resource was created at.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The identity type that created
                          the resource.
                        "lastModifiedAt": "2020-02-20 00:00:00"  # Optional. The timestamp of
                          resource last modification (UTC).
                    },
                    "tags": {
                        "str": "str"  # Optional. Asset's tags.
                    }
                }
        """

    @overload
    async def create_or_update(
        self, name: str, version: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Index:
        # pylint: disable=line-too-long
        """Creates or updates a IndexVersion.

        :param name: Name of the index. Required.
        :type name: str
        :param version: Version of the index. Required.
        :type version: str
        :param body: Properties of an Index Version. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Index. The Index is compatible with MutableMapping
        :rtype: ~azureaiassetsv20240401.models.Index
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 201, 200
                response == {
                    "id": "str",  # Fully qualified resource Id:
                      azureml://workspace/{workspaceName}/indexes/{name}/versions/{version} of the
                      index. Required.
                    "stage": "str",  # Update stage to 'Archive' for soft delete. Default is
                      Development, which means the asset is under development. Required.
                    "storageUri": "str",  # Default workspace blob storage Uri. Should work
                      across storage types and auth scenarios. Required.
                    "description": "str",  # Optional. Description information of the asset.
                    "properties": {
                        "str": "str"  # Optional. Asset's properties.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",  # Optional. The timestamp the
                          resource was created at.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The identity type that created
                          the resource.
                        "lastModifiedAt": "2020-02-20 00:00:00"  # Optional. The timestamp of
                          resource last modification (UTC).
                    },
                    "tags": {
                        "str": "str"  # Optional. Asset's tags.
                    }
                }
        """

    @distributed_trace_async
    async def create_or_update(
        self, name: str, version: str, body: Union[_models.Index, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.Index:
        # pylint: disable=line-too-long
        """Creates or updates a IndexVersion.

        :param name: Name of the index. Required.
        :type name: str
        :param version: Version of the index. Required.
        :type version: str
        :param body: Properties of an Index Version. Is one of the following types: Index, JSON,
         IO[bytes] Required.
        :type body: ~azureaiassetsv20240401.models.Index or JSON or IO[bytes]
        :return: Index. The Index is compatible with MutableMapping
        :rtype: ~azureaiassetsv20240401.models.Index
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "id": "str",  # Fully qualified resource Id:
                      azureml://workspace/{workspaceName}/indexes/{name}/versions/{version} of the
                      index. Required.
                    "stage": "str",  # Update stage to 'Archive' for soft delete. Default is
                      Development, which means the asset is under development. Required.
                    "storageUri": "str",  # Default workspace blob storage Uri. Should work
                      across storage types and auth scenarios. Required.
                    "description": "str",  # Optional. Description information of the asset.
                    "properties": {
                        "str": "str"  # Optional. Asset's properties.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",  # Optional. The timestamp the
                          resource was created at.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The identity type that created
                          the resource.
                        "lastModifiedAt": "2020-02-20 00:00:00"  # Optional. The timestamp of
                          resource last modification (UTC).
                    },
                    "tags": {
                        "str": "str"  # Optional. Asset's tags.
                    }
                }

                # response body for status code(s): 201, 200
                response == {
                    "id": "str",  # Fully qualified resource Id:
                      azureml://workspace/{workspaceName}/indexes/{name}/versions/{version} of the
                      index. Required.
                    "stage": "str",  # Update stage to 'Archive' for soft delete. Default is
                      Development, which means the asset is under development. Required.
                    "storageUri": "str",  # Default workspace blob storage Uri. Should work
                      across storage types and auth scenarios. Required.
                    "description": "str",  # Optional. Description information of the asset.
                    "properties": {
                        "str": "str"  # Optional. Asset's properties.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",  # Optional. The timestamp the
                          resource was created at.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The identity type that created
                          the resource.
                        "lastModifiedAt": "2020-02-20 00:00:00"  # Optional. The timestamp of
                          resource last modification (UTC).
                    },
                    "tags": {
                        "str": "str"  # Optional. Asset's tags.
                    }
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Index] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_indexes_create_or_update_request(
            name=name,
            version=version,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
            "subscriptionId": self._serialize.url("self._config.subscription_id", self._config.subscription_id, "str"),
            "resourceGroupName": self._serialize.url(
                "self._config.resource_group_name", self._config.resource_group_name, "str"
            ),
            "workspaceName": self._serialize.url("self._config.workspace_name", self._config.workspace_name, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.Index, response.json())

        if response.status_code == 201:
            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.Index, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list(
        self,
        name: str,
        *,
        list_view_type: str,
        order_by: Optional[str] = None,
        tags: Optional[str] = None,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.Index"]:
        # pylint: disable=line-too-long
        """The most basic operation.

        :param name: Name of the index. Required.
        :type name: str
        :keyword list_view_type: View type for including/excluding (for example) archived entities.
         Required.
        :paramtype list_view_type: str
        :keyword order_by: Ordering of list: Please choose OrderBy value from ['createdtime',
         'modifiedtime']. Default value is None.
        :paramtype order_by: str
        :keyword tags: Comma-separated list of tag names (and optionally values). Example:
         tag1,tag2=value2. Default value is None.
        :paramtype tags: str
        :keyword top: The number of result items to return. Default value is None.
        :paramtype top: int
        :keyword skip: The number of result items to skip. Default value is None.
        :paramtype skip: int
        :return: An iterator like instance of Index
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azureaiassetsv20240401.models.Index]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Fully qualified resource Id:
                      azureml://workspace/{workspaceName}/indexes/{name}/versions/{version} of the
                      index. Required.
                    "stage": "str",  # Update stage to 'Archive' for soft delete. Default is
                      Development, which means the asset is under development. Required.
                    "storageUri": "str",  # Default workspace blob storage Uri. Should work
                      across storage types and auth scenarios. Required.
                    "description": "str",  # Optional. Description information of the asset.
                    "properties": {
                        "str": "str"  # Optional. Asset's properties.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",  # Optional. The timestamp the
                          resource was created at.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The identity type that created
                          the resource.
                        "lastModifiedAt": "2020-02-20 00:00:00"  # Optional. The timestamp of
                          resource last modification (UTC).
                    },
                    "tags": {
                        "str": "str"  # Optional. Asset's tags.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.Index]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_indexes_list_request(
                    name=name,
                    list_view_type=list_view_type,
                    order_by=order_by,
                    tags=tags,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                    "subscriptionId": self._serialize.url(
                        "self._config.subscription_id", self._config.subscription_id, "str"
                    ),
                    "resourceGroupName": self._serialize.url(
                        "self._config.resource_group_name", self._config.resource_group_name, "str"
                    ),
                    "workspaceName": self._serialize.url(
                        "self._config.workspace_name", self._config.workspace_name, "str"
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                    "subscriptionId": self._serialize.url(
                        "self._config.subscription_id", self._config.subscription_id, "str"
                    ),
                    "resourceGroupName": self._serialize.url(
                        "self._config.resource_group_name", self._config.resource_group_name, "str"
                    ),
                    "workspaceName": self._serialize.url(
                        "self._config.workspace_name", self._config.workspace_name, "str"
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Index], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_latest(self, name: str, **kwargs: Any) -> _models.Index:
        # pylint: disable=line-too-long
        """Get latest Index.

        :param name: Name of the index. Required.
        :type name: str
        :return: Index. The Index is compatible with MutableMapping
        :rtype: ~azureaiassetsv20240401.models.Index
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Fully qualified resource Id:
                      azureml://workspace/{workspaceName}/indexes/{name}/versions/{version} of the
                      index. Required.
                    "stage": "str",  # Update stage to 'Archive' for soft delete. Default is
                      Development, which means the asset is under development. Required.
                    "storageUri": "str",  # Default workspace blob storage Uri. Should work
                      across storage types and auth scenarios. Required.
                    "description": "str",  # Optional. Description information of the asset.
                    "properties": {
                        "str": "str"  # Optional. Asset's properties.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",  # Optional. The timestamp the
                          resource was created at.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The identity type that created
                          the resource.
                        "lastModifiedAt": "2020-02-20 00:00:00"  # Optional. The timestamp of
                          resource last modification (UTC).
                    },
                    "tags": {
                        "str": "str"  # Optional. Asset's tags.
                    }
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Index] = kwargs.pop("cls", None)

        _request = build_indexes_get_latest_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
            "subscriptionId": self._serialize.url("self._config.subscription_id", self._config.subscription_id, "str"),
            "resourceGroupName": self._serialize.url(
                "self._config.resource_group_name", self._config.resource_group_name, "str"
            ),
            "workspaceName": self._serialize.url("self._config.workspace_name", self._config.workspace_name, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Index, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_next_version(self, name: str, **kwargs: Any) -> _models.VersionInfo:
        """Get next Index version.

        :param name: Name of the index. Required.
        :type name: str
        :return: VersionInfo. The VersionInfo is compatible with MutableMapping
        :rtype: ~azureaiassetsv20240401.models.VersionInfo
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "latestVersion": "str",  # Current latest version of the resource. Required.
                    "nextVersion": 0  # Optional. Next version as defined by the server.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.VersionInfo] = kwargs.pop("cls", None)

        _request = build_indexes_get_next_version_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
            "subscriptionId": self._serialize.url("self._config.subscription_id", self._config.subscription_id, "str"),
            "resourceGroupName": self._serialize.url(
                "self._config.resource_group_name", self._config.resource_group_name, "str"
            ),
            "workspaceName": self._serialize.url("self._config.workspace_name", self._config.workspace_name, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.VersionInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_latest(
        self, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable["_models.Index"]:
        # pylint: disable=line-too-long
        """List the latest version of each index.

        :keyword top: The number of result items to return. Default value is None.
        :paramtype top: int
        :keyword skip: The number of result items to skip. Default value is None.
        :paramtype skip: int
        :return: An iterator like instance of Index
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azureaiassetsv20240401.models.Index]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Fully qualified resource Id:
                      azureml://workspace/{workspaceName}/indexes/{name}/versions/{version} of the
                      index. Required.
                    "stage": "str",  # Update stage to 'Archive' for soft delete. Default is
                      Development, which means the asset is under development. Required.
                    "storageUri": "str",  # Default workspace blob storage Uri. Should work
                      across storage types and auth scenarios. Required.
                    "description": "str",  # Optional. Description information of the asset.
                    "properties": {
                        "str": "str"  # Optional. Asset's properties.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",  # Optional. The timestamp the
                          resource was created at.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The identity type that created
                          the resource.
                        "lastModifiedAt": "2020-02-20 00:00:00"  # Optional. The timestamp of
                          resource last modification (UTC).
                    },
                    "tags": {
                        "str": "str"  # Optional. Asset's tags.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.Index]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_indexes_list_latest_request(
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                    "subscriptionId": self._serialize.url(
                        "self._config.subscription_id", self._config.subscription_id, "str"
                    ),
                    "resourceGroupName": self._serialize.url(
                        "self._config.resource_group_name", self._config.resource_group_name, "str"
                    ),
                    "workspaceName": self._serialize.url(
                        "self._config.workspace_name", self._config.workspace_name, "str"
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                    "subscriptionId": self._serialize.url(
                        "self._config.subscription_id", self._config.subscription_id, "str"
                    ),
                    "resourceGroupName": self._serialize.url(
                        "self._config.resource_group_name", self._config.resource_group_name, "str"
                    ),
                    "workspaceName": self._serialize.url(
                        "self._config.workspace_name", self._config.workspace_name, "str"
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Index], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)
