# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field
from .._vendor import FileType

if TYPE_CHECKING:
    from .. import models as _models


class DocumentBatch(_model_base.Model):
    """Definition for the input batch translation request.

    All required parameters must be populated in order to send to server.

    :ivar source: Source of the input documents. Required.
    :vartype source: ~azure.ai.translation.document.models.SourceInput
    :ivar targets: Location of the destination for the output. Required.
    :vartype targets: list[~azure.ai.translation.document.models.TranslationTarget]
    :ivar storage_type: Storage type of the input documents source string. Known values are:
     "Folder" and "File".
    :vartype storage_type: str or ~azure.ai.translation.document.models.StorageInputType
    """

    source: "_models.SourceInput" = rest_field()
    """Source of the input documents. Required."""
    targets: List["_models.TranslationTarget"] = rest_field()
    """Location of the destination for the output. Required."""
    storage_type: Optional[Union[str, "_models.StorageInputType"]] = rest_field(name="storageType")
    """Storage type of the input documents source string. Known values are: \"Folder\" and \"File\"."""

    @overload
    def __init__(
        self,
        *,
        source: "_models.SourceInput",
        targets: List["_models.TranslationTarget"],
        storage_type: Optional[Union[str, "_models.StorageInputType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentFilter(_model_base.Model):
    """Document filter.

    :ivar prefix: A case-sensitive prefix string to filter documents in the source path for
     translation.
     For example, when using a Azure storage blob Uri, use the prefix
     to restrict sub folders for translation.
    :vartype prefix: str
    :ivar suffix: A case-sensitive suffix string to filter documents in the source path for
     translation.
     This is most often use for file extensions.
    :vartype suffix: str
    """

    prefix: Optional[str] = rest_field()
    """A case-sensitive prefix string to filter documents in the source path for
     translation.
     For example, when using a Azure storage blob Uri, use the prefix
     to restrict sub folders for translation."""
    suffix: Optional[str] = rest_field()
    """A case-sensitive suffix string to filter documents in the source path for
     translation.
     This is most often use for file extensions."""

    @overload
    def __init__(
        self,
        *,
        prefix: Optional[str] = None,
        suffix: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentStatus(_model_base.Model):
    """Document Status Response.


    :ivar translated_document_url: Location of the document or folder.
    :vartype translated_document_url: str
    :ivar source_document_url: Location of the source document. Required.
    :vartype source_document_url: str
    :ivar created_on: Operation created date time. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: Date time in which the operation's status has been updated. Required.
    :vartype last_updated_on: ~datetime.datetime
    :ivar status: List of possible statuses for job or document. Required. Known values are:
     "NotStarted", "Running", "Succeeded", "Failed", "Cancelled", "Cancelling", and
     "ValidationFailed".
    :vartype status: str or ~azure.ai.translation.document.models.Status
    :ivar translated_to: To language. Required.
    :vartype translated_to: str
    :ivar error: This contains an outer error with error code, message, details, target and an
     inner error with more descriptive details.
    :vartype error: ~azure.ai.translation.document.models.DocumentTranslationError
    :ivar translation_progress: Progress of the translation if available. Required.
    :vartype translation_progress: float
    :ivar id: Document Id. Required.
    :vartype id: str
    :ivar characters_charged: Character charged by the API.
    :vartype characters_charged: int
    """

    translated_document_url: Optional[str] = rest_field(name="path")
    """Location of the document or folder."""
    source_document_url: str = rest_field(name="sourcePath")
    """Location of the source document. Required."""
    created_on: datetime.datetime = rest_field(name="createdDateTimeUtc", format="rfc3339")
    """Operation created date time. Required."""
    last_updated_on: datetime.datetime = rest_field(name="lastActionDateTimeUtc", format="rfc3339")
    """Date time in which the operation's status has been updated. Required."""
    status: Union[str, "_models.Status"] = rest_field()
    """List of possible statuses for job or document. Required. Known values are: \"NotStarted\",
     \"Running\", \"Succeeded\", \"Failed\", \"Cancelled\", \"Cancelling\", and
     \"ValidationFailed\"."""
    translated_to: str = rest_field(name="to")
    """To language. Required."""
    error: Optional["_models.DocumentTranslationError"] = rest_field()
    """This contains an outer error with error code, message, details, target and an
     inner error with more descriptive details."""
    translation_progress: float = rest_field(name="progress")
    """Progress of the translation if available. Required."""
    id: str = rest_field()
    """Document Id. Required."""
    characters_charged: Optional[int] = rest_field(name="characterCharged")
    """Character charged by the API."""

    @overload
    def __init__(
        self,
        *,
        source_document_url: str,
        created_on: datetime.datetime,
        last_updated_on: datetime.datetime,
        status: Union[str, "_models.Status"],
        translated_to: str,
        translation_progress: float,
        id: str,  # pylint: disable=redefined-builtin
        translated_document_url: Optional[str] = None,
        error: Optional["_models.DocumentTranslationError"] = None,
        characters_charged: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentTranslateContent(_model_base.Model):
    """Document Translate Request Content.

    All required parameters must be populated in order to send to server.

    :ivar document: Document to be translated in the form. Required.
    :vartype document: ~azure.ai.translation.document._vendor.FileType
    :ivar glossary: Glossary-translation memory will be used during translation in the form.
    :vartype glossary: list[~azure.ai.translation.document._vendor.FileType]
    """

    document: FileType = rest_field(is_multipart_file_input=True)
    """Document to be translated in the form. Required."""
    glossary: Optional[List[FileType]] = rest_field(is_multipart_file_input=True)
    """Glossary-translation memory will be used during translation in the form."""

    @overload
    def __init__(
        self,
        *,
        document: FileType,
        glossary: Optional[List[FileType]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentTranslationError(_model_base.Model):
    """This contains an outer error with error code, message, details, target and an
    inner error with more descriptive details.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar code: Enums containing high level error codes. Required. Known values are:
     "InvalidRequest", "InvalidArgument", "InternalServerError", "ServiceUnavailable",
     "ResourceNotFound", "Unauthorized", and "RequestRateTooHigh".
    :vartype code: str or ~azure.ai.translation.document.models.TranslationErrorCode
    :ivar message: Gets high level error message. Required.
    :vartype message: str
    :ivar target: Gets the source of the error.
     For example it would be "documents" or
     "document id" in case of invalid document.
    :vartype target: str
    :ivar inner_error: New Inner Error format which conforms to Cognitive Services API Guidelines
     which is available at
     https://microsoft.sharepoint.com/%3Aw%3A/t/CognitiveServicesPMO/EUoytcrjuJdKpeOKIK_QRC8BPtUYQpKBi8JsWyeDMRsWlQ?e=CPq8ow.
     This
     contains required properties ErrorCode, message and optional properties target,
     details(key value pair), inner error(this can be nested).
    :vartype inner_error: ~azure.ai.translation.document.models.InnerTranslationError
    """

    code: Union[str, "_models.TranslationErrorCode"] = rest_field()
    """Enums containing high level error codes. Required. Known values are: \"InvalidRequest\",
     \"InvalidArgument\", \"InternalServerError\", \"ServiceUnavailable\", \"ResourceNotFound\",
     \"Unauthorized\", and \"RequestRateTooHigh\"."""
    message: str = rest_field()
    """Gets high level error message. Required."""
    target: Optional[str] = rest_field(visibility=["read"])
    """Gets the source of the error.
     For example it would be \"documents\" or
     \"document id\" in case of invalid document."""
    inner_error: Optional["_models.InnerTranslationError"] = rest_field(name="innerError")
    """New Inner Error format which conforms to Cognitive Services API Guidelines
     which is available at
     https://microsoft.sharepoint.com/%3Aw%3A/t/CognitiveServicesPMO/EUoytcrjuJdKpeOKIK_QRC8BPtUYQpKBi8JsWyeDMRsWlQ?e=CPq8ow.  # pylint: disable=line-too-long
     This
     contains required properties ErrorCode, message and optional properties target,
     details(key value pair), inner error(this can be nested)."""

    @overload
    def __init__(
        self,
        *,
        code: Union[str, "_models.TranslationErrorCode"],
        message: str,
        inner_error: Optional["_models.InnerTranslationError"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentTranslationFileFormat(_model_base.Model):
    """File Format.


    :ivar file_format: Name of the format. Required.
    :vartype file_format: str
    :ivar file_extensions: Supported file extension for this format. Required.
    :vartype file_extensions: list[str]
    :ivar content_types: Supported Content-Types for this format. Required.
    :vartype content_types: list[str]
    :ivar default_format_version: Default version if none is specified.
    :vartype default_format_version: str
    :ivar format_versions: Supported Version.
    :vartype format_versions: list[str]
    :ivar type: Supported Type for this format. Known values are: "document" and "glossary".
    :vartype type: str or ~azure.ai.translation.document.models.FileFormatType
    """

    file_format: str = rest_field(name="format")
    """Name of the format. Required."""
    file_extensions: List[str] = rest_field(name="fileExtensions")
    """Supported file extension for this format. Required."""
    content_types: List[str] = rest_field(name="contentTypes")
    """Supported Content-Types for this format. Required."""
    default_format_version: Optional[str] = rest_field(name="defaultVersion")
    """Default version if none is specified."""
    format_versions: Optional[List[str]] = rest_field(name="versions")
    """Supported Version."""
    type: Optional[Union[str, "_models.FileFormatType"]] = rest_field()
    """Supported Type for this format. Known values are: \"document\" and \"glossary\"."""

    @overload
    def __init__(
        self,
        *,
        file_format: str,
        file_extensions: List[str],
        content_types: List[str],
        default_format_version: Optional[str] = None,
        format_versions: Optional[List[str]] = None,
        type: Optional[Union[str, "_models.FileFormatType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InnerTranslationError(_model_base.Model):
    """New Inner Error format which conforms to Cognitive Services API Guidelines
    which is available at
    https://microsoft.sharepoint.com/%3Aw%3A/t/CognitiveServicesPMO/EUoytcrjuJdKpeOKIK_QRC8BPtUYQpKBi8JsWyeDMRsWlQ?e=CPq8ow.
    This
    contains required properties ErrorCode, message and optional properties target,
    details(key value pair), inner error(this can be nested).

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar code: Gets code error string. Required.
    :vartype code: str
    :ivar message: Gets high level error message. Required.
    :vartype message: str
    :ivar target: Gets the source of the error.
     For example it would be "documents" or
     "document id" in case of invalid document.
    :vartype target: str
    :ivar inner_error: New Inner Error format which conforms to Cognitive Services API Guidelines
     which is available at
     https://microsoft.sharepoint.com/%3Aw%3A/t/CognitiveServicesPMO/EUoytcrjuJdKpeOKIK_QRC8BPtUYQpKBi8JsWyeDMRsWlQ?e=CPq8ow.
     This
     contains required properties ErrorCode, message and optional properties target,
     details(key value pair), inner error(this can be nested).
    :vartype inner_error: ~azure.ai.translation.document.models.InnerTranslationError
    """

    code: str = rest_field()
    """Gets code error string. Required."""
    message: str = rest_field()
    """Gets high level error message. Required."""
    target: Optional[str] = rest_field(visibility=["read"])
    """Gets the source of the error.
     For example it would be \"documents\" or
     \"document id\" in case of invalid document."""
    inner_error: Optional["_models.InnerTranslationError"] = rest_field(name="innerError")
    """New Inner Error format which conforms to Cognitive Services API Guidelines
     which is available at
     https://microsoft.sharepoint.com/%3Aw%3A/t/CognitiveServicesPMO/EUoytcrjuJdKpeOKIK_QRC8BPtUYQpKBi8JsWyeDMRsWlQ?e=CPq8ow.  # pylint: disable=line-too-long
     This
     contains required properties ErrorCode, message and optional properties target,
     details(key value pair), inner error(this can be nested)."""

    @overload
    def __init__(
        self,
        *,
        code: str,
        message: str,
        inner_error: Optional["_models.InnerTranslationError"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SourceInput(_model_base.Model):
    """Source of the input documents.

    All required parameters must be populated in order to send to server.

    :ivar source_url: Location of the folder / container or single file with your documents.
     Required.
    :vartype source_url: str
    :ivar filter: Document filter.
    :vartype filter: ~azure.ai.translation.document.models.DocumentFilter
    :ivar language: Language code
     If none is specified, we will perform auto detect on the document.
    :vartype language: str
    :ivar storage_source: Storage Source. "AzureBlob"
    :vartype storage_source: str or ~azure.ai.translation.document.models.TranslationStorageSource
    """

    source_url: str = rest_field(name="sourceUrl")
    """Location of the folder / container or single file with your documents. Required."""
    filter: Optional["_models.DocumentFilter"] = rest_field()
    """Document filter."""
    language: Optional[str] = rest_field()
    """Language code
     If none is specified, we will perform auto detect on the document."""
    storage_source: Optional[Union[str, "_models.TranslationStorageSource"]] = rest_field(name="storageSource")
    """Storage Source. \"AzureBlob\""""

    @overload
    def __init__(
        self,
        *,
        source_url: str,
        filter: Optional["_models.DocumentFilter"] = None,  # pylint: disable=redefined-builtin
        language: Optional[str] = None,
        storage_source: Optional[Union[str, "_models.TranslationStorageSource"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StartTranslationDetails(_model_base.Model):
    """Translation job submission batch request.

    All required parameters must be populated in order to send to server.

    :ivar inputs: The input list of documents or folders containing documents. Required.
    :vartype inputs: list[~azure.ai.translation.document.models.DocumentBatch]
    """

    inputs: List["_models.DocumentBatch"] = rest_field()
    """The input list of documents or folders containing documents. Required."""

    @overload
    def __init__(
        self,
        *,
        inputs: List["_models.DocumentBatch"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SupportedFileFormats(_model_base.Model):
    """List of supported file formats.


    :ivar value: list of objects. Required.
    :vartype value: list[~azure.ai.translation.document.models.DocumentTranslationFileFormat]
    """

    value: List["_models.DocumentTranslationFileFormat"] = rest_field()
    """list of objects. Required."""


class TranslationErrorResponse(_model_base.Model):
    """Contains unified error information used for HTTP responses across any Cognitive
    Service. Instances
    can be created either through
    Microsoft.CloudAI.Containers.HttpStatusExceptionV2 or by returning it directly
    from
    a controller.

    :ivar error: This contains an outer error with error code, message, details, target and an
     inner error with more descriptive details.
    :vartype error: ~azure.ai.translation.document.models.DocumentTranslationError
    """

    error: Optional["_models.DocumentTranslationError"] = rest_field()
    """This contains an outer error with error code, message, details, target and an
     inner error with more descriptive details."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.DocumentTranslationError"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TranslationGlossary(_model_base.Model):
    """Glossary / translation memory for the request.

    All required parameters must be populated in order to send to server.

    :ivar glossary_url: Location of the glossary.
     We will use the file extension to extract the
     formatting if the format parameter is not supplied.

     If the translation
     language pair is not present in the glossary, it will not be applied. Required.
    :vartype glossary_url: str
    :ivar file_format: Format. Required.
    :vartype file_format: str
    :ivar format_version: Optional Version.  If not specified, default is used.
    :vartype format_version: str
    :ivar storage_source: Storage Source. "AzureBlob"
    :vartype storage_source: str or ~azure.ai.translation.document.models.TranslationStorageSource
    """

    glossary_url: str = rest_field(name="glossaryUrl")
    """Location of the glossary.
     We will use the file extension to extract the
     formatting if the format parameter is not supplied.
     
     If the translation
     language pair is not present in the glossary, it will not be applied. Required."""
    file_format: str = rest_field(name="format")
    """Format. Required."""
    format_version: Optional[str] = rest_field(name="version")
    """Optional Version.  If not specified, default is used."""
    storage_source: Optional[Union[str, "_models.TranslationStorageSource"]] = rest_field(name="storageSource")
    """Storage Source. \"AzureBlob\""""

    @overload
    def __init__(
        self,
        *,
        glossary_url: str,
        file_format: str,
        format_version: Optional[str] = None,
        storage_source: Optional[Union[str, "_models.TranslationStorageSource"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TranslationStatus(_model_base.Model):
    """Translation job status response.


    :ivar id: Id of the translation operation. Required.
    :vartype id: str
    :ivar created_on: Operation created date time. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: Date time in which the operation's status has been updated. Required.
    :vartype last_updated_on: ~datetime.datetime
    :ivar status: List of possible statuses for job or document. Required. Known values are:
     "NotStarted", "Running", "Succeeded", "Failed", "Cancelled", "Cancelling", and
     "ValidationFailed".
    :vartype status: str or ~azure.ai.translation.document.models.Status
    :ivar error: This contains an outer error with error code, message, details, target and an
     inner error with more descriptive details.
    :vartype error: ~azure.ai.translation.document.models.DocumentTranslationError
    :ivar summary: Status Summary. Required.
    :vartype summary: ~azure.ai.translation.document.models.TranslationStatusSummary
    """

    id: str = rest_field()
    """Id of the translation operation. Required."""
    created_on: datetime.datetime = rest_field(name="createdDateTimeUtc", format="rfc3339")
    """Operation created date time. Required."""
    last_updated_on: datetime.datetime = rest_field(name="lastActionDateTimeUtc", format="rfc3339")
    """Date time in which the operation's status has been updated. Required."""
    status: Union[str, "_models.Status"] = rest_field()
    """List of possible statuses for job or document. Required. Known values are: \"NotStarted\",
     \"Running\", \"Succeeded\", \"Failed\", \"Cancelled\", \"Cancelling\", and
     \"ValidationFailed\"."""
    error: Optional["_models.DocumentTranslationError"] = rest_field()
    """This contains an outer error with error code, message, details, target and an
     inner error with more descriptive details."""
    summary: "_models.TranslationStatusSummary" = rest_field()
    """Status Summary. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        created_on: datetime.datetime,
        last_updated_on: datetime.datetime,
        status: Union[str, "_models.Status"],
        summary: "_models.TranslationStatusSummary",
        error: Optional["_models.DocumentTranslationError"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TranslationStatusSummary(_model_base.Model):
    """Status Summary.


    :ivar total: Total count. Required.
    :vartype total: int
    :ivar failed: Failed count. Required.
    :vartype failed: int
    :ivar success: Number of Success. Required.
    :vartype success: int
    :ivar in_progress: Number of in progress. Required.
    :vartype in_progress: int
    :ivar not_yet_started: Count of not yet started. Required.
    :vartype not_yet_started: int
    :ivar canceled: Number of cancelled. Required.
    :vartype canceled: int
    :ivar total_characters_charged: Total characters charged by the API. Required.
    :vartype total_characters_charged: int
    """

    total: int = rest_field()
    """Total count. Required."""
    failed: int = rest_field()
    """Failed count. Required."""
    success: int = rest_field()
    """Number of Success. Required."""
    in_progress: int = rest_field(name="inProgress")
    """Number of in progress. Required."""
    not_yet_started: int = rest_field(name="notYetStarted")
    """Count of not yet started. Required."""
    canceled: int = rest_field(name="cancelled")
    """Number of cancelled. Required."""
    total_characters_charged: int = rest_field(name="totalCharacterCharged")
    """Total characters charged by the API. Required."""

    @overload
    def __init__(
        self,
        *,
        total: int,
        failed: int,
        success: int,
        in_progress: int,
        not_yet_started: int,
        canceled: int,
        total_characters_charged: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TranslationTarget(_model_base.Model):
    """Destination for the finished translated documents.

    All required parameters must be populated in order to send to server.

    :ivar target_url: Location of the folder / container with your documents. Required.
    :vartype target_url: str
    :ivar category_id: Category / custom system for translation request.
    :vartype category_id: str
    :ivar language: Target Language. Required.
    :vartype language: str
    :ivar glossaries: List of Glossary.
    :vartype glossaries: list[~azure.ai.translation.document.models.TranslationGlossary]
    :ivar storage_source: Storage Source. "AzureBlob"
    :vartype storage_source: str or ~azure.ai.translation.document.models.TranslationStorageSource
    """

    target_url: str = rest_field(name="targetUrl")
    """Location of the folder / container with your documents. Required."""
    category_id: Optional[str] = rest_field(name="category")
    """Category / custom system for translation request."""
    language: str = rest_field()
    """Target Language. Required."""
    glossaries: Optional[List["_models.TranslationGlossary"]] = rest_field()
    """List of Glossary."""
    storage_source: Optional[Union[str, "_models.TranslationStorageSource"]] = rest_field(name="storageSource")
    """Storage Source. \"AzureBlob\""""

    @overload
    def __init__(
        self,
        *,
        target_url: str,
        language: str,
        category_id: Optional[str] = None,
        glossaries: Optional[List["_models.TranslationGlossary"]] = None,
        storage_source: Optional[Union[str, "_models.TranslationStorageSource"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
