# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.settings import settings
from azure.mgmt.core import ARMPipelineClient
from azure.mgmt.core.policies import ARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints

from . import models as _models
from ._configuration import ApplicationInsightsManagementClientConfiguration
from ._utils.serialization import Deserializer, Serializer
from .operations import (
    APIKeysOperations,
    AnalyticsItemsOperations,
    AnnotationsOperations,
    ComponentAvailableFeaturesOperations,
    ComponentCurrentBillingFeaturesOperations,
    ComponentFeatureCapabilitiesOperations,
    ComponentLinkedStorageAccountsOperations,
    ComponentQuotaStatusOperations,
    ComponentsOperations,
    DeletedWorkbooksOperations,
    ExportConfigurationsOperations,
    FavoritesOperations,
    LiveTokenOperations,
    Operations,
    ProactiveDetectionConfigurationsOperations,
    WebTestLocationsOperations,
    WebTestsOperations,
    WorkItemConfigurationsOperations,
    WorkbookTemplatesOperations,
    WorkbooksOperations,
)

if TYPE_CHECKING:
    from azure.core.credentials import TokenCredential


class ApplicationInsightsManagementClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Composite Swagger for Application Insights Management Client.

    :ivar components: ComponentsOperations operations
    :vartype components: azure.mgmt.applicationinsights.operations.ComponentsOperations
    :ivar annotations: AnnotationsOperations operations
    :vartype annotations: azure.mgmt.applicationinsights.operations.AnnotationsOperations
    :ivar api_keys: APIKeysOperations operations
    :vartype api_keys: azure.mgmt.applicationinsights.operations.APIKeysOperations
    :ivar export_configurations: ExportConfigurationsOperations operations
    :vartype export_configurations:
     azure.mgmt.applicationinsights.operations.ExportConfigurationsOperations
    :ivar component_current_billing_features: ComponentCurrentBillingFeaturesOperations operations
    :vartype component_current_billing_features:
     azure.mgmt.applicationinsights.operations.ComponentCurrentBillingFeaturesOperations
    :ivar component_quota_status: ComponentQuotaStatusOperations operations
    :vartype component_quota_status:
     azure.mgmt.applicationinsights.operations.ComponentQuotaStatusOperations
    :ivar component_feature_capabilities: ComponentFeatureCapabilitiesOperations operations
    :vartype component_feature_capabilities:
     azure.mgmt.applicationinsights.operations.ComponentFeatureCapabilitiesOperations
    :ivar component_available_features: ComponentAvailableFeaturesOperations operations
    :vartype component_available_features:
     azure.mgmt.applicationinsights.operations.ComponentAvailableFeaturesOperations
    :ivar proactive_detection_configurations: ProactiveDetectionConfigurationsOperations operations
    :vartype proactive_detection_configurations:
     azure.mgmt.applicationinsights.operations.ProactiveDetectionConfigurationsOperations
    :ivar work_item_configurations: WorkItemConfigurationsOperations operations
    :vartype work_item_configurations:
     azure.mgmt.applicationinsights.operations.WorkItemConfigurationsOperations
    :ivar favorites: FavoritesOperations operations
    :vartype favorites: azure.mgmt.applicationinsights.operations.FavoritesOperations
    :ivar web_test_locations: WebTestLocationsOperations operations
    :vartype web_test_locations:
     azure.mgmt.applicationinsights.operations.WebTestLocationsOperations
    :ivar web_tests: WebTestsOperations operations
    :vartype web_tests: azure.mgmt.applicationinsights.operations.WebTestsOperations
    :ivar analytics_items: AnalyticsItemsOperations operations
    :vartype analytics_items: azure.mgmt.applicationinsights.operations.AnalyticsItemsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.applicationinsights.operations.Operations
    :ivar workbook_templates: WorkbookTemplatesOperations operations
    :vartype workbook_templates:
     azure.mgmt.applicationinsights.operations.WorkbookTemplatesOperations
    :ivar workbooks: WorkbooksOperations operations
    :vartype workbooks: azure.mgmt.applicationinsights.operations.WorkbooksOperations
    :ivar live_token: LiveTokenOperations operations
    :vartype live_token: azure.mgmt.applicationinsights.operations.LiveTokenOperations
    :ivar component_linked_storage_accounts: ComponentLinkedStorageAccountsOperations operations
    :vartype component_linked_storage_accounts:
     azure.mgmt.applicationinsights.operations.ComponentLinkedStorageAccountsOperations
    :ivar deleted_workbooks: DeletedWorkbooksOperations operations
    :vartype deleted_workbooks:
     azure.mgmt.applicationinsights.operations.DeletedWorkbooksOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is None.
    :type base_url: str
    """

    def __init__(
        self, credential: "TokenCredential", subscription_id: str, base_url: Optional[str] = None, **kwargs: Any
    ) -> None:
        _cloud = kwargs.pop("cloud_setting", None) or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = ApplicationInsightsManagementClientConfiguration(
            credential=credential, subscription_id=subscription_id, credential_scopes=credential_scopes, **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                ARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=cast(str, base_url), policies=_policies, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.components = ComponentsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.annotations = AnnotationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api_keys = APIKeysOperations(self._client, self._config, self._serialize, self._deserialize)
        self.export_configurations = ExportConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.component_current_billing_features = ComponentCurrentBillingFeaturesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.component_quota_status = ComponentQuotaStatusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.component_feature_capabilities = ComponentFeatureCapabilitiesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.component_available_features = ComponentAvailableFeaturesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.proactive_detection_configurations = ProactiveDetectionConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.work_item_configurations = WorkItemConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.favorites = FavoritesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.web_test_locations = WebTestLocationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.web_tests = WebTestsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.analytics_items = AnalyticsItemsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.workbook_templates = WorkbookTemplatesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workbooks = WorkbooksOperations(self._client, self._config, self._serialize, self._deserialize)
        self.live_token = LiveTokenOperations(self._client, self._config, self._serialize, self._deserialize)
        self.component_linked_storage_accounts = ComponentLinkedStorageAccountsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.deleted_workbooks = DeletedWorkbooksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, *, stream: bool = False, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> Self:
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
