---
page_type: sample
languages:
  - python
products:
  - azure
  - azure-cognitive-services
  - azure-health-insights
urlFragment: healthinsights-clinicalmatching-samples
---

# Samples for Health Insights Clinical Matching client library for Python

These code samples show common scenario operations with the Health Insights Clinical Matching client library.

These sample programs show common scenarios for the Health Insights Clinical Matching client's offerings.

|**File Name**|**Description**|
|----------------|-------------|

|[sample_match_trials_fhir.py][sample_match_trials_fhir] and [sample_match_trials_fhir_async.py][sample_match_trials_fhir_async]|Match trials fhir.|
|[sample_match_trials_structured_coded_elements.py][sample_match_trials_structured_coded_elements] and [sample_match_trials_structured_coded_elements_async.py][sample_match_trials_structured_coded_elements_async] |Match trials structured coded elements.|


## Prerequisites
* Python 3.7 or later is required to use this package.
* You must have an [Azure subscription][azure_subscription] and an [Azure Health Insights account][azure_healthinsights_account] to run these samples.

## Setup

1. Install the Azure Health Insights Clinical Matching client library for Python with [pip][pip]:

```bash
pip install azure-healthinsights-clinicalmatching
```

2. Clone or download this sample repository
3. Open the sample folder in Visual Studio Code or your IDE of choice.

## Running the samples

1. Open a terminal window and `cd` to the directory that the samples are saved in.
2. Set the environment variables specified in the sample file you wish to run.
3. Follow the usage described in the file, e.g. `python sample_match_trials_custom_trial.py`

## Next steps

Check out the [API reference documentation][python-fr-ref-docs] to learn more about
what you can do with the Health Insights client library.

[pip]: https://pypi.org/project/pip/
[azure_subscription]: https://azure.microsoft.com/free/cognitive-services
[azure_healthinsights_account]: https://docs.microsoft.com/azure/cognitive-services/cognitive-services-apis-create-account?tabs=singleservice%2Cwindows
[sample_match_trials_fhir]: https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/healthinsights/azure-healthinsights-clinicalmatching/samples/sample_match_trials_fhir.py
[sample_match_trials_fhir_async]: https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/healthinsights/azure-healthinsights-clinicalmatching/samples/async_samples/sample_match_trials_fhir_async.py
[sample_match_trials_structured_coded_elements]: https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/healthinsights/azure-healthinsights-clinicalmatching/samples/sample_match_trials_structured_coded_elements.py
[sample_match_trials_structured_coded_elements_async]: https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/healthinsights/azure-healthinsights-clinicalmatching/samples/async_samples/sample_match_trials_structured_coded_elements_async.py


