# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.policyinsights.aio import PolicyInsightsClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPolicyInsightsPolicyTrackedResourcesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PolicyInsightsClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_policy_tracked_resources_list_query_results_for_management_group(self, resource_group):
        response = self.client.policy_tracked_resources.list_query_results_for_management_group(
            management_group_name="str",
            policy_tracked_resources_resource="str",
            management_groups_namespace="Microsoft.Management",
            api_version="2018-07-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_policy_tracked_resources_list_query_results_for_subscription(self, resource_group):
        response = self.client.policy_tracked_resources.list_query_results_for_subscription(
            policy_tracked_resources_resource="str",
            api_version="2018-07-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_policy_tracked_resources_list_query_results_for_resource_group(self, resource_group):
        response = self.client.policy_tracked_resources.list_query_results_for_resource_group(
            resource_group_name=resource_group.name,
            policy_tracked_resources_resource="str",
            api_version="2018-07-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_policy_tracked_resources_list_query_results_for_resource(self, resource_group):
        response = self.client.policy_tracked_resources.list_query_results_for_resource(
            resource_id="str",
            policy_tracked_resources_resource="str",
            api_version="2018-07-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
