# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.botservice import AzureBotService

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-botservice
# USAGE
    python create_bot.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = AzureBotService(
        credential=DefaultAzureCredential(),
        subscription_id="subscription-id",
    )

    response = client.bots.create(
        resource_group_name="OneResourceGroupName",
        resource_name="samplebotname",
        parameters={
            "etag": "etag1",
            "kind": "sdk",
            "location": "West US",
            "properties": {
                "cmekKeyVaultUrl": "https://myCmekKey",
                "description": "The description of the bot",
                "developerAppInsightKey": "appinsightskey",
                "developerAppInsightsApiKey": "appinsightsapikey",
                "developerAppInsightsApplicationId": "appinsightsappid",
                "disableLocalAuth": True,
                "displayName": "The Name of the bot",
                "endpoint": "http://mybot.coffee",
                "iconUrl": "http://myicon",
                "isCmekEnabled": True,
                "luisAppIds": ["luisappid1", "luisappid2"],
                "luisKey": "luiskey",
                "msaAppId": "exampleappid",
                "msaAppMSIResourceId": "/subscriptions/foo/resourcegroups/bar/providers/microsoft.managedidentity/userassignedidentities/sampleId",
                "msaAppTenantId": "exampleapptenantid",
                "msaAppType": "UserAssignedMSI",
                "publicNetworkAccess": "Enabled",
                "schemaTransformationVersion": "1.0",
            },
            "sku": {"name": "S1"},
            "tags": {"tag1": "value1", "tag2": "value2"},
        },
    )
    print(response)


# x-ms-original-file: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/CreateBot.json
if __name__ == "__main__":
    main()
