# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AccessRule(_Model):
    """Access rule in a network security perimeter configuration profile.

    :ivar name: Name of the access rule.
    :vartype name: str
    :ivar properties:
    :vartype properties: ~azure.mgmt.batch.models.AccessRuleProperties
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the access rule."""
    properties: Optional["_models.AccessRuleProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["_models.AccessRuleProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AccessRuleProperties(_Model):
    """Properties of Access Rule.

    :ivar direction: Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.batch.models.AccessRuleDirection
    :ivar address_prefixes: Address prefixes in the CIDR format for inbound rules.
    :vartype address_prefixes: list[str]
    :ivar subscriptions: Subscriptions for inbound rules.
    :vartype subscriptions: list[~azure.mgmt.batch.models.AccessRulePropertiesSubscription]
    :ivar network_security_perimeters: Network security perimeters for inbound rules.
    :vartype network_security_perimeters: list[~azure.mgmt.batch.models.NetworkSecurityPerimeter]
    :ivar fully_qualified_domain_names: Fully qualified domain names (FQDN) for outbound rules.
    :vartype fully_qualified_domain_names: list[str]
    :ivar email_addresses: Email addresses for outbound rules.
    :vartype email_addresses: list[str]
    :ivar phone_numbers: Phone numbers for outbound rules.
    :vartype phone_numbers: list[str]
    """

    direction: Optional[Union[str, "_models.AccessRuleDirection"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"Inbound\" and \"Outbound\"."""
    address_prefixes: Optional[list[str]] = rest_field(
        name="addressPrefixes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Address prefixes in the CIDR format for inbound rules."""
    subscriptions: Optional[list["_models.AccessRulePropertiesSubscription"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Subscriptions for inbound rules."""
    network_security_perimeters: Optional[list["_models.NetworkSecurityPerimeter"]] = rest_field(
        name="networkSecurityPerimeters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network security perimeters for inbound rules."""
    fully_qualified_domain_names: Optional[list[str]] = rest_field(
        name="fullyQualifiedDomainNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """Fully qualified domain names (FQDN) for outbound rules."""
    email_addresses: Optional[list[str]] = rest_field(
        name="emailAddresses", visibility=["read", "create", "update", "delete", "query"]
    )
    """Email addresses for outbound rules."""
    phone_numbers: Optional[list[str]] = rest_field(
        name="phoneNumbers", visibility=["read", "create", "update", "delete", "query"]
    )
    """Phone numbers for outbound rules."""

    @overload
    def __init__(
        self,
        *,
        direction: Optional[Union[str, "_models.AccessRuleDirection"]] = None,
        address_prefixes: Optional[list[str]] = None,
        subscriptions: Optional[list["_models.AccessRulePropertiesSubscription"]] = None,
        network_security_perimeters: Optional[list["_models.NetworkSecurityPerimeter"]] = None,
        fully_qualified_domain_names: Optional[list[str]] = None,
        email_addresses: Optional[list[str]] = None,
        phone_numbers: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AccessRulePropertiesSubscription(_Model):
    """AccessRulePropertiesSubscription.

    :ivar id: The fully qualified Azure resource ID of the subscription e.g.
     ('/subscriptions/00000000-0000-0000-0000-000000000000').
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The fully qualified Azure resource ID of the subscription e.g.
     ('/subscriptions/00000000-0000-0000-0000-000000000000')."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ActivateApplicationPackageParameters(_Model):
    """Parameters for an activating an application package.

    :ivar format: The format of the application package binary file. Required.
    :vartype format: str
    """

    format: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The format of the application package binary file. Required."""

    @overload
    def __init__(
        self,
        *,
        format: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.batch.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.batch.models.SystemData
    """


class Application(ProxyResource):
    """Contains information about an application in a Batch account.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.batch.models.SystemData
    :ivar properties: The properties associated with the Application.
    :vartype properties: ~azure.mgmt.batch.models.ApplicationProperties
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.ApplicationProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties associated with the Application."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """The ETag of the resource, used for concurrency statements."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tags of the resource."""

    __flattened_items = ["display_name", "allow_updates", "default_version"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ApplicationProperties"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ApplicationPackage(ProxyResource):
    """An application package which represents a particular version of an application.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.batch.models.SystemData
    :ivar properties: The properties associated with the Application Package.
    :vartype properties: ~azure.mgmt.batch.models.ApplicationPackageProperties
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.ApplicationPackageProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties associated with the Application Package."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """The ETag of the resource, used for concurrency statements."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tags of the resource."""

    __flattened_items = ["state", "format", "storage_url", "storage_url_expiry", "last_activation_time"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ApplicationPackageProperties"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ApplicationPackageProperties(_Model):
    """Properties of an application package.

    :ivar state: The current state of the application package. Known values are: "Pending" and
     "Active".
    :vartype state: str or ~azure.mgmt.batch.models.PackageState
    :ivar format: The format of the application package, if the package is active.
    :vartype format: str
    :ivar storage_url: The URL for the application package in Azure Storage.
    :vartype storage_url: str
    :ivar storage_url_expiry: The UTC time at which the Azure Storage URL will expire.
    :vartype storage_url_expiry: ~datetime.datetime
    :ivar last_activation_time: The time at which the package was last activated, if the package is
     active.
    :vartype last_activation_time: ~datetime.datetime
    """

    state: Optional[Union[str, "_models.PackageState"]] = rest_field(visibility=["read"])
    """The current state of the application package. Known values are: \"Pending\" and \"Active\"."""
    format: Optional[str] = rest_field(visibility=["read"])
    """The format of the application package, if the package is active."""
    storage_url: Optional[str] = rest_field(name="storageUrl", visibility=["read"])
    """The URL for the application package in Azure Storage."""
    storage_url_expiry: Optional[datetime.datetime] = rest_field(
        name="storageUrlExpiry", visibility=["read"], format="rfc3339"
    )
    """The UTC time at which the Azure Storage URL will expire."""
    last_activation_time: Optional[datetime.datetime] = rest_field(
        name="lastActivationTime", visibility=["read"], format="rfc3339"
    )
    """The time at which the package was last activated, if the package is active."""


class ApplicationPackageReference(_Model):
    """Link to an application package inside the batch account.

    :ivar id: The ID of the application package to install. This must be inside the same Batch
     account as the pool. This can either be a reference to a specific version or the default
     version if one exists. Required.
    :vartype id: str
    :ivar version: The version of the application to deploy. If omitted, the default version is
     deployed.
    :vartype version: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the application package to install. This must be inside the same Batch account as the
     pool. This can either be a reference to a specific version or the default version if one
     exists. Required."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The version of the application to deploy. If omitted, the default version is deployed."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApplicationProperties(_Model):
    """The properties associated with the Application.

    :ivar display_name: The display name for the application.
    :vartype display_name: str
    :ivar allow_updates: A value indicating whether packages within the application may be
     overwritten using the same version string.
    :vartype allow_updates: bool
    :ivar default_version: The package to use if a client requests the application but does not
     specify a version. This property can only be set to the name of an existing package.
    :vartype default_version: str
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The display name for the application."""
    allow_updates: Optional[bool] = rest_field(
        name="allowUpdates", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether packages within the application may be overwritten using the same
     version string."""
    default_version: Optional[str] = rest_field(
        name="defaultVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The package to use if a client requests the application but does not specify a version. This
     property can only be set to the name of an existing package."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        allow_updates: Optional[bool] = None,
        default_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutomaticOSUpgradePolicy(_Model):
    """The configuration parameters used for performing automatic OS upgrade.

    :ivar disable_automatic_rollback: Whether OS image rollback feature should be disabled.
    :vartype disable_automatic_rollback: bool
    :ivar enable_automatic_os_upgrade: Indicates whether OS upgrades should automatically be
     applied to scale set instances in a rolling fashion when a newer version of the OS image
     becomes available. <br /><br /> If this is set to true for Windows based pools,
     `WindowsConfiguration.enableAutomaticUpdates
     <https://learn.microsoft.com/rest/api/batchmanagement/pool/create?tabs=HTTP#windowsconfiguration>`_
     cannot be set to true.
    :vartype enable_automatic_os_upgrade: bool
    :ivar use_rolling_upgrade_policy: Indicates whether rolling upgrade policy should be used
     during Auto OS Upgrade. Auto OS Upgrade will fallback to the default policy if no policy is
     defined on the VMSS.
    :vartype use_rolling_upgrade_policy: bool
    :ivar os_rolling_upgrade_deferral: Defer OS upgrades on the TVMs if they are running tasks.
    :vartype os_rolling_upgrade_deferral: bool
    """

    disable_automatic_rollback: Optional[bool] = rest_field(
        name="disableAutomaticRollback", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether OS image rollback feature should be disabled."""
    enable_automatic_os_upgrade: Optional[bool] = rest_field(
        name="enableAutomaticOSUpgrade", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether OS upgrades should automatically be applied to scale set instances in a
     rolling fashion when a newer version of the OS image becomes available. <br /><br /> If this is
     set to true for Windows based pools, `WindowsConfiguration.enableAutomaticUpdates
     <https://learn.microsoft.com/rest/api/batchmanagement/pool/create?tabs=HTTP#windowsconfiguration>`_
     cannot be set to true."""
    use_rolling_upgrade_policy: Optional[bool] = rest_field(
        name="useRollingUpgradePolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether rolling upgrade policy should be used during Auto OS Upgrade. Auto OS Upgrade
     will fallback to the default policy if no policy is defined on the VMSS."""
    os_rolling_upgrade_deferral: Optional[bool] = rest_field(
        name="osRollingUpgradeDeferral", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defer OS upgrades on the TVMs if they are running tasks."""

    @overload
    def __init__(
        self,
        *,
        disable_automatic_rollback: Optional[bool] = None,
        enable_automatic_os_upgrade: Optional[bool] = None,
        use_rolling_upgrade_policy: Optional[bool] = None,
        os_rolling_upgrade_deferral: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutoScaleRun(_Model):
    """The results and errors from an execution of a pool autoscale formula.

    :ivar evaluation_time: The time at which the autoscale formula was last evaluated. Required.
    :vartype evaluation_time: ~datetime.datetime
    :ivar results: The final values of all variables used in the evaluation of the autoscale
     formula.
    :vartype results: str
    :ivar error: Details of the error encountered evaluating the autoscale formula on the pool, if
     the evaluation was unsuccessful.
    :vartype error: ~azure.mgmt.batch.models.AutoScaleRunError
    """

    evaluation_time: datetime.datetime = rest_field(
        name="evaluationTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the autoscale formula was last evaluated. Required."""
    results: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The final values of all variables used in the evaluation of the autoscale formula."""
    error: Optional["_models.AutoScaleRunError"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Details of the error encountered evaluating the autoscale formula on the pool, if the
     evaluation was unsuccessful."""

    @overload
    def __init__(
        self,
        *,
        evaluation_time: datetime.datetime,
        results: Optional[str] = None,
        error: Optional["_models.AutoScaleRunError"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutoScaleRunError(_Model):
    """An error that occurred when autoscaling a pool.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically. Required.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface. Required.
    :vartype message: str
    :ivar details: Additional details about the error.
    :vartype details: list[~azure.mgmt.batch.models.AutoScaleRunError]
    """

    code: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically. Required."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A message describing the error, intended to be suitable for display in a user interface.
     Required."""
    details: Optional[list["_models.AutoScaleRunError"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional details about the error."""

    @overload
    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: Optional[list["_models.AutoScaleRunError"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutoScaleSettings(_Model):
    """AutoScale settings for the pool.

    :ivar formula: A formula for the desired number of compute nodes in the pool. Required.
    :vartype formula: str
    :ivar evaluation_interval: The time interval at which to automatically adjust the pool size
     according to the autoscale formula.
    :vartype evaluation_interval: ~datetime.timedelta
    """

    formula: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A formula for the desired number of compute nodes in the pool. Required."""
    evaluation_interval: Optional[datetime.timedelta] = rest_field(
        name="evaluationInterval", visibility=["read", "create", "update", "delete", "query"]
    )
    """The time interval at which to automatically adjust the pool size according to the autoscale
     formula."""

    @overload
    def __init__(
        self,
        *,
        formula: str,
        evaluation_interval: Optional[datetime.timedelta] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutoStorageBaseProperties(_Model):
    """The properties related to the auto-storage account.

    :ivar storage_account_id: The resource ID of the storage account to be used for auto-storage
     account. Required.
    :vartype storage_account_id: str
    :ivar authentication_mode: The authentication mode which the Batch service will use to manage
     the auto-storage account. Known values are: "StorageKeys" and "BatchAccountManagedIdentity".
    :vartype authentication_mode: str or ~azure.mgmt.batch.models.AutoStorageAuthenticationMode
    :ivar node_identity_reference: The reference to the user assigned identity which compute nodes
     will use to access auto-storage.
    :vartype node_identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
    """

    storage_account_id: str = rest_field(
        name="storageAccountId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource ID of the storage account to be used for auto-storage account. Required."""
    authentication_mode: Optional[Union[str, "_models.AutoStorageAuthenticationMode"]] = rest_field(
        name="authenticationMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The authentication mode which the Batch service will use to manage the auto-storage account.
     Known values are: \"StorageKeys\" and \"BatchAccountManagedIdentity\"."""
    node_identity_reference: Optional["_models.ComputeNodeIdentityReference"] = rest_field(
        name="nodeIdentityReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference to the user assigned identity which compute nodes will use to access
     auto-storage."""

    @overload
    def __init__(
        self,
        *,
        storage_account_id: str,
        authentication_mode: Optional[Union[str, "_models.AutoStorageAuthenticationMode"]] = None,
        node_identity_reference: Optional["_models.ComputeNodeIdentityReference"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutoStorageProperties(AutoStorageBaseProperties):
    """Contains information about the auto-storage account associated with a Batch account.

    :ivar storage_account_id: The resource ID of the storage account to be used for auto-storage
     account. Required.
    :vartype storage_account_id: str
    :ivar authentication_mode: The authentication mode which the Batch service will use to manage
     the auto-storage account. Known values are: "StorageKeys" and "BatchAccountManagedIdentity".
    :vartype authentication_mode: str or ~azure.mgmt.batch.models.AutoStorageAuthenticationMode
    :ivar node_identity_reference: The reference to the user assigned identity which compute nodes
     will use to access auto-storage.
    :vartype node_identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
    :ivar last_key_sync: The UTC time at which storage keys were last synchronized with the Batch
     account. Required.
    :vartype last_key_sync: ~datetime.datetime
    """

    last_key_sync: datetime.datetime = rest_field(
        name="lastKeySync", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The UTC time at which storage keys were last synchronized with the Batch account. Required."""

    @overload
    def __init__(
        self,
        *,
        storage_account_id: str,
        last_key_sync: datetime.datetime,
        authentication_mode: Optional[Union[str, "_models.AutoStorageAuthenticationMode"]] = None,
        node_identity_reference: Optional["_models.ComputeNodeIdentityReference"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutoUserSpecification(_Model):
    """Specifies the parameters for the auto user that runs a task on the Batch service.

    :ivar scope: The scope for the auto user. Known values are: "Task" and "Pool".
    :vartype scope: str or ~azure.mgmt.batch.models.AutoUserScope
    :ivar elevation_level: The elevation level of the user. Known values are: "NonAdmin" and
     "Admin".
    :vartype elevation_level: str or ~azure.mgmt.batch.models.ElevationLevel
    """

    scope: Optional[Union[str, "_models.AutoUserScope"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The scope for the auto user. Known values are: \"Task\" and \"Pool\"."""
    elevation_level: Optional[Union[str, "_models.ElevationLevel"]] = rest_field(
        name="elevationLevel", visibility=["read", "create", "update", "delete", "query"]
    )
    """The elevation level of the user. Known values are: \"NonAdmin\" and \"Admin\"."""

    @overload
    def __init__(
        self,
        *,
        scope: Optional[Union[str, "_models.AutoUserScope"]] = None,
        elevation_level: Optional[Union[str, "_models.ElevationLevel"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureBlobFileSystemConfiguration(_Model):
    """Information used to connect to an Azure Storage Container using Blobfuse.

    :ivar account_name: The Azure Storage Account name. Required.
    :vartype account_name: str
    :ivar container_name: The Azure Blob Storage Container name. Required.
    :vartype container_name: str
    :ivar account_key: The Azure Storage Account key.
    :vartype account_key: str
    :ivar sas_key: The Azure Storage SAS token.
    :vartype sas_key: str
    :ivar blobfuse_options: Additional command line options to pass to the mount command.
    :vartype blobfuse_options: str
    :ivar relative_mount_path: The relative path on the compute node where the file system will be
     mounted. Required.
    :vartype relative_mount_path: str
    :ivar identity_reference: The reference to the user assigned identity to use to access
     containerName.
    :vartype identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
    """

    account_name: str = rest_field(name="accountName", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Storage Account name. Required."""
    container_name: str = rest_field(name="containerName", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Blob Storage Container name. Required."""
    account_key: Optional[str] = rest_field(
        name="accountKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Azure Storage Account key."""
    sas_key: Optional[str] = rest_field(name="sasKey", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Storage SAS token."""
    blobfuse_options: Optional[str] = rest_field(
        name="blobfuseOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional command line options to pass to the mount command."""
    relative_mount_path: str = rest_field(
        name="relativeMountPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The relative path on the compute node where the file system will be mounted. Required."""
    identity_reference: Optional["_models.ComputeNodeIdentityReference"] = rest_field(
        name="identityReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference to the user assigned identity to use to access containerName."""

    @overload
    def __init__(
        self,
        *,
        account_name: str,
        container_name: str,
        relative_mount_path: str,
        account_key: Optional[str] = None,
        sas_key: Optional[str] = None,
        blobfuse_options: Optional[str] = None,
        identity_reference: Optional["_models.ComputeNodeIdentityReference"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureFileShareConfiguration(_Model):
    """Information used to connect to an Azure Fileshare.

    :ivar account_name: The Azure Storage account name. Required.
    :vartype account_name: str
    :ivar azure_file_url: The Azure Files URL. Required.
    :vartype azure_file_url: str
    :ivar account_key: The Azure Storage account key. Required.
    :vartype account_key: str
    :ivar relative_mount_path: The relative path on the compute node where the file system will be
     mounted. Required.
    :vartype relative_mount_path: str
    :ivar mount_options: Additional command line options to pass to the mount command.
    :vartype mount_options: str
    """

    account_name: str = rest_field(name="accountName", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Storage account name. Required."""
    azure_file_url: str = rest_field(name="azureFileUrl", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Files URL. Required."""
    account_key: str = rest_field(name="accountKey", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Storage account key. Required."""
    relative_mount_path: str = rest_field(
        name="relativeMountPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The relative path on the compute node where the file system will be mounted. Required."""
    mount_options: Optional[str] = rest_field(
        name="mountOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional command line options to pass to the mount command."""

    @overload
    def __init__(
        self,
        *,
        account_name: str,
        azure_file_url: str,
        account_key: str,
        relative_mount_path: str,
        mount_options: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.batch.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchAccount(AzureResource):
    """Contains information about an Azure Batch account.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.batch.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The properties associated with the account.
    :vartype properties: ~azure.mgmt.batch.models.BatchAccountProperties
    :ivar identity: The identity of the Batch account.
    :vartype identity: ~azure.mgmt.batch.models.BatchAccountIdentity
    """

    properties: Optional["_models.BatchAccountProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties associated with the account."""
    identity: Optional["_models.BatchAccountIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity of the Batch account."""

    __flattened_items = [
        "account_endpoint",
        "node_management_endpoint",
        "provisioning_state",
        "pool_allocation_mode",
        "key_vault_reference",
        "public_network_access",
        "network_profile",
        "private_endpoint_connections",
        "auto_storage",
        "encryption",
        "dedicated_core_quota",
        "low_priority_core_quota",
        "dedicated_core_quota_per_vm_family",
        "dedicated_core_quota_per_vm_family_enforced",
        "pool_quota",
        "active_job_and_job_schedule_quota",
        "allowed_authentication_modes",
    ]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.BatchAccountProperties"] = None,
        identity: Optional["_models.BatchAccountIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class BatchAccountCreateParameters(_Model):
    """Parameters supplied to the Create operation.

    :ivar location: The region in which to create the account. Required.
    :vartype location: str
    :ivar tags: The user-specified tags associated with the account.
    :vartype tags: dict[str, str]
    :ivar properties: The properties of the Batch account.
    :vartype properties: ~azure.mgmt.batch.models.BatchAccountCreateProperties
    :ivar identity: The identity of the Batch account.
    :vartype identity: ~azure.mgmt.batch.models.BatchAccountIdentity
    """

    location: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The region in which to create the account. Required."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The user-specified tags associated with the account."""
    properties: Optional["_models.BatchAccountCreateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of the Batch account."""
    identity: Optional["_models.BatchAccountIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity of the Batch account."""

    __flattened_items = [
        "auto_storage",
        "pool_allocation_mode",
        "key_vault_reference",
        "public_network_access",
        "network_profile",
        "encryption",
        "allowed_authentication_modes",
    ]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.BatchAccountCreateProperties"] = None,
        identity: Optional["_models.BatchAccountIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class BatchAccountCreateProperties(_Model):
    """The properties of a Batch account.

    :ivar auto_storage: The properties related to the auto-storage account.
    :vartype auto_storage: ~azure.mgmt.batch.models.AutoStorageBaseProperties
    :ivar pool_allocation_mode: The allocation mode to use for creating pools in the Batch account.
     Known values are: "BatchService" and "UserSubscription".
    :vartype pool_allocation_mode: str or ~azure.mgmt.batch.models.PoolAllocationMode
    :ivar key_vault_reference: A reference to the Azure key vault associated with the Batch
     account.
    :vartype key_vault_reference: ~azure.mgmt.batch.models.KeyVaultReference
    :ivar public_network_access: The network access type for accessing Azure Batch account. Known
     values are: "Enabled", "Disabled", and "SecuredByPerimeter".
    :vartype public_network_access: str or ~azure.mgmt.batch.models.PublicNetworkAccessType
    :ivar network_profile: Network profile for Batch account, which contains network rule settings
     for each endpoint.
    :vartype network_profile: ~azure.mgmt.batch.models.NetworkProfile
    :ivar encryption: The encryption configuration for the Batch account.
    :vartype encryption: ~azure.mgmt.batch.models.EncryptionProperties
    :ivar allowed_authentication_modes: List of allowed authentication modes for the Batch account
     that can be used to authenticate with the data plane. This does not affect authentication with
     the control plane.
    :vartype allowed_authentication_modes: list[str or ~azure.mgmt.batch.models.AuthenticationMode]
    """

    auto_storage: Optional["_models.AutoStorageBaseProperties"] = rest_field(
        name="autoStorage", visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties related to the auto-storage account."""
    pool_allocation_mode: Optional[Union[str, "_models.PoolAllocationMode"]] = rest_field(
        name="poolAllocationMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The allocation mode to use for creating pools in the Batch account. Known values are:
     \"BatchService\" and \"UserSubscription\"."""
    key_vault_reference: Optional["_models.KeyVaultReference"] = rest_field(
        name="keyVaultReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """A reference to the Azure key vault associated with the Batch account."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccessType"]] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """The network access type for accessing Azure Batch account. Known values are: \"Enabled\",
     \"Disabled\", and \"SecuredByPerimeter\"."""
    network_profile: Optional["_models.NetworkProfile"] = rest_field(
        name="networkProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network profile for Batch account, which contains network rule settings for each endpoint."""
    encryption: Optional["_models.EncryptionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The encryption configuration for the Batch account."""
    allowed_authentication_modes: Optional[list[Union[str, "_models.AuthenticationMode"]]] = rest_field(
        name="allowedAuthenticationModes", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of allowed authentication modes for the Batch account that can be used to authenticate
     with the data plane. This does not affect authentication with the control plane."""

    @overload
    def __init__(
        self,
        *,
        auto_storage: Optional["_models.AutoStorageBaseProperties"] = None,
        pool_allocation_mode: Optional[Union[str, "_models.PoolAllocationMode"]] = None,
        key_vault_reference: Optional["_models.KeyVaultReference"] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccessType"]] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        encryption: Optional["_models.EncryptionProperties"] = None,
        allowed_authentication_modes: Optional[list[Union[str, "_models.AuthenticationMode"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchAccountIdentity(_Model):
    """The identity of the Batch account, if configured. This is used when the user specifies
    'Microsoft.KeyVault' as their Batch account encryption configuration or when
    ``ManagedIdentity`` is selected as the auto-storage authentication mode.

    :ivar principal_id: The principal id of the Batch account. This property will only be provided
     for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the Batch account. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the Batch account. Required. Known values are:
     "SystemAssigned", "UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.batch.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the Batch account.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.batch.models.UserAssignedIdentities]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal id of the Batch account. This property will only be provided for a system
     assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant id associated with the Batch account. This property will only be provided for a
     system assigned identity."""
    type: Union[str, "_models.ResourceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity used for the Batch account. Required. Known values are:
     \"SystemAssigned\", \"UserAssigned\", and \"None\"."""
    user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentities"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of user identities associated with the Batch account."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ResourceIdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentities"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchAccountKeys(_Model):
    """A set of Azure Batch account keys.

    :ivar account_name: The Batch account name.
    :vartype account_name: str
    :ivar primary: The primary key associated with the account.
    :vartype primary: str
    :ivar secondary: The secondary key associated with the account.
    :vartype secondary: str
    """

    account_name: Optional[str] = rest_field(name="accountName", visibility=["read"])
    """The Batch account name."""
    primary: Optional[str] = rest_field(visibility=["read"])
    """The primary key associated with the account."""
    secondary: Optional[str] = rest_field(visibility=["read"])
    """The secondary key associated with the account."""


class BatchAccountProperties(_Model):
    """Account specific properties.

    :ivar account_endpoint: The account endpoint used to interact with the Batch service.
    :vartype account_endpoint: str
    :ivar node_management_endpoint: The endpoint used by compute node to connect to the Batch node
     management service.
    :vartype node_management_endpoint: str
    :ivar provisioning_state: The provisioned state of the resource. Known values are: "Invalid",
     "Creating", "Deleting", "Succeeded", "Failed", and "Cancelled".
    :vartype provisioning_state: str or ~azure.mgmt.batch.models.ProvisioningState
    :ivar pool_allocation_mode: The allocation mode to use for creating pools in the Batch account.
     Known values are: "BatchService" and "UserSubscription".
    :vartype pool_allocation_mode: str or ~azure.mgmt.batch.models.PoolAllocationMode
    :ivar key_vault_reference: A reference to the Azure key vault associated with the Batch
     account.
    :vartype key_vault_reference: ~azure.mgmt.batch.models.KeyVaultReference
    :ivar public_network_access: The network interface type for accessing Azure Batch service and
     Batch account operations. Known values are: "Enabled", "Disabled", and "SecuredByPerimeter".
    :vartype public_network_access: str or ~azure.mgmt.batch.models.PublicNetworkAccessType
    :ivar network_profile: Network profile for Batch account, which contains network rule settings
     for each endpoint.
    :vartype network_profile: ~azure.mgmt.batch.models.NetworkProfile
    :ivar private_endpoint_connections: List of private endpoint connections associated with the
     Batch account.
    :vartype private_endpoint_connections: list[~azure.mgmt.batch.models.PrivateEndpointConnection]
    :ivar auto_storage: The properties and status of any auto-storage account associated with the
     Batch account.
    :vartype auto_storage: ~azure.mgmt.batch.models.AutoStorageProperties
    :ivar encryption: The encryption configuration for the Batch account.
    :vartype encryption: ~azure.mgmt.batch.models.EncryptionProperties
    :ivar dedicated_core_quota: The dedicated core quota for the Batch account.
    :vartype dedicated_core_quota: int
    :ivar low_priority_core_quota: The Spot/low-priority core quota for the Batch account.
    :vartype low_priority_core_quota: int
    :ivar dedicated_core_quota_per_vm_family: A list of the dedicated core quota per Virtual
     Machine family for the Batch account. For accounts with PoolAllocationMode set to
     UserSubscription, quota is managed on the subscription so this value is not returned.
    :vartype dedicated_core_quota_per_vm_family:
     list[~azure.mgmt.batch.models.VirtualMachineFamilyCoreQuota]
    :ivar dedicated_core_quota_per_vm_family_enforced: A value indicating whether core quotas per
     Virtual Machine family are enforced for this account.
    :vartype dedicated_core_quota_per_vm_family_enforced: bool
    :ivar pool_quota: The pool quota for the Batch account.
    :vartype pool_quota: int
    :ivar active_job_and_job_schedule_quota: The active job and job schedule quota for the Batch
     account.
    :vartype active_job_and_job_schedule_quota: int
    :ivar allowed_authentication_modes: List of allowed authentication modes for the Batch account
     that can be used to authenticate with the data plane. This does not affect authentication with
     the control plane.
    :vartype allowed_authentication_modes: list[str or ~azure.mgmt.batch.models.AuthenticationMode]
    """

    account_endpoint: Optional[str] = rest_field(name="accountEndpoint", visibility=["read"])
    """The account endpoint used to interact with the Batch service."""
    node_management_endpoint: Optional[str] = rest_field(name="nodeManagementEndpoint", visibility=["read"])
    """The endpoint used by compute node to connect to the Batch node management service."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioned state of the resource. Known values are: \"Invalid\", \"Creating\",
     \"Deleting\", \"Succeeded\", \"Failed\", and \"Cancelled\"."""
    pool_allocation_mode: Optional[Union[str, "_models.PoolAllocationMode"]] = rest_field(
        name="poolAllocationMode", visibility=["read"]
    )
    """The allocation mode to use for creating pools in the Batch account. Known values are:
     \"BatchService\" and \"UserSubscription\"."""
    key_vault_reference: Optional["_models.KeyVaultReference"] = rest_field(
        name="keyVaultReference", visibility=["read"]
    )
    """A reference to the Azure key vault associated with the Batch account."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccessType"]] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """The network interface type for accessing Azure Batch service and Batch account operations.
     Known values are: \"Enabled\", \"Disabled\", and \"SecuredByPerimeter\"."""
    network_profile: Optional["_models.NetworkProfile"] = rest_field(
        name="networkProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network profile for Batch account, which contains network rule settings for each endpoint."""
    private_endpoint_connections: Optional[list["_models.PrivateEndpointConnection"]] = rest_field(
        name="privateEndpointConnections", visibility=["read"]
    )
    """List of private endpoint connections associated with the Batch account."""
    auto_storage: Optional["_models.AutoStorageProperties"] = rest_field(name="autoStorage", visibility=["read"])
    """The properties and status of any auto-storage account associated with the Batch account."""
    encryption: Optional["_models.EncryptionProperties"] = rest_field(visibility=["read"])
    """The encryption configuration for the Batch account."""
    dedicated_core_quota: Optional[int] = rest_field(name="dedicatedCoreQuota", visibility=["read"])
    """The dedicated core quota for the Batch account."""
    low_priority_core_quota: Optional[int] = rest_field(name="lowPriorityCoreQuota", visibility=["read"])
    """The Spot/low-priority core quota for the Batch account."""
    dedicated_core_quota_per_vm_family: Optional[list["_models.VirtualMachineFamilyCoreQuota"]] = rest_field(
        name="dedicatedCoreQuotaPerVMFamily", visibility=["read"]
    )
    """A list of the dedicated core quota per Virtual Machine family for the Batch account. For
     accounts with PoolAllocationMode set to UserSubscription, quota is managed on the subscription
     so this value is not returned."""
    dedicated_core_quota_per_vm_family_enforced: Optional[bool] = rest_field(
        name="dedicatedCoreQuotaPerVMFamilyEnforced", visibility=["read"]
    )
    """A value indicating whether core quotas per Virtual Machine family are enforced for this
     account."""
    pool_quota: Optional[int] = rest_field(name="poolQuota", visibility=["read"])
    """The pool quota for the Batch account."""
    active_job_and_job_schedule_quota: Optional[int] = rest_field(
        name="activeJobAndJobScheduleQuota", visibility=["read"]
    )
    """The active job and job schedule quota for the Batch account."""
    allowed_authentication_modes: Optional[list[Union[str, "_models.AuthenticationMode"]]] = rest_field(
        name="allowedAuthenticationModes", visibility=["read"]
    )
    """List of allowed authentication modes for the Batch account that can be used to authenticate
     with the data plane. This does not affect authentication with the control plane."""

    @overload
    def __init__(
        self,
        *,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccessType"]] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchAccountRegenerateKeyParameters(_Model):
    """Parameters supplied to the RegenerateKey operation.

    :ivar key_name: The type of account key to regenerate. Required. Known values are: "Primary"
     and "Secondary".
    :vartype key_name: str or ~azure.mgmt.batch.models.AccountKeyType
    """

    key_name: Union[str, "_models.AccountKeyType"] = rest_field(
        name="keyName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of account key to regenerate. Required. Known values are: \"Primary\" and
     \"Secondary\"."""

    @overload
    def __init__(
        self,
        *,
        key_name: Union[str, "_models.AccountKeyType"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchAccountUpdateParameters(_Model):
    """Parameters for updating an Azure Batch account.

    :ivar tags: The user-specified tags associated with the account.
    :vartype tags: dict[str, str]
    :ivar properties: The properties of the account.
    :vartype properties: ~azure.mgmt.batch.models.BatchAccountUpdateProperties
    :ivar identity: The identity of the Batch account.
    :vartype identity: ~azure.mgmt.batch.models.BatchAccountIdentity
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The user-specified tags associated with the account."""
    properties: Optional["_models.BatchAccountUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of the account."""
    identity: Optional["_models.BatchAccountIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity of the Batch account."""

    __flattened_items = [
        "auto_storage",
        "encryption",
        "allowed_authentication_modes",
        "public_network_access",
        "network_profile",
    ]

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.BatchAccountUpdateProperties"] = None,
        identity: Optional["_models.BatchAccountIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class BatchAccountUpdateProperties(_Model):
    """The properties of a Batch account.

    :ivar auto_storage: The properties related to the auto-storage account.
    :vartype auto_storage: ~azure.mgmt.batch.models.AutoStorageBaseProperties
    :ivar encryption: The encryption configuration for the Batch account.
    :vartype encryption: ~azure.mgmt.batch.models.EncryptionProperties
    :ivar allowed_authentication_modes: List of allowed authentication modes for the Batch account
     that can be used to authenticate with the data plane. This does not affect authentication with
     the control plane.
    :vartype allowed_authentication_modes: list[str or ~azure.mgmt.batch.models.AuthenticationMode]
    :ivar public_network_access: The network access type for accessing Azure Batch account. Known
     values are: "Enabled", "Disabled", and "SecuredByPerimeter".
    :vartype public_network_access: str or ~azure.mgmt.batch.models.PublicNetworkAccessType
    :ivar network_profile: Network profile for Batch account, which contains network rule settings
     for each endpoint.
    :vartype network_profile: ~azure.mgmt.batch.models.NetworkProfile
    """

    auto_storage: Optional["_models.AutoStorageBaseProperties"] = rest_field(
        name="autoStorage", visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties related to the auto-storage account."""
    encryption: Optional["_models.EncryptionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The encryption configuration for the Batch account."""
    allowed_authentication_modes: Optional[list[Union[str, "_models.AuthenticationMode"]]] = rest_field(
        name="allowedAuthenticationModes", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of allowed authentication modes for the Batch account that can be used to authenticate
     with the data plane. This does not affect authentication with the control plane."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccessType"]] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """The network access type for accessing Azure Batch account. Known values are: \"Enabled\",
     \"Disabled\", and \"SecuredByPerimeter\"."""
    network_profile: Optional["_models.NetworkProfile"] = rest_field(
        name="networkProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network profile for Batch account, which contains network rule settings for each endpoint."""

    @overload
    def __init__(
        self,
        *,
        auto_storage: Optional["_models.AutoStorageBaseProperties"] = None,
        encryption: Optional["_models.EncryptionProperties"] = None,
        allowed_authentication_modes: Optional[list[Union[str, "_models.AuthenticationMode"]]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccessType"]] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchLocationQuota(_Model):
    """Quotas associated with a Batch region for a particular subscription.

    :ivar account_quota: The number of Batch accounts that may be created under the subscription in
     the specified region.
    :vartype account_quota: int
    """

    account_quota: Optional[int] = rest_field(name="accountQuota", visibility=["read"])
    """The number of Batch accounts that may be created under the subscription in the specified
     region."""


class BatchPoolIdentity(_Model):
    """The identity of the Batch pool, if configured. If the pool identity is updated during update an
    existing pool, only the new vms which are created after the pool shrinks to 0 will have the
    updated identities.

    :ivar type: The type of identity used for the Batch Pool. Required. Known values are:
     "UserAssigned" and "None".
    :vartype type: str or ~azure.mgmt.batch.models.PoolIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the Batch pool.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.batch.models.UserAssignedIdentities]
    """

    type: Union[str, "_models.PoolIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity used for the Batch Pool. Required. Known values are: \"UserAssigned\" and
     \"None\"."""
    user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentities"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of user identities associated with the Batch pool."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.PoolIdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentities"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckNameAvailabilityParameters(_Model):
    """Parameters for a check name availability request.

    :ivar name: The name to check for availability. Required.
    :vartype name: str
    :ivar type: The resource type. Required. "Microsoft.Batch/batchAccounts"
    :vartype type: str or ~azure.mgmt.batch.models.ResourceType
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name to check for availability. Required."""
    type: Union[str, "_models.ResourceType"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource type. Required. \"Microsoft.Batch/batchAccounts\""""

    @overload
    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.ResourceType"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckNameAvailabilityResult(_Model):
    """The CheckNameAvailability operation response.

    :ivar name_available: Gets a boolean value that indicates whether the name is available for you
     to use. If true, the name is available. If false, the name has already been taken or invalid
     and cannot be used.
    :vartype name_available: bool
    :ivar reason: Gets the reason that a Batch account name could not be used. The Reason element
     is only returned if NameAvailable is false. Known values are: "Invalid" and "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.batch.models.NameAvailabilityReason
    :ivar message: Gets an error message explaining the Reason value in more detail.
    :vartype message: str
    """

    name_available: Optional[bool] = rest_field(name="nameAvailable", visibility=["read"])
    """Gets a boolean value that indicates whether the name is available for you to use. If true, the
     name is available. If false, the name has already been taken or invalid and cannot be used."""
    reason: Optional[Union[str, "_models.NameAvailabilityReason"]] = rest_field(visibility=["read"])
    """Gets the reason that a Batch account name could not be used. The Reason element is only
     returned if NameAvailable is false. Known values are: \"Invalid\" and \"AlreadyExists\"."""
    message: Optional[str] = rest_field(visibility=["read"])
    """Gets an error message explaining the Reason value in more detail."""


class CIFSMountConfiguration(_Model):
    """Information used to connect to a CIFS file system.

    :ivar user_name: The user to use for authentication against the CIFS file system. Required.
    :vartype user_name: str
    :ivar source: The URI of the file system to mount. Required.
    :vartype source: str
    :ivar relative_mount_path: The relative path on the compute node where the file system will be
     mounted. Required.
    :vartype relative_mount_path: str
    :ivar mount_options: Additional command line options to pass to the mount command.
    :vartype mount_options: str
    :ivar password: The password to use for authentication against the CIFS file system. Required.
    :vartype password: str
    """

    user_name: str = rest_field(name="userName", visibility=["read", "create", "update", "delete", "query"])
    """The user to use for authentication against the CIFS file system. Required."""
    source: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URI of the file system to mount. Required."""
    relative_mount_path: str = rest_field(
        name="relativeMountPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The relative path on the compute node where the file system will be mounted. Required."""
    mount_options: Optional[str] = rest_field(
        name="mountOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional command line options to pass to the mount command."""
    password: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The password to use for authentication against the CIFS file system. Required."""

    @overload
    def __init__(
        self,
        *,
        user_name: str,
        source: str,
        relative_mount_path: str,
        password: str,
        mount_options: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudError(_Model):
    """An error response from the Batch service.

    :ivar error: The body of the error response.
    :vartype error: ~azure.mgmt.batch.models.CloudErrorBody
    """

    error: Optional["_models.CloudErrorBody"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The body of the error response."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.CloudErrorBody"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudErrorBody(_Model):
    """An error response from the Batch service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.batch.models.CloudErrorBody]
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A message describing the error, intended to be suitable for display in a user interface."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The target of the particular error. For example, the name of the property in error."""
    details: Optional[list["_models.CloudErrorBody"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of additional details about the error."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[list["_models.CloudErrorBody"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ComputeNodeIdentityReference(_Model):
    """The reference to a user assigned identity associated with the Batch pool which a compute node
    will use.

    :ivar resource_id: The ARM resource id of the user assigned identity.
    :vartype resource_id: str
    """

    resource_id: Optional[str] = rest_field(
        name="resourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ARM resource id of the user assigned identity."""

    @overload
    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContainerConfiguration(_Model):
    """The configuration for container-enabled pools.

    :ivar type: The container technology to be used. Required. Known values are: "DockerCompatible"
     and "CriCompatible".
    :vartype type: str or ~azure.mgmt.batch.models.ContainerType
    :ivar container_image_names: The collection of container image names.
    :vartype container_image_names: list[str]
    :ivar container_registries: Additional private registries from which containers can be pulled.
    :vartype container_registries: list[~azure.mgmt.batch.models.ContainerRegistry]
    """

    type: Union[str, "_models.ContainerType"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The container technology to be used. Required. Known values are: \"DockerCompatible\" and
     \"CriCompatible\"."""
    container_image_names: Optional[list[str]] = rest_field(
        name="containerImageNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The collection of container image names."""
    container_registries: Optional[list["_models.ContainerRegistry"]] = rest_field(
        name="containerRegistries", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional private registries from which containers can be pulled."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ContainerType"],
        container_image_names: Optional[list[str]] = None,
        container_registries: Optional[list["_models.ContainerRegistry"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContainerHostBatchBindMountEntry(_Model):
    """The entry of path and mount mode you want to mount into task container.

    :ivar source: The paths which will be mounted to container task's container. Known values are:
     "Shared", "Startup", "VfsMounts", "Task", "JobPrep", and "Applications".
    :vartype source: str or ~azure.mgmt.batch.models.ContainerHostDataPath
    :ivar is_read_only: Mount this source path as read-only mode or not. Default value is false
     (read/write mode).
    :vartype is_read_only: bool
    """

    source: Optional[Union[str, "_models.ContainerHostDataPath"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The paths which will be mounted to container task's container. Known values are: \"Shared\",
     \"Startup\", \"VfsMounts\", \"Task\", \"JobPrep\", and \"Applications\"."""
    is_read_only: Optional[bool] = rest_field(
        name="isReadOnly", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mount this source path as read-only mode or not. Default value is false (read/write mode)."""

    @overload
    def __init__(
        self,
        *,
        source: Optional[Union[str, "_models.ContainerHostDataPath"]] = None,
        is_read_only: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContainerRegistry(_Model):
    """A private container registry.

    :ivar user_name: The user name to log into the registry server.
    :vartype user_name: str
    :ivar password: The password to log into the registry server.
    :vartype password: str
    :ivar registry_server: The registry URL.
    :vartype registry_server: str
    :ivar identity_reference: The reference to the user assigned identity to use to access an Azure
     Container Registry instead of username and password.
    :vartype identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
    """

    user_name: Optional[str] = rest_field(name="username", visibility=["read", "create", "update", "delete", "query"])
    """The user name to log into the registry server."""
    password: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The password to log into the registry server."""
    registry_server: Optional[str] = rest_field(
        name="registryServer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The registry URL."""
    identity_reference: Optional["_models.ComputeNodeIdentityReference"] = rest_field(
        name="identityReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference to the user assigned identity to use to access an Azure Container Registry
     instead of username and password."""

    @overload
    def __init__(
        self,
        *,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        registry_server: Optional[str] = None,
        identity_reference: Optional["_models.ComputeNodeIdentityReference"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataDisk(_Model):
    """Settings which will be used by the data disks associated to Compute Nodes in the Pool. When
    using attached data disks, you need to mount and format the disks from within a VM to use them.

    :ivar lun: The logical unit number. Required.
    :vartype lun: int
    :ivar caching: The type of caching to enable for the disk. Known values are: "None",
     "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.batch.models.CachingType
    :ivar disk_size_gb: The initial disk size in GB when creating new data disk. Required.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk: ~azure.mgmt.batch.models.ManagedDisk
    """

    lun: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The logical unit number. Required."""
    caching: Optional[Union[str, "_models.CachingType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of caching to enable for the disk. Known values are: \"None\", \"ReadOnly\", and
     \"ReadWrite\"."""
    disk_size_gb: int = rest_field(name="diskSizeGB", visibility=["read", "create", "update", "delete", "query"])
    """The initial disk size in GB when creating new data disk. Required."""
    managed_disk: Optional["_models.ManagedDisk"] = rest_field(
        name="managedDisk", visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed disk parameters."""

    @overload
    def __init__(
        self,
        *,
        lun: int,
        disk_size_gb: int,
        caching: Optional[Union[str, "_models.CachingType"]] = None,
        managed_disk: Optional["_models.ManagedDisk"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeploymentConfiguration(_Model):
    """Deployment configuration properties.

    :ivar virtual_machine_configuration: The virtual machine configuration for the pool.
    :vartype virtual_machine_configuration: ~azure.mgmt.batch.models.VirtualMachineConfiguration
    """

    virtual_machine_configuration: Optional["_models.VirtualMachineConfiguration"] = rest_field(
        name="virtualMachineConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The virtual machine configuration for the pool."""

    @overload
    def __init__(
        self,
        *,
        virtual_machine_configuration: Optional["_models.VirtualMachineConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DetectorResponse(ProxyResource):
    """Contains the information for a detector.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.batch.models.SystemData
    :ivar properties: The properties associated with the detector.
    :vartype properties: ~azure.mgmt.batch.models.DetectorResponseProperties
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.DetectorResponseProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties associated with the detector."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """The ETag of the resource, used for concurrency statements."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tags of the resource."""

    __flattened_items = ["value"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DetectorResponseProperties"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class DetectorResponseProperties(_Model):
    """Detector response properties.

    :ivar value: A base64 encoded string that represents the content of a detector.
    :vartype value: str
    """

    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A base64 encoded string that represents the content of a detector."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiffDiskSettings(_Model):
    """Specifies the ephemeral Disk Settings for the operating system disk used by the virtual
    machine.

    :ivar placement: Specifies the ephemeral disk placement for operating system disk for all VMs
     in the pool. "CacheDisk"
    :vartype placement: str or ~azure.mgmt.batch.models.DiffDiskPlacement
    """

    placement: Optional[Union[str, "_models.DiffDiskPlacement"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the ephemeral disk placement for operating system disk for all VMs in the pool.
     \"CacheDisk\""""

    @overload
    def __init__(
        self,
        *,
        placement: Optional[Union[str, "_models.DiffDiskPlacement"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiskCustomerManagedKey(_Model):
    """The Customer Managed Key reference to encrypt the Disk.

    :ivar key_url: Fully versioned Key Url pointing to a key in KeyVault. Version segment of the
     Url is required regardless of rotationToLatestKeyVersionEnabled value.
    :vartype key_url: str
    :ivar rotation_to_latest_key_version_enabled: Set this flag to true to enable auto-updating of
     the Disk Encryption to the latest key version. Default is false.
    :vartype rotation_to_latest_key_version_enabled: bool
    :ivar identity_reference: The reference of one of the pool identities to encrypt Disk. This
     identity will be used to access the KeyVault.
    :vartype identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
    """

    key_url: Optional[str] = rest_field(name="keyUrl", visibility=["read", "create", "update", "delete", "query"])
    """Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is required
     regardless of rotationToLatestKeyVersionEnabled value."""
    rotation_to_latest_key_version_enabled: Optional[bool] = rest_field(
        name="rotationToLatestKeyVersionEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Set this flag to true to enable auto-updating of the Disk Encryption to the latest key version.
     Default is false."""
    identity_reference: Optional["_models.ComputeNodeIdentityReference"] = rest_field(
        name="identityReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference of one of the pool identities to encrypt Disk. This identity will be used to
     access the KeyVault."""

    @overload
    def __init__(
        self,
        *,
        key_url: Optional[str] = None,
        rotation_to_latest_key_version_enabled: Optional[bool] = None,
        identity_reference: Optional["_models.ComputeNodeIdentityReference"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiskEncryptionConfiguration(_Model):
    """The disk encryption configuration applied on compute nodes in the pool. Disk encryption
    configuration is not supported on Linux pool created with Virtual Machine Image or Azure
    Compute Gallery Image.

    :ivar targets: The list of disk targets Batch Service will encrypt on the compute node.
    :vartype targets: list[str or ~azure.mgmt.batch.models.DiskEncryptionTarget]
    :ivar customer_managed_key: The Customer Managed Key reference to encrypt the OS Disk.
    :vartype customer_managed_key: ~azure.mgmt.batch.models.DiskCustomerManagedKey
    """

    targets: Optional[list[Union[str, "_models.DiskEncryptionTarget"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of disk targets Batch Service will encrypt on the compute node."""
    customer_managed_key: Optional["_models.DiskCustomerManagedKey"] = rest_field(
        name="customerManagedKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Customer Managed Key reference to encrypt the OS Disk."""

    @overload
    def __init__(
        self,
        *,
        targets: Optional[list[Union[str, "_models.DiskEncryptionTarget"]]] = None,
        customer_managed_key: Optional["_models.DiskCustomerManagedKey"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiskEncryptionSetParameters(_Model):
    """The ARM resource id of the disk encryption set.

    :ivar id: The resource id of the disk encryption set. Required.
    :vartype id: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource id of the disk encryption set. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EncryptionProperties(_Model):
    """Configures how customer data is encrypted inside the Batch account. By default, accounts are
    encrypted using a Microsoft managed key. For additional control, a customer-managed key can be
    used instead.

    :ivar key_source: Type of the key source. Known values are: "Microsoft.Batch" and
     "Microsoft.KeyVault".
    :vartype key_source: str or ~azure.mgmt.batch.models.KeySource
    :ivar key_vault_properties: Additional details when using Microsoft.KeyVault.
    :vartype key_vault_properties: ~azure.mgmt.batch.models.KeyVaultProperties
    """

    key_source: Optional[Union[str, "_models.KeySource"]] = rest_field(
        name="keySource", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of the key source. Known values are: \"Microsoft.Batch\" and \"Microsoft.KeyVault\"."""
    key_vault_properties: Optional["_models.KeyVaultProperties"] = rest_field(
        name="keyVaultProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional details when using Microsoft.KeyVault."""

    @overload
    def __init__(
        self,
        *,
        key_source: Optional[Union[str, "_models.KeySource"]] = None,
        key_vault_properties: Optional["_models.KeyVaultProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EndpointAccessProfile(_Model):
    """Network access profile for Batch endpoint.

    :ivar default_action: The default action when there is no IPRule matched. Required. Known
     values are: "Allow" and "Deny".
    :vartype default_action: str or ~azure.mgmt.batch.models.EndpointAccessDefaultAction
    :ivar ip_rules: Array of IP ranges to filter client IP address.
    :vartype ip_rules: list[~azure.mgmt.batch.models.IPRule]
    """

    default_action: Union[str, "_models.EndpointAccessDefaultAction"] = rest_field(
        name="defaultAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """The default action when there is no IPRule matched. Required. Known values are: \"Allow\" and
     \"Deny\"."""
    ip_rules: Optional[list["_models.IPRule"]] = rest_field(
        name="ipRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """Array of IP ranges to filter client IP address."""

    @overload
    def __init__(
        self,
        *,
        default_action: Union[str, "_models.EndpointAccessDefaultAction"],
        ip_rules: Optional[list["_models.IPRule"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EndpointDependency(_Model):
    """A domain name and connection details used to access a dependency.

    :ivar domain_name: The domain name of the dependency. Domain names may be fully qualified or
     may contain a * wildcard.
    :vartype domain_name: str
    :ivar description: Human-readable supplemental information about the dependency and when it is
     applicable.
    :vartype description: str
    :ivar endpoint_details: The list of connection details for this endpoint.
    :vartype endpoint_details: list[~azure.mgmt.batch.models.EndpointDetail]
    """

    domain_name: Optional[str] = rest_field(name="domainName", visibility=["read"])
    """The domain name of the dependency. Domain names may be fully qualified or may contain a *
     wildcard."""
    description: Optional[str] = rest_field(visibility=["read"])
    """Human-readable supplemental information about the dependency and when it is applicable."""
    endpoint_details: Optional[list["_models.EndpointDetail"]] = rest_field(name="endpointDetails", visibility=["read"])
    """The list of connection details for this endpoint."""


class EndpointDetail(_Model):
    """Details about the connection between the Batch service and the endpoint.

    :ivar port: The port an endpoint is connected to.
    :vartype port: int
    """

    port: Optional[int] = rest_field(visibility=["read"])
    """The port an endpoint is connected to."""


class EnvironmentSetting(_Model):
    """An environment variable to be set on a task process.

    :ivar name: The name of the environment variable. Required.
    :vartype name: str
    :ivar value: The value of the environment variable.
    :vartype value: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the environment variable. Required."""
    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the environment variable."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.batch.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.batch.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.batch.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FixedScaleSettings(_Model):
    """Fixed scale settings for the pool.

    :ivar resize_timeout: The timeout for allocation of compute nodes to the pool.
    :vartype resize_timeout: ~datetime.timedelta
    :ivar target_dedicated_nodes: The desired number of dedicated compute nodes in the pool.
    :vartype target_dedicated_nodes: int
    :ivar target_low_priority_nodes: The desired number of Spot/low-priority compute nodes in the
     pool.
    :vartype target_low_priority_nodes: int
    :ivar node_deallocation_option: Determines what to do with a node and its running task(s) after
     it has been selected for deallocation. Known values are: "Requeue", "Terminate",
     "TaskCompletion", and "RetainedData".
    :vartype node_deallocation_option: str or
     ~azure.mgmt.batch.models.ComputeNodeDeallocationOption
    """

    resize_timeout: Optional[datetime.timedelta] = rest_field(
        name="resizeTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """The timeout for allocation of compute nodes to the pool."""
    target_dedicated_nodes: Optional[int] = rest_field(
        name="targetDedicatedNodes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired number of dedicated compute nodes in the pool."""
    target_low_priority_nodes: Optional[int] = rest_field(
        name="targetLowPriorityNodes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired number of Spot/low-priority compute nodes in the pool."""
    node_deallocation_option: Optional[Union[str, "_models.ComputeNodeDeallocationOption"]] = rest_field(
        name="nodeDeallocationOption", visibility=["create", "update"]
    )
    """Determines what to do with a node and its running task(s) after it has been selected for
     deallocation. Known values are: \"Requeue\", \"Terminate\", \"TaskCompletion\", and
     \"RetainedData\"."""

    @overload
    def __init__(
        self,
        *,
        resize_timeout: Optional[datetime.timedelta] = None,
        target_dedicated_nodes: Optional[int] = None,
        target_low_priority_nodes: Optional[int] = None,
        node_deallocation_option: Optional[Union[str, "_models.ComputeNodeDeallocationOption"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HostEndpointSettings(_Model):
    """Specifies particular host endpoint settings.

    :ivar mode: Specifies the access control policy execution mode. Known values are: "Audit" and
     "Enforce".
    :vartype mode: str or ~azure.mgmt.batch.models.HostEndpointSettingsModeTypes
    :ivar in_vm_access_control_profile_reference_id: Specifies the reference to the
     InVMAccessControlProfileVersion resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{profile}/versions/{version}.
    :vartype in_vm_access_control_profile_reference_id: str
    """

    mode: Optional[Union[str, "_models.HostEndpointSettingsModeTypes"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the access control policy execution mode. Known values are: \"Audit\" and
     \"Enforce\"."""
    in_vm_access_control_profile_reference_id: Optional[str] = rest_field(
        name="inVMAccessControlProfileReferenceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the reference to the InVMAccessControlProfileVersion resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{profile}/versions/{version}."""

    @overload
    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.HostEndpointSettingsModeTypes"]] = None,
        in_vm_access_control_profile_reference_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImageReference(_Model):
    """A reference to an Azure Virtual Machines Marketplace image or the Azure Image resource of a
    custom Virtual Machine. To get the list of all imageReferences verified by Azure Batch, see the
    'List supported node agent SKUs' operation.

    :ivar publisher: The publisher of the Azure Virtual Machines Marketplace image.
    :vartype publisher: str
    :ivar offer: The offer type of the Azure Virtual Machines Marketplace image.
    :vartype offer: str
    :ivar sku: The SKU of the Azure Virtual Machines Marketplace image.
    :vartype sku: str
    :ivar version: The version of the Azure Virtual Machines Marketplace image.
    :vartype version: str
    :ivar id: The ARM resource identifier of the Azure Compute Gallery Image. Compute Nodes in the
     Pool will be created using this Image Id. This is of the form
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{versionId}.
    :vartype id: str
    :ivar shared_gallery_image_id: The shared gallery image unique identifier.
    :vartype shared_gallery_image_id: str
    :ivar community_gallery_image_id: The community gallery image unique identifier.
    :vartype community_gallery_image_id: str
    """

    publisher: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The publisher of the Azure Virtual Machines Marketplace image."""
    offer: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The offer type of the Azure Virtual Machines Marketplace image."""
    sku: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SKU of the Azure Virtual Machines Marketplace image."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The version of the Azure Virtual Machines Marketplace image."""
    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ARM resource identifier of the Azure Compute Gallery Image. Compute Nodes in the Pool will
     be created using this Image Id. This is of the form
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{versionId}."""
    shared_gallery_image_id: Optional[str] = rest_field(
        name="sharedGalleryImageId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The shared gallery image unique identifier."""
    community_gallery_image_id: Optional[str] = rest_field(
        name="communityGalleryImageId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The community gallery image unique identifier."""

    @overload
    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        sku: Optional[str] = None,
        version: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        shared_gallery_image_id: Optional[str] = None,
        community_gallery_image_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InboundNatPool(_Model):
    """A inbound NAT pool that can be used to address specific ports on compute nodes in a Batch pool
    externally.

    :ivar name: The name of the endpoint. Required.
    :vartype name: str
    :ivar protocol: The protocol of the endpoint. Required. Known values are: "TCP" and "UDP".
    :vartype protocol: str or ~azure.mgmt.batch.models.InboundEndpointProtocol
    :ivar backend_port: The port number on the compute node. Required.
    :vartype backend_port: int
    :ivar frontend_port_range_start: The first port number in the range of external ports that will
     be used to provide inbound access to the backendPort on individual compute nodes. Required.
    :vartype frontend_port_range_start: int
    :ivar frontend_port_range_end: The last port number in the range of external ports that will be
     used to provide inbound access to the backendPort on individual compute nodes. Required.
    :vartype frontend_port_range_end: int
    :ivar network_security_group_rules: A list of network security group rules that will be applied
     to the endpoint.
    :vartype network_security_group_rules: list[~azure.mgmt.batch.models.NetworkSecurityGroupRule]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the endpoint. Required."""
    protocol: Union[str, "_models.InboundEndpointProtocol"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The protocol of the endpoint. Required. Known values are: \"TCP\" and \"UDP\"."""
    backend_port: int = rest_field(name="backendPort", visibility=["read", "create", "update", "delete", "query"])
    """The port number on the compute node. Required."""
    frontend_port_range_start: int = rest_field(
        name="frontendPortRangeStart", visibility=["read", "create", "update", "delete", "query"]
    )
    """The first port number in the range of external ports that will be used to provide inbound
     access to the backendPort on individual compute nodes. Required."""
    frontend_port_range_end: int = rest_field(
        name="frontendPortRangeEnd", visibility=["read", "create", "update", "delete", "query"]
    )
    """The last port number in the range of external ports that will be used to provide inbound access
     to the backendPort on individual compute nodes. Required."""
    network_security_group_rules: Optional[list["_models.NetworkSecurityGroupRule"]] = rest_field(
        name="networkSecurityGroupRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of network security group rules that will be applied to the endpoint."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        protocol: Union[str, "_models.InboundEndpointProtocol"],
        backend_port: int,
        frontend_port_range_start: int,
        frontend_port_range_end: int,
        network_security_group_rules: Optional[list["_models.NetworkSecurityGroupRule"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IPRule(_Model):
    """Rule to filter client IP address.

    :ivar action: Action when client IP address is matched. Required. "Allow"
    :vartype action: str or ~azure.mgmt.batch.models.IPRuleAction
    :ivar value: The IP address or IP address range to filter. Required.
    :vartype value: str
    """

    action: Union[str, "_models.IPRuleAction"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Action when client IP address is matched. Required. \"Allow\""""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The IP address or IP address range to filter. Required."""

    @overload
    def __init__(
        self,
        *,
        action: Union[str, "_models.IPRuleAction"],
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IPTag(_Model):
    """Specifies how tasks should be distributed across compute nodes.

    :ivar ip_tag_type: The IP Tag type.
    :vartype ip_tag_type: str
    :ivar tag: The value of the IP tag associated with the public IP.
    :vartype tag: str
    """

    ip_tag_type: Optional[str] = rest_field(
        name="ipTagType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The IP Tag type."""
    tag: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the IP tag associated with the public IP."""

    @overload
    def __init__(
        self,
        *,
        ip_tag_type: Optional[str] = None,
        tag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyVaultProperties(_Model):
    """KeyVault configuration when using an encryption KeySource of Microsoft.KeyVault.

    :ivar key_identifier: Full path to the secret with or without version. Example
     `https://mykeyvault.vault.azure.net/keys/testkey/6e34a81fef704045975661e297a4c053
     <https://mykeyvault.vault.azure.net/keys/testkey/6e34a81fef704045975661e297a4c053>`_. or
     `https://mykeyvault.vault.azure.net/keys/testkey
     <https://mykeyvault.vault.azure.net/keys/testkey>`_. To be usable the following prerequisites
     must be met:

     The Batch Account has a System Assigned identity
     The account identity has been granted Key/Get, Key/Unwrap and Key/Wrap permissions
     The KeyVault has soft-delete and purge protection enabled.
    :vartype key_identifier: str
    """

    key_identifier: Optional[str] = rest_field(
        name="keyIdentifier", visibility=["read", "create", "update", "delete", "query"]
    )
    """Full path to the secret with or without version. Example
     `https://mykeyvault.vault.azure.net/keys/testkey/6e34a81fef704045975661e297a4c053
     <https://mykeyvault.vault.azure.net/keys/testkey/6e34a81fef704045975661e297a4c053>`_. or
     `https://mykeyvault.vault.azure.net/keys/testkey
     <https://mykeyvault.vault.azure.net/keys/testkey>`_. To be usable the following prerequisites
     must be met:
     
     The Batch Account has a System Assigned identity
     The account identity has been granted Key/Get, Key/Unwrap and Key/Wrap permissions
     The KeyVault has soft-delete and purge protection enabled."""

    @overload
    def __init__(
        self,
        *,
        key_identifier: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyVaultReference(_Model):
    """Identifies the Azure key vault associated with a Batch account.

    :ivar id: The resource ID of the Azure key vault associated with the Batch account. Required.
    :vartype id: str
    :ivar url: The URL of the Azure key vault associated with the Batch account. Required.
    :vartype url: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource ID of the Azure key vault associated with the Batch account. Required."""
    url: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL of the Azure key vault associated with the Batch account. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        url: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LinuxUserConfiguration(_Model):
    """Properties used to create a user account on a Linux node.

    :ivar uid: The user ID of the user account.
    :vartype uid: int
    :ivar gid: The group ID for the user account.
    :vartype gid: int
    :ivar ssh_private_key: The SSH private key for the user account.
    :vartype ssh_private_key: str
    """

    uid: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The user ID of the user account."""
    gid: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The group ID for the user account."""
    ssh_private_key: Optional[str] = rest_field(
        name="sshPrivateKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """The SSH private key for the user account."""

    @overload
    def __init__(
        self,
        *,
        uid: Optional[int] = None,
        gid: Optional[int] = None,
        ssh_private_key: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedDisk(_Model):
    """The managed disk parameters.

    :ivar storage_account_type: The storage account type for use in creating data disks or OS disk.
     Known values are: "Standard_LRS", "Premium_LRS", and "StandardSSD_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.batch.models.StorageAccountType
    :ivar security_profile: Specifies the security profile for the managed disk.
    :vartype security_profile: ~azure.mgmt.batch.models.VMDiskSecurityProfile
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed disk. It can be set only in UserSubscription mode.
    :vartype disk_encryption_set: ~azure.mgmt.batch.models.DiskEncryptionSetParameters
    """

    storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = rest_field(
        name="storageAccountType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The storage account type for use in creating data disks or OS disk. Known values are:
     \"Standard_LRS\", \"Premium_LRS\", and \"StandardSSD_LRS\"."""
    security_profile: Optional["_models.VMDiskSecurityProfile"] = rest_field(
        name="securityProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the security profile for the managed disk."""
    disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = rest_field(
        name="diskEncryptionSet", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the customer managed disk encryption set resource id for the managed disk. It can be
     set only in UserSubscription mode."""

    @overload
    def __init__(
        self,
        *,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        security_profile: Optional["_models.VMDiskSecurityProfile"] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetadataItem(_Model):
    """A name-value pair associated with a Batch service resource.

    :ivar name: The name of the metadata item. Required.
    :vartype name: str
    :ivar value: The value of the metadata item. Required.
    :vartype value: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the metadata item. Required."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the metadata item. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MountConfiguration(_Model):
    """The file system to mount on each node.

    :ivar azure_blob_file_system_configuration: The Azure Storage Container to mount using blob
     FUSE on each node.
    :vartype azure_blob_file_system_configuration:
     ~azure.mgmt.batch.models.AzureBlobFileSystemConfiguration
    :ivar nfs_mount_configuration: The NFS file system to mount on each node.
    :vartype nfs_mount_configuration: ~azure.mgmt.batch.models.NFSMountConfiguration
    :ivar cifs_mount_configuration: The CIFS/SMB file system to mount on each node.
    :vartype cifs_mount_configuration: ~azure.mgmt.batch.models.CIFSMountConfiguration
    :ivar azure_file_share_configuration: The Azure File Share to mount on each node.
    :vartype azure_file_share_configuration: ~azure.mgmt.batch.models.AzureFileShareConfiguration
    """

    azure_blob_file_system_configuration: Optional["_models.AzureBlobFileSystemConfiguration"] = rest_field(
        name="azureBlobFileSystemConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Azure Storage Container to mount using blob FUSE on each node."""
    nfs_mount_configuration: Optional["_models.NFSMountConfiguration"] = rest_field(
        name="nfsMountConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The NFS file system to mount on each node."""
    cifs_mount_configuration: Optional["_models.CIFSMountConfiguration"] = rest_field(
        name="cifsMountConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The CIFS/SMB file system to mount on each node."""
    azure_file_share_configuration: Optional["_models.AzureFileShareConfiguration"] = rest_field(
        name="azureFileShareConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Azure File Share to mount on each node."""

    @overload
    def __init__(
        self,
        *,
        azure_blob_file_system_configuration: Optional["_models.AzureBlobFileSystemConfiguration"] = None,
        nfs_mount_configuration: Optional["_models.NFSMountConfiguration"] = None,
        cifs_mount_configuration: Optional["_models.CIFSMountConfiguration"] = None,
        azure_file_share_configuration: Optional["_models.AzureFileShareConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkConfiguration(_Model):
    """The network configuration for a pool.

    :ivar subnet_id: The ARM resource identifier of the virtual network subnet which the compute
     nodes of the pool will join. This is of the form
     /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
    :vartype subnet_id: str
    :ivar dynamic_vnet_assignment_scope: The scope of dynamic vnet assignment. Known values are:
     "none" and "job".
    :vartype dynamic_vnet_assignment_scope: str or
     ~azure.mgmt.batch.models.DynamicVNetAssignmentScope
    :ivar endpoint_configuration: The configuration for endpoints on compute nodes in the Batch
     pool.
    :vartype endpoint_configuration: ~azure.mgmt.batch.models.PoolEndpointConfiguration
    :ivar public_ip_address_configuration: The Public IPAddress configuration for Compute Nodes in
     the Batch Pool.
    :vartype public_ip_address_configuration: ~azure.mgmt.batch.models.PublicIPAddressConfiguration
    :ivar enable_accelerated_networking: Whether this pool should enable accelerated networking.
    :vartype enable_accelerated_networking: bool
    """

    subnet_id: Optional[str] = rest_field(name="subnetId", visibility=["read", "create", "update", "delete", "query"])
    """The ARM resource identifier of the virtual network subnet which the compute nodes of the pool
     will join. This is of the form
     /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}."""
    dynamic_vnet_assignment_scope: Optional[Union[str, "_models.DynamicVNetAssignmentScope"]] = rest_field(
        name="dynamicVnetAssignmentScope", visibility=["read", "create", "update", "delete", "query"]
    )
    """The scope of dynamic vnet assignment. Known values are: \"none\" and \"job\"."""
    endpoint_configuration: Optional["_models.PoolEndpointConfiguration"] = rest_field(
        name="endpointConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The configuration for endpoints on compute nodes in the Batch pool."""
    public_ip_address_configuration: Optional["_models.PublicIPAddressConfiguration"] = rest_field(
        name="publicIPAddressConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Public IPAddress configuration for Compute Nodes in the Batch Pool."""
    enable_accelerated_networking: Optional[bool] = rest_field(
        name="enableAcceleratedNetworking", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether this pool should enable accelerated networking."""

    @overload
    def __init__(
        self,
        *,
        subnet_id: Optional[str] = None,
        dynamic_vnet_assignment_scope: Optional[Union[str, "_models.DynamicVNetAssignmentScope"]] = None,
        endpoint_configuration: Optional["_models.PoolEndpointConfiguration"] = None,
        public_ip_address_configuration: Optional["_models.PublicIPAddressConfiguration"] = None,
        enable_accelerated_networking: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkProfile(_Model):
    """Network profile for Batch account, which contains network rule settings for each endpoint.

    :ivar account_access: Network access profile for batchAccount endpoint (Batch account data
     plane API).
    :vartype account_access: ~azure.mgmt.batch.models.EndpointAccessProfile
    :ivar node_management_access: Network access profile for nodeManagement endpoint (Batch service
     managing compute nodes for Batch pools).
    :vartype node_management_access: ~azure.mgmt.batch.models.EndpointAccessProfile
    """

    account_access: Optional["_models.EndpointAccessProfile"] = rest_field(
        name="accountAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network access profile for batchAccount endpoint (Batch account data plane API)."""
    node_management_access: Optional["_models.EndpointAccessProfile"] = rest_field(
        name="nodeManagementAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network access profile for nodeManagement endpoint (Batch service managing compute nodes for
     Batch pools)."""

    @overload
    def __init__(
        self,
        *,
        account_access: Optional["_models.EndpointAccessProfile"] = None,
        node_management_access: Optional["_models.EndpointAccessProfile"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkSecurityGroupRule(_Model):
    """A network security group rule to apply to an inbound endpoint.

    :ivar priority: The priority for this rule. Required.
    :vartype priority: int
    :ivar access: The action that should be taken for a specified IP address, subnet range or tag.
     Required. Known values are: "Allow" and "Deny".
    :vartype access: str or ~azure.mgmt.batch.models.NetworkSecurityGroupRuleAccess
    :ivar source_address_prefix: The source address prefix or tag to match for the rule. Required.
    :vartype source_address_prefix: str
    :ivar source_port_ranges: The source port ranges to match for the rule.
    :vartype source_port_ranges: list[str]
    """

    priority: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The priority for this rule. Required."""
    access: Union[str, "_models.NetworkSecurityGroupRuleAccess"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The action that should be taken for a specified IP address, subnet range or tag. Required.
     Known values are: \"Allow\" and \"Deny\"."""
    source_address_prefix: str = rest_field(
        name="sourceAddressPrefix", visibility=["read", "create", "update", "delete", "query"]
    )
    """The source address prefix or tag to match for the rule. Required."""
    source_port_ranges: Optional[list[str]] = rest_field(
        name="sourcePortRanges", visibility=["read", "create", "update", "delete", "query"]
    )
    """The source port ranges to match for the rule."""

    @overload
    def __init__(
        self,
        *,
        priority: int,
        access: Union[str, "_models.NetworkSecurityGroupRuleAccess"],
        source_address_prefix: str,
        source_port_ranges: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkSecurityPerimeter(_Model):
    """Information about a network security perimeter (NSP).

    :ivar id: Fully qualified Azure resource ID of the NSP resource.
    :vartype id: str
    :ivar perimeter_guid: Universal unique ID (UUID) of the network security perimeter.
    :vartype perimeter_guid: str
    :ivar location: Location of the network security perimeter.
    :vartype location: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Fully qualified Azure resource ID of the NSP resource."""
    perimeter_guid: Optional[str] = rest_field(
        name="perimeterGuid", visibility=["read", "create", "update", "delete", "query"]
    )
    """Universal unique ID (UUID) of the network security perimeter."""
    location: Optional[str] = rest_field(visibility=["read", "create"])
    """Location of the network security perimeter."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        perimeter_guid: Optional[str] = None,
        location: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkSecurityPerimeterConfiguration(ProxyResource):
    """Network security perimeter (NSP) configuration resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.batch.models.SystemData
    :ivar properties:
    :vartype properties: ~azure.mgmt.batch.models.NetworkSecurityPerimeterConfigurationProperties
    """

    properties: Optional["_models.NetworkSecurityPerimeterConfigurationProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.NetworkSecurityPerimeterConfigurationProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkSecurityPerimeterConfigurationProperties(_Model):  # pylint: disable=name-too-long
    """Network security configuration properties.

    :ivar provisioning_state: Known values are: "Succeeded", "Creating", "Updating", "Deleting",
     "Accepted", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.batch.models.NetworkSecurityPerimeterConfigurationProvisioningState
    :ivar provisioning_issues: List of provisioning issues, if any.
    :vartype provisioning_issues: list[~azure.mgmt.batch.models.ProvisioningIssue]
    :ivar network_security_perimeter:
    :vartype network_security_perimeter: ~azure.mgmt.batch.models.NetworkSecurityPerimeter
    :ivar resource_association:
    :vartype resource_association: ~azure.mgmt.batch.models.ResourceAssociation
    :ivar profile:
    :vartype profile: ~azure.mgmt.batch.models.NetworkSecurityProfile
    """

    provisioning_state: Optional[Union[str, "_models.NetworkSecurityPerimeterConfigurationProvisioningState"]] = (
        rest_field(name="provisioningState", visibility=["read"])
    )
    """Known values are: \"Succeeded\", \"Creating\", \"Updating\", \"Deleting\", \"Accepted\",
     \"Failed\", and \"Canceled\"."""
    provisioning_issues: Optional[list["_models.ProvisioningIssue"]] = rest_field(
        name="provisioningIssues", visibility=["read"]
    )
    """List of provisioning issues, if any."""
    network_security_perimeter: Optional["_models.NetworkSecurityPerimeter"] = rest_field(
        name="networkSecurityPerimeter", visibility=["read", "create", "update", "delete", "query"]
    )
    resource_association: Optional["_models.ResourceAssociation"] = rest_field(
        name="resourceAssociation", visibility=["read", "create", "update", "delete", "query"]
    )
    profile: Optional["_models.NetworkSecurityProfile"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        network_security_perimeter: Optional["_models.NetworkSecurityPerimeter"] = None,
        resource_association: Optional["_models.ResourceAssociation"] = None,
        profile: Optional["_models.NetworkSecurityProfile"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkSecurityProfile(_Model):
    """Network security perimeter configuration profile.

    :ivar name: Name of the profile.
    :vartype name: str
    :ivar access_rules_version: Current access rules version.
    :vartype access_rules_version: int
    :ivar access_rules: List of Access Rules.
    :vartype access_rules: list[~azure.mgmt.batch.models.AccessRule]
    :ivar diagnostic_settings_version: Current diagnostic settings version.
    :vartype diagnostic_settings_version: int
    :ivar enabled_log_categories: List of log categories that are enabled.
    :vartype enabled_log_categories: list[str]
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the profile."""
    access_rules_version: Optional[int] = rest_field(
        name="accessRulesVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Current access rules version."""
    access_rules: Optional[list["_models.AccessRule"]] = rest_field(
        name="accessRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of Access Rules."""
    diagnostic_settings_version: Optional[int] = rest_field(
        name="diagnosticSettingsVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Current diagnostic settings version."""
    enabled_log_categories: Optional[list[str]] = rest_field(
        name="enabledLogCategories", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of log categories that are enabled."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        access_rules_version: Optional[int] = None,
        access_rules: Optional[list["_models.AccessRule"]] = None,
        diagnostic_settings_version: Optional[int] = None,
        enabled_log_categories: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NFSMountConfiguration(_Model):
    """Information used to connect to an NFS file system.

    :ivar source: The URI of the file system to mount. Required.
    :vartype source: str
    :ivar relative_mount_path: The relative path on the compute node where the file system will be
     mounted. Required.
    :vartype relative_mount_path: str
    :ivar mount_options: Additional command line options to pass to the mount command.
    :vartype mount_options: str
    """

    source: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URI of the file system to mount. Required."""
    relative_mount_path: str = rest_field(
        name="relativeMountPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The relative path on the compute node where the file system will be mounted. Required."""
    mount_options: Optional[str] = rest_field(
        name="mountOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional command line options to pass to the mount command."""

    @overload
    def __init__(
        self,
        *,
        source: str,
        relative_mount_path: str,
        mount_options: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NodePlacementConfiguration(_Model):
    """Node placement configuration for Batch pools.

    :ivar policy: Node placement Policy type on Batch pools. Known values are: "Regional" and
     "Zonal".
    :vartype policy: str or ~azure.mgmt.batch.models.NodePlacementPolicyType
    """

    policy: Optional[Union[str, "_models.NodePlacementPolicyType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Node placement Policy type on Batch pools. Known values are: \"Regional\" and \"Zonal\"."""

    @overload
    def __init__(
        self,
        *,
        policy: Optional[Union[str, "_models.NodePlacementPolicyType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """A REST API operation.

    :ivar name: The operation name.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: The object that describes the operation.
    :vartype display: ~azure.mgmt.batch.models.OperationDisplay
    :ivar origin: The intended executor of the operation.
    :vartype origin: str
    :ivar properties: Properties of the operation.
    :vartype properties: any
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The operation name."""
    is_data_action: Optional[bool] = rest_field(
        name="isDataAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the operation is a data action."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The object that describes the operation."""
    origin: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The intended executor of the operation."""
    properties: Optional[Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Properties of the operation."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional[Any] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """The object that describes the operation.

    :ivar provider: Friendly name of the resource provider.
    :vartype provider: str
    :ivar operation: The operation type.
    :vartype operation: str
    :ivar resource: The resource type on which the operation is performed.
    :vartype resource: str
    :ivar description: The friendly name of the operation.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Friendly name of the resource provider."""
    operation: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The operation type."""
    resource: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource type on which the operation is performed."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The friendly name of the operation."""

    @overload
    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        operation: Optional[str] = None,
        resource: Optional[str] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OSDisk(_Model):
    """Settings for the operating system disk of the virtual machine.

    :ivar ephemeral_os_disk_settings: Specifies the ephemeral Disk Settings for the operating
     system disk used by the virtual machine.
    :vartype ephemeral_os_disk_settings: ~azure.mgmt.batch.models.DiffDiskSettings
    :ivar caching: The type of caching to enable for the disk. Known values are: "None",
     "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.batch.models.CachingType
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk: ~azure.mgmt.batch.models.ManagedDisk
    :ivar disk_size_gb: The initial disk size in GB when creating new OS disk.
    :vartype disk_size_gb: int
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    """

    ephemeral_os_disk_settings: Optional["_models.DiffDiskSettings"] = rest_field(
        name="ephemeralOSDiskSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the ephemeral Disk Settings for the operating system disk used by the virtual
     machine."""
    caching: Optional[Union[str, "_models.CachingType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of caching to enable for the disk. Known values are: \"None\", \"ReadOnly\", and
     \"ReadWrite\"."""
    managed_disk: Optional["_models.ManagedDisk"] = rest_field(
        name="managedDisk", visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed disk parameters."""
    disk_size_gb: Optional[int] = rest_field(
        name="diskSizeGB", visibility=["read", "create", "update", "delete", "query"]
    )
    """The initial disk size in GB when creating new OS disk."""
    write_accelerator_enabled: Optional[bool] = rest_field(
        name="writeAcceleratorEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether writeAccelerator should be enabled or disabled on the disk."""

    @overload
    def __init__(
        self,
        *,
        ephemeral_os_disk_settings: Optional["_models.DiffDiskSettings"] = None,
        caching: Optional[Union[str, "_models.CachingType"]] = None,
        managed_disk: Optional["_models.ManagedDisk"] = None,
        disk_size_gb: Optional[int] = None,
        write_accelerator_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OutboundEnvironmentEndpoint(_Model):
    """A collection of related endpoints from the same service for which the Batch service requires
    outbound access.

    :ivar category: The type of service that the Batch service connects to.
    :vartype category: str
    :ivar endpoints: The endpoints for this service to which the Batch service makes outbound
     calls.
    :vartype endpoints: list[~azure.mgmt.batch.models.EndpointDependency]
    """

    category: Optional[str] = rest_field(visibility=["read"])
    """The type of service that the Batch service connects to."""
    endpoints: Optional[list["_models.EndpointDependency"]] = rest_field(visibility=["read"])
    """The endpoints for this service to which the Batch service makes outbound calls."""


class Pool(ProxyResource):
    """Contains information about a pool.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.batch.models.SystemData
    :ivar properties: The properties associated with the pool.
    :vartype properties: ~azure.mgmt.batch.models.PoolProperties
    :ivar identity: The type of identity used for the Batch Pool.
    :vartype identity: ~azure.mgmt.batch.models.BatchPoolIdentity
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.PoolProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties associated with the pool."""
    identity: Optional["_models.BatchPoolIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity used for the Batch Pool."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """The ETag of the resource, used for concurrency statements."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tags of the resource."""

    __flattened_items = [
        "display_name",
        "last_modified",
        "creation_time",
        "provisioning_state",
        "provisioning_state_transition_time",
        "allocation_state",
        "allocation_state_transition_time",
        "vm_size",
        "deployment_configuration",
        "current_dedicated_nodes",
        "current_low_priority_nodes",
        "scale_settings",
        "auto_scale_run",
        "inter_node_communication",
        "network_configuration",
        "task_slots_per_node",
        "task_scheduling_policy",
        "user_accounts",
        "metadata",
        "start_task",
        "application_packages",
        "resize_operation_status",
        "mount_configuration",
        "upgrade_policy",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PoolProperties"] = None,
        identity: Optional["_models.BatchPoolIdentity"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PoolEndpointConfiguration(_Model):
    """The endpoint configuration for a pool.

    :ivar inbound_nat_pools: A list of inbound NAT pools that can be used to address specific ports
     on an individual compute node externally. Required.
    :vartype inbound_nat_pools: list[~azure.mgmt.batch.models.InboundNatPool]
    """

    inbound_nat_pools: list["_models.InboundNatPool"] = rest_field(
        name="inboundNatPools", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of inbound NAT pools that can be used to address specific ports on an individual compute
     node externally. Required."""

    @overload
    def __init__(
        self,
        *,
        inbound_nat_pools: list["_models.InboundNatPool"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PoolProperties(_Model):
    """Pool properties.

    :ivar display_name: The display name for the pool.
    :vartype display_name: str
    :ivar last_modified: The last modified time of the pool.
    :vartype last_modified: ~datetime.datetime
    :ivar creation_time: The creation time of the pool.
    :vartype creation_time: ~datetime.datetime
    :ivar provisioning_state: The current state of the pool. Known values are: "Succeeded" and
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.batch.models.PoolProvisioningState
    :ivar provisioning_state_transition_time: The time at which the pool entered its current state.
    :vartype provisioning_state_transition_time: ~datetime.datetime
    :ivar allocation_state: Whether the pool is resizing. Known values are: "Steady", "Resizing",
     and "Stopping".
    :vartype allocation_state: str or ~azure.mgmt.batch.models.AllocationState
    :ivar allocation_state_transition_time: The time at which the pool entered its current
     allocation state.
    :vartype allocation_state_transition_time: ~datetime.datetime
    :ivar vm_size: The size of virtual machines in the pool. All VMs in a pool are the same size.
    :vartype vm_size: str
    :ivar deployment_configuration: This property describes the virtual machines that the pool
     nodes will be deployed on.
    :vartype deployment_configuration: ~azure.mgmt.batch.models.DeploymentConfiguration
    :ivar current_dedicated_nodes: The number of dedicated compute nodes currently in the pool.
    :vartype current_dedicated_nodes: int
    :ivar current_low_priority_nodes: The number of Spot/low-priority compute nodes currently in
     the pool.
    :vartype current_low_priority_nodes: int
    :ivar scale_settings: Settings which configure the number of nodes in the pool.
    :vartype scale_settings: ~azure.mgmt.batch.models.ScaleSettings
    :ivar auto_scale_run: The results and errors from the last execution of the autoscale formula.
    :vartype auto_scale_run: ~azure.mgmt.batch.models.AutoScaleRun
    :ivar inter_node_communication: Whether the pool permits direct communication between nodes.
     Known values are: "Enabled" and "Disabled".
    :vartype inter_node_communication: str or ~azure.mgmt.batch.models.InterNodeCommunicationState
    :ivar network_configuration: The network configuration for the pool.
    :vartype network_configuration: ~azure.mgmt.batch.models.NetworkConfiguration
    :ivar task_slots_per_node: The number of task slots that can be used to run concurrent tasks on
     a single compute node in the pool.
    :vartype task_slots_per_node: int
    :ivar task_scheduling_policy: How tasks are distributed across compute nodes in a pool.
    :vartype task_scheduling_policy: ~azure.mgmt.batch.models.TaskSchedulingPolicy
    :ivar user_accounts: The list of user accounts to be created on each node in the pool.
    :vartype user_accounts: list[~azure.mgmt.batch.models.UserAccount]
    :ivar metadata: A list of name-value pairs associated with the pool as metadata.
    :vartype metadata: list[~azure.mgmt.batch.models.MetadataItem]
    :ivar start_task: A task specified to run on each compute node as it joins the pool.
    :vartype start_task: ~azure.mgmt.batch.models.StartTask
    :ivar application_packages: The list of application packages to be installed on each compute
     node in the pool.
    :vartype application_packages: list[~azure.mgmt.batch.models.ApplicationPackageReference]
    :ivar resize_operation_status: Contains details about the current or last completed resize
     operation.
    :vartype resize_operation_status: ~azure.mgmt.batch.models.ResizeOperationStatus
    :ivar mount_configuration: A list of file systems to mount on each node in the pool.
    :vartype mount_configuration: list[~azure.mgmt.batch.models.MountConfiguration]
    :ivar upgrade_policy: The upgrade policy for the pool.
    :vartype upgrade_policy: ~azure.mgmt.batch.models.UpgradePolicy
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The display name for the pool."""
    last_modified: Optional[datetime.datetime] = rest_field(name="lastModified", visibility=["read"], format="rfc3339")
    """The last modified time of the pool."""
    creation_time: Optional[datetime.datetime] = rest_field(name="creationTime", visibility=["read"], format="rfc3339")
    """The creation time of the pool."""
    provisioning_state: Optional[Union[str, "_models.PoolProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The current state of the pool. Known values are: \"Succeeded\" and \"Deleting\"."""
    provisioning_state_transition_time: Optional[datetime.datetime] = rest_field(
        name="provisioningStateTransitionTime", visibility=["read"], format="rfc3339"
    )
    """The time at which the pool entered its current state."""
    allocation_state: Optional[Union[str, "_models.AllocationState"]] = rest_field(
        name="allocationState", visibility=["read"]
    )
    """Whether the pool is resizing. Known values are: \"Steady\", \"Resizing\", and \"Stopping\"."""
    allocation_state_transition_time: Optional[datetime.datetime] = rest_field(
        name="allocationStateTransitionTime", visibility=["read"], format="rfc3339"
    )
    """The time at which the pool entered its current allocation state."""
    vm_size: Optional[str] = rest_field(name="vmSize", visibility=["read", "create", "update", "delete", "query"])
    """The size of virtual machines in the pool. All VMs in a pool are the same size."""
    deployment_configuration: Optional["_models.DeploymentConfiguration"] = rest_field(
        name="deploymentConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """This property describes the virtual machines that the pool nodes will be deployed on."""
    current_dedicated_nodes: Optional[int] = rest_field(name="currentDedicatedNodes", visibility=["read"])
    """The number of dedicated compute nodes currently in the pool."""
    current_low_priority_nodes: Optional[int] = rest_field(name="currentLowPriorityNodes", visibility=["read"])
    """The number of Spot/low-priority compute nodes currently in the pool."""
    scale_settings: Optional["_models.ScaleSettings"] = rest_field(
        name="scaleSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Settings which configure the number of nodes in the pool."""
    auto_scale_run: Optional["_models.AutoScaleRun"] = rest_field(name="autoScaleRun", visibility=["read"])
    """The results and errors from the last execution of the autoscale formula."""
    inter_node_communication: Optional[Union[str, "_models.InterNodeCommunicationState"]] = rest_field(
        name="interNodeCommunication", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the pool permits direct communication between nodes. Known values are: \"Enabled\" and
     \"Disabled\"."""
    network_configuration: Optional["_models.NetworkConfiguration"] = rest_field(
        name="networkConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The network configuration for the pool."""
    task_slots_per_node: Optional[int] = rest_field(
        name="taskSlotsPerNode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of task slots that can be used to run concurrent tasks on a single compute node in
     the pool."""
    task_scheduling_policy: Optional["_models.TaskSchedulingPolicy"] = rest_field(
        name="taskSchedulingPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """How tasks are distributed across compute nodes in a pool."""
    user_accounts: Optional[list["_models.UserAccount"]] = rest_field(
        name="userAccounts", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of user accounts to be created on each node in the pool."""
    metadata: Optional[list["_models.MetadataItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of name-value pairs associated with the pool as metadata."""
    start_task: Optional["_models.StartTask"] = rest_field(
        name="startTask", visibility=["read", "create", "update", "delete", "query"]
    )
    """A task specified to run on each compute node as it joins the pool."""
    application_packages: Optional[list["_models.ApplicationPackageReference"]] = rest_field(
        name="applicationPackages", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of application packages to be installed on each compute node in the pool."""
    resize_operation_status: Optional["_models.ResizeOperationStatus"] = rest_field(
        name="resizeOperationStatus", visibility=["read"]
    )
    """Contains details about the current or last completed resize operation."""
    mount_configuration: Optional[list["_models.MountConfiguration"]] = rest_field(
        name="mountConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of file systems to mount on each node in the pool."""
    upgrade_policy: Optional["_models.UpgradePolicy"] = rest_field(
        name="upgradePolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The upgrade policy for the pool."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        vm_size: Optional[str] = None,
        deployment_configuration: Optional["_models.DeploymentConfiguration"] = None,
        scale_settings: Optional["_models.ScaleSettings"] = None,
        inter_node_communication: Optional[Union[str, "_models.InterNodeCommunicationState"]] = None,
        network_configuration: Optional["_models.NetworkConfiguration"] = None,
        task_slots_per_node: Optional[int] = None,
        task_scheduling_policy: Optional["_models.TaskSchedulingPolicy"] = None,
        user_accounts: Optional[list["_models.UserAccount"]] = None,
        metadata: Optional[list["_models.MetadataItem"]] = None,
        start_task: Optional["_models.StartTask"] = None,
        application_packages: Optional[list["_models.ApplicationPackageReference"]] = None,
        mount_configuration: Optional[list["_models.MountConfiguration"]] = None,
        upgrade_policy: Optional["_models.UpgradePolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpoint(_Model):
    """The private endpoint of the private endpoint connection.

    :ivar id: The ARM resource identifier of the private endpoint. This is of the form
     /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/privateEndpoints/{privateEndpoint}.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The ARM resource identifier of the private endpoint. This is of the form
     /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/privateEndpoints/{privateEndpoint}."""


class PrivateEndpointConnection(ProxyResource):
    """Contains information about a private link resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.batch.models.SystemData
    :ivar properties: The properties associated with the private endpoint connection.
    :vartype properties: ~azure.mgmt.batch.models.PrivateEndpointConnectionProperties
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.PrivateEndpointConnectionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties associated with the private endpoint connection."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """The ETag of the resource, used for concurrency statements."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tags of the resource."""

    __flattened_items = ["provisioning_state", "private_endpoint", "group_ids", "private_link_service_connection_state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateEndpointConnectionProperties"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PrivateEndpointConnectionProperties(_Model):
    """Private endpoint connection properties.

    :ivar provisioning_state: The provisioning state of the private endpoint connection. Known
     values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Cancelled".
    :vartype provisioning_state: str or
     ~azure.mgmt.batch.models.PrivateEndpointConnectionProvisioningState
    :ivar private_endpoint: The ARM resource identifier of the private endpoint.
    :vartype private_endpoint: ~azure.mgmt.batch.models.PrivateEndpoint
    :ivar group_ids: The group id of the private endpoint connection.
    :vartype group_ids: list[str]
    :ivar private_link_service_connection_state: The private link service connection state of the
     private endpoint connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.batch.models.PrivateLinkServiceConnectionState
    """

    provisioning_state: Optional[Union[str, "_models.PrivateEndpointConnectionProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the private endpoint connection. Known values are: \"Creating\",
     \"Updating\", \"Deleting\", \"Succeeded\", \"Failed\", and \"Cancelled\"."""
    private_endpoint: Optional["_models.PrivateEndpoint"] = rest_field(name="privateEndpoint", visibility=["read"])
    """The ARM resource identifier of the private endpoint."""
    group_ids: Optional[list[str]] = rest_field(name="groupIds", visibility=["read"])
    """The group id of the private endpoint connection."""
    private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = rest_field(
        name="privateLinkServiceConnectionState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The private link service connection state of the private endpoint connection."""

    @overload
    def __init__(
        self,
        *,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkResource(ProxyResource):
    """Contains information about a private link resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.batch.models.SystemData
    :ivar properties: The properties associated with the private link resource.
    :vartype properties: ~azure.mgmt.batch.models.PrivateLinkResourceProperties
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.PrivateLinkResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties associated with the private link resource."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """The ETag of the resource, used for concurrency statements."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tags of the resource."""

    __flattened_items = ["group_id", "required_members", "required_zone_names"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateLinkResourceProperties"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PrivateLinkResourceProperties(_Model):
    """Private link resource properties.

    :ivar group_id: The group id of the private link resource.
    :vartype group_id: str
    :ivar required_members: The list of required members that are used to establish the private
     link connection.
    :vartype required_members: list[str]
    :ivar required_zone_names: The list of required zone names for the private DNS resource name.
    :vartype required_zone_names: list[str]
    """

    group_id: Optional[str] = rest_field(name="groupId", visibility=["read"])
    """The group id of the private link resource."""
    required_members: Optional[list[str]] = rest_field(name="requiredMembers", visibility=["read"])
    """The list of required members that are used to establish the private link connection."""
    required_zone_names: Optional[list[str]] = rest_field(name="requiredZoneNames", visibility=["read"])
    """The list of required zone names for the private DNS resource name."""


class PrivateLinkServiceConnectionState(_Model):
    """The private link service connection state of the private endpoint connection.

    :ivar status: The status of the Batch private endpoint connection. Required. Known values are:
     "Approved", "Pending", "Rejected", and "Disconnected".
    :vartype status: str or ~azure.mgmt.batch.models.PrivateLinkServiceConnectionStatus
    :ivar description: Description of the private Connection state.
    :vartype description: str
    :ivar actions_required: Action required on the private connection state.
    :vartype actions_required: str
    """

    status: Union[str, "_models.PrivateLinkServiceConnectionStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the Batch private endpoint connection. Required. Known values are: \"Approved\",
     \"Pending\", \"Rejected\", and \"Disconnected\"."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of the private Connection state."""
    actions_required: Optional[str] = rest_field(name="actionsRequired", visibility=["read"])
    """Action required on the private connection state."""

    @overload
    def __init__(
        self,
        *,
        status: Union[str, "_models.PrivateLinkServiceConnectionStatus"],
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProvisioningIssue(_Model):
    """Describes a provisioning issue for a network security perimeter configuration.

    :ivar name: Name of the issue.
    :vartype name: str
    :ivar properties:
    :vartype properties: ~azure.mgmt.batch.models.ProvisioningIssueProperties
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """Name of the issue."""
    properties: Optional["_models.ProvisioningIssueProperties"] = rest_field(visibility=["read"])


class ProvisioningIssueProperties(_Model):
    """Details of a provisioning issue for a network security perimeter (NSP) configuration. Resource
    providers should generate separate provisioning issue elements for each separate issue
    detected, and include a meaningful and distinctive description, as well as any appropriate
    suggestedResourceIds and suggestedAccessRules.

    :ivar issue_type: Type of issue. Known values are: "Unknown",
     "ConfigurationPropagationFailure", "MissingPerimeterConfiguration", and
     "MissingIdentityConfiguration".
    :vartype issue_type: str or ~azure.mgmt.batch.models.IssueType
    :ivar severity: Severity of the issue. Known values are: "Warning" and "Error".
    :vartype severity: str or ~azure.mgmt.batch.models.Severity
    :ivar description: Description of the issue.
    :vartype description: str
    :ivar suggested_resource_ids: Fully qualified resource IDs of suggested resources that can be
     associated to the network security perimeter (NSP) to remediate the issue.
    :vartype suggested_resource_ids: list[str]
    :ivar suggested_access_rules: Access rules that can be added to the network security profile
     (NSP) to remediate the issue.
    :vartype suggested_access_rules: list[~azure.mgmt.batch.models.AccessRule]
    """

    issue_type: Optional[Union[str, "_models.IssueType"]] = rest_field(name="issueType", visibility=["read"])
    """Type of issue. Known values are: \"Unknown\", \"ConfigurationPropagationFailure\",
     \"MissingPerimeterConfiguration\", and \"MissingIdentityConfiguration\"."""
    severity: Optional[Union[str, "_models.Severity"]] = rest_field(visibility=["read"])
    """Severity of the issue. Known values are: \"Warning\" and \"Error\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """Description of the issue."""
    suggested_resource_ids: Optional[list[str]] = rest_field(name="suggestedResourceIds", visibility=["read"])
    """Fully qualified resource IDs of suggested resources that can be associated to the network
     security perimeter (NSP) to remediate the issue."""
    suggested_access_rules: Optional[list["_models.AccessRule"]] = rest_field(
        name="suggestedAccessRules", visibility=["read"]
    )
    """Access rules that can be added to the network security profile (NSP) to remediate the issue."""


class ProxyAgentSettings(_Model):
    """Specifies ProxyAgent settings while creating the virtual machine.

    :ivar enabled: Specifies whether Metadata Security Protocol feature should be enabled on the
     virtual machine or virtual machine scale set. Default is False.
    :vartype enabled: bool
    :ivar imds: Settings for the IMDS endpoint.
    :vartype imds: ~azure.mgmt.batch.models.HostEndpointSettings
    :ivar wire_server: Settings for the WireServer endpoint.
    :vartype wire_server: ~azure.mgmt.batch.models.HostEndpointSettings
    """

    enabled: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies whether Metadata Security Protocol feature should be enabled on the virtual machine
     or virtual machine scale set. Default is False."""
    imds: Optional["_models.HostEndpointSettings"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Settings for the IMDS endpoint."""
    wire_server: Optional["_models.HostEndpointSettings"] = rest_field(
        name="wireServer", visibility=["read", "create", "update", "delete", "query"]
    )
    """Settings for the WireServer endpoint."""

    @overload
    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        imds: Optional["_models.HostEndpointSettings"] = None,
        wire_server: Optional["_models.HostEndpointSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PublicIPAddressConfiguration(_Model):
    """The public IP Address configuration of the networking configuration of a Pool.

    :ivar provision: The provisioning type for Public IP Addresses for the Batch Pool. Known values
     are: "BatchManaged", "UserManaged", and "NoPublicIPAddresses".
    :vartype provision: str or ~azure.mgmt.batch.models.IPAddressProvisioningType
    :ivar ip_address_ids: The list of public IPs which the Batch service will use when provisioning
     Compute Nodes.
    :vartype ip_address_ids: list[str]
    :ivar ip_families: The IP families used to specify IP versions available to the pool.
    :vartype ip_families: list[str or ~azure.mgmt.batch.models.IPFamily]
    :ivar ip_tags: IP Tags that will applied to new Public IPs that Batch creates.
    :vartype ip_tags: list[~azure.mgmt.batch.models.IPTag]
    """

    provision: Optional[Union[str, "_models.IPAddressProvisioningType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The provisioning type for Public IP Addresses for the Batch Pool. Known values are:
     \"BatchManaged\", \"UserManaged\", and \"NoPublicIPAddresses\"."""
    ip_address_ids: Optional[list[str]] = rest_field(
        name="ipAddressIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of public IPs which the Batch service will use when provisioning Compute Nodes."""
    ip_families: Optional[list[Union[str, "_models.IPFamily"]]] = rest_field(
        name="ipFamilies", visibility=["read", "create", "update", "delete", "query"]
    )
    """The IP families used to specify IP versions available to the pool."""
    ip_tags: Optional[list["_models.IPTag"]] = rest_field(
        name="ipTags", visibility=["read", "create", "update", "delete", "query"]
    )
    """IP Tags that will applied to new Public IPs that Batch creates."""

    @overload
    def __init__(
        self,
        *,
        provision: Optional[Union[str, "_models.IPAddressProvisioningType"]] = None,
        ip_address_ids: Optional[list[str]] = None,
        ip_families: Optional[list[Union[str, "_models.IPFamily"]]] = None,
        ip_tags: Optional[list["_models.IPTag"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResizeError(_Model):
    """An error that occurred when resizing a pool.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically. Required.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface. Required.
    :vartype message: str
    :ivar details: Additional details about the error.
    :vartype details: list[~azure.mgmt.batch.models.ResizeError]
    """

    code: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically. Required."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A message describing the error, intended to be suitable for display in a user interface.
     Required."""
    details: Optional[list["_models.ResizeError"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional details about the error."""

    @overload
    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: Optional[list["_models.ResizeError"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResizeOperationStatus(_Model):
    """Details about the current or last completed resize operation.

    :ivar target_dedicated_nodes: The desired number of dedicated compute nodes in the pool.
    :vartype target_dedicated_nodes: int
    :ivar target_low_priority_nodes: The desired number of Spot/low-priority compute nodes in the
     pool.
    :vartype target_low_priority_nodes: int
    :ivar resize_timeout: The timeout for allocation of compute nodes to the pool or removal of
     compute nodes from the pool.
    :vartype resize_timeout: ~datetime.timedelta
    :ivar node_deallocation_option: Determines what to do with a node and its running task(s) after
     it has been selected for deallocation. Known values are: "Requeue", "Terminate",
     "TaskCompletion", and "RetainedData".
    :vartype node_deallocation_option: str or
     ~azure.mgmt.batch.models.ComputeNodeDeallocationOption
    :ivar start_time: The time when this resize operation was started.
    :vartype start_time: ~datetime.datetime
    :ivar errors: Details of any errors encountered while performing the last resize on the pool.
    :vartype errors: list[~azure.mgmt.batch.models.ResizeError]
    """

    target_dedicated_nodes: Optional[int] = rest_field(
        name="targetDedicatedNodes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired number of dedicated compute nodes in the pool."""
    target_low_priority_nodes: Optional[int] = rest_field(
        name="targetLowPriorityNodes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired number of Spot/low-priority compute nodes in the pool."""
    resize_timeout: Optional[datetime.timedelta] = rest_field(
        name="resizeTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """The timeout for allocation of compute nodes to the pool or removal of compute nodes from the
     pool."""
    node_deallocation_option: Optional[Union[str, "_models.ComputeNodeDeallocationOption"]] = rest_field(
        name="nodeDeallocationOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Determines what to do with a node and its running task(s) after it has been selected for
     deallocation. Known values are: \"Requeue\", \"Terminate\", \"TaskCompletion\", and
     \"RetainedData\"."""
    start_time: Optional[datetime.datetime] = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time when this resize operation was started."""
    errors: Optional[list["_models.ResizeError"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Details of any errors encountered while performing the last resize on the pool."""

    @overload
    def __init__(
        self,
        *,
        target_dedicated_nodes: Optional[int] = None,
        target_low_priority_nodes: Optional[int] = None,
        resize_timeout: Optional[datetime.timedelta] = None,
        node_deallocation_option: Optional[Union[str, "_models.ComputeNodeDeallocationOption"]] = None,
        start_time: Optional[datetime.datetime] = None,
        errors: Optional[list["_models.ResizeError"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceAssociation(_Model):
    """Information about resource association.

    :ivar name: Name of the resource association.
    :vartype name: str
    :ivar access_mode: Known values are: "Enforced", "Learning", and "Audit".
    :vartype access_mode: str or ~azure.mgmt.batch.models.ResourceAssociationAccessMode
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the resource association."""
    access_mode: Optional[Union[str, "_models.ResourceAssociationAccessMode"]] = rest_field(
        name="accessMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"Enforced\", \"Learning\", and \"Audit\"."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        access_mode: Optional[Union[str, "_models.ResourceAssociationAccessMode"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceFile(_Model):
    """A single file or multiple files to be downloaded to a compute node.

    :ivar auto_storage_container_name: The storage container name in the auto storage account.
    :vartype auto_storage_container_name: str
    :ivar storage_container_url: The URL of the blob container within Azure Blob Storage.
    :vartype storage_container_url: str
    :ivar http_url: The URL of the file to download.
    :vartype http_url: str
    :ivar blob_prefix: The blob prefix to use when downloading blobs from an Azure Storage
     container. Only the blobs whose names begin with the specified prefix will be downloaded.
    :vartype blob_prefix: str
    :ivar file_path: The location on the compute node to which to download the file, relative to
     the task's working directory.
    :vartype file_path: str
    :ivar file_mode: The file permission mode attribute in octal format.
    :vartype file_mode: str
    :ivar identity_reference: The reference to the user assigned identity to use to access Azure
     Blob Storage specified by storageContainerUrl or httpUrl.
    :vartype identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
    """

    auto_storage_container_name: Optional[str] = rest_field(
        name="autoStorageContainerName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The storage container name in the auto storage account."""
    storage_container_url: Optional[str] = rest_field(
        name="storageContainerUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URL of the blob container within Azure Blob Storage."""
    http_url: Optional[str] = rest_field(name="httpUrl", visibility=["read", "create", "update", "delete", "query"])
    """The URL of the file to download."""
    blob_prefix: Optional[str] = rest_field(
        name="blobPrefix", visibility=["read", "create", "update", "delete", "query"]
    )
    """The blob prefix to use when downloading blobs from an Azure Storage container. Only the blobs
     whose names begin with the specified prefix will be downloaded."""
    file_path: Optional[str] = rest_field(name="filePath", visibility=["read", "create", "update", "delete", "query"])
    """The location on the compute node to which to download the file, relative to the task's working
     directory."""
    file_mode: Optional[str] = rest_field(name="fileMode", visibility=["read", "create", "update", "delete", "query"])
    """The file permission mode attribute in octal format."""
    identity_reference: Optional["_models.ComputeNodeIdentityReference"] = rest_field(
        name="identityReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference to the user assigned identity to use to access Azure Blob Storage specified by
     storageContainerUrl or httpUrl."""

    @overload
    def __init__(
        self,
        *,
        auto_storage_container_name: Optional[str] = None,
        storage_container_url: Optional[str] = None,
        http_url: Optional[str] = None,
        blob_prefix: Optional[str] = None,
        file_path: Optional[str] = None,
        file_mode: Optional[str] = None,
        identity_reference: Optional["_models.ComputeNodeIdentityReference"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RollingUpgradePolicy(_Model):
    """The configuration parameters used while performing a rolling upgrade.

    :ivar enable_cross_zone_upgrade: Allow VMSS to ignore AZ boundaries when constructing upgrade
     batches. Take into consideration the Update Domain and maxBatchInstancePercent to determine the
     batch size. If this field is not set, Azure Azure Batch will not set its default value. The
     value of enableCrossZoneUpgrade on the created VirtualMachineScaleSet will be decided by the
     default configurations on VirtualMachineScaleSet. This field is able to be set to true or false
     only when using NodePlacementConfiguration as Zonal.
    :vartype enable_cross_zone_upgrade: bool
    :ivar max_batch_instance_percent: The maximum percent of total virtual machine instances that
     will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum,
     unhealthy instances in previous or future batches can cause the percentage of instances in a
     batch to decrease to ensure higher reliability. The value of this field should be between 5 and
     100, inclusive. If both maxBatchInstancePercent and maxUnhealthyInstancePercent are assigned
     with value, the value of maxBatchInstancePercent should not be more than
     maxUnhealthyInstancePercent.
    :vartype max_batch_instance_percent: int
    :ivar max_unhealthy_instance_percent: The maximum percentage of the total virtual machine
     instances in the scale set that can be simultaneously unhealthy, either as a result of being
     upgraded, or by being found in an unhealthy state by the virtual machine health checks before
     the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The
     value of this field should be between 5 and 100, inclusive. If both maxBatchInstancePercent and
     maxUnhealthyInstancePercent are assigned with value, the value of maxBatchInstancePercent
     should not be more than maxUnhealthyInstancePercent.
    :vartype max_unhealthy_instance_percent: int
    :ivar max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual
     machine instances that can be found to be in an unhealthy state. This check will happen after
     each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The
     value of this field should be between 0 and 100, inclusive.
    :vartype max_unhealthy_upgraded_instance_percent: int
    :ivar pause_time_between_batches: The wait time between completing the update for all virtual
     machines in one batch and starting the next batch. The time duration should be specified in ISO
     8601 format.
    :vartype pause_time_between_batches: str
    :ivar prioritize_unhealthy_instances: Upgrade all unhealthy instances in a scale set before any
     healthy instances.
    :vartype prioritize_unhealthy_instances: bool
    :ivar rollback_failed_instances_on_policy_breach: Rollback failed instances to previous model
     if the Rolling Upgrade policy is violated.
    :vartype rollback_failed_instances_on_policy_breach: bool
    """

    enable_cross_zone_upgrade: Optional[bool] = rest_field(
        name="enableCrossZoneUpgrade", visibility=["read", "create", "update", "delete", "query"]
    )
    """Allow VMSS to ignore AZ boundaries when constructing upgrade batches. Take into consideration
     the Update Domain and maxBatchInstancePercent to determine the batch size. If this field is not
     set, Azure Azure Batch will not set its default value. The value of enableCrossZoneUpgrade on
     the created VirtualMachineScaleSet will be decided by the default configurations on
     VirtualMachineScaleSet. This field is able to be set to true or false only when using
     NodePlacementConfiguration as Zonal."""
    max_batch_instance_percent: Optional[int] = rest_field(
        name="maxBatchInstancePercent", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum percent of total virtual machine instances that will be upgraded simultaneously by
     the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or
     future batches can cause the percentage of instances in a batch to decrease to ensure higher
     reliability. The value of this field should be between 5 and 100, inclusive. If both
     maxBatchInstancePercent and maxUnhealthyInstancePercent are assigned with value, the value of
     maxBatchInstancePercent should not be more than maxUnhealthyInstancePercent."""
    max_unhealthy_instance_percent: Optional[int] = rest_field(
        name="maxUnhealthyInstancePercent", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum percentage of the total virtual machine instances in the scale set that can be
     simultaneously unhealthy, either as a result of being upgraded, or by being found in an
     unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This
     constraint will be checked prior to starting any batch. The value of this field should be
     between 5 and 100, inclusive. If both maxBatchInstancePercent and maxUnhealthyInstancePercent
     are assigned with value, the value of maxBatchInstancePercent should not be more than
     maxUnhealthyInstancePercent."""
    max_unhealthy_upgraded_instance_percent: Optional[int] = rest_field(
        name="maxUnhealthyUpgradedInstancePercent", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum percentage of upgraded virtual machine instances that can be found to be in an
     unhealthy state. This check will happen after each batch is upgraded. If this percentage is
     ever exceeded, the rolling update aborts. The value of this field should be between 0 and 100,
     inclusive."""
    pause_time_between_batches: Optional[str] = rest_field(
        name="pauseTimeBetweenBatches", visibility=["read", "create", "update", "delete", "query"]
    )
    """The wait time between completing the update for all virtual machines in one batch and starting
     the next batch. The time duration should be specified in ISO 8601 format."""
    prioritize_unhealthy_instances: Optional[bool] = rest_field(
        name="prioritizeUnhealthyInstances", visibility=["read", "create", "update", "delete", "query"]
    )
    """Upgrade all unhealthy instances in a scale set before any healthy instances."""
    rollback_failed_instances_on_policy_breach: Optional[bool] = rest_field(
        name="rollbackFailedInstancesOnPolicyBreach", visibility=["read", "create", "update", "delete", "query"]
    )
    """Rollback failed instances to previous model if the Rolling Upgrade policy is violated."""

    @overload
    def __init__(
        self,
        *,
        enable_cross_zone_upgrade: Optional[bool] = None,
        max_batch_instance_percent: Optional[int] = None,
        max_unhealthy_instance_percent: Optional[int] = None,
        max_unhealthy_upgraded_instance_percent: Optional[int] = None,
        pause_time_between_batches: Optional[str] = None,
        prioritize_unhealthy_instances: Optional[bool] = None,
        rollback_failed_instances_on_policy_breach: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ScaleSettings(_Model):
    """Scale settings for the pool.

    :ivar fixed_scale: Fixed scale settings for the pool.
    :vartype fixed_scale: ~azure.mgmt.batch.models.FixedScaleSettings
    :ivar auto_scale: AutoScale settings for the pool.
    :vartype auto_scale: ~azure.mgmt.batch.models.AutoScaleSettings
    """

    fixed_scale: Optional["_models.FixedScaleSettings"] = rest_field(
        name="fixedScale", visibility=["read", "create", "update", "delete", "query"]
    )
    """Fixed scale settings for the pool."""
    auto_scale: Optional["_models.AutoScaleSettings"] = rest_field(
        name="autoScale", visibility=["read", "create", "update", "delete", "query"]
    )
    """AutoScale settings for the pool."""

    @overload
    def __init__(
        self,
        *,
        fixed_scale: Optional["_models.FixedScaleSettings"] = None,
        auto_scale: Optional["_models.AutoScaleSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecurityProfile(_Model):
    """Specifies the security profile settings for the virtual machine or virtual machine scale set.

    :ivar security_type: Specifies the SecurityType of the virtual machine. It has to be set to any
     specified value to enable UefiSettings. Known values are: "trustedLaunch" and "confidentialVM".
    :vartype security_type: str or ~azure.mgmt.batch.models.SecurityTypes
    :ivar encryption_at_host: This property can be used by user in the request to enable or disable
     the Host Encryption for the virtual machine or virtual machine scale set. This will enable the
     encryption for all the disks including Resource/Temp disk at host itself.
    :vartype encryption_at_host: bool
    :ivar uefi_settings: Specifies the security settings like secure boot and vTPM used while
     creating the virtual machine.
    :vartype uefi_settings: ~azure.mgmt.batch.models.UefiSettings
    :ivar proxy_agent_settings: Specifies ProxyAgent settings while creating the virtual machine.
    :vartype proxy_agent_settings: ~azure.mgmt.batch.models.ProxyAgentSettings
    """

    security_type: Optional[Union[str, "_models.SecurityTypes"]] = rest_field(
        name="securityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the SecurityType of the virtual machine. It has to be set to any specified value to
     enable UefiSettings. Known values are: \"trustedLaunch\" and \"confidentialVM\"."""
    encryption_at_host: Optional[bool] = rest_field(
        name="encryptionAtHost", visibility=["read", "create", "update", "delete", "query"]
    )
    """This property can be used by user in the request to enable or disable the Host Encryption for
     the virtual machine or virtual machine scale set. This will enable the encryption for all the
     disks including Resource/Temp disk at host itself."""
    uefi_settings: Optional["_models.UefiSettings"] = rest_field(
        name="uefiSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the security settings like secure boot and vTPM used while creating the virtual
     machine."""
    proxy_agent_settings: Optional["_models.ProxyAgentSettings"] = rest_field(
        name="proxyAgentSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies ProxyAgent settings while creating the virtual machine."""

    @overload
    def __init__(
        self,
        *,
        security_type: Optional[Union[str, "_models.SecurityTypes"]] = None,
        encryption_at_host: Optional[bool] = None,
        uefi_settings: Optional["_models.UefiSettings"] = None,
        proxy_agent_settings: Optional["_models.ProxyAgentSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceArtifactReference(_Model):
    """Specifies the service artifact reference id used to set same image version for all virtual
    machines in the scale set when using 'latest' image version.

    :ivar id: The service artifact reference id of ServiceArtifactReference. Required.
    :vartype id: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The service artifact reference id of ServiceArtifactReference. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SkuCapability(_Model):
    """A SKU capability, such as the number of cores.

    :ivar name: The name of the feature.
    :vartype name: str
    :ivar value: The value of the feature.
    :vartype value: str
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the feature."""
    value: Optional[str] = rest_field(visibility=["read"])
    """The value of the feature."""


class StartTask(_Model):
    """A task which is run when a compute node joins a pool in the Azure Batch service, or when the
    compute node is rebooted or reimaged.

    :ivar command_line: The command line of the start task.
    :vartype command_line: str
    :ivar resource_files: A list of files that the Batch service will download to the compute node
     before running the command line.
    :vartype resource_files: list[~azure.mgmt.batch.models.ResourceFile]
    :ivar environment_settings: A list of environment variable settings for the start task.
    :vartype environment_settings: list[~azure.mgmt.batch.models.EnvironmentSetting]
    :ivar user_identity: The user identity under which the start task runs.
    :vartype user_identity: ~azure.mgmt.batch.models.UserIdentity
    :ivar max_task_retry_count: The maximum number of times the task may be retried.
    :vartype max_task_retry_count: int
    :ivar wait_for_success: Whether the Batch service should wait for the start task to complete
     successfully (that is, to exit with exit code 0) before scheduling any tasks on the compute
     node.
    :vartype wait_for_success: bool
    :ivar container_settings: The settings for the container under which the start task runs.
    :vartype container_settings: ~azure.mgmt.batch.models.TaskContainerSettings
    """

    command_line: Optional[str] = rest_field(
        name="commandLine", visibility=["read", "create", "update", "delete", "query"]
    )
    """The command line of the start task."""
    resource_files: Optional[list["_models.ResourceFile"]] = rest_field(
        name="resourceFiles", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of files that the Batch service will download to the compute node before running the
     command line."""
    environment_settings: Optional[list["_models.EnvironmentSetting"]] = rest_field(
        name="environmentSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of environment variable settings for the start task."""
    user_identity: Optional["_models.UserIdentity"] = rest_field(
        name="userIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user identity under which the start task runs."""
    max_task_retry_count: Optional[int] = rest_field(
        name="maxTaskRetryCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum number of times the task may be retried."""
    wait_for_success: Optional[bool] = rest_field(
        name="waitForSuccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the Batch service should wait for the start task to complete successfully (that is, to
     exit with exit code 0) before scheduling any tasks on the compute node."""
    container_settings: Optional["_models.TaskContainerSettings"] = rest_field(
        name="containerSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """The settings for the container under which the start task runs."""

    @overload
    def __init__(
        self,
        *,
        command_line: Optional[str] = None,
        resource_files: Optional[list["_models.ResourceFile"]] = None,
        environment_settings: Optional[list["_models.EnvironmentSetting"]] = None,
        user_identity: Optional["_models.UserIdentity"] = None,
        max_task_retry_count: Optional[int] = None,
        wait_for_success: Optional[bool] = None,
        container_settings: Optional["_models.TaskContainerSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SupportedSku(_Model):
    """Describes a Batch supported SKU.

    :ivar name: The name of the SKU.
    :vartype name: str
    :ivar family_name: The family name of the SKU.
    :vartype family_name: str
    :ivar capabilities: A collection of capabilities which this SKU supports.
    :vartype capabilities: list[~azure.mgmt.batch.models.SkuCapability]
    :ivar batch_support_end_of_life: The time when Azure Batch service will retire this SKU.
    :vartype batch_support_end_of_life: ~datetime.datetime
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the SKU."""
    family_name: Optional[str] = rest_field(name="familyName", visibility=["read"])
    """The family name of the SKU."""
    capabilities: Optional[list["_models.SkuCapability"]] = rest_field(visibility=["read"])
    """A collection of capabilities which this SKU supports."""
    batch_support_end_of_life: Optional[datetime.datetime] = rest_field(
        name="batchSupportEndOfLife", visibility=["read"], format="rfc3339"
    )
    """The time when Azure Batch service will retire this SKU."""


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.batch.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.batch.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TaskContainerSettings(_Model):
    """The container settings for a task.

    :ivar container_run_options: Additional options to the container create command.
    :vartype container_run_options: str
    :ivar image_name: The image to use to create the container in which the task will run.
     Required.
    :vartype image_name: str
    :ivar registry: The private registry which contains the container image.
    :vartype registry: ~azure.mgmt.batch.models.ContainerRegistry
    :ivar working_directory: A flag to indicate where the container task working directory is. The
     default is 'taskWorkingDirectory'. Known values are: "TaskWorkingDirectory" and
     "ContainerImageDefault".
    :vartype working_directory: str or ~azure.mgmt.batch.models.ContainerWorkingDirectory
    :ivar container_host_batch_bind_mounts: The paths you want to mounted to container task.
    :vartype container_host_batch_bind_mounts:
     list[~azure.mgmt.batch.models.ContainerHostBatchBindMountEntry]
    """

    container_run_options: Optional[str] = rest_field(
        name="containerRunOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional options to the container create command."""
    image_name: str = rest_field(name="imageName", visibility=["read", "create", "update", "delete", "query"])
    """The image to use to create the container in which the task will run. Required."""
    registry: Optional["_models.ContainerRegistry"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The private registry which contains the container image."""
    working_directory: Optional[Union[str, "_models.ContainerWorkingDirectory"]] = rest_field(
        name="workingDirectory", visibility=["read", "create", "update", "delete", "query"]
    )
    """A flag to indicate where the container task working directory is. The default is
     'taskWorkingDirectory'. Known values are: \"TaskWorkingDirectory\" and
     \"ContainerImageDefault\"."""
    container_host_batch_bind_mounts: Optional[list["_models.ContainerHostBatchBindMountEntry"]] = rest_field(
        name="containerHostBatchBindMounts", visibility=["read", "create", "update", "delete", "query"]
    )
    """The paths you want to mounted to container task."""

    @overload
    def __init__(
        self,
        *,
        image_name: str,
        container_run_options: Optional[str] = None,
        registry: Optional["_models.ContainerRegistry"] = None,
        working_directory: Optional[Union[str, "_models.ContainerWorkingDirectory"]] = None,
        container_host_batch_bind_mounts: Optional[list["_models.ContainerHostBatchBindMountEntry"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TaskSchedulingPolicy(_Model):
    """Specifies how tasks should be distributed across compute nodes.

    :ivar job_default_order: If not specified, the default is none. Known values are: "None" and
     "CreationTime".
    :vartype job_default_order: str or ~azure.mgmt.batch.models.JobDefaultOrder
    :ivar node_fill_type: How tasks should be distributed across compute nodes. Required. Known
     values are: "Spread" and "Pack".
    :vartype node_fill_type: str or ~azure.mgmt.batch.models.ComputeNodeFillType
    """

    job_default_order: Optional[Union[str, "_models.JobDefaultOrder"]] = rest_field(
        name="jobDefaultOrder", visibility=["read", "create", "update", "delete", "query"]
    )
    """If not specified, the default is none. Known values are: \"None\" and \"CreationTime\"."""
    node_fill_type: Union[str, "_models.ComputeNodeFillType"] = rest_field(
        name="nodeFillType", visibility=["read", "create", "update", "delete", "query"]
    )
    """How tasks should be distributed across compute nodes. Required. Known values are: \"Spread\"
     and \"Pack\"."""

    @overload
    def __init__(
        self,
        *,
        node_fill_type: Union[str, "_models.ComputeNodeFillType"],
        job_default_order: Optional[Union[str, "_models.JobDefaultOrder"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UefiSettings(_Model):
    """Specifies the security settings like secure boot and vTPM used while creating the virtual
    machine.

    :ivar secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual
     machine.
    :vartype secure_boot_enabled: bool
    :ivar v_tpm_enabled: Specifies whether vTPM should be enabled on the virtual machine.
    :vartype v_tpm_enabled: bool
    """

    secure_boot_enabled: Optional[bool] = rest_field(
        name="secureBootEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether secure boot should be enabled on the virtual machine."""
    v_tpm_enabled: Optional[bool] = rest_field(
        name="vTpmEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether vTPM should be enabled on the virtual machine."""

    @overload
    def __init__(
        self,
        *,
        secure_boot_enabled: Optional[bool] = None,
        v_tpm_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpgradePolicy(_Model):
    """Describes an upgrade policy - automatic, manual, or rolling.

    :ivar mode: Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br />
     Possible values are:<br /><br /> **Manual** - You  control the application of updates to
     virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br />
     **Automatic** - All virtual machines in the scale set are automatically updated at the same
     time.<br /><br /> **Rolling** - Scale set performs updates in batches with an optional pause
     time in between. Required. Known values are: "automatic", "manual", and "rolling".
    :vartype mode: str or ~azure.mgmt.batch.models.UpgradeMode
    :ivar automatic_os_upgrade_policy: Configuration parameters used for performing automatic OS
     Upgrade.
    :vartype automatic_os_upgrade_policy: ~azure.mgmt.batch.models.AutomaticOSUpgradePolicy
    :ivar rolling_upgrade_policy: The configuration parameters used while performing a rolling
     upgrade.
    :vartype rolling_upgrade_policy: ~azure.mgmt.batch.models.RollingUpgradePolicy
    """

    mode: Union[str, "_models.UpgradeMode"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible
     values are:<br /><br /> **Manual** - You  control the application of updates to virtual
     machines in the scale set. You do this by using the manualUpgrade action.<br /><br />
     **Automatic** - All virtual machines in the scale set are automatically updated at the same
     time.<br /><br /> **Rolling** - Scale set performs updates in batches with an optional pause
     time in between. Required. Known values are: \"automatic\", \"manual\", and \"rolling\"."""
    automatic_os_upgrade_policy: Optional["_models.AutomaticOSUpgradePolicy"] = rest_field(
        name="automaticOSUpgradePolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Configuration parameters used for performing automatic OS Upgrade."""
    rolling_upgrade_policy: Optional["_models.RollingUpgradePolicy"] = rest_field(
        name="rollingUpgradePolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The configuration parameters used while performing a rolling upgrade."""

    @overload
    def __init__(
        self,
        *,
        mode: Union[str, "_models.UpgradeMode"],
        automatic_os_upgrade_policy: Optional["_models.AutomaticOSUpgradePolicy"] = None,
        rolling_upgrade_policy: Optional["_models.RollingUpgradePolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAccount(_Model):
    """Properties used to create a user on an Azure Batch node.

    :ivar name: The name of the user account. Names can contain any Unicode characters up to a
     maximum length of 20. Required.
    :vartype name: str
    :ivar password: The password for the user account. Required.
    :vartype password: str
    :ivar elevation_level: The elevation level of the user. Known values are: "NonAdmin" and
     "Admin".
    :vartype elevation_level: str or ~azure.mgmt.batch.models.ElevationLevel
    :ivar linux_user_configuration: The Linux-specific user configuration for the user account.
    :vartype linux_user_configuration: ~azure.mgmt.batch.models.LinuxUserConfiguration
    :ivar windows_user_configuration: The Windows-specific user configuration for the user account.
    :vartype windows_user_configuration: ~azure.mgmt.batch.models.WindowsUserConfiguration
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the user account. Names can contain any Unicode characters up to a maximum length
     of 20. Required."""
    password: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The password for the user account. Required."""
    elevation_level: Optional[Union[str, "_models.ElevationLevel"]] = rest_field(
        name="elevationLevel", visibility=["read", "create", "update", "delete", "query"]
    )
    """The elevation level of the user. Known values are: \"NonAdmin\" and \"Admin\"."""
    linux_user_configuration: Optional["_models.LinuxUserConfiguration"] = rest_field(
        name="linuxUserConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Linux-specific user configuration for the user account."""
    windows_user_configuration: Optional["_models.WindowsUserConfiguration"] = rest_field(
        name="windowsUserConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Windows-specific user configuration for the user account."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        password: str,
        elevation_level: Optional[Union[str, "_models.ElevationLevel"]] = None,
        linux_user_configuration: Optional["_models.LinuxUserConfiguration"] = None,
        windows_user_configuration: Optional["_models.WindowsUserConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentities(_Model):
    """The list of associated user identities.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal id of user assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client id of user assigned identity."""


class UserIdentity(_Model):
    """The definition of the user identity under which the task is run.

    :ivar user_name: The name of the user identity under which the task is run.
    :vartype user_name: str
    :ivar auto_user: The auto user under which the task is run.
    :vartype auto_user: ~azure.mgmt.batch.models.AutoUserSpecification
    """

    user_name: Optional[str] = rest_field(name="userName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the user identity under which the task is run."""
    auto_user: Optional["_models.AutoUserSpecification"] = rest_field(
        name="autoUser", visibility=["read", "create", "update", "delete", "query"]
    )
    """The auto user under which the task is run."""

    @overload
    def __init__(
        self,
        *,
        user_name: Optional[str] = None,
        auto_user: Optional["_models.AutoUserSpecification"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineConfiguration(_Model):
    """The configuration for compute nodes in a pool based on the Azure Virtual Machines
    infrastructure.

    :ivar image_reference: A reference to the Azure Virtual Machines Marketplace Image or the
     custom Virtual Machine Image to use. Required.
    :vartype image_reference: ~azure.mgmt.batch.models.ImageReference
    :ivar node_agent_sku_id: The SKU of the Batch node agent to be provisioned on compute nodes in
     the pool. Required.
    :vartype node_agent_sku_id: str
    :ivar windows_configuration: Windows operating system settings on the virtual machine.
    :vartype windows_configuration: ~azure.mgmt.batch.models.WindowsConfiguration
    :ivar data_disks: The configuration for data disks attached to the compute nodes in the pool.
    :vartype data_disks: list[~azure.mgmt.batch.models.DataDisk]
    :ivar license_type: The type of on-premises license to be used when deploying the operating
     system.
    :vartype license_type: str
    :ivar container_configuration: The container configuration for the pool.
    :vartype container_configuration: ~azure.mgmt.batch.models.ContainerConfiguration
    :ivar disk_encryption_configuration: The disk encryption configuration for the pool.
    :vartype disk_encryption_configuration: ~azure.mgmt.batch.models.DiskEncryptionConfiguration
    :ivar node_placement_configuration: The node placement configuration for the pool.
    :vartype node_placement_configuration: ~azure.mgmt.batch.models.NodePlacementConfiguration
    :ivar extensions: The virtual machine extension for the pool.
    :vartype extensions: list[~azure.mgmt.batch.models.VMExtension]
    :ivar os_disk: Settings for the operating system disk of the Virtual Machine.
    :vartype os_disk: ~azure.mgmt.batch.models.OSDisk
    :ivar security_profile: Specifies the security profile settings for the virtual machine or
     virtual machine scale set.
    :vartype security_profile: ~azure.mgmt.batch.models.SecurityProfile
    :ivar service_artifact_reference: Specifies the service artifact reference id used to set same
     image version for all virtual machines in the scale set when using 'latest' image version.
    :vartype service_artifact_reference: ~azure.mgmt.batch.models.ServiceArtifactReference
    """

    image_reference: "_models.ImageReference" = rest_field(
        name="imageReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """A reference to the Azure Virtual Machines Marketplace Image or the custom Virtual Machine Image
     to use. Required."""
    node_agent_sku_id: str = rest_field(
        name="nodeAgentSkuId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The SKU of the Batch node agent to be provisioned on compute nodes in the pool. Required."""
    windows_configuration: Optional["_models.WindowsConfiguration"] = rest_field(
        name="windowsConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Windows operating system settings on the virtual machine."""
    data_disks: Optional[list["_models.DataDisk"]] = rest_field(
        name="dataDisks", visibility=["read", "create", "update", "delete", "query"]
    )
    """The configuration for data disks attached to the compute nodes in the pool."""
    license_type: Optional[str] = rest_field(
        name="licenseType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of on-premises license to be used when deploying the operating system."""
    container_configuration: Optional["_models.ContainerConfiguration"] = rest_field(
        name="containerConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The container configuration for the pool."""
    disk_encryption_configuration: Optional["_models.DiskEncryptionConfiguration"] = rest_field(
        name="diskEncryptionConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The disk encryption configuration for the pool."""
    node_placement_configuration: Optional["_models.NodePlacementConfiguration"] = rest_field(
        name="nodePlacementConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The node placement configuration for the pool."""
    extensions: Optional[list["_models.VMExtension"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The virtual machine extension for the pool."""
    os_disk: Optional["_models.OSDisk"] = rest_field(
        name="osDisk", visibility=["read", "create", "update", "delete", "query"]
    )
    """Settings for the operating system disk of the Virtual Machine."""
    security_profile: Optional["_models.SecurityProfile"] = rest_field(
        name="securityProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the security profile settings for the virtual machine or virtual machine scale set."""
    service_artifact_reference: Optional["_models.ServiceArtifactReference"] = rest_field(
        name="serviceArtifactReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the service artifact reference id used to set same image version for all virtual
     machines in the scale set when using 'latest' image version."""

    @overload
    def __init__(
        self,
        *,
        image_reference: "_models.ImageReference",
        node_agent_sku_id: str,
        windows_configuration: Optional["_models.WindowsConfiguration"] = None,
        data_disks: Optional[list["_models.DataDisk"]] = None,
        license_type: Optional[str] = None,
        container_configuration: Optional["_models.ContainerConfiguration"] = None,
        disk_encryption_configuration: Optional["_models.DiskEncryptionConfiguration"] = None,
        node_placement_configuration: Optional["_models.NodePlacementConfiguration"] = None,
        extensions: Optional[list["_models.VMExtension"]] = None,
        os_disk: Optional["_models.OSDisk"] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        service_artifact_reference: Optional["_models.ServiceArtifactReference"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineFamilyCoreQuota(_Model):
    """A VM Family and its associated core quota for the Batch account.

    :ivar name: The Virtual Machine family name.
    :vartype name: str
    :ivar core_quota: The core quota for the VM family for the Batch account.
    :vartype core_quota: int
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The Virtual Machine family name."""
    core_quota: Optional[int] = rest_field(name="coreQuota", visibility=["read"])
    """The core quota for the VM family for the Batch account."""


class VMDiskSecurityProfile(_Model):
    """Specifies the security profile settings for the managed disk. **Note**: It can only be set for
    Confidential VMs and is required when using Confidential VMs.

    :ivar security_encryption_type: Specifies the EncryptionType of the managed disk. It is set to
     VMGuestStateOnly for encryption of just the VMGuestState blob, and NonPersistedTPM for not
     persisting firmware state in the VMGuestState blob. **Note**: It can be set for only
     Confidential VMs and required when using Confidential VMs. Known values are: "NonPersistedTPM",
     "VMGuestStateOnly", and "DiskWithVMGuestState".
    :vartype security_encryption_type: str or ~azure.mgmt.batch.models.SecurityEncryptionTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed disk that is used for Customer Managed Key encrypted ConfidentialVM OS Disk and
     VMGuest blob. It can be set only in UserSubscription mode.
    :vartype disk_encryption_set: ~azure.mgmt.batch.models.DiskEncryptionSetParameters
    """

    security_encryption_type: Optional[Union[str, "_models.SecurityEncryptionTypes"]] = rest_field(
        name="securityEncryptionType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the EncryptionType of the managed disk. It is set to VMGuestStateOnly for encryption
     of just the VMGuestState blob, and NonPersistedTPM for not persisting firmware state in the
     VMGuestState blob. **Note**: It can be set for only Confidential VMs and required when using
     Confidential VMs. Known values are: \"NonPersistedTPM\", \"VMGuestStateOnly\", and
     \"DiskWithVMGuestState\"."""
    disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = rest_field(
        name="diskEncryptionSet", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the customer managed disk encryption set resource id for the managed disk that is
     used for Customer Managed Key encrypted ConfidentialVM OS Disk and VMGuest blob. It can be set
     only in UserSubscription mode."""

    @overload
    def __init__(
        self,
        *,
        security_encryption_type: Optional[Union[str, "_models.SecurityEncryptionTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VMExtension(_Model):
    """The configuration for virtual machine extensions.

    :ivar name: The name of the virtual machine extension. Required.
    :vartype name: str
    :ivar publisher: The name of the extension handler publisher. Required.
    :vartype publisher: str
    :ivar type: The type of the extensions. Required.
    :vartype type: str
    :ivar type_handler_version: The version of script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    :ivar settings: JSON formatted public settings for the extension.
    :vartype settings: any
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: any
    :ivar provision_after_extensions: The collection of extension names.
    :vartype provision_after_extensions: list[str]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the virtual machine extension. Required."""
    publisher: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the extension handler publisher. Required."""
    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of the extensions. Required."""
    type_handler_version: Optional[str] = rest_field(
        name="typeHandlerVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The version of script handler."""
    auto_upgrade_minor_version: Optional[bool] = rest_field(
        name="autoUpgradeMinorVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the extension should use a newer minor version if one is available at
     deployment time. Once deployed, however, the extension will not upgrade minor versions unless
     redeployed, even with this property set to true."""
    enable_automatic_upgrade: Optional[bool] = rest_field(
        name="enableAutomaticUpgrade", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the extension should be automatically upgraded by the platform if there is a
     newer version of the extension available."""
    settings: Optional[Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """JSON formatted public settings for the extension."""
    protected_settings: Optional[Any] = rest_field(
        name="protectedSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no
     protected settings at all."""
    provision_after_extensions: Optional[list[str]] = rest_field(
        name="provisionAfterExtensions", visibility=["read", "create", "update", "delete", "query"]
    )
    """The collection of extension names."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        publisher: str,
        type: str,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[Any] = None,
        protected_settings: Optional[Any] = None,
        provision_after_extensions: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WindowsConfiguration(_Model):
    """Windows operating system settings to apply to the virtual machine.

    :ivar enable_automatic_updates: Whether automatic updates are enabled on the virtual machine.
    :vartype enable_automatic_updates: bool
    """

    enable_automatic_updates: Optional[bool] = rest_field(
        name="enableAutomaticUpdates", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether automatic updates are enabled on the virtual machine."""

    @overload
    def __init__(
        self,
        *,
        enable_automatic_updates: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WindowsUserConfiguration(_Model):
    """Properties used to create a user account on a Windows node.

    :ivar login_mode: Login mode for user. Known values are: "Batch" and "Interactive".
    :vartype login_mode: str or ~azure.mgmt.batch.models.LoginMode
    """

    login_mode: Optional[Union[str, "_models.LoginMode"]] = rest_field(
        name="loginMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Login mode for user. Known values are: \"Batch\" and \"Interactive\"."""

    @overload
    def __init__(
        self,
        *,
        login_mode: Optional[Union[str, "_models.LoginMode"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
