# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.batch import BatchManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestBatchManagementApplicationPackageOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(BatchManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_application_package_get(self, resource_group):
        response = self.client.application_package.get(
            resource_group_name=resource_group.name,
            account_name="str",
            application_name="str",
            version_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_application_package_create(self, resource_group):
        response = self.client.application_package.create(
            resource_group_name=resource_group.name,
            account_name="str",
            application_name="str",
            version_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_application_package_delete(self, resource_group):
        response = self.client.application_package.delete(
            resource_group_name=resource_group.name,
            account_name="str",
            application_name="str",
            version_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_application_package_list(self, resource_group):
        response = self.client.application_package.list(
            resource_group_name=resource_group.name,
            account_name="str",
            application_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_application_package_activate(self, resource_group):
        response = self.client.application_package.activate(
            resource_group_name=resource_group.name,
            account_name="str",
            application_name="str",
            version_name="str",
            parameters={"format": "str"},
        )

        # please add some check logic here by yourself
        # ...
