# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=enum-must-be-uppercase

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AnalysisContentKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kind of media content."""

    DOCUMENT = "document"
    """Document content, such as pdf, image, txt, etc."""
    AUDIO_VISUAL = "audioVisual"
    """Audio visual content, such as mp3, mp4, etc."""


class AnnotationFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Representation format of annotations in analyze result markdown."""

    NONE = "none"
    """Do not represent annotations."""
    MARKDOWN = "markdown"
    """Represent basic annotation information using markdown formatting."""


class ChartFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Representation format of charts in analyze result markdown."""

    CHART_JS = "chartJs"
    """Represent charts as Chart.js code blocks."""
    MARKDOWN = "markdown"
    """Represent charts as markdown tables."""


class ContentAnalyzerStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of a resource."""

    CREATING = "creating"
    """The resource is being created."""
    READY = "ready"
    """The resource is ready."""
    DELETING = "deleting"
    """The resource is being deleted."""
    FAILED = "failed"
    """The resource failed during creation."""


class ContentFieldType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Semantic data type of the field value."""

    STRING = "string"
    """Plain text."""
    DATE = "date"
    """Date, normalized to ISO 8601 (YYYY-MM-DD) format."""
    TIME = "time"
    """Time, normalized to ISO 8601 (hh:mm:ss) format."""
    NUMBER = "number"
    """Number as double precision floating point."""
    INTEGER = "integer"
    """Integer as 64-bit signed integer."""
    BOOLEAN = "boolean"
    """Boolean value."""
    ARRAY = "array"
    """List of subfields of the same type."""
    OBJECT = "object"
    """Named list of subfields."""
    JSON = "json"
    """JSON object."""


class DocumentAnnotationKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Document annotation kind."""

    HIGHLIGHT = "highlight"
    """Highlight annotation."""
    STRIKETHROUGH = "strikethrough"
    """Strikethrough annotation."""
    UNDERLINE = "underline"
    """Underline annotation."""
    ITALIC = "italic"
    """Italic annotation."""
    BOLD = "bold"
    """Bold annotation."""
    CIRCLE = "circle"
    """Circle annotation."""
    NOTE = "note"
    """Note annotation."""


class DocumentBarcodeKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Barcode kind."""

    QR_CODE = "QRCode"
    """QR code, as defined in ISO/IEC 18004:2015."""
    PDF417 = "PDF417"
    """PDF417, as defined in ISO 15438."""
    UPCA = "UPCA"
    """GS1 12-digit Universal Product Code."""
    UPCE = "UPCE"
    """GS1 6-digit Universal Product Code."""
    CODE39 = "Code39"
    """Code 39 barcode, as defined in ISO/IEC 16388:2007."""
    CODE128 = "Code128"
    """Code 128 barcode, as defined in ISO/IEC 15417:2007."""
    EAN8 = "EAN8"
    """GS1 8-digit International Article Number (European Article Number)."""
    EAN13 = "EAN13"
    """GS1 13-digit International Article Number (European Article Number)."""
    DATA_BAR = "DataBar"
    """GS1 DataBar barcode."""
    CODE93 = "Code93"
    """Code 93 barcode, as defined in ANSI/AIM BC5-1995."""
    CODABAR = "Codabar"
    """Codabar barcode, as defined in ANSI/AIM BC3-1995."""
    DATA_BAR_EXPANDED = "DataBarExpanded"
    """GS1 DataBar Expanded barcode."""
    ITF = "ITF"
    """Interleaved 2 of 5 barcode, as defined in ANSI/AIM BC2-1995."""
    MICRO_QR_CODE = "MicroQRCode"
    """Micro QR code, as defined in ISO/IEC 23941:2022."""
    AZTEC = "Aztec"
    """Aztec code, as defined in ISO/IEC 24778:2008."""
    DATA_MATRIX = "DataMatrix"
    """Data matrix code, as defined in ISO/IEC 16022:2006."""
    MAXI_CODE = "MaxiCode"
    """MaxiCode, as defined in ISO/IEC 16023:2000."""


class DocumentFigureKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Figure kind."""

    UNKNOWN = "unknown"
    """Unknown figure kind."""
    CHART = "chart"
    """Figure containing a chart, such as a bar chart, line chart, or pie chart."""
    MERMAID = "mermaid"
    """Figure containing a diagram, such as a flowchart or network diagram."""


class DocumentFormulaKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Formula kind."""

    INLINE = "inline"
    """A formula embedded within the content of a paragraph."""
    DISPLAY = "display"
    """A formula in display mode that takes up an entire line."""


class DocumentTableCellKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Table cell kind."""

    CONTENT = "content"
    """Main content/data."""
    ROW_HEADER = "rowHeader"
    """Description of the row content."""
    COLUMN_HEADER = "columnHeader"
    """Description the column content."""
    STUB_HEAD = "stubHead"
    """Description of the row headers, usually located at the top left corner of a table."""
    DESCRIPTION = "description"
    """Description of the content in (parts of) the table."""


class GenerationMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Generation method."""

    GENERATE = "generate"
    """Values are generated freely based on the content."""
    EXTRACT = "extract"
    """Values are extracted as they appear in the content."""
    CLASSIFY = "classify"
    """Values are classified against a predefined set of categories."""


class KnowledgeSourceKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Knowledge source kind."""

    LABELED_DATA = "labeledData"
    """A labeled data knowledge source."""


class LengthUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Length unit used by the width, height, and source properties."""

    PIXEL = "pixel"
    """Pixel unit."""
    INCH = "inch"
    """Inch unit."""


class OperationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum describing allowed operation states."""

    NOT_STARTED = "NotStarted"
    """The operation has not started."""
    RUNNING = "Running"
    """The operation is in progress."""
    SUCCEEDED = "Succeeded"
    """The operation has completed successfully."""
    FAILED = "Failed"
    """The operation has failed."""
    CANCELED = "Canceled"
    """The operation has been canceled by the user."""


class ProcessingLocation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The location where the data may be processed."""

    GEOGRAPHY = "geography"
    """Data may be processed in the same geography as the resource."""
    DATA_ZONE = "dataZone"
    """Data may be processed in the same data zone as the resource."""
    GLOBALEnum = "global"
    """Data may be processed in any Azure data center globally."""


class SemanticRole(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Semantic role of the paragraph."""

    PAGE_HEADER = "pageHeader"
    """Text near the top edge of the page."""
    PAGE_FOOTER = "pageFooter"
    """Text near the bottom edge of the page."""
    PAGE_NUMBER = "pageNumber"
    """Page number."""
    TITLE = "title"
    """Top-level title describing the entire document."""
    SECTION_HEADING = "sectionHeading"
    """Sub heading describing a section of the document."""
    FOOTNOTE = "footnote"
    """Note usually placed after the main content on a page."""
    FORMULA_BLOCK = "formulaBlock"
    """Block of formulas, often with shared alignment."""


class TableFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Representation format of tables in analyze result markdown."""

    HTML = "html"
    """Represent tables using HTML table elements: \\<table>, \\<th>, \\<tr>, \\<td>."""
    MARKDOWN = "markdown"
    """Represent tables using GitHub Flavored Markdown table syntax, which does not support merged
    cells or rich headers."""
