# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.managedops.aio import ManagedOpsMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestManagedOpsMgmtManagedOpsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ManagedOpsMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_ops_get(self, resource_group):
        response = await self.client.managed_ops.get(
            managed_ops_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_ops_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.managed_ops.begin_create_or_update(
                managed_ops_name="str",
                resource={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "desiredConfiguration": {
                            "azureMonitorInsights": {"azureMonitorWorkspaceId": "str"},
                            "changeTrackingAndInventory": {"logAnalyticsWorkspaceId": "str"},
                            "userAssignedManagedIdentityId": "str",
                            "defenderCspm": "Enable",
                            "defenderForServers": "Enable",
                        },
                        "policyAssignmentProperties": {"policyInitiativeAssignmentId": "str"},
                        "provisioningState": "str",
                        "services": {
                            "azureMonitorInsights": {"dcrId": "str", "enablementStatus": "Enabled"},
                            "azurePolicyAndMachineConfiguration": {"enablementStatus": "Enabled"},
                            "azureUpdateManager": {"enablementStatus": "Enabled"},
                            "changeTrackingAndInventory": {"dcrId": "str", "enablementStatus": "Enabled"},
                            "defenderCspm": {"enablementStatus": "Enabled"},
                            "defenderForServers": {"enablementStatus": "Enabled"},
                        },
                        "sku": {"name": "str", "tier": "str"},
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_ops_list(self, resource_group):
        response = self.client.managed_ops.list()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_ops_begin_update(self, resource_group):
        response = await (
            await self.client.managed_ops.begin_update(
                managed_ops_name="str",
                properties={
                    "properties": {"desiredConfiguration": {"defenderCspm": "Enable", "defenderForServers": "Enable"}}
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_ops_begin_delete(self, resource_group):
        response = await (
            await self.client.managed_ops.begin_delete(
                managed_ops_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
