# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=wrong-import-position

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ._patch import *  # pylint: disable=unused-wildcard-import


from ._models import (  # type: ignore
    AssetMetadata,
    AssetStatisticsResponse,
    BandStatistics,
    BandStatisticsMap,
    ClassMapLegendResponse,
    DefaultLocation,
    ErrorInfo,
    Feature,
    Geometry,
    ImageParameters,
    ImageResponse,
    IngestionDefinition,
    IngestionRun,
    IngestionRunOperation,
    IngestionSource,
    IngestionSourceSummary,
    LineString,
    ManagedIdentityConnection,
    ManagedIdentityIngestionSource,
    ManagedIdentityMetadata,
    MosaicMetadata,
    MultiLineString,
    MultiPoint,
    MultiPolygon,
    Operation,
    OperationStatusHistoryItem,
    PartitionType,
    Point,
    Polygon,
    QueryableDefinitionsResponse,
    RenderOption,
    RenderOptionCondition,
    RenderOptionLegend,
    RenderOptionVectorOptions,
    SearchOptionsFields,
    SharedAccessSignatureSignedLink,
    SharedAccessSignatureToken,
    SharedAccessSignatureTokenConnection,
    SharedAccessSignatureTokenIngestionSource,
    StacAsset,
    StacAssetData,
    StacCatalogCollections,
    StacCollection,
    StacCollectionTemporalExtent,
    StacConformanceClasses,
    StacContextExtension,
    StacExtensionExtent,
    StacExtensionSpatialExtent,
    StacItem,
    StacItemAsset,
    StacItemBounds,
    StacItemCollection,
    StacItemOrStacItemCollection,
    StacItemPointAsset,
    StacItemProperties,
    StacItemStatisticsGeoJson,
    StacItemStatisticsGeoJsonProperties,
    StacLandingPage,
    StacLink,
    StacMosaic,
    StacMosaicConfiguration,
    StacProvider,
    StacQueryable,
    StacSearchParameters,
    StacSortExtension,
    TileJsonMetadata,
    TileMatrix,
    TileMatrixSet,
    TileMatrixSetBoundingBox,
    TileSettings,
    TilerAssetGeoJson,
    TilerCoreModelsResponsesPoint,
    TilerInfo,
    TilerInfoGeoJsonFeature,
    TilerInfoMapResponse,
    TilerMosaicSearchRegistrationResponse,
    TilerStacItemStatistics,
    TilerStacSearchDefinition,
    TilerStacSearchRegistration,
    UserCollectionSettings,
    VariableMatrixWidth,
)

from ._enums import (  # type: ignore
    ColorMapNames,
    FeatureType,
    FilterLanguage,
    GeometryType,
    IngestionSourceType,
    IngestionStatus,
    IngestionType,
    LegendConfigType,
    MosaicMetadataType,
    NoDataType,
    OperationStatus,
    PartitionTypeScheme,
    PixelSelection,
    RenderOptionType,
    Resampling,
    StacAssetUrlSigningMode,
    StacLinkType,
    StacModelType,
    StacQueryableDefinitionDataType,
    StacSearchSortingDirection,
    TerrainAlgorithm,
    TileAddressingScheme,
    TileMatrixCornerOfOrigin,
    TilerImageFormat,
)
from ._patch import __all__ as _patch_all
from ._patch import *
from ._patch import patch_sdk as _patch_sdk

__all__ = [
    "AssetMetadata",
    "AssetStatisticsResponse",
    "BandStatistics",
    "BandStatisticsMap",
    "ClassMapLegendResponse",
    "DefaultLocation",
    "ErrorInfo",
    "Feature",
    "Geometry",
    "ImageParameters",
    "ImageResponse",
    "IngestionDefinition",
    "IngestionRun",
    "IngestionRunOperation",
    "IngestionSource",
    "IngestionSourceSummary",
    "LineString",
    "ManagedIdentityConnection",
    "ManagedIdentityIngestionSource",
    "ManagedIdentityMetadata",
    "MosaicMetadata",
    "MultiLineString",
    "MultiPoint",
    "MultiPolygon",
    "Operation",
    "OperationStatusHistoryItem",
    "PartitionType",
    "Point",
    "Polygon",
    "QueryableDefinitionsResponse",
    "RenderOption",
    "RenderOptionCondition",
    "RenderOptionLegend",
    "RenderOptionVectorOptions",
    "SearchOptionsFields",
    "SharedAccessSignatureSignedLink",
    "SharedAccessSignatureToken",
    "SharedAccessSignatureTokenConnection",
    "SharedAccessSignatureTokenIngestionSource",
    "StacAsset",
    "StacAssetData",
    "StacCatalogCollections",
    "StacCollection",
    "StacCollectionTemporalExtent",
    "StacConformanceClasses",
    "StacContextExtension",
    "StacExtensionExtent",
    "StacExtensionSpatialExtent",
    "StacItem",
    "StacItemAsset",
    "StacItemBounds",
    "StacItemCollection",
    "StacItemOrStacItemCollection",
    "StacItemPointAsset",
    "StacItemProperties",
    "StacItemStatisticsGeoJson",
    "StacItemStatisticsGeoJsonProperties",
    "StacLandingPage",
    "StacLink",
    "StacMosaic",
    "StacMosaicConfiguration",
    "StacProvider",
    "StacQueryable",
    "StacSearchParameters",
    "StacSortExtension",
    "TileJsonMetadata",
    "TileMatrix",
    "TileMatrixSet",
    "TileMatrixSetBoundingBox",
    "TileSettings",
    "TilerAssetGeoJson",
    "TilerCoreModelsResponsesPoint",
    "TilerInfo",
    "TilerInfoGeoJsonFeature",
    "TilerInfoMapResponse",
    "TilerMosaicSearchRegistrationResponse",
    "TilerStacItemStatistics",
    "TilerStacSearchDefinition",
    "TilerStacSearchRegistration",
    "UserCollectionSettings",
    "VariableMatrixWidth",
    "ColorMapNames",
    "FeatureType",
    "FilterLanguage",
    "GeometryType",
    "IngestionSourceType",
    "IngestionStatus",
    "IngestionType",
    "LegendConfigType",
    "MosaicMetadataType",
    "NoDataType",
    "OperationStatus",
    "PartitionTypeScheme",
    "PixelSelection",
    "RenderOptionType",
    "Resampling",
    "StacAssetUrlSigningMode",
    "StacLinkType",
    "StacModelType",
    "StacQueryableDefinitionDataType",
    "StacSearchSortingDirection",
    "TerrainAlgorithm",
    "TileAddressingScheme",
    "TileMatrixCornerOfOrigin",
    "TilerImageFormat",
]
__all__.extend([p for p in _patch_all if p not in __all__])  # pyright: ignore
_patch_sdk()
