# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models


class APIServerProfile(_serialization.Model):
    """APIServerProfile represents an API server profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar visibility: API server visibility. Known values are: "Private" and "Public".
    :vartype visibility: str or ~azure.mgmt.redhatopenshift.models.Visibility
    :ivar url: The URL to access the cluster API server.
    :vartype url: str
    :ivar ip: The IP of the cluster API server.
    :vartype ip: str
    """

    _validation = {
        "url": {"readonly": True},
        "ip": {"readonly": True},
    }

    _attribute_map = {
        "visibility": {"key": "visibility", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "ip": {"key": "ip", "type": "str"},
    }

    def __init__(self, *, visibility: Optional[Union[str, "_models.Visibility"]] = None, **kwargs: Any) -> None:
        """
        :keyword visibility: API server visibility. Known values are: "Private" and "Public".
        :paramtype visibility: str or ~azure.mgmt.redhatopenshift.models.Visibility
        """
        super().__init__(**kwargs)
        self.visibility = visibility
        self.url: Optional[str] = None
        self.ip: Optional[str] = None


class CloudErrorBody(_serialization.Model):
    """CloudErrorBody represents the body of a cloud error.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.redhatopenshift.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[list["_models.CloudErrorBody"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.redhatopenshift.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ClusterProfile(_serialization.Model):
    """ClusterProfile represents a cluster profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar pull_secret: The pull secret for the cluster.
    :vartype pull_secret: str
    :ivar domain: The domain for the cluster.
    :vartype domain: str
    :ivar version: The version of the cluster.
    :vartype version: str
    :ivar resource_group_id: The ID of the cluster resource group.
    :vartype resource_group_id: str
    :ivar fips_validated_modules: If FIPS validated crypto modules are used. Known values are:
     "Disabled" and "Enabled".
    :vartype fips_validated_modules: str or ~azure.mgmt.redhatopenshift.models.FipsValidatedModules
    :ivar oidc_issuer: The URL of the managed OIDC issuer in a workload identity cluster.
    :vartype oidc_issuer: str
    """

    _validation = {
        "oidc_issuer": {"readonly": True},
    }

    _attribute_map = {
        "pull_secret": {"key": "pullSecret", "type": "str"},
        "domain": {"key": "domain", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "resource_group_id": {"key": "resourceGroupId", "type": "str"},
        "fips_validated_modules": {"key": "fipsValidatedModules", "type": "str"},
        "oidc_issuer": {"key": "oidcIssuer", "type": "str"},
    }

    def __init__(
        self,
        *,
        pull_secret: Optional[str] = None,
        domain: Optional[str] = None,
        version: Optional[str] = None,
        resource_group_id: Optional[str] = None,
        fips_validated_modules: Optional[Union[str, "_models.FipsValidatedModules"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pull_secret: The pull secret for the cluster.
        :paramtype pull_secret: str
        :keyword domain: The domain for the cluster.
        :paramtype domain: str
        :keyword version: The version of the cluster.
        :paramtype version: str
        :keyword resource_group_id: The ID of the cluster resource group.
        :paramtype resource_group_id: str
        :keyword fips_validated_modules: If FIPS validated crypto modules are used. Known values are:
         "Disabled" and "Enabled".
        :paramtype fips_validated_modules: str or
         ~azure.mgmt.redhatopenshift.models.FipsValidatedModules
        """
        super().__init__(**kwargs)
        self.pull_secret = pull_secret
        self.domain = domain
        self.version = version
        self.resource_group_id = resource_group_id
        self.fips_validated_modules = fips_validated_modules
        self.oidc_issuer: Optional[str] = None


class ConsoleProfile(_serialization.Model):
    """ConsoleProfile represents a console profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar url: The URL to access the cluster console.
    :vartype url: str
    """

    _validation = {
        "url": {"readonly": True},
    }

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.url: Optional[str] = None


class Display(_serialization.Model):
    """Display represents the display details of an operation.

    :ivar provider: Friendly name of the resource provider.
    :vartype provider: str
    :ivar resource: Resource type on which the operation is performed.
    :vartype resource: str
    :ivar operation: Operation type: read, write, delete, listKeys/action, etc.
    :vartype operation: str
    :ivar description: Friendly name of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Friendly name of the resource provider.
        :paramtype provider: str
        :keyword resource: Resource type on which the operation is performed.
        :paramtype resource: str
        :keyword operation: Operation type: read, write, delete, listKeys/action, etc.
        :paramtype operation: str
        :keyword description: Friendly name of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class EffectiveOutboundIP(_serialization.Model):
    """EffectiveOutboundIP represents an effective outbound IP resource of the cluster public load
    balancer.

    :ivar id: The fully qualified Azure resource id of an IP address resource.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The fully qualified Azure resource id of an IP address resource.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class IngressProfile(_serialization.Model):
    """IngressProfile represents an ingress profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The ingress profile name.
    :vartype name: str
    :ivar visibility: Ingress visibility. Known values are: "Private" and "Public".
    :vartype visibility: str or ~azure.mgmt.redhatopenshift.models.Visibility
    :ivar ip: The IP of the ingress.
    :vartype ip: str
    """

    _validation = {
        "ip": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "visibility": {"key": "visibility", "type": "str"},
        "ip": {"key": "ip", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        visibility: Optional[Union[str, "_models.Visibility"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The ingress profile name.
        :paramtype name: str
        :keyword visibility: Ingress visibility. Known values are: "Private" and "Public".
        :paramtype visibility: str or ~azure.mgmt.redhatopenshift.models.Visibility
        """
        super().__init__(**kwargs)
        self.name = name
        self.visibility = visibility
        self.ip: Optional[str] = None


class LoadBalancerProfile(_serialization.Model):
    """LoadBalancerProfile represents the profile of the cluster public load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar managed_outbound_ips: The desired managed outbound IPs for the cluster public load
     balancer.
    :vartype managed_outbound_ips: ~azure.mgmt.redhatopenshift.models.ManagedOutboundIPs
    :ivar effective_outbound_ips: The list of effective outbound IP addresses of the public load
     balancer.
    :vartype effective_outbound_ips: list[~azure.mgmt.redhatopenshift.models.EffectiveOutboundIP]
    """

    _validation = {
        "effective_outbound_ips": {"readonly": True},
    }

    _attribute_map = {
        "managed_outbound_ips": {"key": "managedOutboundIps", "type": "ManagedOutboundIPs"},
        "effective_outbound_ips": {"key": "effectiveOutboundIps", "type": "[EffectiveOutboundIP]"},
    }

    def __init__(self, *, managed_outbound_ips: Optional["_models.ManagedOutboundIPs"] = None, **kwargs: Any) -> None:
        """
        :keyword managed_outbound_ips: The desired managed outbound IPs for the cluster public load
         balancer.
        :paramtype managed_outbound_ips: ~azure.mgmt.redhatopenshift.models.ManagedOutboundIPs
        """
        super().__init__(**kwargs)
        self.managed_outbound_ips = managed_outbound_ips
        self.effective_outbound_ips: Optional[list["_models.EffectiveOutboundIP"]] = None


class ManagedOutboundIPs(_serialization.Model):
    """ManagedOutboundIPs represents the desired managed outbound IPs for the cluster public load
    balancer.

    :ivar count: Count represents the desired number of IPv4 outbound IPs created and managed by
     Azure for the cluster public load balancer.  Allowed values are in the range of 1 - 20.  The
     default value is 1.
    :vartype count: int
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, *, count: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword count: Count represents the desired number of IPv4 outbound IPs created and managed by
         Azure for the cluster public load balancer.  Allowed values are in the range of 1 - 20.  The
         default value is 1.
        :paramtype count: int
        """
        super().__init__(**kwargs)
        self.count = count


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.redhatopenshift.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.redhatopenshift.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.redhatopenshift.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.redhatopenshift.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class MasterProfile(_serialization.Model):
    """MasterProfile represents a master profile.

    :ivar vm_size: The size of the master VMs.
    :vartype vm_size: str
    :ivar subnet_id: The Azure resource ID of the master subnet.
    :vartype subnet_id: str
    :ivar encryption_at_host: Whether master virtual machines are encrypted at host. Known values
     are: "Disabled" and "Enabled".
    :vartype encryption_at_host: str or ~azure.mgmt.redhatopenshift.models.EncryptionAtHost
    :ivar disk_encryption_set_id: The resource ID of an associated DiskEncryptionSet, if
     applicable.
    :vartype disk_encryption_set_id: str
    """

    _attribute_map = {
        "vm_size": {"key": "vmSize", "type": "str"},
        "subnet_id": {"key": "subnetId", "type": "str"},
        "encryption_at_host": {"key": "encryptionAtHost", "type": "str"},
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
    }

    def __init__(
        self,
        *,
        vm_size: Optional[str] = None,
        subnet_id: Optional[str] = None,
        encryption_at_host: Optional[Union[str, "_models.EncryptionAtHost"]] = None,
        disk_encryption_set_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_size: The size of the master VMs.
        :paramtype vm_size: str
        :keyword subnet_id: The Azure resource ID of the master subnet.
        :paramtype subnet_id: str
        :keyword encryption_at_host: Whether master virtual machines are encrypted at host. Known
         values are: "Disabled" and "Enabled".
        :paramtype encryption_at_host: str or ~azure.mgmt.redhatopenshift.models.EncryptionAtHost
        :keyword disk_encryption_set_id: The resource ID of an associated DiskEncryptionSet, if
         applicable.
        :paramtype disk_encryption_set_id: str
        """
        super().__init__(**kwargs)
        self.vm_size = vm_size
        self.subnet_id = subnet_id
        self.encryption_at_host = encryption_at_host
        self.disk_encryption_set_id = disk_encryption_set_id


class NetworkProfile(_serialization.Model):
    """NetworkProfile represents a network profile.

    :ivar pod_cidr: The CIDR used for OpenShift/Kubernetes Pods.
    :vartype pod_cidr: str
    :ivar service_cidr: The CIDR used for OpenShift/Kubernetes Services.
    :vartype service_cidr: str
    :ivar outbound_type: The OutboundType used for egress traffic. Known values are: "Loadbalancer"
     and "UserDefinedRouting".
    :vartype outbound_type: str or ~azure.mgmt.redhatopenshift.models.OutboundType
    :ivar load_balancer_profile: The cluster load balancer profile.
    :vartype load_balancer_profile: ~azure.mgmt.redhatopenshift.models.LoadBalancerProfile
    :ivar preconfigured_nsg: Specifies whether subnets are pre-attached with an NSG. Known values
     are: "Disabled" and "Enabled".
    :vartype preconfigured_nsg: str or ~azure.mgmt.redhatopenshift.models.PreconfiguredNSG
    """

    _attribute_map = {
        "pod_cidr": {"key": "podCidr", "type": "str"},
        "service_cidr": {"key": "serviceCidr", "type": "str"},
        "outbound_type": {"key": "outboundType", "type": "str"},
        "load_balancer_profile": {"key": "loadBalancerProfile", "type": "LoadBalancerProfile"},
        "preconfigured_nsg": {"key": "preconfiguredNSG", "type": "str"},
    }

    def __init__(
        self,
        *,
        pod_cidr: Optional[str] = None,
        service_cidr: Optional[str] = None,
        outbound_type: Optional[Union[str, "_models.OutboundType"]] = None,
        load_balancer_profile: Optional["_models.LoadBalancerProfile"] = None,
        preconfigured_nsg: Optional[Union[str, "_models.PreconfiguredNSG"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pod_cidr: The CIDR used for OpenShift/Kubernetes Pods.
        :paramtype pod_cidr: str
        :keyword service_cidr: The CIDR used for OpenShift/Kubernetes Services.
        :paramtype service_cidr: str
        :keyword outbound_type: The OutboundType used for egress traffic. Known values are:
         "Loadbalancer" and "UserDefinedRouting".
        :paramtype outbound_type: str or ~azure.mgmt.redhatopenshift.models.OutboundType
        :keyword load_balancer_profile: The cluster load balancer profile.
        :paramtype load_balancer_profile: ~azure.mgmt.redhatopenshift.models.LoadBalancerProfile
        :keyword preconfigured_nsg: Specifies whether subnets are pre-attached with an NSG. Known
         values are: "Disabled" and "Enabled".
        :paramtype preconfigured_nsg: str or ~azure.mgmt.redhatopenshift.models.PreconfiguredNSG
        """
        super().__init__(**kwargs)
        self.pod_cidr = pod_cidr
        self.service_cidr = service_cidr
        self.outbound_type = outbound_type
        self.load_balancer_profile = load_balancer_profile
        self.preconfigured_nsg = preconfigured_nsg


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.redhatopenshift.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.redhatopenshift.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class OpenShiftCluster(TrackedResource):
    """OpenShiftCluster represents an Azure Red Hat OpenShift cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.redhatopenshift.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: Identity stores information about the cluster MSI(s) in a workload identity
     cluster.
    :vartype identity: ~azure.mgmt.redhatopenshift.models.ManagedServiceIdentity
    :ivar provisioning_state: The cluster provisioning state. Known values are: "AdminUpdating",
     "Canceled", "Creating", "Deleting", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.redhatopenshift.models.ProvisioningState
    :ivar cluster_profile: The cluster profile.
    :vartype cluster_profile: ~azure.mgmt.redhatopenshift.models.ClusterProfile
    :ivar console_profile: The console profile.
    :vartype console_profile: ~azure.mgmt.redhatopenshift.models.ConsoleProfile
    :ivar service_principal_profile: The cluster service principal profile.
    :vartype service_principal_profile: ~azure.mgmt.redhatopenshift.models.ServicePrincipalProfile
    :ivar platform_workload_identity_profile: The workload identity profile.
    :vartype platform_workload_identity_profile:
     ~azure.mgmt.redhatopenshift.models.PlatformWorkloadIdentityProfile
    :ivar network_profile: The cluster network profile.
    :vartype network_profile: ~azure.mgmt.redhatopenshift.models.NetworkProfile
    :ivar master_profile: The cluster master profile.
    :vartype master_profile: ~azure.mgmt.redhatopenshift.models.MasterProfile
    :ivar worker_profiles: The cluster worker profiles.
    :vartype worker_profiles: list[~azure.mgmt.redhatopenshift.models.WorkerProfile]
    :ivar worker_profiles_status: The cluster worker profiles status.
    :vartype worker_profiles_status: list[~azure.mgmt.redhatopenshift.models.WorkerProfile]
    :ivar apiserver_profile: The cluster API server profile.
    :vartype apiserver_profile: ~azure.mgmt.redhatopenshift.models.APIServerProfile
    :ivar ingress_profiles: The cluster ingress profiles.
    :vartype ingress_profiles: list[~azure.mgmt.redhatopenshift.models.IngressProfile]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "worker_profiles_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "cluster_profile": {"key": "properties.clusterProfile", "type": "ClusterProfile"},
        "console_profile": {"key": "properties.consoleProfile", "type": "ConsoleProfile"},
        "service_principal_profile": {"key": "properties.servicePrincipalProfile", "type": "ServicePrincipalProfile"},
        "platform_workload_identity_profile": {
            "key": "properties.platformWorkloadIdentityProfile",
            "type": "PlatformWorkloadIdentityProfile",
        },
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfile"},
        "master_profile": {"key": "properties.masterProfile", "type": "MasterProfile"},
        "worker_profiles": {"key": "properties.workerProfiles", "type": "[WorkerProfile]"},
        "worker_profiles_status": {"key": "properties.workerProfilesStatus", "type": "[WorkerProfile]"},
        "apiserver_profile": {"key": "properties.apiserverProfile", "type": "APIServerProfile"},
        "ingress_profiles": {"key": "properties.ingressProfiles", "type": "[IngressProfile]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        cluster_profile: Optional["_models.ClusterProfile"] = None,
        console_profile: Optional["_models.ConsoleProfile"] = None,
        service_principal_profile: Optional["_models.ServicePrincipalProfile"] = None,
        platform_workload_identity_profile: Optional["_models.PlatformWorkloadIdentityProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        master_profile: Optional["_models.MasterProfile"] = None,
        worker_profiles: Optional[list["_models.WorkerProfile"]] = None,
        apiserver_profile: Optional["_models.APIServerProfile"] = None,
        ingress_profiles: Optional[list["_models.IngressProfile"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Identity stores information about the cluster MSI(s) in a workload identity
         cluster.
        :paramtype identity: ~azure.mgmt.redhatopenshift.models.ManagedServiceIdentity
        :keyword provisioning_state: The cluster provisioning state. Known values are: "AdminUpdating",
         "Canceled", "Creating", "Deleting", "Failed", "Succeeded", and "Updating".
        :paramtype provisioning_state: str or ~azure.mgmt.redhatopenshift.models.ProvisioningState
        :keyword cluster_profile: The cluster profile.
        :paramtype cluster_profile: ~azure.mgmt.redhatopenshift.models.ClusterProfile
        :keyword console_profile: The console profile.
        :paramtype console_profile: ~azure.mgmt.redhatopenshift.models.ConsoleProfile
        :keyword service_principal_profile: The cluster service principal profile.
        :paramtype service_principal_profile:
         ~azure.mgmt.redhatopenshift.models.ServicePrincipalProfile
        :keyword platform_workload_identity_profile: The workload identity profile.
        :paramtype platform_workload_identity_profile:
         ~azure.mgmt.redhatopenshift.models.PlatformWorkloadIdentityProfile
        :keyword network_profile: The cluster network profile.
        :paramtype network_profile: ~azure.mgmt.redhatopenshift.models.NetworkProfile
        :keyword master_profile: The cluster master profile.
        :paramtype master_profile: ~azure.mgmt.redhatopenshift.models.MasterProfile
        :keyword worker_profiles: The cluster worker profiles.
        :paramtype worker_profiles: list[~azure.mgmt.redhatopenshift.models.WorkerProfile]
        :keyword apiserver_profile: The cluster API server profile.
        :paramtype apiserver_profile: ~azure.mgmt.redhatopenshift.models.APIServerProfile
        :keyword ingress_profiles: The cluster ingress profiles.
        :paramtype ingress_profiles: list[~azure.mgmt.redhatopenshift.models.IngressProfile]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.provisioning_state = provisioning_state
        self.cluster_profile = cluster_profile
        self.console_profile = console_profile
        self.service_principal_profile = service_principal_profile
        self.platform_workload_identity_profile = platform_workload_identity_profile
        self.network_profile = network_profile
        self.master_profile = master_profile
        self.worker_profiles = worker_profiles
        self.worker_profiles_status: Optional[list["_models.WorkerProfile"]] = None
        self.apiserver_profile = apiserver_profile
        self.ingress_profiles = ingress_profiles


class OpenShiftClusterAdminKubeconfig(_serialization.Model):
    """OpenShiftClusterAdminKubeconfig represents an OpenShift cluster's admin kubeconfig.

    :ivar kubeconfig: The base64-encoded kubeconfig file.
    :vartype kubeconfig: str
    """

    _attribute_map = {
        "kubeconfig": {"key": "kubeconfig", "type": "str"},
    }

    def __init__(self, *, kubeconfig: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kubeconfig: The base64-encoded kubeconfig file.
        :paramtype kubeconfig: str
        """
        super().__init__(**kwargs)
        self.kubeconfig = kubeconfig


class OpenShiftClusterCredentials(_serialization.Model):
    """OpenShiftClusterCredentials represents an OpenShift cluster's credentials.

    :ivar kubeadmin_username: The username for the kubeadmin user.
    :vartype kubeadmin_username: str
    :ivar kubeadmin_password: The password for the kubeadmin user.
    :vartype kubeadmin_password: str
    """

    _attribute_map = {
        "kubeadmin_username": {"key": "kubeadminUsername", "type": "str"},
        "kubeadmin_password": {"key": "kubeadminPassword", "type": "str"},
    }

    def __init__(
        self, *, kubeadmin_username: Optional[str] = None, kubeadmin_password: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kubeadmin_username: The username for the kubeadmin user.
        :paramtype kubeadmin_username: str
        :keyword kubeadmin_password: The password for the kubeadmin user.
        :paramtype kubeadmin_password: str
        """
        super().__init__(**kwargs)
        self.kubeadmin_username = kubeadmin_username
        self.kubeadmin_password = kubeadmin_password


class OpenShiftClusterList(_serialization.Model):
    """OpenShiftClusterList represents a list of OpenShift clusters.

    :ivar value: The list of OpenShift clusters.
    :vartype value: list[~azure.mgmt.redhatopenshift.models.OpenShiftCluster]
    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OpenShiftCluster]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.OpenShiftCluster"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of OpenShift clusters.
        :paramtype value: list[~azure.mgmt.redhatopenshift.models.OpenShiftCluster]
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OpenShiftClusterUpdate(_serialization.Model):
    """OpenShiftCluster represents an Azure Red Hat OpenShift cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Identity stores information about the cluster MSI(s) in a workload identity
     cluster.
    :vartype identity: ~azure.mgmt.redhatopenshift.models.ManagedServiceIdentity
    :ivar provisioning_state: The cluster provisioning state. Known values are: "AdminUpdating",
     "Canceled", "Creating", "Deleting", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.redhatopenshift.models.ProvisioningState
    :ivar cluster_profile: The cluster profile.
    :vartype cluster_profile: ~azure.mgmt.redhatopenshift.models.ClusterProfile
    :ivar console_profile: The console profile.
    :vartype console_profile: ~azure.mgmt.redhatopenshift.models.ConsoleProfile
    :ivar service_principal_profile: The cluster service principal profile.
    :vartype service_principal_profile: ~azure.mgmt.redhatopenshift.models.ServicePrincipalProfile
    :ivar platform_workload_identity_profile: The workload identity profile.
    :vartype platform_workload_identity_profile:
     ~azure.mgmt.redhatopenshift.models.PlatformWorkloadIdentityProfile
    :ivar network_profile: The cluster network profile.
    :vartype network_profile: ~azure.mgmt.redhatopenshift.models.NetworkProfile
    :ivar master_profile: The cluster master profile.
    :vartype master_profile: ~azure.mgmt.redhatopenshift.models.MasterProfile
    :ivar worker_profiles: The cluster worker profiles.
    :vartype worker_profiles: list[~azure.mgmt.redhatopenshift.models.WorkerProfile]
    :ivar worker_profiles_status: The cluster worker profiles status.
    :vartype worker_profiles_status: list[~azure.mgmt.redhatopenshift.models.WorkerProfile]
    :ivar apiserver_profile: The cluster API server profile.
    :vartype apiserver_profile: ~azure.mgmt.redhatopenshift.models.APIServerProfile
    :ivar ingress_profiles: The cluster ingress profiles.
    :vartype ingress_profiles: list[~azure.mgmt.redhatopenshift.models.IngressProfile]
    """

    _validation = {
        "worker_profiles_status": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "cluster_profile": {"key": "properties.clusterProfile", "type": "ClusterProfile"},
        "console_profile": {"key": "properties.consoleProfile", "type": "ConsoleProfile"},
        "service_principal_profile": {"key": "properties.servicePrincipalProfile", "type": "ServicePrincipalProfile"},
        "platform_workload_identity_profile": {
            "key": "properties.platformWorkloadIdentityProfile",
            "type": "PlatformWorkloadIdentityProfile",
        },
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfile"},
        "master_profile": {"key": "properties.masterProfile", "type": "MasterProfile"},
        "worker_profiles": {"key": "properties.workerProfiles", "type": "[WorkerProfile]"},
        "worker_profiles_status": {"key": "properties.workerProfilesStatus", "type": "[WorkerProfile]"},
        "apiserver_profile": {"key": "properties.apiserverProfile", "type": "APIServerProfile"},
        "ingress_profiles": {"key": "properties.ingressProfiles", "type": "[IngressProfile]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        cluster_profile: Optional["_models.ClusterProfile"] = None,
        console_profile: Optional["_models.ConsoleProfile"] = None,
        service_principal_profile: Optional["_models.ServicePrincipalProfile"] = None,
        platform_workload_identity_profile: Optional["_models.PlatformWorkloadIdentityProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        master_profile: Optional["_models.MasterProfile"] = None,
        worker_profiles: Optional[list["_models.WorkerProfile"]] = None,
        apiserver_profile: Optional["_models.APIServerProfile"] = None,
        ingress_profiles: Optional[list["_models.IngressProfile"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Identity stores information about the cluster MSI(s) in a workload identity
         cluster.
        :paramtype identity: ~azure.mgmt.redhatopenshift.models.ManagedServiceIdentity
        :keyword provisioning_state: The cluster provisioning state. Known values are: "AdminUpdating",
         "Canceled", "Creating", "Deleting", "Failed", "Succeeded", and "Updating".
        :paramtype provisioning_state: str or ~azure.mgmt.redhatopenshift.models.ProvisioningState
        :keyword cluster_profile: The cluster profile.
        :paramtype cluster_profile: ~azure.mgmt.redhatopenshift.models.ClusterProfile
        :keyword console_profile: The console profile.
        :paramtype console_profile: ~azure.mgmt.redhatopenshift.models.ConsoleProfile
        :keyword service_principal_profile: The cluster service principal profile.
        :paramtype service_principal_profile:
         ~azure.mgmt.redhatopenshift.models.ServicePrincipalProfile
        :keyword platform_workload_identity_profile: The workload identity profile.
        :paramtype platform_workload_identity_profile:
         ~azure.mgmt.redhatopenshift.models.PlatformWorkloadIdentityProfile
        :keyword network_profile: The cluster network profile.
        :paramtype network_profile: ~azure.mgmt.redhatopenshift.models.NetworkProfile
        :keyword master_profile: The cluster master profile.
        :paramtype master_profile: ~azure.mgmt.redhatopenshift.models.MasterProfile
        :keyword worker_profiles: The cluster worker profiles.
        :paramtype worker_profiles: list[~azure.mgmt.redhatopenshift.models.WorkerProfile]
        :keyword apiserver_profile: The cluster API server profile.
        :paramtype apiserver_profile: ~azure.mgmt.redhatopenshift.models.APIServerProfile
        :keyword ingress_profiles: The cluster ingress profiles.
        :paramtype ingress_profiles: list[~azure.mgmt.redhatopenshift.models.IngressProfile]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.provisioning_state = provisioning_state
        self.cluster_profile = cluster_profile
        self.console_profile = console_profile
        self.service_principal_profile = service_principal_profile
        self.platform_workload_identity_profile = platform_workload_identity_profile
        self.network_profile = network_profile
        self.master_profile = master_profile
        self.worker_profiles = worker_profiles
        self.worker_profiles_status: Optional[list["_models.WorkerProfile"]] = None
        self.apiserver_profile = apiserver_profile
        self.ingress_profiles = ingress_profiles


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.redhatopenshift.models.SystemData
    """


class OpenShiftVersion(ProxyResource):
    """OpenShiftVersion represents an OpenShift version that can be installed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.redhatopenshift.models.SystemData
    :ivar version: Version represents the version to create the cluster at.
    :vartype version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "version": {"key": "properties.version", "type": "str"},
    }

    def __init__(self, *, version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword version: Version represents the version to create the cluster at.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.version = version


class OpenShiftVersionList(_serialization.Model):
    """OpenShiftVersionList represents a List of available versions.

    :ivar value: The List of available versions.
    :vartype value: list[~azure.mgmt.redhatopenshift.models.OpenShiftVersion]
    :ivar next_link: Next Link to next operation.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OpenShiftVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.OpenShiftVersion"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The List of available versions.
        :paramtype value: list[~azure.mgmt.redhatopenshift.models.OpenShiftVersion]
        :keyword next_link: Next Link to next operation.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Operation(_serialization.Model):
    """Operation represents an RP operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that describes the operation.
    :vartype display: ~azure.mgmt.redhatopenshift.models.Display
    :ivar origin: Sources of requests to this operation.  Comma separated list with valid values
     user or system, e.g. "user,system".
    :vartype origin: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "Display"},
        "origin": {"key": "origin", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.Display"] = None,
        origin: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that describes the operation.
        :paramtype display: ~azure.mgmt.redhatopenshift.models.Display
        :keyword origin: Sources of requests to this operation.  Comma separated list with valid values
         user or system, e.g. "user,system".
        :paramtype origin: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin


class OperationList(_serialization.Model):
    """OperationList represents an RP operation list.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.redhatopenshift.models.Operation]
    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[list["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of operations supported by the resource provider.
        :paramtype value: list[~azure.mgmt.redhatopenshift.models.Operation]
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PlatformWorkloadIdentity(_serialization.Model):
    """PlatformWorkloadIdentity stores information representing a single workload identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_id: The resource ID of the PlatformWorkloadIdentity resource.
    :vartype resource_id: str
    :ivar client_id: The ClientID of the PlatformWorkloadIdentity resource.
    :vartype client_id: str
    :ivar object_id: The ObjectID of the PlatformWorkloadIdentity resource.
    :vartype object_id: str
    """

    _validation = {
        "client_id": {"readonly": True},
        "object_id": {"readonly": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "object_id": {"key": "objectId", "type": "str"},
    }

    def __init__(self, *, resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword resource_id: The resource ID of the PlatformWorkloadIdentity resource.
        :paramtype resource_id: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.client_id: Optional[str] = None
        self.object_id: Optional[str] = None


class PlatformWorkloadIdentityProfile(_serialization.Model):
    """PlatformWorkloadIdentityProfile encapsulates all information that is specific to workload
    identity clusters.

    :ivar upgradeable_to: UpgradeableTo stores a single OpenShift version a workload identity
     cluster can be upgraded to.
    :vartype upgradeable_to: str
    :ivar platform_workload_identities: Dictionary of :code:`<PlatformWorkloadIdentity>`.
    :vartype platform_workload_identities: dict[str,
     ~azure.mgmt.redhatopenshift.models.PlatformWorkloadIdentity]
    """

    _attribute_map = {
        "upgradeable_to": {"key": "upgradeableTo", "type": "str"},
        "platform_workload_identities": {"key": "platformWorkloadIdentities", "type": "{PlatformWorkloadIdentity}"},
    }

    def __init__(
        self,
        *,
        upgradeable_to: Optional[str] = None,
        platform_workload_identities: Optional[dict[str, "_models.PlatformWorkloadIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword upgradeable_to: UpgradeableTo stores a single OpenShift version a workload identity
         cluster can be upgraded to.
        :paramtype upgradeable_to: str
        :keyword platform_workload_identities: Dictionary of :code:`<PlatformWorkloadIdentity>`.
        :paramtype platform_workload_identities: dict[str,
         ~azure.mgmt.redhatopenshift.models.PlatformWorkloadIdentity]
        """
        super().__init__(**kwargs)
        self.upgradeable_to = upgradeable_to
        self.platform_workload_identities = platform_workload_identities


class PlatformWorkloadIdentityRole(_serialization.Model):
    """PlatformWorkloadIdentityRole represents a mapping from a particular OCP operator to the
    built-in role that should be assigned to that operator's corresponding managed identity.

    :ivar operator_name: OperatorName represents the name of the operator that this role is for.
    :vartype operator_name: str
    :ivar role_definition_name: RoleDefinitionName represents the name of the role.
    :vartype role_definition_name: str
    :ivar role_definition_id: RoleDefinitionID represents the resource ID of the role definition.
    :vartype role_definition_id: str
    """

    _attribute_map = {
        "operator_name": {"key": "operatorName", "type": "str"},
        "role_definition_name": {"key": "roleDefinitionName", "type": "str"},
        "role_definition_id": {"key": "roleDefinitionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        operator_name: Optional[str] = None,
        role_definition_name: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operator_name: OperatorName represents the name of the operator that this role is for.
        :paramtype operator_name: str
        :keyword role_definition_name: RoleDefinitionName represents the name of the role.
        :paramtype role_definition_name: str
        :keyword role_definition_id: RoleDefinitionID represents the resource ID of the role
         definition.
        :paramtype role_definition_id: str
        """
        super().__init__(**kwargs)
        self.operator_name = operator_name
        self.role_definition_name = role_definition_name
        self.role_definition_id = role_definition_id


class PlatformWorkloadIdentityRoleSet(ProxyResource):
    """PlatformWorkloadIdentityRoleSet represents a mapping from the names of OCP operators to the
    built-in roles that should be assigned to those operator's corresponding managed identities for
    a particular OCP version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.redhatopenshift.models.SystemData
    :ivar open_shift_version: OpenShiftVersion represents the version associated with this set of
     roles.
    :vartype open_shift_version: str
    :ivar platform_workload_identity_roles: PlatformWorkloadIdentityRoles represents the set of
     roles associated with this version.
    :vartype platform_workload_identity_roles:
     list[~azure.mgmt.redhatopenshift.models.PlatformWorkloadIdentityRole]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "open_shift_version": {"key": "properties.openShiftVersion", "type": "str"},
        "platform_workload_identity_roles": {
            "key": "properties.platformWorkloadIdentityRoles",
            "type": "[PlatformWorkloadIdentityRole]",
        },
    }

    def __init__(
        self,
        *,
        open_shift_version: Optional[str] = None,
        platform_workload_identity_roles: Optional[list["_models.PlatformWorkloadIdentityRole"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword open_shift_version: OpenShiftVersion represents the version associated with this set
         of roles.
        :paramtype open_shift_version: str
        :keyword platform_workload_identity_roles: PlatformWorkloadIdentityRoles represents the set of
         roles associated with this version.
        :paramtype platform_workload_identity_roles:
         list[~azure.mgmt.redhatopenshift.models.PlatformWorkloadIdentityRole]
        """
        super().__init__(**kwargs)
        self.open_shift_version = open_shift_version
        self.platform_workload_identity_roles = platform_workload_identity_roles


class PlatformWorkloadIdentityRoleSetList(_serialization.Model):
    """PlatformWorkloadIdentityRoleSetList represents a List of role sets.

    :ivar value: The list of role sets.
    :vartype value: list[~azure.mgmt.redhatopenshift.models.PlatformWorkloadIdentityRoleSet]
    :ivar next_link: Next Link to next operation.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PlatformWorkloadIdentityRoleSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.PlatformWorkloadIdentityRoleSet"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of role sets.
        :paramtype value: list[~azure.mgmt.redhatopenshift.models.PlatformWorkloadIdentityRoleSet]
        :keyword next_link: Next Link to next operation.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServicePrincipalProfile(_serialization.Model):
    """ServicePrincipalProfile represents a service principal profile.

    :ivar client_id: The client ID used for the cluster.
    :vartype client_id: str
    :ivar client_secret: The client secret used for the cluster.
    :vartype client_secret: str
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret": {"key": "clientSecret", "type": "str"},
    }

    def __init__(self, *, client_id: Optional[str] = None, client_secret: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword client_id: The client ID used for the cluster.
        :paramtype client_id: str
        :keyword client_secret: The client secret used for the cluster.
        :paramtype client_secret: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.client_secret = client_secret


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.redhatopenshift.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.redhatopenshift.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.redhatopenshift.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.redhatopenshift.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class WorkerProfile(_serialization.Model):
    """WorkerProfile represents a worker profile.

    :ivar name: The worker profile name.
    :vartype name: str
    :ivar vm_size: The size of the worker VMs.
    :vartype vm_size: str
    :ivar disk_size_gb: The disk size of the worker VMs.
    :vartype disk_size_gb: int
    :ivar subnet_id: The Azure resource ID of the worker subnet.
    :vartype subnet_id: str
    :ivar count: The number of worker VMs.
    :vartype count: int
    :ivar encryption_at_host: Whether master virtual machines are encrypted at host. Known values
     are: "Disabled" and "Enabled".
    :vartype encryption_at_host: str or ~azure.mgmt.redhatopenshift.models.EncryptionAtHost
    :ivar disk_encryption_set_id: The resource ID of an associated DiskEncryptionSet, if
     applicable.
    :vartype disk_encryption_set_id: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "subnet_id": {"key": "subnetId", "type": "str"},
        "count": {"key": "count", "type": "int"},
        "encryption_at_host": {"key": "encryptionAtHost", "type": "str"},
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        vm_size: Optional[str] = None,
        disk_size_gb: Optional[int] = None,
        subnet_id: Optional[str] = None,
        count: Optional[int] = None,
        encryption_at_host: Optional[Union[str, "_models.EncryptionAtHost"]] = None,
        disk_encryption_set_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The worker profile name.
        :paramtype name: str
        :keyword vm_size: The size of the worker VMs.
        :paramtype vm_size: str
        :keyword disk_size_gb: The disk size of the worker VMs.
        :paramtype disk_size_gb: int
        :keyword subnet_id: The Azure resource ID of the worker subnet.
        :paramtype subnet_id: str
        :keyword count: The number of worker VMs.
        :paramtype count: int
        :keyword encryption_at_host: Whether master virtual machines are encrypted at host. Known
         values are: "Disabled" and "Enabled".
        :paramtype encryption_at_host: str or ~azure.mgmt.redhatopenshift.models.EncryptionAtHost
        :keyword disk_encryption_set_id: The resource ID of an associated DiskEncryptionSet, if
         applicable.
        :paramtype disk_encryption_set_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.vm_size = vm_size
        self.disk_size_gb = disk_size_gb
        self.subnet_id = subnet_id
        self.count = count
        self.encryption_at_host = encryption_at_host
        self.disk_encryption_set_id = disk_encryption_set_id
