# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
import azure.mgmt.logic as az_logic
from azure.mgmt.resource.changes import ChangesClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.live_test_only
class TestChangesChangesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ChangesClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_changes_list_for_workflow(self, resource_group):
        logic_client = self.create_mgmt_client(az_logic.LogicManagementClient)

        # create a workflow as the target resource
        workflow_name = self.get_resource_name("workflow")
        workflow = az_logic.models.Workflow(
            location=AZURE_LOCATION,
            definition={
                "$schema": "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#",
                "contentVersion": "1.0.0.0",
                "parameters": {},
                "triggers": {},
                "actions": {},
                "outputs": {},
            },
        )

        logic_client.workflows.create_or_update(resource_group.name, workflow_name, workflow)

        try:
            response = self.client.changes.list(
                resource_group_name=resource_group.name,
                resource_provider_namespace="Microsoft.Logic",
                resource_type="workflows",
                resource_name=workflow_name,
            )
            # Just ensure the call succeeds and returns an iterable
            _ = [r for r in response]
        finally:
            # Best-effort cleanup of the workflow
            logic_client.workflows.delete(resource_group.name, workflow_name)
