# Google API Client Library for Python Docs

 The Google API Client Library for Python is designed for Python
client-application developers. It offers simple, flexible
access to many Google APIs.

## Features

- Call Google APIs simply
- Handle Auth with fewer lines of code
- Use standard tooling for installation

## Documentation

Learn how to use the Google API Python Client with these guides:

### Usage Guides

- [Getting Started](start.md)
- [Auth](auth.md)
  - [API Keys](api-keys.md)
  - [OAuth 2.0](oauth.md)
  - [OAuth 2.0 for Web Server Applications](https://developers.google.com/identity/protocols/oauth2/web-server)
  - [OAuth 2.0 for Installed Applications](oauth-installed.md)
  - [OAuth 2.0 for Server to Server Applications](oauth-server.md)
  - [Client Secrets](client-secrets.md)
- How to...
  - [Use Logging](logging.md)
  - [Upload Media](media.md)
  - [Use Mocks](mocks.md)
  - [Use Pagination](pagination.md)
  - [Improve Performance](performance.md)
  - [Understand Thread Safety](thread_safety.md)

### Reference Documentation

- Reference documentation for the core library [googleapiclient](http://googleapis.github.io/google-api-python-client/docs/epy/index.html).
- [Library reference documentation by API](dyn/index.md).
